<?php
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Custom field handler to display the count of items.
 *
 * @ViewsField("tmgmt_capi_items_count")
 */
class TmgmtCapiItemsCount extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    // Access the aggregated count value
    $value = $values->{'count_rid'} ?? 0;
    return ['#markup' => (string) $value];
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    // This field doesn't need to participate in query building
    // as we're using Views aggregation
  }
}