<?php

namespace Drupal\tmgmt_contentapi\Services;

use Drupal\Core\Utility\LinkGenerator;
use Drupal\Core\Routing\UrlGeneratorInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Render\RendererInterface;

/**
 * Null-safe link generator decorator for Drupal 11.
 */
class NullSafeLinkGenerator extends LinkGenerator {

  /**
   * The decorated link generator service.
   *
   * @var \Drupal\Core\Utility\LinkGenerator
   */
  protected $innerService;

  /**
   * Constructs a new NullSafeLinkGenerator.
   *
   * @param \Drupal\Core\Utility\LinkGenerator $inner_service
   *   The decorated service.
   * @param \Drupal\Core\Routing\UrlGeneratorInterface $url_generator
   *   The URL generator service.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler service.
   * @param \Drupal\Core\Render\RendererInterface $renderer
   *   The renderer service.
   */
  public function __construct(
    LinkGenerator $inner_service,
    UrlGeneratorInterface $url_generator,
    ModuleHandlerInterface $module_handler,
    RendererInterface $renderer,
  ) {
    $this->innerService = $inner_service;
    parent::__construct($url_generator, $module_handler, $renderer);
  }

  /**
   * {@inheritdoc}
   */
  public function generate($text, $url) {
    return parent::generate($text ?? '', $url);
  }

}
