<?php

namespace Drupal\tmgmt_contentapi\Plugin\QueueWorker;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\QueueWorkerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Process a queue of translated jobs.
 *
 * @QueueWorker(
 *   id = "import_jobs_manually_from_queue",
 *   title = @Translation("Manual File and Zip import: Import translated jobs initiated manually from queue"),
 *   cron = {"time" = 60}
 * )
 */
class ImportJobsManuallyFromQueue extends QueueWorkerBase implements ContainerFactoryPluginInterface {

  /**
   * Constructs a new class instance.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
    );
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data) {
    // Check if zip_file_path and extracted_folder_path are set, if not set them to empty string.
    $data['zip_file_path'] ??= '';
    $data['extracted_folder_path'] ??= '';
    \Drupal::service('tmgmt_contentapi.import_job')->importJobViaFile($data['job_id'], $data['file'], $data['iszip'], $data['zip_file_path'], $data['extracted_folder_path'], $data['is_manual']);
  }

}
