<?php
/**
 * JobApi
 * PHP version 5
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * The Lionbridge Content API
 *
 * Enable translations with the Lionbridge Content API.
 *
 * OpenAPI spec version: 1.4.3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Drupal\tmgmt_contentapi\Swagger\Client\Api;



use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Drupal\tmgmt_contentapi\Swagger\Client\ApiException;
use Drupal\tmgmt_contentapi\Swagger\Client\Configuration;
use Drupal\tmgmt_contentapi\Swagger\Client\HeaderSelector;
use Drupal\tmgmt_contentapi\Swagger\Client\ObjectSerializer;

/**
 * JobApi Class Doc Comment
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class JobApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    #[\ReturnTypeWillChange]
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    #[\ReturnTypeWillChange]
    public function getConfig()
    {
        return $this->config;
    }

    #[\ReturnTypeWillChange]
    public function handleThrottling($request, $options) {
      return \DRUPAL::service('tmgmt_contentapi.handle_throttling')->handleThrottling($request, $options);
    }

    /**
     * Operation jobsGet
     *
     * Query all jobs.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     * @param  bool $include_archived Include archived jobs in job listing. (optional, default to false)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job[]
     */
    #[\ReturnTypeWillChange]
    public function jobsGet($authorization, $fetch_type = 'full', $include_archived = 'false')
    {
        list($response) = $this->jobsGetWithHttpInfo($authorization, $fetch_type, $include_archived);
        return $response;
    }

    /**
     * Operation jobsGetWithHttpInfo
     *
     * Query all jobs.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     * @param  bool $include_archived Include archived jobs in job listing. (optional, default to false)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsGetWithHttpInfo($authorization, $fetch_type = 'full', $include_archived = 'false')
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job[]';
        $request = $this->jobsGetRequest($authorization, $fetch_type, $include_archived);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsGetAsync
     *
     * Query all jobs.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     * @param  bool $include_archived Include archived jobs in job listing. (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsGetAsync($authorization, $fetch_type = 'full', $include_archived = 'false')
    {
        return $this->jobsGetAsyncWithHttpInfo($authorization, $fetch_type, $include_archived)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsGetAsyncWithHttpInfo
     *
     * Query all jobs.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     * @param  bool $include_archived Include archived jobs in job listing. (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsGetAsyncWithHttpInfo($authorization, $fetch_type = 'full', $include_archived = 'false')
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job[]';
        $request = $this->jobsGetRequest($authorization, $fetch_type, $include_archived);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsGet'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     * @param  bool $include_archived Include archived jobs in job listing. (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsGetRequest($authorization, $fetch_type = 'full', $include_archived = 'false')
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsGet'
            );
        }

        $resourcePath = '/jobs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($fetch_type !== null) {
            $queryParams['fetchType'] = ObjectSerializer::toQueryValue($fetch_type);
        }
        // query params
        if ($include_archived !== null) {
            $queryParams['includeArchived'] = ObjectSerializer::toQueryValue($include_archived);
        }
        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }
        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdArchivePut
     *
     * Archive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdArchivePut($authorization, $job_id)
    {
        list($response) = $this->jobsJobIdArchivePutWithHttpInfo($authorization, $job_id);
        return $response;
    }

    /**
     * Operation jobsJobIdArchivePutWithHttpInfo
     *
     * Archive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdArchivePutWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdArchivePutRequest($authorization, $job_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdArchivePutAsync
     *
     * Archive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdArchivePutAsync($authorization, $job_id)
    {
        return $this->jobsJobIdArchivePutAsyncWithHttpInfo($authorization, $job_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdArchivePutAsyncWithHttpInfo
     *
     * Archive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdArchivePutAsyncWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdArchivePutRequest($authorization, $job_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdArchivePut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdArchivePutRequest($authorization, $job_id)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdArchivePut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdArchivePut'
            );
        }

        $resourcePath = '/jobs/{jobId}/archive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

     /**
     * Operation jobsJobIdArchivePut
     *
     * Archive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdArchivePutCtt($authorization, $job_id)
    {
        list($response) = $this->jobsJobIdArchivePutWithHttpInfoCtt($authorization, $job_id);
        return $response;
    }

    /**
     * Operation jobsJobIdArchivePutWithHttpInfo
     *
     * Archive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdArchivePutWithHttpInfoCtt($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdArchivePutRequestCtt($authorization, $job_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdArchivePutAsync
     *
     * Archive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdArchivePutAsyncCtt($authorization, $job_id)
    {
        return $this->jobsJobIdArchivePutAsyncWithHttpInfoCtt($authorization, $job_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdArchivePutAsyncWithHttpInfo
     *
     * Archive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdArchivePutAsyncWithHttpInfoCtt($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdArchivePutRequestCtt($authorization, $job_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdArchivePut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdArchivePutRequestCtt($authorization, $job_id)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdArchivePut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdArchivePut'
            );
        }

        $resourcePath = '/jobs/{jobId}/archive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        // $headers = [
        //     'Authorization' => 'Bearer ' . $authorization,   
        //     'Accept'        => 'application/json',
        //     'Content-Type'        => 'application/json',
        //   ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost1() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdDelete
     *
     * Delete a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdDelete($authorization, $job_id)
    {
        list($response) = $this->jobsJobIdDeleteWithHttpInfo($authorization, $job_id);
        return $response;
    }

    /**
     * Operation jobsJobIdDeleteWithHttpInfo
     *
     * Delete a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdDeleteWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdDeleteRequest($authorization, $job_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdDeleteAsync
     *
     * Delete a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdDeleteAsync($authorization, $job_id)
    {
        return $this->jobsJobIdDeleteAsyncWithHttpInfo($authorization, $job_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdDeleteAsyncWithHttpInfo
     *
     * Delete a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdDeleteAsyncWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdDeleteRequest($authorization, $job_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdDelete'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdDeleteRequest($authorization, $job_id)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdDelete'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdDelete'
            );
        }

        $resourcePath = '/jobs/{jobId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdGet
     *
     * Query job information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdGet($authorization, $job_id, $fetch_type = 'full')
    {
        
        list($response) = $this->jobsJobIdGetWithHttpInfo($authorization, $job_id, $fetch_type);
        return $response;
    }

    /**
     * Operation jobsJobIdGetWithHttpInfo
     *
     * Query job information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdGetWithHttpInfo($authorization, $job_id, $fetch_type = 'full')
    {
        
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdGetRequest($authorization, $job_id, $fetch_type);

        
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
       
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }
            
            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdGetAsync
     *
     * Query job information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdGetAsync($authorization, $job_id, $fetch_type = 'full')
    {
        return $this->jobsJobIdGetAsyncWithHttpInfo($authorization, $job_id, $fetch_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdGetAsyncWithHttpInfo
     *
     * Query job information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdGetAsyncWithHttpInfo($authorization, $job_id, $fetch_type = 'full')
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdGetRequest($authorization, $job_id, $fetch_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdGet'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdGetRequest($authorization, $job_id, $fetch_type = 'full')
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdGet'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdGet'
            );
        }

        $resourcePath = '/jobs/{jobId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($fetch_type !== null) {
            $queryParams['fetchType'] = ObjectSerializer::toQueryValue($fetch_type);
        }
        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }
        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdGet
     *
     * Query job information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdGetCtt($authorization, $job_id, $fetch_type = 'full')
    {
        list($response) = $this->jobsJobIdGetCttWithHttpInfo($authorization, $job_id, $fetch_type);
        return $response;
    }

    /**
     * Operation jobsJobIdGetWithHttpInfo
     *
     * Query job information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdGetCttWithHttpInfo($authorization, $job_id, $fetch_type = 'full')
    {
        
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\JobCtt';
        $request = $this->jobsJobIdGetRequestCtt($authorization, $job_id, $fetch_type);
        
        
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
        
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }
            
            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdGetAsync
     *
     * Query job information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdGetCttAsync($authorization, $job_id, $fetch_type = 'full')
    {
        return $this->jobsJobIdGetCttAsyncWithHttpInfo($authorization, $job_id, $fetch_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdGetAsyncWithHttpInfo
     *
     * Query job information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdGetCttAsyncWithHttpInfo($authorization, $job_id, $fetch_type = 'full')
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdGetRequestCtt($authorization, $job_id, $fetch_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdGet'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being queried. (required)
     * @param  string $fetch_type Specifies what level of detail is returned for a job. (optional, default to full)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */

    protected function jobsJobIdGetRequestCtt($authorization, $job_id, $fetch_type = 'full')
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdGet'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdGet'
            );
        }

        $resourcePath = '/jobs/{jobId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($fetch_type !== null) {
            $queryParams['fetchType'] = ObjectSerializer::toQueryValue($fetch_type);
        }
        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost1() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdPut
     *
     * Update a job's information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being updated. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateJob $job The job being updated. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdPut($authorization, $job_id, $job)
    {
        list($response) = $this->jobsJobIdPutWithHttpInfo($authorization, $job_id, $job);
        return $response;
    }

    /**
     * Operation jobsJobIdPutWithHttpInfo
     *
     * Update a job's information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being updated. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateJob $job The job being updated. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdPutWithHttpInfo($authorization, $job_id, $job)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdPutRequest($authorization, $job_id, $job);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdPutAsync
     *
     * Update a job's information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being updated. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateJob $job The job being updated. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdPutAsync($authorization, $job_id, $job)
    {
        return $this->jobsJobIdPutAsyncWithHttpInfo($authorization, $job_id, $job)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdPutAsyncWithHttpInfo
     *
     * Update a job's information.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being updated. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateJob $job The job being updated. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdPutAsyncWithHttpInfo($authorization, $job_id, $job)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdPutRequest($authorization, $job_id, $job);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdPut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job being updated. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateJob $job The job being updated. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdPutRequest($authorization, $job_id, $job)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdPut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdPut'
            );
        }
        // verify the required parameter 'job' is set
        if ($job === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job when calling jobsJobIdPut'
            );
        }

        $resourcePath = '/jobs/{jobId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($job)) {
            $_tempBody = $job;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }
        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdSubmitPut
     *
     * Send/Submit job to provider.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ProviderId $body The ID of the provider the job will be sent to. This information can be omitted if the site has only one translation provider. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdSubmitPut($authorization, $job_id, $body)
    {
        list($response) = $this->jobsJobIdSubmitPutWithHttpInfo($authorization, $job_id, $body);
        return $response;
    }

    /**
     * Operation jobsJobIdSubmitPutWithHttpInfo
     *
     * Send/Submit job to provider.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ProviderId $body The ID of the provider the job will be sent to. This information can be omitted if the site has only one translation provider. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdSubmitPutWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdSubmitPutRequest($authorization, $job_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdSubmitPutAsync
     *
     * Send/Submit job to provider.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ProviderId $body The ID of the provider the job will be sent to. This information can be omitted if the site has only one translation provider. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdSubmitPutAsync($authorization, $job_id, $body)
    {
        return $this->jobsJobIdSubmitPutAsyncWithHttpInfo($authorization, $job_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdSubmitPutAsyncWithHttpInfo
     *
     * Send/Submit job to provider.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ProviderId $body The ID of the provider the job will be sent to. This information can be omitted if the site has only one translation provider. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdSubmitPutAsyncWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdSubmitPutRequest($authorization, $job_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdSubmitPut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ProviderId $body The ID of the provider the job will be sent to. This information can be omitted if the site has only one translation provider. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdSubmitPutRequest($authorization, $job_id, $body)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdSubmitPut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdSubmitPut'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsJobIdSubmitPut'
            );
        }

        $resourcePath = '/jobs/{jobId}/submit';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];
        
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdUnarchivePut
     *
     * Unarchive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdUnarchivePut($authorization, $job_id)
    {
        list($response) = $this->jobsJobIdUnarchivePutWithHttpInfo($authorization, $job_id);
        return $response;
    }

    /**
     * Operation jobsJobIdUnarchivePutWithHttpInfo
     *
     * Unarchive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdUnarchivePutWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdUnarchivePutRequest($authorization, $job_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdUnarchivePutAsync
     *
     * Unarchive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdUnarchivePutAsync($authorization, $job_id)
    {
        return $this->jobsJobIdUnarchivePutAsyncWithHttpInfo($authorization, $job_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdUnarchivePutAsyncWithHttpInfo
     *
     * Unarchive a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdUnarchivePutAsyncWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsJobIdUnarchivePutRequest($authorization, $job_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdUnarchivePut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdUnarchivePutRequest($authorization, $job_id)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdUnarchivePut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdUnarchivePut'
            );
        }

        $resourcePath = '/jobs/{jobId}/unarchive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsPost
     *
     * Create a new job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateJob $body Created job object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job
     */
    #[\ReturnTypeWillChange]
    public function jobsPost($authorization, $body)
    {
        list($response) = $this->jobsPostWithHttpInfo($authorization, $body);
        return $response;
    }

    /**
     * Operation jobsPostWithHttpInfo
     *
     * Create a new job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateJob $body Created job object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Job, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsPostWithHttpInfo($authorization, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsPostRequest($authorization, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsPostAsync
     *
     * Create a new job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateJob $body Created job object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsPostAsync($authorization, $body)
    {
        return $this->jobsPostAsyncWithHttpInfo($authorization, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsPostAsyncWithHttpInfo
     *
     * Create a new job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateJob $body Created job object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsPostAsyncWithHttpInfo($authorization, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Job';
        $request = $this->jobsPostRequest($authorization, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsPost'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateJob $body Created job object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsPostRequest($authorization, $body)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsPost'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsPost'
            );
        }

        $resourcePath = '/jobs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }


        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }
        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
    #[\ReturnTypeWillChange]
    public function jobsJobIdGetStatus($token, $capijobid)
    {
       
        $headers = [
            'Authorization' => 'Bearer ' . $token,        
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];
        
          $request = $this->client->get(Configuration::getDefaultConfiguration()->getHost().'/jobs/'.$capijobid.'/requests', [
            'headers'=> $headers,
          ]);
          
          $output = $request->getBody()->getContents();
          $content = json_decode($output);
        
          foreach($content->_embedded->requests as $value)
          {
              $status_code = $value->statusCode;
          }
        
          return $status_code;
    }

    public function jobsJobIdGetAllRequest($token, $capijobid)
    {
        $headers = [
          'Authorization' => 'Bearer ' . $token,        
          'Accept'        => 'application/json',
          'Content-Type'        => 'application/json',
        ];
    
        $request = $this->client->get(Configuration::getDefaultConfiguration()->getHost().'/jobs/'.$capijobid.'/requests', [
          'headers'=> $headers,
        ]);
        
        $output = $request->getBody()->getContents();
        $content = json_decode($output);
        $request_array = [];
    
        foreach($content->_embedded->requests as $value)
        {
          $request_array[] = $value;
        }
        return $request_array;
    }
    
    #[\ReturnTypeWillChange]
    public function FindJob($token, $capijobid)
    {
        $ch = curl_init($this->config->getHost().'/jobs/'.$capijobid.''); 
        $authorization = "Authorization: Bearer ".$token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json' , $authorization )); // Inject the token into the header
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
        $result = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        return $httpCode;
    }
}
