<?php
/**
 * RequestApi
 * PHP version 5
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * The Lionbridge Content API
 *
 * Enable translations with the Lionbridge Content API.
 *
 * OpenAPI spec version: 1.4.3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Drupal\tmgmt_contentapi\Swagger\Client\Api;



use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Drupal\tmgmt_contentapi\Swagger\Client\ApiException;
use Drupal\tmgmt_contentapi\Swagger\Client\Configuration;
use Drupal\tmgmt_contentapi\Swagger\Client\HeaderSelector;
use Drupal\tmgmt_contentapi\Swagger\Client\ObjectSerializer;

/**
 * RequestApi Class Doc Comment
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class RequestApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    #[\ReturnTypeWillChange]
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    #[\ReturnTypeWillChange]
    public function getConfig()
    {
        return $this->config;
    }

    #[\ReturnTypeWillChange]
    public function handleThrottling($request, $options) {
      return \DRUPAL::service('tmgmt_contentapi.handle_throttling')->handleThrottling($request, $options);
    }

    /**
     * Operation jobsJobIdRequestsAddPost
     *
     * Create new translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestKeyValue $body Created Request object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsAddPost($authorization, $job_id, $body)
    {
        list($response) = $this->jobsJobIdRequestsAddPostWithHttpInfo($authorization, $job_id, $body);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsAddPostWithHttpInfo
     *
     * Create new translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestKeyValue $body Created Request object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsAddPostWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsAddPostRequest($authorization, $job_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsAddPostAsync
     *
     * Create new translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestKeyValue $body Created Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsAddPostAsync($authorization, $job_id, $body)
    {
        return $this->jobsJobIdRequestsAddPostAsyncWithHttpInfo($authorization, $job_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsAddPostAsyncWithHttpInfo
     *
     * Create new translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestKeyValue $body Created Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsAddPostAsyncWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsAddPostRequest($authorization, $job_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsAddPost'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestKeyValue $body Created Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsAddPostRequest($authorization, $job_id, $body)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsAddPost'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsAddPost'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsJobIdRequestsAddPost'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests/add';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsAddfilePost
     *
     * Add translation requests to a job based on a file.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestFile $body Created Request object (required)
     *
     * @param  string $requestType 1= source, 2 = reference. (optional) DEFAULT = source
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsAddfilePost($authorization, $job_id, $body, $requestType = 1)
    {
        list($response) = $this->jobsJobIdRequestsAddfilePostWithHttpInfo($authorization, $job_id, $body, $requestType);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsAddfilePostWithHttpInfo
     *
     * Add translation requests to a job based on a file.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestFile $body Created Request object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsAddfilePostWithHttpInfo($authorization, $job_id, $body, $requestType)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdAddSourceReferencePostRequest($authorization, $job_id, $body, $requestType);//$this->jobsJobIdRequestsAddfilePostRequest($authorization, $job_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                    $output = $content->_embedded->requests;
                }
            }

            return [
                ObjectSerializer::deserialize($output, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsAddfilePostAsync
     *
     * Add translation requests to a job based on a file.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestFile $body Created Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsAddfilePostAsync($authorization, $job_id, $body)
    {
        return $this->jobsJobIdRequestsAddfilePostAsyncWithHttpInfo($authorization, $job_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsAddfilePostAsyncWithHttpInfo
     *
     * Add translation requests to a job based on a file.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestFile $body Created Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsAddfilePostAsyncWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsAddfilePostRequest($authorization, $job_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }
    /**
     * Create request for operation 'jobsJobIdSupportAssetsPostRequest'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestFile $body Created Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    //protected function jobsJobIdSupportAssetsPostRequest($authorization, $job_id, $body)
    //{
    //    return jobsJobIdAddSourceReferencePostRequest(authorization, $job_id, $body, 2);
    //}
    /**
     * Create request for operation 'jobsJobIdRequestsAddfilePostRequest'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestFile $body Created Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    //protected function jobsJobIdRequestsAddfilePostRequest($authorization, $job_id, $body)
    //{
    //    return jobsJobIdAddSourceReferencePostRequest(authorization, $job_id, $body, 1);
    //}
    /**
     * Create request for operation 'jobsJobIdRequestsAddfilePost'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateRequestFile $body Created Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdAddSourceReferencePostRequest($authorization, $job_id, $body, $requestType)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsAddfilePost'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsAddfilePost'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsJobIdRequestsAddfilePost'
            );
        }

        $resourcePath = $requestType == 1 ? '/jobs/{jobId}/requests/add' : '/jobs/{jobId}/supportassets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
          ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsApprovePut
     *
     * Approve translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsApprovePut($authorization, $job_id, $body)
    {
        list($response) = $this->jobsJobIdRequestsApprovePutWithHttpInfo($authorization, $job_id, $body);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsApprovePutWithHttpInfo
     *
     * Approve translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsApprovePutWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsApprovePutRequest($authorization, $job_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsApprovePutAsync
     *
     * Approve translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsApprovePutAsync($authorization, $job_id, $body)
    {
        return $this->jobsJobIdRequestsApprovePutAsyncWithHttpInfo($authorization, $job_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsApprovePutAsyncWithHttpInfo
     *
     * Approve translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsApprovePutAsyncWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsApprovePutRequest($authorization, $job_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsApprovePut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsApprovePutRequest($authorization, $job_id, $body)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsApprovePut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsApprovePut'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsJobIdRequestsApprovePut'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests/approve';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }
        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsApprovePut
     *
     * Approve translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsApprovePutCtt($authorization, $job_id, $body)
    {
        list($response) = $this->jobsJobIdRequestsApprovePutWithHttpInfoCtt($authorization, $job_id, $body);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsApprovePutWithHttpInfo
     *
     * Approve translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsApprovePutWithHttpInfoCtt($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\RequestCtt[]';
        $request = $this->jobsJobIdRequestsApprovePutRequestCtt($authorization, $job_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsApprovePutAsync
     *
     * Approve translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsApprovePutAsyncCtt($authorization, $job_id, $body)
    {
        return $this->jobsJobIdRequestsApprovePutAsyncWithHttpInfoCtt($authorization, $job_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsApprovePutAsyncWithHttpInfo
     *
     * Approve translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsApprovePutAsyncWithHttpInfoCtt($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\RequestCtt[]';
        $request = $this->jobsJobIdRequestsApprovePutRequestCtt($authorization, $job_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsApprovePut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsApprovePutRequestCtt($authorization, $job_id, $body)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsApprovePut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsApprovePut'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsJobIdRequestsApprovePut'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests/approve';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // $headers = [
        //     'Authorization' => 'Bearer ' . $authorization,   
        //     'Accept'        => 'application/json',
        //     'Content-Type'        => 'application/json',
        // ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost1() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsGet
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsGet($authorization, $job_id)
    {
        list($response) = $this->jobsJobIdRequestsGetWithHttpInfo($authorization, $job_id);
        return $response;
    }

    public function jobsJobIdRequestsGetWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $nextlink = '';
        $output = [];
        do {
              $content = $this->getAllJobIdReequestsIncludingPagination($authorization, $job_id, $returnType, $nextlink);
              $output = array_merge($output, $content->_embedded->requests);
              if (isset($content->_links)) {
                $nextlink = $content->_links->next->href;
              } else {
                $nextlink = '';
                break;
              }
        } while (isset($nextlink));
        return [
            ObjectSerializer::deserialize($output, $returnType, []),
        ];
    }

    /**
     * Operation jobsJobIdRequestsGetWithHttpInfo
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  string $returnType return type string
     * @param  string $nextLink next link if applicable.
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function getAllJobIdReequestsIncludingPagination($authorization, $job_id, string $returnType, string $nextLink = '')
    {
        $request = $this->jobsJobIdRequestsGetRequest($authorization, $job_id, $nextLink);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                    // $output = $content->_embedded->requests;
                }
            }
            return $content;

            // return [
            //     ObjectSerializer::deserialize($output, $returnType, []),
            //     $response->getStatusCode(),
            //     $response->getHeaders()
            // ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsGetAsync
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsGetAsync($authorization, $job_id)
    {
        return $this->jobsJobIdRequestsGetAsyncWithHttpInfo($authorization, $job_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsGetAsyncWithHttpInfo
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsGetAsyncWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsGetRequest($authorization, $job_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsGet'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsGetRequest($authorization, $job_id, $nextLink)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsGet'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsGet'
            );
        }
        if ($nextLink != '') {
            $nextlink = parse_url($nextLink);
            $bbb = parse_str($nextlink['query'], $query);
            $aaa = $query['next'];
            $resourcePath = '/jobs/{jobId}/requests?next=' .  $aaa;
        } else {
            $resourcePath = '/jobs/{jobId}/requests';
        }

        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsGet
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsGetCtt($authorization, $job_id)
    {
        list($response) = $this->jobsJobIdRequestsGetWithHttpInfoCtt($authorization, $job_id);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsGetWithHttpInfo
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsGetWithHttpInfoCtt($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\RequestCtt[]';
        $request = $this->jobsJobIdRequestsGetRequestCtt($authorization, $job_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                    // $output = $content->_embedded->requests;
                }
            }
           
            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsGetAsync
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsGetAsyncCtt($authorization, $job_id)
    {
        return $this->jobsJobIdRequestsGetAsyncWithHttpInfoCtt($authorization, $job_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsGetAsyncWithHttpInfo
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsGetAsyncWithHttpInfoCtt($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsGetRequestCtt($authorization, $job_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsGet'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsGetRequestCtt($authorization, $job_id)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsGet'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsGet'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        // $headers = [
        //     'Authorization' => 'Bearer ' . $authorization,   
        //     'Accept'        => 'application/json',
        //     'Content-Type'        => 'application/json',
        // ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost1() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsPut
     *
     * Get specified translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsPut($authorization, $job_id, $body)
    {
        list($response) = $this->jobsJobIdRequestsPutWithHttpInfo($authorization, $job_id, $body);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsPutWithHttpInfo
     *
     * Get specified translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsPutWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsPutRequest($authorization, $job_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsPutAsync
     *
     * Get specified translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsPutAsync($authorization, $job_id, $body)
    {
        return $this->jobsJobIdRequestsPutAsyncWithHttpInfo($authorization, $job_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsPutAsyncWithHttpInfo
     *
     * Get specified translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsPutAsyncWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsPutRequest($authorization, $job_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsPut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIds $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsPutRequest($authorization, $job_id, $body)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsPut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsPut'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsJobIdRequestsPut'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsRejectPut
     *
     * Reject translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIdsNote $body Array of RequestIds (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRejectPut($authorization, $job_id, $body)
    {
        list($response) = $this->jobsJobIdRequestsRejectPutWithHttpInfo($authorization, $job_id, $body);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsRejectPutWithHttpInfo
     *
     * Reject translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIdsNote $body Array of RequestIds (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRejectPutWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsRejectPutRequest($authorization, $job_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsRejectPutAsync
     *
     * Reject translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIdsNote $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRejectPutAsync($authorization, $job_id, $body)
    {
        return $this->jobsJobIdRequestsRejectPutAsyncWithHttpInfo($authorization, $job_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsRejectPutAsyncWithHttpInfo
     *
     * Reject translated content of specified request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIdsNote $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRejectPutAsyncWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsRejectPutRequest($authorization, $job_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsRejectPut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\ArrayOfRequestIdsNote $body Array of RequestIds (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsRejectPutRequest($authorization, $job_id, $body)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsRejectPut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsRejectPut'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsJobIdRequestsRejectPut'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests/reject';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsRequestIdDelete
     *
     * Delete the translation request in a job identified by requestId
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdDelete($authorization, $job_id, $request_id)
    {
        list($response) = $this->jobsJobIdRequestsRequestIdDeleteWithHttpInfo($authorization, $job_id, $request_id);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsRequestIdDeleteWithHttpInfo
     *
     * Delete the translation request in a job identified by requestId
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdDeleteWithHttpInfo($authorization, $job_id, $request_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request';
        $request = $this->jobsJobIdRequestsRequestIdDeleteRequest($authorization, $job_id, $request_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsRequestIdDeleteAsync
     *
     * Delete the translation request in a job identified by requestId
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdDeleteAsync($authorization, $job_id, $request_id)
    {
        return $this->jobsJobIdRequestsRequestIdDeleteAsyncWithHttpInfo($authorization, $job_id, $request_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsRequestIdDeleteAsyncWithHttpInfo
     *
     * Delete the translation request in a job identified by requestId
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdDeleteAsyncWithHttpInfo($authorization, $job_id, $request_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request';
        $request = $this->jobsJobIdRequestsRequestIdDeleteRequest($authorization, $job_id, $request_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsRequestIdDelete'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsRequestIdDeleteRequest($authorization, $job_id, $request_id)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsRequestIdDelete'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsRequestIdDelete'
            );
        }
        // verify the required parameter 'request_id' is set
        if ($request_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling jobsJobIdRequestsRequestIdDelete'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }
        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }
        
        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsRequestIdGet
     *
     * Get the translation request in a job identified by requestId
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdGet($authorization, $job_id, $request_id)
    {
        list($response) = $this->jobsJobIdRequestsRequestIdGetWithHttpInfo($authorization, $job_id, $request_id);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsRequestIdGetWithHttpInfo
     *
     * Get the translation request in a job identified by requestId
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdGetWithHttpInfo($authorization, $job_id, $request_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request';
        $request = $this->jobsJobIdRequestsRequestIdGetRequest($authorization, $job_id, $request_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsRequestIdGetAsync
     *
     * Get the translation request in a job identified by requestId
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdGetAsync($authorization, $job_id, $request_id)
    {
        return $this->jobsJobIdRequestsRequestIdGetAsyncWithHttpInfo($authorization, $job_id, $request_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsRequestIdGetAsyncWithHttpInfo
     *
     * Get the translation request in a job identified by requestId
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdGetAsyncWithHttpInfo($authorization, $job_id, $request_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request';
        $request = $this->jobsJobIdRequestsRequestIdGetRequest($authorization, $job_id, $request_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsRequestIdGet'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsRequestIdGetRequest($authorization, $job_id, $request_id)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsRequestIdGet'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsRequestIdGet'
            );
        }
        // verify the required parameter 'request_id' is set
        if ($request_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling jobsJobIdRequestsRequestIdGet'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }
        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsUpdatecontentPut
     *
     * Add content to existing translation requests.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsKeyValue $body Updated Request object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsUpdatecontentPut($authorization, $job_id, $body)
    {
        list($response) = $this->jobsJobIdRequestsUpdatecontentPutWithHttpInfo($authorization, $job_id, $body);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsUpdatecontentPutWithHttpInfo
     *
     * Add content to existing translation requests.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsKeyValue $body Updated Request object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsUpdatecontentPutWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsUpdatecontentPutRequest($authorization, $job_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsUpdatecontentPutAsync
     *
     * Add content to existing translation requests.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsKeyValue $body Updated Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsUpdatecontentPutAsync($authorization, $job_id, $body)
    {
        return $this->jobsJobIdRequestsUpdatecontentPutAsyncWithHttpInfo($authorization, $job_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsUpdatecontentPutAsyncWithHttpInfo
     *
     * Add content to existing translation requests.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsKeyValue $body Updated Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsUpdatecontentPutAsyncWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsUpdatecontentPutRequest($authorization, $job_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsUpdatecontentPut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsKeyValue $body Updated Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsUpdatecontentPutRequest($authorization, $job_id, $body)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsUpdatecontentPut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsUpdatecontentPut'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsJobIdRequestsUpdatecontentPut'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests/updatecontent';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }
        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation jobsJobIdRequestsUpdatefilecontentPut
     *
     * Add a file to existing translation requests.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsFile $body Updated Request object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsUpdatefilecontentPut($authorization, $job_id, $body)
    {
        list($response) = $this->jobsJobIdRequestsUpdatefilecontentPutWithHttpInfo($authorization, $job_id, $body);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsUpdatefilecontentPutWithHttpInfo
     *
     * Add a file to existing translation requests.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsFile $body Updated Request object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsUpdatefilecontentPutWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsUpdatefilecontentPutRequest($authorization, $job_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsUpdatefilecontentPutAsync
     *
     * Add a file to existing translation requests.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsFile $body Updated Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsUpdatefilecontentPutAsync($authorization, $job_id, $body)
    {
        return $this->jobsJobIdRequestsUpdatefilecontentPutAsyncWithHttpInfo($authorization, $job_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsUpdatefilecontentPutAsyncWithHttpInfo
     *
     * Add a file to existing translation requests.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsFile $body Updated Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsUpdatefilecontentPutAsyncWithHttpInfo($authorization, $job_id, $body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsJobIdRequestsUpdatefilecontentPutRequest($authorization, $job_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsUpdatefilecontentPut'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\UpdateRequestsFile $body Updated Request object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsUpdatefilecontentPutRequest($authorization, $job_id, $body)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsUpdatefilecontentPut'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsUpdatefilecontentPut'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling jobsJobIdRequestsUpdatefilecontentPut'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests/updatefilecontent';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }
        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    #[\ReturnTypeWillChange]
    public function jobsCompleteRequestsGet($authorization, $job_id)
    {
        list($response) = $this->jobsCompletePutWithHttpInfo($authorization, $job_id);
        
        return $response;
    }

    #[\ReturnTypeWillChange]
    public function jobsCompletePutWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsCompletePutRequest($authorization, $job_id);

        

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                    // $output = $content->_embedded->requests;
                }
            }
            
            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsGetAsync
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsCompleteRequestsGetAsync($authorization, $job_id)
    {
        return $this->jobsCompleteRequestsGetAsyncWithHttpInfo($authorization, $job_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsGetAsyncWithHttpInfo
     *
     * Get all translation requests in a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsCompleteRequestsGetAsyncWithHttpInfo($authorization, $job_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Request[]';
        $request = $this->jobsCompletePutRequest($authorization, $job_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsGet'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the specified job. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsCompletePutRequest($authorization, $job_id)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsGet'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsGet'
            );
        }

        $resourcePath = '/jobs/{jobId}/complete';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }
}
