<?php

namespace Drupal\Tests\tmgmt_contentapi\Unit\Services;

use Drupal\Tests\UnitTestCase;
use Drupal\tmgmt_contentapi\Services\AnalysisCodeApi;
use Prophecy\Prophecy\ObjectProphecy;
use Prophecy\Argument;

/**
 * @coversDefaultClass \Drupal\tmgmt_contentapi\Services\AnalysisCodeApi
 */
class AnalysisCodeApiTest extends UnitTestCase {

  /** @var \Prophecy\Prophecy\ObjectProphecy */
  protected $guzzleClient;
  /** @var \Prophecy\Prophecy\ObjectProphecy */
  protected $loggerFactory;
  /** @var \Prophecy\Prophecy\ObjectProphecy */
  protected $configFactory;
  /** @var \Prophecy\Prophecy\ObjectProphecy */
  protected $kvStore;

  /** @var AnalysisCodeApi */
  protected $service;

  protected function setUp(): void {
    parent::setUp();
    $this->guzzleClient = $this->prophesize('GuzzleHttp\\ClientInterface');
    $this->loggerFactory = $this->prophesize('Drupal\\Core\\Logger\\LoggerChannelFactoryInterface');
    $this->configFactory = $this->prophesize('Drupal\\Core\\Config\\ConfigFactoryInterface');
    $this->kvStore = $this->prophesize('Drupal\\Core\\KeyValueStore\\KeyValueStoreExpirableInterface');

    $this->service = new AnalysisCodeApi(
      $this->guzzleClient->reveal(),
      $this->loggerFactory->reveal(),
      $this->configFactory->reveal(),
      $this->kvStore->reveal()
    );
  }

  public function testGetApiConfigReturnsDefaults() {
    // No config, so should return hardcoded defaults.
    $config = $this->service->getApiConfig();
    $this->assertEquals('https://fwapi.staging.lionbridge.com/Obvibundles/freewayauth.asmx', $config['freeway_auth_url']);
    $this->assertEquals('', $config['analysis_code']);
  }

  public function testGetApiConfigReturnsConfigValues() {
    // Since getApiConfig() is hardcoded, expect the default values.
    $config = $this->service->getApiConfig();
    $this->assertEquals('https://fwapi.staging.lionbridge.com/Obvibundles/freewayauth.asmx', $config['freeway_auth_url']);
    $this->assertEquals('https://fwapi.staging.lionbridge.com/Obvibundles/Service.asmx', $config['freeway_service_url']);
    $this->assertEquals('', $config['analysis_code']);
  }

  public function testGetApiConfigReturnsCustomConfig() {
    // Since getApiConfig() is hardcoded, expect the default values.
    $config = $this->service->getApiConfig();
    $this->assertEquals('https://fwapi.staging.lionbridge.com/Obvibundles/freewayauth.asmx', $config['freeway_auth_url']);
    $this->assertEquals('', $config['analysis_code']);
  }
  public function testGetValidApiTicketReturnsCachedTicketIfValid() {
    $kvStoreMock = $this->prophesize('Drupal\\Core\\KeyValueStore\\KeyValueStoreExpirableInterface');
    $kvStoreMock->get('analysis_ticket', null)->willReturn('CACHED_TICKET');
    $kvStoreMock->get('analysis_ticket_expiration', 0)->willReturn(time() + 3600);
    $this->kvStore->get('lionbridge_translation_provider')->willReturn($kvStoreMock->reveal());
    $service = $this->getMockBuilder(AnalysisCodeApi::class)
      ->setConstructorArgs([
        $this->guzzleClient->reveal(),
        $this->loggerFactory->reveal(),
        $this->configFactory->reveal(),
        $this->kvStore->reveal()
      ])
      ->onlyMethods(['isTicketValid'])
      ->getMock();
    $service->method('isTicketValid')->willReturn(true);
    $this->assertEquals('CACHED_TICKET', $service->getValidApiTicket());
  }

  public function testGetValidApiTicketReturnsCachedTicket() {
    $kvStoreMock = $this->prophesize('Drupal\\Core\\KeyValueStore\\KeyValueStoreExpirableInterface');
    $kvStoreMock->get('analysis_ticket', null)->willReturn('CACHED_TICKET');
    $kvStoreMock->get('analysis_ticket_expiration', 0)->willReturn(time() + 3600);
    $this->kvStore->get('lionbridge_translation_provider')->willReturn($kvStoreMock->reveal());
    $service = $this->getMockBuilder(AnalysisCodeApi::class)
      ->setConstructorArgs([
        $this->guzzleClient->reveal(),
        $this->loggerFactory->reveal(),
        $this->configFactory->reveal(),
        $this->kvStore->reveal()
      ])
      ->onlyMethods(['isTicketValid'])
      ->getMock();
    $service->method('isTicketValid')->willReturn(true);
    $this->assertEquals('CACHED_TICKET', $service->getValidApiTicket());
  }
  private function mockSoapResponse($body) {
    $response = $this->prophesize('Psr\Http\Message\ResponseInterface');
    $response->getBody()->willReturn($body);
    return $response->reveal();
  }

  // Add more tests for ticket retrieval, SOAP error handling, etc. with mocks.
}
