<?php
/**
 * ProviderApi
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * The Lionbridge Content API
 *
 * Enable translations with the Lionbridge Content API.
 *
 * OpenAPI spec version: 1.6.1
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.8
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Drupal\tmgmt_contentapi\Swagger\Client\Api;



use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Exception\BadResponseException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Drupal\tmgmt_contentapi\Swagger\Client\ApiException;
use Drupal\tmgmt_contentapi\Swagger\Client\Configuration;
use Drupal\tmgmt_contentapi\Swagger\Client\HeaderSelector;
use Drupal\tmgmt_contentapi\Swagger\Client\ObjectSerializer;

/**
 * ProviderApi Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ProviderApi
{
  /**
   * @var ClientInterface
   */
  protected $client;

  /**
   * @var Configuration
   */
  protected $config;

  /**
   * @var HeaderSelector
   */
  protected $headerSelector;

  /**
   * @param ClientInterface $client
   * @param Configuration   $config
   * @param HeaderSelector  $selector
   */
  #[\ReturnTypeWillChange]
    public function __construct(
    ClientInterface $client = null,
    Configuration $config = null,
    HeaderSelector $selector = null
  ) {
    $this->client = $client ?: new Client();
    $this->config = $config ?: new Configuration();
    $this->headerSelector = $selector ?: new HeaderSelector();
  }

  /**
   * @return Configuration
   */
  #[\ReturnTypeWillChange]
    public function getConfig()
  {
    return $this->config;
  }

  #[\ReturnTypeWillChange]
    public function handleThrottling($request, $options){
    $validResponse = false;
    $attempts = 0;
    $response = null;
    while(!$validResponse){
      try{
        $response = $this->client->send($request, $options);
        $validResponse = true;
      }catch(RequestException $ex){
        if($ex->getResponse()->getStatusCode() == 429){
          $attempts = $attempts + 1;
          sleep(3);
        }else{
          $e = new ApiException(
            "[{$ex->getCode()}] {$ex->getMessage()}",
            $ex->getCode(),
            $ex->getResponse() ? $ex->getResponse()->getHeaders() : null,
            $ex->getResponse() ? $ex->getResponse()->getBody()->getContents() : null
          );

          switch ($e->getCode()) {
            case 200:
              $data = ObjectSerializer::deserialize(
                $e->getResponseBody(),
                '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider[]',
                $e->getResponseHeaders()
              );
              $e->setResponseObject($data);
              break;
            case 400:
              $data = ObjectSerializer::deserialize(
                $e->getResponseBody(),
                '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                $e->getResponseHeaders()
              );
              $e->setResponseObject($data);
              break;
            case 401:
              $data = ObjectSerializer::deserialize(
                $e->getResponseBody(),
                '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                $e->getResponseHeaders()
              );
              $e->setResponseObject($data);
              break;
            case 500:
              $data = ObjectSerializer::deserialize(
                $e->getResponseBody(),
                '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                $e->getResponseHeaders()
              );
              $e->setResponseObject($data);
              break;
          }
          throw $e;
          
        }
      }
    }
    if($response == null){

        throw new \Exception("Throttling handler tried 10 times, CAPIV2 unavailable");
    }
    return $response;
}

  /**
   * Operation providersGet
   *
   * Get all configured translation providers.
   *
   * @param  string $authorization Oauth2 token (required)
   *
   * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
   * @throws \InvalidArgumentException
   * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider[]
   */
  #[\ReturnTypeWillChange]
    public function providersGet($authorization)
  {
    list($response) = $this->providersGetWithHttpInfo($authorization);
    return $response;
  }

  /**
   * Operation providersGetWithHttpInfo
   *
   * Get all configured translation providers.
   *
   * @param  string $authorization Oauth2 token (required)
   *
   * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
   * @throws \InvalidArgumentException
   * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider[], HTTP status code, HTTP response headers (array of strings)
   */
  #[\ReturnTypeWillChange]
    public function providersGetWithHttpInfo($authorization)
  {
    $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider[]';
    $request = $this->providersGetRequest($authorization);

    //try {
      $options = $this->createHttpClientOption();
      //try {
        $response = $this->handleThrottling($request, $options);
      /*
      } catch (RequestException $e) {
        throw new ApiException(
          "[{$e->getCode()}] {$e->getMessage()}",
          $e->getCode(),
          $e->getResponse() ? $e->getResponse()->getHeaders() : null,
          $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
        );
      }

      $statusCode = $response->getStatusCode();

      if ($statusCode < 200 || $statusCode > 299) {
        throw new ApiException(
          sprintf(
            '[%d] Error connecting to the API (%s)',
            $statusCode,
            $request->getUri()
          ),
          $statusCode,
          $response->getHeaders(),
          $response->getBody()
        );
      }
      */
      $responseBody = $response->getBody();
      if ($returnType === '\SplFileObject') {
        $content = $responseBody; //stream goes to serializer
      } else {
        $content = $responseBody->getContents();
        if ($returnType !== 'string') {
          $content = json_decode($content);
          $output = $content->_embedded->providers;
        }
      }

      return [
        ObjectSerializer::deserialize($output, $returnType, []),
        $response->getStatusCode(),
        $response->getHeaders()
      ];
/*
    } catch (ApiException $e) {
      switch ($e->getCode()) {
        case 200:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider[]',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 400:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 401:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 500:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
      }
      throw $e;
    }
    */
  }

  /**
   * Operation providersGetAsync
   *
   * Get all configured translation providers.
   *
   * @param  string $authorization Oauth2 token (required)
   *
   * @throws \InvalidArgumentException
   * @return \GuzzleHttp\Promise\PromiseInterface
   */
  #[\ReturnTypeWillChange]
    public function providersGetAsync($authorization)
  {
    return $this->providersGetAsyncWithHttpInfo($authorization)
      ->then(
        function ($response) {
          return $response[0];
        }
      );
  }

  /**
   * Operation providersGetAsyncWithHttpInfo
   *
   * Get all configured translation providers.
   *
   * @param  string $authorization Oauth2 token (required)
   *
   * @throws \InvalidArgumentException
   * @return \GuzzleHttp\Promise\PromiseInterface
   */
  #[\ReturnTypeWillChange]
    public function providersGetAsyncWithHttpInfo($authorization)
  {
    $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider[]';
    $request = $this->providersGetRequest($authorization);

    return $this->client
      ->sendAsync($request, $this->createHttpClientOption())
      ->then(
        function ($response) use ($returnType) {
          $responseBody = $response->getBody();
          if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
          } else {
            $content = $responseBody->getContents();
            if ($returnType !== 'string') {
              $content = json_decode($content);
            }
          }

          return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
          ];
        },
        function ($exception) {
          $response = $exception->getResponse();
          $statusCode = $response->getStatusCode();
          throw new ApiException(
            sprintf(
              '[%d] Error connecting to the API (%s)',
              $statusCode,
              $exception->getRequest()->getUri()
            ),
            $statusCode,
            $response->getHeaders(),
            $response->getBody()
          );
        }
      );
  }

  /**
   * Create request for operation 'providersGet'
   *
   * @param  string $authorization Oauth2 token (required)
   *
   * @throws \InvalidArgumentException
   * @return \GuzzleHttp\Psr7\Request
   */
  protected function providersGetRequest($authorization)
  {
    // verify the required parameter 'authorization' is set
    if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
      throw new \InvalidArgumentException(
        'Missing the required parameter $authorization when calling providersGet'
      );
    }

    $resourcePath = '/providers';
    $formParams = [];
    $queryParams = [];
    $headerParams = [];
    $httpBody = '';
    $multipart = false;

    // header params
    if ($authorization !== null) {
      $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
    }


    // body params
    $_tempBody = null;

    if ($multipart) {
      $headers = $this->headerSelector->selectHeadersForMultipart(
        ['application/json']
      );
    } else {
      $headers = $this->headerSelector->selectHeaders(
        ['application/json'],
        ['application/json']
      );
    }

    // for model (json/xml)
    if (isset($_tempBody)) {
      // $_tempBody is the method argument, if present
      $httpBody = $_tempBody;
      // \stdClass has no __toString(), so we should encode it manually
      if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
        $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
      }
    } elseif (count($formParams) > 0) {
      if ($multipart) {
        $multipartContents = [];
        foreach ($formParams as $formParamName => $formParamValue) {
          $multipartContents[] = [
            'name' => $formParamName,
            'contents' => $formParamValue
          ];
        }
        // for HTTP post (form)
        $httpBody = new MultipartStream($multipartContents);

      } elseif ($headers['Content-Type'] === 'application/json') {
        $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

      } else {
        // for HTTP post (form)
        $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
      }
    }

    // // this endpoint requires API key authentication
    // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
    // if ($apiKey !== null) {
    //   $headers['Authorization'] = $apiKey;
    // }
    // // this endpoint requires API key authentication
    // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
    // if ($apiKey !== null) {
    //   $headers['x-api-key'] = $apiKey;
    // }
    $headers = [
      'Authorization' => 'Bearer ' . $authorization,   
    ];

    $defaultHeaders = [];
    if ($this->config->getUserAgent()) {
      $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
    }

    $headers = array_merge(
      $defaultHeaders,
      $headerParams,
      $headers
    );

    $query = \GuzzleHttp\Psr7\Query::build($queryParams);
    return new Request(
      'GET',
      $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
      $headers,
      $httpBody
    );
  }

  /**
   * Operation providersProviderIdGet
   *
   * Get a translation provider.
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
   * @throws \InvalidArgumentException
   * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider
   */
  #[\ReturnTypeWillChange]
    public function providersProviderIdGet($authorization, $provider_id)
  {
    list($response) = $this->providersProviderIdGetWithHttpInfo($authorization, $provider_id);
    return $response;
  }

  /**
   * Operation providersProviderIdGetWithHttpInfo
   *
   * Get a translation provider.
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
   * @throws \InvalidArgumentException
   * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider, HTTP status code, HTTP response headers (array of strings)
   */
  #[\ReturnTypeWillChange]
    public function providersProviderIdGetWithHttpInfo($authorization, $provider_id)
  {
    $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider';
    $request = $this->providersProviderIdGetRequest($authorization, $provider_id);

    try {
      $options = $this->createHttpClientOption();
      try {
        $response = $this->handleThrottling($request, $options);
      } catch (RequestException $e) {
        throw new ApiException(
          "[{$e->getCode()}] {$e->getMessage()}",
          $e->getCode(),
          $e->getResponse() ? $e->getResponse()->getHeaders() : null,
          $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
        );
      }

      $statusCode = $response->getStatusCode();

      if ($statusCode < 200 || $statusCode > 299) {
        throw new ApiException(
          sprintf(
            '[%d] Error connecting to the API (%s)',
            $statusCode,
            $request->getUri()
          ),
          $statusCode,
          $response->getHeaders(),
          $response->getBody()
        );
      }

      $responseBody = $response->getBody();
      if ($returnType === '\SplFileObject') {
        $content = $responseBody; //stream goes to serializer
      } else {
        $content = $responseBody->getContents();
        if ($returnType !== 'string') {
          $content = json_decode($content);
        }
      }

      return [
        ObjectSerializer::deserialize($content, $returnType, []),
        $response->getStatusCode(),
        $response->getHeaders()
      ];

    } catch (ApiException $e) {
      switch ($e->getCode()) {
        case 200:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 400:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 401:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 404:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 500:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
      }
      throw $e;
    }
  }

  /**
   * Operation providersProviderIdGetAsync
   *
   * Get a translation provider.
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \InvalidArgumentException
   * @return \GuzzleHttp\Promise\PromiseInterface
   */
  #[\ReturnTypeWillChange]
    public function providersProviderIdGetAsync($authorization, $provider_id)
  {
    return $this->providersProviderIdGetAsyncWithHttpInfo($authorization, $provider_id)
      ->then(
        function ($response) {
          return $response[0];
        }
      );
  }

  /**
   * Operation providersProviderIdGetAsyncWithHttpInfo
   *
   * Get a translation provider.
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \InvalidArgumentException
   * @return \GuzzleHttp\Promise\PromiseInterface
   */
  #[\ReturnTypeWillChange]
    public function providersProviderIdGetAsyncWithHttpInfo($authorization, $provider_id)
  {
    $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider';
    $request = $this->providersProviderIdGetRequest($authorization, $provider_id);

    return $this->client
      ->sendAsync($request, $this->createHttpClientOption())
      ->then(
        function ($response) use ($returnType) {
          $responseBody = $response->getBody();
          if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
          } else {
            $content = $responseBody->getContents();
            if ($returnType !== 'string') {
              $content = json_decode($content);
            }
          }

          return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
          ];
        },
        function ($exception) {
          $response = $exception->getResponse();
          $statusCode = $response->getStatusCode();
          throw new ApiException(
            sprintf(
              '[%d] Error connecting to the API (%s)',
              $statusCode,
              $exception->getRequest()->getUri()
            ),
            $statusCode,
            $response->getHeaders(),
            $response->getBody()
          );
        }
      );
  }

  /**
   * Create request for operation 'providersProviderIdGet'
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \InvalidArgumentException
   * @return \GuzzleHttp\Psr7\Request
   */
  protected function providersProviderIdGetRequest($authorization, $provider_id)
  {
    // verify the required parameter 'authorization' is set
    if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
      throw new \InvalidArgumentException(
        'Missing the required parameter $authorization when calling providersProviderIdGet'
      );
    }
    // verify the required parameter 'provider_id' is set
    if ($provider_id === null || (is_array($provider_id) && count($provider_id) === 0)) {
      throw new \InvalidArgumentException(
        'Missing the required parameter $provider_id when calling providersProviderIdGet'
      );
    }

    $resourcePath = '/providers/{providerId}';
    $formParams = [];
    $queryParams = [];
    $headerParams = [];
    $httpBody = '';
    $multipart = false;

    // header params
    if ($authorization !== null) {
      $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
    }

    // path params
    if ($provider_id !== null) {
      $resourcePath = str_replace(
        '{' . 'providerId' . '}',
        ObjectSerializer::toPathValue($provider_id),
        $resourcePath
      );
    }

    // body params
    $_tempBody = null;

    if ($multipart) {
      $headers = $this->headerSelector->selectHeadersForMultipart(
        ['application/json']
      );
    } else {
      $headers = $this->headerSelector->selectHeaders(
        ['application/json'],
        ['application/json']
      );
    }

    // for model (json/xml)
    if (isset($_tempBody)) {
      // $_tempBody is the method argument, if present
      $httpBody = $_tempBody;
      // \stdClass has no __toString(), so we should encode it manually
      if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
        $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
      }
    } elseif (count($formParams) > 0) {
      if ($multipart) {
        $multipartContents = [];
        foreach ($formParams as $formParamName => $formParamValue) {
          $multipartContents[] = [
            'name' => $formParamName,
            'contents' => $formParamValue
          ];
        }
        // for HTTP post (form)
        $httpBody = new MultipartStream($multipartContents);

      } elseif ($headers['Content-Type'] === 'application/json') {
        $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

      } else {
        // for HTTP post (form)
        $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
      }
    }

    // this endpoint requires API key authentication
    // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
    // if ($apiKey !== null) {
    //   $headers['Authorization'] = $apiKey;
    // }
    // // this endpoint requires API key authentication
    // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
    // if ($apiKey !== null) {
    //   $headers['x-api-key'] = $apiKey;
    // }
    $headers = [
      'Authorization' => 'Bearer ' . $authorization,   
    ];

    $defaultHeaders = [];
    if ($this->config->getUserAgent()) {
      $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
    }

    $headers = array_merge(
      $defaultHeaders,
      $headerParams,
      $headers
    );

    $query = \GuzzleHttp\Psr7\Query::build($queryParams);
    return new Request(
      'GET',
      $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
      $headers,
      $httpBody
    );
  }

  /**
   * Operation providersProviderIdGet
   *
   * Get a translation provider.
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
   * @throws \InvalidArgumentException
   * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider
   */
  #[\ReturnTypeWillChange]
    public function providersProviderIdGetCtt($authorization, $provider_id)
  {
    list($response) = $this->providersProviderIdGetWithHttpInfoCtt($authorization, $provider_id);
    return $response;
  }

  /**
   * Operation providersProviderIdGetWithHttpInfo
   *
   * Get a translation provider.
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
   * @throws \InvalidArgumentException
   * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider, HTTP status code, HTTP response headers (array of strings)
   */
  #[\ReturnTypeWillChange]
    public function providersProviderIdGetWithHttpInfoCtt($authorization, $provider_id)
  {
    $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider';
    $request = $this->providersProviderIdGetRequestCtt($authorization, $provider_id);

    try {
      $options = $this->createHttpClientOption();
      try {
        $response = $this->handleThrottling($request, $options);
      } catch (RequestException $e) {
        throw new ApiException(
          "[{$e->getCode()}] {$e->getMessage()}",
          $e->getCode(),
          $e->getResponse() ? $e->getResponse()->getHeaders() : null,
          $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
        );
      }

      $statusCode = $response->getStatusCode();

      if ($statusCode < 200 || $statusCode > 299) {
        throw new ApiException(
          sprintf(
            '[%d] Error connecting to the API (%s)',
            $statusCode,
            $request->getUri()
          ),
          $statusCode,
          $response->getHeaders(),
          $response->getBody()
        );
      }

      $responseBody = $response->getBody();
      if ($returnType === '\SplFileObject') {
        $content = $responseBody; //stream goes to serializer
      } else {
        $content = $responseBody->getContents();
        if ($returnType !== 'string') {
          $content = json_decode($content);
        }
      }

      return [
        ObjectSerializer::deserialize($content, $returnType, []),
        $response->getStatusCode(),
        $response->getHeaders()
      ];

    } catch (ApiException $e) {
      switch ($e->getCode()) {
        case 200:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 400:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 401:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 404:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
        case 500:
          $data = ObjectSerializer::deserialize(
            $e->getResponseBody(),
            '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
            $e->getResponseHeaders()
          );
          $e->setResponseObject($data);
          break;
      }
      throw $e;
    }
  }

  /**
   * Operation providersProviderIdGetAsync
   *
   * Get a translation provider.
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \InvalidArgumentException
   * @return \GuzzleHttp\Promise\PromiseInterface
   */
  #[\ReturnTypeWillChange]
    public function providersProviderIdGetAsyncCtt($authorization, $provider_id)
  {
    return $this->providersProviderIdGetAsyncWithHttpInfoCtt($authorization, $provider_id)
      ->then(
        function ($response) {
          return $response[0];
        }
      );
  }

  /**
   * Operation providersProviderIdGetAsyncWithHttpInfo
   *
   * Get a translation provider.
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \InvalidArgumentException
   * @return \GuzzleHttp\Promise\PromiseInterface
   */
  #[\ReturnTypeWillChange]
    public function providersProviderIdGetAsyncWithHttpInfoCtt($authorization, $provider_id)
  {
    $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Provider';
    $request = $this->providersProviderIdGetRequestCtt($authorization, $provider_id);

    return $this->client
      ->sendAsync($request, $this->createHttpClientOption())
      ->then(
        function ($response) use ($returnType) {
          $responseBody = $response->getBody();
          if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
          } else {
            $content = $responseBody->getContents();
            if ($returnType !== 'string') {
              $content = json_decode($content);
            }
          }

          return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
          ];
        },
        function ($exception) {
          $response = $exception->getResponse();
          $statusCode = $response->getStatusCode();
          throw new ApiException(
            sprintf(
              '[%d] Error connecting to the API (%s)',
              $statusCode,
              $exception->getRequest()->getUri()
            ),
            $statusCode,
            $response->getHeaders(),
            $response->getBody()
          );
        }
      );
  }

  /**
   * Create request for operation 'providersProviderIdGet'
   *
   * @param  string $authorization Oauth2 token (required)
   * @param  string $provider_id The ID of the translation provider. (required)
   *
   * @throws \InvalidArgumentException
   * @return \GuzzleHttp\Psr7\Request
   */
  protected function providersProviderIdGetRequestCtt($authorization, $provider_id)
  {
    // verify the required parameter 'authorization' is set
    if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
      throw new \InvalidArgumentException(
        'Missing the required parameter $authorization when calling providersProviderIdGet'
      );
    }
    // verify the required parameter 'provider_id' is set
    if ($provider_id === null || (is_array($provider_id) && count($provider_id) === 0)) {
      throw new \InvalidArgumentException(
        'Missing the required parameter $provider_id when calling providersProviderIdGet'
      );
    }

    $resourcePath = '/providers/{providerId}';
    $formParams = [];
    $queryParams = [];
    $headerParams = [];
    $httpBody = '';
    $multipart = false;

    // header params
    if ($authorization !== null) {
      $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
    }

    // path params
    if ($provider_id !== null) {
      $resourcePath = str_replace(
        '{' . 'providerId' . '}',
        ObjectSerializer::toPathValue($provider_id),
        $resourcePath
      );
    }

    // body params
    $_tempBody = null;

    if ($multipart) {
      $headers = $this->headerSelector->selectHeadersForMultipart(
        ['application/json']
      );
    } else {
      $headers = $this->headerSelector->selectHeaders(
        ['application/json'],
        ['application/json']
      );
    }

    // for model (json/xml)
    if (isset($_tempBody)) {
      // $_tempBody is the method argument, if present
      $httpBody = $_tempBody;
      // \stdClass has no __toString(), so we should encode it manually
      if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
        $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
      }
    } elseif (count($formParams) > 0) {
      if ($multipart) {
        $multipartContents = [];
        foreach ($formParams as $formParamName => $formParamValue) {
          $multipartContents[] = [
            'name' => $formParamName,
            'contents' => $formParamValue
          ];
        }
        // for HTTP post (form)
        $httpBody = new MultipartStream($multipartContents);

      } elseif ($headers['Content-Type'] === 'application/json') {
        $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

      } else {
        // for HTTP post (form)
        $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
      }
    }

    //this endpoint requires API key authentication
    $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
    if ($apiKey !== null) {
      $headers['Authorization'] = $apiKey;
    }
    // this endpoint requires API key authentication
    $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
    if ($apiKey !== null) {
      $headers['x-api-key'] = $apiKey;
    }
    // $headers = [
    //   'Authorization' => 'Bearer ' . $authorization,   
    // ];

    $defaultHeaders = [];
    if ($this->config->getUserAgent()) {
      $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
    }

    $headers = array_merge(
      $defaultHeaders,
      $headerParams,
      $headers
    );

    $query = \GuzzleHttp\Psr7\Query::build($queryParams);
    return new Request(
      'GET',
      $this->config->getHost1() . $resourcePath . ($query ? "?{$query}" : ''),
      $headers,
      $httpBody
    );
  }

  /**
   * Create http client option
   *
   * @throws \RuntimeException on file opening failure
   * @return array of http client options
   */
  protected function createHttpClientOption()
  {
    $options = [];
    if ($this->config->getDebug()) {
      $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
      if (!$options[RequestOptions::DEBUG]) {
        throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
      }
    }

    return $options;
  }

  #[\ReturnTypeWillChange]
    public function providersGetCtt($token,$p_id)
    {
        $headers = [
            'Authorization' => 'Bearer ' . $token,        
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];
        
        $request = $this->client->get($this->config->getHost1(). '/providers/', [
        'headers'=> $headers,
        ]);
          
        $output = $request->getBody()->getContents();
        $content = json_decode($output);

        
        foreach($content as $value)
        {
            if($value->providerId == $p_id)
            {
                $provider_name = $value->providerName;
            }
        }
        return $provider_name;
    }

    #[\ReturnTypeWillChange]
    public function providersGetAllCtt($token)
    {
        $headers = [
            'Authorization' => 'Bearer ' . $token,        
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];
        
        $request = $this->client->get($this->config->getHost1(). '/providers/', [
        'headers'=> $headers,
        ]);
          
        $output = $request->getBody()->getContents();
        $content = json_decode($output);

        
      
        return $content;
    }
}
