<?php
/**
 * SourceFileApi
 * PHP version 5
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * The Lionbridge Content API
 *
 * Enable translations with the Lionbridge Content API.
 *
 * OpenAPI spec version: 1.4.3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Drupal\tmgmt_contentapi\Swagger\Client\Api;



use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Drupal\tmgmt_contentapi\Swagger\Client\ApiException;
use Drupal\tmgmt_contentapi\Swagger\Client\Configuration;
use Drupal\tmgmt_contentapi\Swagger\Client\HeaderSelector;
use Drupal\tmgmt_contentapi\Swagger\Client\ObjectSerializer;

/**
 * SourceFileApi Class Doc Comment
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SourceFileApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    #[\ReturnTypeWillChange]
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,

    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    #[\ReturnTypeWillChange]
    public function getConfig()
    {
        return $this->config;
    }


    #[\ReturnTypeWillChange]
    public function handleThrottling($request, $options) {
      return \DRUPAL::service('tmgmt_contentapi.handle_throttling')->handleThrottling($request, $options);
    }

    /**
     * Operation jobsJobIdUploadPost
     *
     * Upload a binary file to a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  string $file_name Name of file. (required)
     * @param  string $file_type MIME type of the source file of the request. If empty, a default will be supplied based on the extension extracted from the name of the request, or &#39;application/octet-stream&#39; if no extension can be found from the name of the request. (required)
     * @param  \SplFileObject $source_file The file of the source content for the request(s). *Note*: \&quot;Try it out\&quot; for this method on developers.lionbridge.com is currently not functioning. To test this method, use the cURL sample on https://bitbucket.org/liox-ondemand/liox-content-api-client/src/master/curl/File%20Workflow (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\SourceFile
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdUploadPost($authorization, $job_id, $file_name, $file_type, $source_file)
    {
        list($response) = $this->jobsJobIdUploadPostWithHttpInfo($authorization, $job_id, $file_name, $file_type, $source_file);
        return $response;
    }

    /**
     * Operation jobsJobIdUploadPostWithHttpInfo
     *
     * Upload a binary file to a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  string $file_name Name of file. (required)
     * @param  string $file_type MIME type of the source file of the request. If empty, a default will be supplied based on the extension extracted from the name of the request, or &#39;application/octet-stream&#39; if no extension can be found from the name of the request. (required)
     * @param  \SplFileObject $source_file The file of the source content for the request(s). *Note*: \&quot;Try it out\&quot; for this method on developers.lionbridge.com is currently not functioning. To test this method, use the cURL sample on https://bitbucket.org/liox-ondemand/liox-content-api-client/src/master/curl/File%20Workflow (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\SourceFile, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdUploadPostWithHttpInfo($authorization, $job_id, $file_name, $file_type, $source_file)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\SourceFile';
        $request = $this->jobsJobIdUploadPostRequest($authorization, $job_id, $file_name, $file_type, $source_file);

        try {
            $options = $this->createHttpClientOption();
            $options = [
              'curl' => [
                  CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4,
              ],
            ];
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\SourceFile',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdUploadPostAsync
     *
     * Upload a binary file to a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  string $file_name Name of file. (required)
     * @param  string $file_type MIME type of the source file of the request. If empty, a default will be supplied based on the extension extracted from the name of the request, or &#39;application/octet-stream&#39; if no extension can be found from the name of the request. (required)
     * @param  \SplFileObject $source_file The file of the source content for the request(s). *Note*: \&quot;Try it out\&quot; for this method on developers.lionbridge.com is currently not functioning. To test this method, use the cURL sample on https://bitbucket.org/liox-ondemand/liox-content-api-client/src/master/curl/File%20Workflow (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdUploadPostAsync($authorization, $job_id, $file_name, $file_type, $source_file)
    {
        return $this->jobsJobIdUploadPostAsyncWithHttpInfo($authorization, $job_id, $file_name, $file_type, $source_file)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdUploadPostAsyncWithHttpInfo
     *
     * Upload a binary file to a job.
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  string $file_name Name of file. (required)
     * @param  string $file_type MIME type of the source file of the request. If empty, a default will be supplied based on the extension extracted from the name of the request, or &#39;application/octet-stream&#39; if no extension can be found from the name of the request. (required)
     * @param  \SplFileObject $source_file The file of the source content for the request(s). *Note*: \&quot;Try it out\&quot; for this method on developers.lionbridge.com is currently not functioning. To test this method, use the cURL sample on https://bitbucket.org/liox-ondemand/liox-content-api-client/src/master/curl/File%20Workflow (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdUploadPostAsyncWithHttpInfo($authorization, $job_id, $file_name, $file_type, $source_file)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\SourceFile';
        $request = $this->jobsJobIdUploadPostRequest($authorization, $job_id, $file_name, $file_type, $source_file);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdUploadPost'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id Job ID. (required)
     * @param  string $file_name Name of file. (required)
     * @param  string $file_type MIME type of the source file of the request. If empty, a default will be supplied based on the extension extracted from the name of the request, or &#39;application/octet-stream&#39; if no extension can be found from the name of the request. (required)
     * @param  \SplFileObject $source_file The file of the source content for the request(s). *Note*: \&quot;Try it out\&quot; for this method on developers.lionbridge.com is currently not functioning. To test this method, use the cURL sample on https://bitbucket.org/liox-ondemand/liox-content-api-client/src/master/curl/File%20Workflow (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdUploadPostRequest($authorization, $job_id, $file_name, $file_type, $source_file)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdUploadPost'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdUploadPost'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling jobsJobIdUploadPost'
            );
        }
        // // verify the required parameter 'file_type' is set
        // if ($file_type === null) {
        //     throw new \InvalidArgumentException(
        //         'Missing the required parameter $file_type when calling jobsJobIdUploadPost'
        //     );
        // }
        // // verify the required parameter 'source_file' is set
        // if ($source_file === null) {
        //     throw new \InvalidArgumentException(
        //         'Missing the required parameter $source_file when calling jobsJobIdUploadPost'
        //     );
        // }

        $resourcePath = '/jobs/{jobId}/sourcefiles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($file_name !== null) {
            $queryParams['fileName'] = ObjectSerializer::toQueryValue($file_name);
        }
        // query params
        // if ($file_type !== null) {
        //     $queryParams['fileType'] = ObjectSerializer::toQueryValue($file_type);
        // }
        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }

        // // form params
        // if ($source_file !== null) {
        //     $multipart = true;
        //     $formParams['sourceFile'] = \GuzzleHttp\Psr7\try_fopen(ObjectSerializer::toFormValue($source_file), 'rb');
        // }
        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['multipart/form-data']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = [
            'Authorization' => 'Bearer ' . $authorization,
            'Accept'        => 'application/json',
            'Content-Type'  => 'application/json',
            'fileName' => $file_name,
            //'Host' => parse_url($this->config->getHost(), PHP_URL_HOST),
            'Connection' => 'keep-alive',
          ];

        // // Use curl to verify the SSL certificate
        // $curl_option['curl'] = [
        //     CURLOPT_SSL_VERIFYHOST => 2, // Verify the certificate’s hostname
        //     CURLOPT_SSL_VERIFYPEER => true, // Verify the SSL certificate
        // ];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers,
        );
        $hostIp = $this->config->getHost();
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $hostIp . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    #[\ReturnTypeWillChange]
    public function uploadFile($contentapitmpfile, $jobpath)
    {
        $fileSize = filesize($jobpath);
        $minTusSize = (1024 * 1024 * 5);
        if($fileSize < $minTusSize){
            return $this->directUpload($contentapitmpfile, $jobpath);
        }else{
            return $this->tusUpload($contentapitmpfile, $jobpath);
        }
    }
    private function getData($path, $offset,$lenbytes)
    {
        $data = file_get_contents($path, FALSE, NULL, $offset, $lenbytes);
        return $data;
    }
    private function tusUpload($contentapitmpfile, $jobpath)
    {
        $chunkSize = (1024 * 1024 * 5);
        $fileSize = filesize($jobpath);
        if($chunkSize > $fileSize){
            $chunkSize = $fileSize;
        }
        $chunkCount = ceil($fileSize/$chunkSize);
        $checksum = 'sha256  '.base64_encode(
            hash_file('sha256', $jobpath)
        );
        $offset = 0;
        $uploadKey = $contentapitmpfile['fms_sas_token'];
        $uploadURL = $contentapitmpfile['fms_upload_url'];

        $tusClient = new Client([
            'timeout'  => 5000
        ]);
        $locations = array();
        $maxAttempts = 10;
        $retryDelay = 3; // 3 seconds
        $attempts = 0;
        $location = null;
        while ($attempts < $maxAttempts) {
          try {
            $request = new Request('POST',$uploadURL, [
                'Upload-Length' => ObjectSerializer::toQueryValue($fileSize),
                'Tus-Resumable' => ObjectSerializer::toQueryValue('1.0.0'),
                'Content-Length' => ObjectSerializer::toQueryValue('0'),
                'sastoken' => ObjectSerializer::toQueryValue((string)$contentapitmpfile['fms_sas_token']),
                'Upload-Metadata' => ObjectSerializer::toQueryValue('name '.base64_encode(basename($jobpath)).',contentType '.base64_encode('application/json').',chunkSize '.base64_encode(strval($chunkSize)))
            ]);
            $response = $tusClient->send($request);
            $location = $request->getUri()->getHost() . $response->getHeader('Location')[0];
            $locations[$idx]=strval($location);
            break;
          }
          catch (\Exception $e) {
            $attempts++;
            if ($attempts >= $maxAttempts) {
                throw new \Exception("Failed to create upload session after $maxAttempts attempts: " . $e->getMessage());
            }
            sleep($retryDelay);
          }
        }
        for($idx = 0; $idx < $chunkCount; $idx++)
        {
            if($idx == ($chunkCount - 1)){
                $chunkSize = $fileSize - ($idx * $chunkSize);
            }
            $data = $this->getData($jobpath, $offset, $chunkSize);
            $attempts = 0;
            while ($attempts < $maxAttempts) {
              try {
                $request = new Request('PATCH',$location,
                [
                        'Content-Type' => ObjectSerializer::toQueryValue('application/offset+octet-stream'),
                        'Tus-Resumable' => ObjectSerializer::toQueryValue('1.0.0'),
                        'Content-Length' => ObjectSerializer::toQueryValue($chunkSize),
                        'Upload-Offset' => ObjectSerializer::toQueryValue($offset),
                        'sastoken' => ObjectSerializer::toQueryValue((string)$contentapitmpfile['fms_sas_token'])
                        ],$data);
                $response = $tusClient->send($request);
                $offset = (int)$response->getHeader("Upload-Offset")[0];
                break;
              } 
              catch (\Exception $e) {
                $attempts++;
                if ($attempts >= $maxAttempts) {
                    throw new \Exception("Failed to upload chunk $idx after $maxAttempts attempts: " . $e->getMessage());
                }
                sleep($retryDelay);
              }
            }

        }
       
        return $response;
    }

    private function directUpload($contentapitmpfile, $jobpath){
        $resourcePath = $contentapitmpfile['fms_multipart_url'];
        $directClient = new Client([
            'base_uri' => $resourcePath,
            'timeout'  => 3600.0,
        ]);

        $attempts = 0;
        $maxAttempts = 10;
        $retryDelay = 3; // Seconds
        $response = null;
        while ($attempts < $maxAttempts) {
          try {
            $response = $directClient->request('POST', '', [
                'multipart' => [
                    [
                        'name'     => 'file',
                        'contents' => fopen($jobpath, 'r'),
                        'filename' => basename($jobpath),
                        'headers'  => [
                            'Content-Type' => 'multipart/form-data'
                        ]
                    ]
                ]
            ]);
            // Check if the response status code is successful (2xx)
            if ($response->getStatusCode() >= 200 && $response->getStatusCode() < 300) {
                return $response;
            }
            \Drupal::logger('TMGMT_CONTENTAPI_DIRECT_UPLOAD')->notice('Throttling handler got statuscode:@statuscode, retrying once:@attempts',
                [
                    '@attempts' => $attempts,
                    '@statuscode' => $response->getStatusCode(),
            ]);
            // If the status code is not successful, increment attempts
            $attempts++;
            sleep($retryDelay);
          }
          catch (\Exception $e) {
            // Handle exceptions like network errors or server issues
            $attempts++;

            if ($attempts >= $maxAttempts) {
                throw new \Exception("Failed to upload file after $maxAttempts attempts: " . $e->getMessage());
            }

            sleep($retryDelay);
          }
        }
        
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
