<?php
/**
 * TokenApi
 * PHP version 5
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * The Lionbridge Content API
 *
 * Enable translations with the Lionbridge Content API.
 *
 * OpenAPI spec version: 1.4.3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Drupal\tmgmt_contentapi\Swagger\Client\Api;



use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Drupal\tmgmt_contentapi\Swagger\Client\ApiException;
use Drupal\tmgmt_contentapi\Swagger\Client\Configuration;
use Drupal\tmgmt_contentapi\Swagger\Client\HeaderSelector;
use Drupal\tmgmt_contentapi\Swagger\Client\ObjectSerializer;

/**
 * TokenApi Class Doc Comment
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TokenApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;


    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    #[\ReturnTypeWillChange]
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    #[\ReturnTypeWillChange]
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation oauth2TokenPost
     *
     * Get a new token.
     *
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateToken $body Created token object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\Token
     */
    #[\ReturnTypeWillChange]
    public function oauth2TokenPost($body)
    {
        try{
            list($response) = $this->oauth2TokenPostWithHttpInfo($body);
            return $response;
        }catch(Exception $ex){
            return null;
        }
    }

    /**
     * Operation oauth2TokenPostWithHttpInfo
     *
     * Get a new token.
     *
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateToken $body Created token object (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\Token, HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function oauth2TokenPostWithHttpInfo($body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Token';
        $request = $this->oauth2TokenPostRequest($body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Token',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation oauth2TokenPostAsync
     *
     * Get a new token.
     *
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateToken $body Created token object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function oauth2TokenPostAsync($body)
    {
        return $this->oauth2TokenPostAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation oauth2TokenPostAsyncWithHttpInfo
     *
     * Get a new token.
     *
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateToken $body Created token object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function oauth2TokenPostAsyncWithHttpInfo($body)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Token';
        $request = $this->oauth2TokenPostRequest($body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'oauth2TokenPost'
     *
     * @param  \Drupal\tmgmt_contentapi\Swagger\Client\Model\CreateToken $body Created token object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function oauth2TokenPostRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling oauth2TokenPost'
            );
        }

        $resourcePath = '/oauth2/token';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost1() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    #[\ReturnTypeWillChange]
    public function getToken($clientid, $clientsecretid) {
      // Replace all - with _ in the client id.
      $identification_id = str_replace('-', '_', $clientid);
      // Use drupal core Kevalue Expire service to store the token.
      $kv_store = \Drupal::service('keyvalue.expirable')->get('lionbridge_translation_provider');
      // log kv_store value in the log with appropriate format.
      //\Drupal::logger('lionbridge_translation_provider')->notice('KV Store: @kv_store', ['@kv_store' => print_r($kv_store, TRUE)]);
      // Get the value or null.
      $capi_token = $kv_store->get('capi_token' . $identification_id, NULL);
      // log if this function is called.
      // check how much time left for the token to expire.
      $expire_time = $kv_store->get('capi_token_expiration' . $identification_id, 0);
      $current_time = time();
      if ($expire_time) {
        $time_remaining = $expire_time - $current_time;
      }
      // If the token null generate new one. Else return existing token.
      // If token suppose expire in 10 minutes, then get new token.
      if ($capi_token == NULL || $time_remaining < 600) {
        // Log due to which condition on which new token is generated.
        $capi_token = $this->generateNewToken($clientid, $clientsecretid);
      }
      return $capi_token;
    }

    /**
     * Function to generate token.
     *
     * @param mixed $clientid
     *   Client id.
     * @param mixed $clientsecretid
     *   Client secret id.
     */
    public function generateNewToken($clientid, $clientsecretid) {
      // Replace all - with _ in the client id.
      $identification_id = str_replace('-', '_', $clientid);
      // If the token is null get a new token.
      $tokenEndpoint = Configuration::getDefaultConfiguration()->getTokenEndpoint();
      $response = $this->client->post($tokenEndpoint, [
        'form_params' => [
          'grant_type' => 'client_credentials',
          'client_id' => $clientid,
          'client_secret' => $clientsecretid,
        ],
      ]);
      $value = $response->getBody()->getContents();
      $json_decode = json_decode($value, true);
      $capi_token = $json_decode['access_token'];
      // Set the token with expire time.
      \Drupal::service('keyvalue.expirable')->get('lionbridge_translation_provider')->setWithExpire('capi_token' . $identification_id, $json_decode['access_token'], $json_decode['expires_in']);
      // Log the token expire time.
      //\Drupal::logger('lionbridge_translation_provider')->notice('Token expire time: @token_expire_time', ['@token_expire_time' => $json_decode['expires_in']]);
      $expiration_time = time() + $json_decode['expires_in'];
      \Drupal::service('keyvalue.expirable')->get('lionbridge_translation_provider')->setWithExpire('capi_token_expiration' . $identification_id, $expiration_time, $json_decode['expires_in']);
      return $capi_token;
    }

}
