<?php
/**
 * TranslationContentApi
 * PHP version 5
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * The Lionbridge Content API
 *
 * Enable translations with the Lionbridge Content API.
 *
 * OpenAPI spec version: 1.4.3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Drupal\tmgmt_contentapi\Swagger\Client\Api;



use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Drupal\tmgmt_contentapi\Swagger\Client\ApiException;
use Drupal\tmgmt_contentapi\Swagger\Client\Configuration;
use Drupal\tmgmt_contentapi\Swagger\Client\HeaderSelector;
use Drupal\tmgmt_contentapi\Swagger\Client\ObjectSerializer;

/**
 * TranslationContentApi Class Doc Comment
 *
 * @category Class
 * @package  Drupal\tmgmt_contentapi\Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TranslationContentApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    #[\ReturnTypeWillChange]
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    #[\ReturnTypeWillChange]
    public function getConfig()
    {
        return $this->config;
    }

    #[\ReturnTypeWillChange]
    public function handleThrottling($request, $options) {
      return \DRUPAL::service('tmgmt_contentapi.handle_throttling')->handleThrottling($request, $options);
    }

    /**
     * Operation jobsJobIdRequestsRequestIdRetrieveGet
     *
     * Retrieve the target content for translation request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\TranslationContent[]
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdRetrieveGet($authorization, $job_id, $request_id)
    {
        list($response) = $this->jobsJobIdRequestsRequestIdRetrieveGetWithHttpInfo($authorization, $job_id, $request_id);
        return $response;
    }

    /**
     * Operation jobsJobIdRequestsRequestIdRetrieveGetWithHttpInfo
     *
     * Retrieve the target content for translation request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \Drupal\tmgmt_contentapi\Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Drupal\tmgmt_contentapi\Swagger\Client\Model\TranslationContent[], HTTP status code, HTTP response headers (array of strings)
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdRetrieveGetWithHttpInfo($authorization, $job_id, $request_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\TranslationContent[]';
        $request = $this->jobsJobIdRequestsRequestIdRetrieveGetRequest($authorization, $job_id, $request_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->handleThrottling($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\TranslationContent[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Drupal\tmgmt_contentapi\Swagger\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation jobsJobIdRequestsRequestIdRetrieveGetAsync
     *
     * Retrieve the target content for translation request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdRetrieveGetAsync($authorization, $job_id, $request_id)
    {
        return $this->jobsJobIdRequestsRequestIdRetrieveGetAsyncWithHttpInfo($authorization, $job_id, $request_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation jobsJobIdRequestsRequestIdRetrieveGetAsyncWithHttpInfo
     *
     * Retrieve the target content for translation request(s).
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    #[\ReturnTypeWillChange]
    public function jobsJobIdRequestsRequestIdRetrieveGetAsyncWithHttpInfo($authorization, $job_id, $request_id)
    {
        $returnType = '\Drupal\tmgmt_contentapi\Swagger\Client\Model\TranslationContent[]';
        $request = $this->jobsJobIdRequestsRequestIdRetrieveGetRequest($authorization, $job_id, $request_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'jobsJobIdRequestsRequestIdRetrieveGet'
     *
     * @param  string $authorization Oauth2 token (required)
     * @param  string $job_id The ID of the job. (required)
     * @param  string $request_id The ID of the translation request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function jobsJobIdRequestsRequestIdRetrieveGetRequest($authorization, $job_id, $request_id)
    {
        // verify the required parameter 'authorization' is set
        if ($authorization === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling jobsJobIdRequestsRequestIdRetrieveGet'
            );
        }
        // verify the required parameter 'job_id' is set
        if ($job_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $job_id when calling jobsJobIdRequestsRequestIdRetrieveGet'
            );
        }
        // verify the required parameter 'request_id' is set
        if ($request_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling jobsJobIdRequestsRequestIdRetrieveGet'
            );
        }

        $resourcePath = '/jobs/{jobId}/requests/{requestId}/retrieve';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($job_id !== null) {
            $resourcePath = str_replace(
                '{' . 'jobId' . '}',
                ObjectSerializer::toPathValue($job_id),
                $resourcePath
            );
        }
        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        // if ($apiKey !== null) {
        //     $headers['Authorization'] = $apiKey;
        // }
        // // this endpoint requires API key authentication
        // $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        // if ($apiKey !== null) {
        //     $headers['x-api-key'] = $apiKey;
        // }
        $headers = [
            'Authorization' => 'Bearer ' . $authorization,   
            'Accept'        => 'application/json',
            'Content-Type'        => 'application/json',
        ];

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
