<?php
/**
 * Capabilities
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * The Lionbridge Content API
 *
 * Enable translations with the Lionbridge Content API.
 *
 * OpenAPI spec version: 1.6.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.8
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Drupal\tmgmt_contentapi\Swagger\Client\Model;

use \ArrayAccess;
use \Drupal\tmgmt_contentapi\Swagger\Client\ObjectSerializer;

/**
 * Capabilities Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class Capabilities implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'Capabilities';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'support_update_tm' => 'bool',
        'support_quote' => 'bool',
        'supported_languages' => '\Drupal\tmgmt_contentapi\Swagger\Client\Model\LanguagePairs[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'support_update_tm' => null,
        'support_quote' => null,
        'supported_languages' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    #[\ReturnTypeWillChange]
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    #[\ReturnTypeWillChange]
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'support_update_tm' => 'supportUpdateTM',
        'support_quote' => 'supportQuote',
        'supported_languages' => 'supportedLanguages'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'support_update_tm' => 'setSupportUpdateTm',
        'support_quote' => 'setSupportQuote',
        'supported_languages' => 'setSupportedLanguages'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'support_update_tm' => 'getSupportUpdateTm',
        'support_quote' => 'getSupportQuote',
        'supported_languages' => 'getSupportedLanguages'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    #[\ReturnTypeWillChange]
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    #[\ReturnTypeWillChange]
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    #[\ReturnTypeWillChange]
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    #[\ReturnTypeWillChange]
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['support_update_tm'] = isset($data['support_update_tm']) ? $data['support_update_tm'] : null;
        $this->container['support_quote'] = isset($data['support_quote']) ? $data['support_quote'] : null;
        $this->container['supported_languages'] = isset($data['supported_languages']) ? $data['supported_languages'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    #[\ReturnTypeWillChange]
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    #[\ReturnTypeWillChange]
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets support_update_tm
     *
     * @return bool
     */
    #[\ReturnTypeWillChange]
    public function getSupportUpdateTm()
    {
        return $this->container['support_update_tm'];
    }

    /**
     * Sets support_update_tm
     *
     * @param bool $support_update_tm Defines if the provider supports TM updates.
     *
     * @return $this
     */
    #[\ReturnTypeWillChange]
    public function setSupportUpdateTm($support_update_tm)
    {
        $this->container['support_update_tm'] = $support_update_tm;

        return $this;
    }

    /**
     * Gets support_quote
     *
     * @return bool
     */
    #[\ReturnTypeWillChange]
    public function getSupportQuote()
    {
        return $this->container['support_quote'];
    }

    /**
     * Sets support_quote
     *
     * @param bool $support_quote Defines if the provider supports quoting.
     *
     * @return $this
     */
    #[\ReturnTypeWillChange]
    public function setSupportQuote($support_quote)
    {
        $this->container['support_quote'] = $support_quote;

        return $this;
    }

    /**
     * Gets supported_languages
     *
     * @return \Drupal\tmgmt_contentapi\Swagger\Client\Model\LanguagePairs[]
     */
    #[\ReturnTypeWillChange]
    public function getSupportedLanguages()
    {
        return $this->container['supported_languages'];
    }

    /**
     * Sets supported_languages
     *
     * @param \Drupal\tmgmt_contentapi\Swagger\Client\Model\LanguagePairs[] $supported_languages A list of supported source/target languages.
     *
     * @return $this
     */
    #[\ReturnTypeWillChange]
    public function setSupportedLanguages($supported_languages)
    {
        $this->container['supported_languages'] = $supported_languages;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    #[\ReturnTypeWillChange]
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


