# Listing page module

## Introduction

Display the content of your views in content entities. Give your clients control over url aliases, metatags, translation etc..

## When to use this module

Views has a display plugin "Page" wich allows to render the views in a stand alone page that has it's own route.

This works well for sites that do not "move" a lot but has some limitations :

- What if you want to change or translate the route?
- What if you want to display some other contents to the page?
- What if you want to alter the page metatags?
- What if you want to change the displayed title?
- etc...

For all of these use cases, you'll have play with views_ui and you w'll definitly have to export and import the config in order to deploy on production.

But then what if your client wants to be able to change all of this by himself?
You'll have to give him access to views_ui, exclude configs via config_ignore or config_plit and hope nothing breaks.

This module tries to address this use cases. By moving all of this configurations to content scope.

### Basic usage

Configure your content types and views :

- Create a views that lists your content type (`news` for exemple).
- Add a display "Listing page" to the views.
- Create and configure a content type (`listing` for example) as you normally would do.
- Add a field of type "Entity listing information" (`field_listing` for example) that will hold data about the views that lists things and the content type of the things that are listed.
- Theme your views and your nodes you normally do.

Add contents :

- Create a "Listing page" content and choose your views (`news`)
- Give your node a alias url, change metatags as you wish, add paragraphs etc...

## Requirements

The minimum requirements are :

- Views
- Fields

## Featues

Supports :

- Search API based views
- Facets
- Tokens

## Under the hood

- Introduces a new field type `entity_listing_info` that holds data about the views that lists things and the content type of the things that are listed.
- Introduces a new field widget `entity_listing_info_default` to collect the views and the content type.
- Introduces a new field formatter `entity_listing_info_default` to display the views on the listing page.
- Introduces a new views diplay `listing_page`.
- Ships with several theme suggessions that extend the theme layer and provides more flexibility to themers to extend templates.
- Introduces some usefull tokens that helpes with retreiving informations about listing entities For example:
  - `[site:listing_page:node:news:url:relative]` returns the relative url of the news listing page.
  - `[node:related_listing_entity:url:relative]` returns the relative url of the "parent" listing entity
combined with pathauto, this makes it possible to define "dynamic" urls aliases with ease that could be updated with ease and without change in config.
  - The most common usage for url aliases is : `[node:related_listing_entity:url:relative]/[node:title]`
- Ships a twig extension to generate a link to the listing entity page.
- Introduces a hook `hook_listing_entities_alter` to allow altering the selected listing entities.

## Maintainers

Current maintainers for Drupal 10 / 11:

- Adel Ben Yacoub (adel-by) - <https://www.drupal.org/u/adel-by>
