<?php

declare(strict_types=1);

namespace Drupal\listing_page\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Provides a Same entity type constraint.
 *
 * @see https://www.drupal.org/node/2015723
 */
#[Constraint(
  id: 'SameEntityType',
  label: new TranslatableMarkup('Same entity type', options: ['context' => 'Validation'])
)]
final class SameEntityTypeConstraint extends SymfonyConstraint {

  /**
   * The default violation message.
   *
   * @var string
   */
  public string $message = 'Mixing multiple entity type is not supported.';

}
