<?php

namespace Drupal\listing_page\Plugin\views\display;

use Drupal\views\Plugin\views\display\DisplayPluginBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\views\Attribute\ViewsDisplay;

/**
 * The plugin that handles a listing_page display.
 *
 * @ingroup views_display_plugins
 */
#[ViewsDisplay(
  id: "listing_page",
  title: new TranslatableMarkup("Listing page"),
  help: new TranslatableMarkup("Provide a display which can be embedded into listing pages."),
  theme: "views_view",
  uses_menu_links: FALSE
)]
class ListingPage extends DisplayPluginBase {

  /**
   * {@inheritdoc}
   */
  protected $usesAttachments = TRUE;

  /**
   * {@inheritdoc}
   */
  public function buildRenderable(array $args = [], $cache = TRUE) {
    $build = parent::buildRenderable($args, $cache);
    $build['#embed'] = TRUE;
    return $build;
  }

}
