<?php

declare(strict_types=1);

namespace Drupal\listing_page\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'Entity listing information' formatter.
 */
#[FieldFormatter(
  id: 'entity_listing_info_default',
  label: new TranslatableMarkup('Entity listing'),
  field_types: ['entity_listing_info'],
)]
final class EntityListingInfoDefaultFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $element = [];
    foreach ($items as $delta => $item) {
      [$views_id, $display_id] = explode(':', $item->views);
      if ($build_view = views_embed_view($views_id, $display_id)) {
        $element[$delta] = $build_view;
        $element[$delta]['#listing_entity'] = $items->getEntity()->getEntityTypeId() . ':' . $items->getEntity()->id();
      }
    }
    return $element;
  }

}
