<?php

declare(strict_types=1);

namespace Drupal\listing_page\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates the Same entity type constraint.
 */
final class SameEntityTypeConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate(mixed $values, Constraint $constraint): void {

    // Get a list of unique entered entity types.
    $entity_types = array_unique(array_map(function ($string) {
      return explode(':', $string)[0];
    }, $values));

    // Register a violation if we  found more than one item.
    if (count($entity_types) > 1) {
      $this->context->addViolation($constraint->message);
    }

  }

}
