/* eslint-disable no-undef */
/**
 * @file
 * Behavior which initializes the select_extractor library for the menu node form
 */
(function (Drupal, drupalSettings, once) {
  Drupal.behaviors.book_parent_ui = {
    attach(context) {
      once('book_parent_ui', '.js-form-item-book-pid', context).forEach(
        function () {
          if (document.getElementById('edit-book-pid')) {
            new SelectExtractorBook({
              selectors: {
                select_input_original: '#edit-book-pid',
                select_box_container: '.js-form-item-book-pid',
                active_set: drupalSettings.book_active_path,
              },
            });
          }
          // This is the node add form.
          else {
            new SelectExtractorBook({
              selectors: {
                select_input_original: 'select[name="book[pid]"]',
                select_box_container: '.js-form-item-book-pid',
                active_set: drupalSettings.book_active_path,
              },
            });
          }
        },
      );
    },
  };
})(Drupal, drupalSettings, once);
