### Essential configuration changes for DrupalDev / Docker4Drupal

**Nginx**

Add the following environment variable to your `docker-compose.yml` file to specify a custom Nginx configuration for the `/llms.txt` endpoint:

```yaml
NGINX_SERVER_EXTRA_CONF_FILEPATH: /mnt/files/local_mount/build/config/nginx/locations.conf
```

If the `locations.conf` file does not exist in your project, create it with the following content to enable support for the `llms_txt` module:

```
# Enable support for the llms_txt module
location = /llms.txt {
  access_log off;
  try_files $uri @drupal;
}
```

**Apache**

Configuration instructions for Apache are to be determined.

## DDEV

**No additional configuration required** - As of DDEV v1.24.6, the llms_txt module works out of the box without any additional server configuration changes.
