# llms.txt AI Generator

<p><strong>Automatically generate llms.txt files for your Drupal site using AI. Makes your content discoverable by ChatGPT, Claude, Perplexity, Gemini and other Large Language Models.</strong></p>

<blockquote>
<strong>Summary:</strong> AI-powered llms.txt generator. Extracts menus & meta descriptions, reformulates with AI into natural language. Makes your site understandable by AI...
</blockquote>

## Features

- **Menu extraction:** Automatically pulls pages from your Drupal menus
- **Meta descriptions:** Reads existing meta via Metatag module
- **AI reformulation:** Transforms SEO text into natural language using AI module
- **Manual editing:** Add or override any description
- **One-click generation:** Creates llms.txt in a few minutes

### Why use this?

Users increasingly ask AI questions instead of searching into the web. The llms.txt standard helps LLMs understand your site during conversations.

## Additional Requirements

### Required

- **Drupal:** 10.0+ or 11.0+
- **AI Module:** `composer require drupal/ai`

### Web Server Setup

**Nginx:** Add to your config:

```
location = /llms.txt {
  access_log off;
  try_files $uri @drupal;
}
```

**Apache:** Usually works out of the box.

## Post-Installation

### Quick Start

1. Go to `Configuration > Content authoring > llms.txt AI Generator`
2. Write introduction text (2-3 paragraphs about your site)
3. Select menus to include (Main navigation, Footer, etc.)
4. Configure AI settings: Choose any AI provider configured in the AI module
5. Review descriptions - add manual ones for pages missing meta
6. Click "Generate llms.txt"
7. Done! Your file is live at `yoursite.com/llms.txt`

### Configuration

- **Content Sources:** Select menus, set depth (3 levels recommended)
- **AI Settings:** Choose provider AI
- **Manage Descriptions:** Review all pages, add missing descriptions
- **Generate:** Create and publish your llms.txt

## Recommended Modules

- **Metatag** (`drupal/metatag`): Highly recommended for automatic meta extraction. Without it, you'll need to add descriptions manually.
- **Pathauto** (`drupal/pathauto`): Clean URLs for better links

## Similar Projects

| Module | AI Integration | Best For |
|--------|----------------|----------|
| **llms_txt_ai** (this) | ✅ Full AI reformulation | Automated natural language |
| llms_txt (Pronovix) | ❌ Manual | Full manual control |
| llmstxt | ❌ Manual | Simple sites |
| LLMs txt Exporter | ❌ No AI | Basic listing |

**Unique features:** Only module using AI for natural language reformulation + menu-first approach + hybrid auto/manual editing.

## FAQ

**Do I need Metatag module?**
Recommended but not required. Without it, manual descriptions needed.

**Should I include all 1000 pages?**
No! Select 20-50 key pages. Think "executive summary" not "full catalog."

**Will this slow my site?**
No. Generation is on-demand, not during page loads. Output is cached.

## Technical

**Data flow:** Menus → Meta extraction → Manual editing → AI reformulation → llms.txt generation → Publish

**Storage:** Configuration via CMI (exportable), manual descriptions via KeyValue (lightweight, no DB tables)

