<?php

namespace Drupal\llms_txt_ai\Service;

use Drupal\Core\KeyValueStore\KeyValueFactoryInterface;
use Drupal\Core\KeyValueStore\KeyValueStoreInterface;

/**
 * Service to store manual description overrides.
 */
class DescriptionStorageService {

  /**
   * The key-value store.
   *
   * @var \Drupal\Core\KeyValueStore\KeyValueStoreInterface
   */
  protected $storage;

  /**
   * Constructs a DescriptionStorageService object.
   *
   * @param \Drupal\Core\KeyValueStore\KeyValueFactoryInterface $key_value_factory
   *   The key-value factory.
   */
  public function __construct(KeyValueFactoryInterface $key_value_factory) {
    $this->storage = $key_value_factory->get('llms_txt_ai_manual_descriptions');
  }

  /**
   * Sets a manual description for a node.
   *
   * @param int|string $nid
   *   The node ID or special identifier (e.g., 'homepage_manual').
   * @param string $description
   *   The description text.
   */
  public function set(int|string $nid, string $description): void {
    $this->storage->set((string) $nid, $description);
  }

  /**
   * Gets a manual description for a node.
   *
   * @param int|string $nid
   *   The node ID or special identifier (e.g., 'homepage_manual').
   *
   * @return string|null
   *   The description or NULL if not set.
   */
  public function get(int|string $nid): ?string {
    return $this->storage->get((string) $nid);
  }

  /**
   * Gets all manual descriptions.
   *
   * @return array
   *   Array of descriptions keyed by NID.
   */
  public function getAll(): array {
    return $this->storage->getAll();
  }

  /**
   * Deletes a manual description.
   *
   * @param int|string $nid
   *   The node ID or special identifier (e.g., 'homepage_manual').
   */
  public function delete(int|string $nid): void {
    $this->storage->delete((string) $nid);
  }

}

