# llms.txt AI Generator

<p><strong>Automatically generate llms.txt files for your Drupal site using AI. Makes your content discoverable by ChatGPT, Claude, Perplexity, Gemini and other Large Language Models.</strong></p>

<blockquote>
<strong>Summary:</strong> AI-powered llms.txt generator. Extracts menus & meta descriptions, reformulates with AI into natural language. Makes your site understandable by AI...
</blockquote>

## Features

- **Menu extraction:** Automatically pulls pages from your Drupal menus
- **Meta descriptions:** Reads existing meta via Metatag module
- **AI reformulation:** Transforms SEO text into natural language using AI module
- **Manual editing:** Add or override any description
- **One-click generation:** Creates llms.txt in a few minutes
- **Auto-regeneration:** Automatically updates llms.txt when content changes (via cron)

### Why use this?

Users increasingly ask AI questions instead of searching into the web. The llms.txt standard helps LLMs understand your site during conversations.

## Additional Requirements

### Required

- **Drupal:** 10.0+ or 11.0+
- **AI Module:** `composer require drupal/ai`

### Web Server Setup

**Nginx:** Add to your config:

```
location = /llms.txt {
  access_log off;
  try_files $uri @drupal;
}
```

**Apache:** Usually works out of the box.

## Post-Installation

### Quick Start

1. Go to `Configuration > Content authoring > llms.txt AI Generator`
2. Write introduction text (2-3 paragraphs about your site)
3. Select menus to include (Main navigation, Footer, etc.)
4. Configure AI settings: Choose any AI provider configured in the AI module
5. Review descriptions - add manual ones for pages missing meta
6. Click "Generate llms.txt"
7. Done! Your file is live at `yoursite.com/llms.txt`

### Configuration

- **Content Sources:** Select menus, set depth (3 levels recommended)
- **AI Settings:** Choose provider AI
- **Auto-Regeneration:** Enable automatic updates when content changes (default: enabled, debouncing: 5 minutes)
- **Manage Descriptions:** Review all pages, add missing descriptions
- **Generate:** Create and publish your llms.txt

### Auto-Regeneration

When enabled, llms.txt automatically updates when you modify pages or menus. Changes are processed via cron with AI reformulation.

**Debouncing:** Prevents multiple regenerations. Default 5 minutes. Increase (15-30 min) if you have frequent edits to avoid reformulating the same pages multiple times.

## Recommended Modules

- **Metatag** (`drupal/metatag`): Highly recommended for automatic meta extraction. Without it, you'll need to add descriptions manually.
- **Pathauto** (`drupal/pathauto`): Clean URLs for better links

## Similar Projects

| Module | AI Integration | Best For |
|--------|----------------|----------|
| **llms_txt_ai** (this) | ✅ Full AI reformulation | Automated natural language |
| llms_txt (Pronovix) | ❌ Manual | Full manual control |
| llmstxt | ❌ Manual | Simple sites |
| LLMs txt Exporter | ❌ No AI | Basic listing |

**Unique features:** Only module using AI for natural language reformulation + menu-first approach + hybrid auto/manual editing.

## FAQ

**Do I need Metatag module?**
Recommended but not required. Without it, manual descriptions needed.

**Should I include all 1000 pages?**
No! Select 20-50 key pages. Think "executive summary" not "full catalog."

**Will this slow my site?**
No. Generation is on-demand, not during page loads. Output is cached. Auto-regeneration runs via cron in background.

**How does auto-regeneration work?**
When you save a page/menu, it's queued for regeneration. Cron processes the queue with full AI reformulation. Debouncing prevents duplicate work.

## Technical

**Data flow:** Menus → Meta extraction → Manual editing → AI reformulation → llms.txt generation → Publish

**Auto-regeneration:** Entity hooks → Queue → Cron (change detection + AI reformulation) → File update

**Storage:** Configuration via CMI (exportable), manual descriptions via KeyValue (lightweight, no DB tables)
