<?php

declare(strict_types=1);

namespace Drupal\lms\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * From builder class for general LMS settings.
 */
final class LmsSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'lms_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['lms.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['allow_to_enter_ungraded'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Allow to enter ungraded courses'),
      '#description' => $this->t('This allows students to reenter finished courses that still need manual grading by a teacher and make changes to their answers. NOTE: If changed on a site with existing courses that are already in progress, caches need to be cleared.'),
      '#config_target' => 'lms.settings:allow_to_enter_ungraded',
    ];

    return parent::buildForm($form, $form_state);
  }

}
