<?php

/**
 * @file
 * Contains post-update hooks for the LMS module.
 */

declare(strict_types=1);

use Drupal\Core\Entity\EntityPublishedInterface;

/**
 * Set status to TRUE on all lessons and activities.
 */
function lms_post_update_set_statuses(array &$sandbox): void {
  $storages = [
    'lms_lesson' => \Drupal::entityTypeManager()->getStorage('lms_lesson'),
    'lms_activity' => \Drupal::entityTypeManager()->getStorage('lms_activity'),
  ];
  if (!\array_key_exists('list', $sandbox)) {
    $sandbox['list'] = [];
    foreach ($storages as $entity_type_id => $storage) {
      foreach ($storage->getQuery()->accessCheck(FALSE)->execute() as $id) {
        $sandbox['list'][] = [$entity_type_id, $id];
      }
    }
    $sandbox['total'] = \count($sandbox['list']);
    $sandbox['progress'] = 0;
  }

  $item = array_pop($sandbox['list']);
  if ($item === NULL) {
    return;
  }

  $entity = $storages[$item[0]]->load($item[1]);
  if ($entity instanceof EntityPublishedInterface) {
    $entity->setPublished()->save();
  }

  $sandbox['progress']++;
  $sandbox['#finished'] = $sandbox['progress'] / $sandbox['total'];
}

/**
 * BC - Add add students permission to all member course group roles.
 */
function lms_post_update_add_students_permission(): void {
  $roles = \Drupal::entityTypeManager()->getStorage('group_role')->loadByProperties([
    'group_type' => 'lms_course',
    'scope' => ['insider', 'individual'],
  ]);
  /** @var Drupal\group\Entity\GroupRoleInterface $role */
  foreach ($roles as $role) {
    if ($role->hasPermission('add students')) {
      continue;
    }
    $role->grantPermission('add students')->save();
  }
}

/**
 * BC - Add view students permission to all member course group roles.
 */
function lms_post_update_view_students_permission(): void {
  $roles = \Drupal::entityTypeManager()->getStorage('group_role')->loadByProperties([
    'group_type' => 'lms_course',
    'scope' => ['insider', 'individual'],
  ]);
  /** @var Drupal\group\Entity\GroupRoleInterface $role */
  foreach ($roles as $role) {
    if ($role->hasPermission('view students')) {
      continue;
    }
    $role->grantPermission('view students')->save();
  }
}

/**
 * BC - Add grade students permission to all member course group roles.
 */
function lms_post_update_grade_students_permission(): void {
  $roles = \Drupal::entityTypeManager()->getStorage('group_role')->loadByProperties([
    'group_type' => 'lms_course',
    'scope' => ['insider', 'individual'],
  ]);
  /** @var Drupal\group\Entity\GroupRoleInterface $role */
  foreach ($roles as $role) {
    if ($role->hasPermission('grade students')) {
      continue;
    }
    $role->grantPermission('grade students')->save();
  }
}
