<?php

declare(strict_types=1);

namespace Drupal\lms\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Contains all hooks that don't need any services injected.
 */
final class LmsOtherHooks {

  #[Hook('theme_suggestions_container_alter')]
  public function themeSuggestionsContainerAlter(array &$suggestions, array $variables): void {
    // Provide a theme suggestion for the container in the course navigation.
    if (
      \array_key_exists('element', $variables) &&
      \array_key_exists('activities', $variables['element'])
    ) {
      $suggestions[] = 'container__lms_activities_navigation';
    }
  }

  #[Hook('element_info_alter')]
  public function elementInfoAlter(array &$types): void {
    // Attach our extra CSS for toolbar icons.
    if (\array_key_exists('toolbar', $types)) {
      $types['toolbar']['#attached']['library'][] = 'lms/toolbar';
    }
  }

}
