<?php

declare(strict_types=1);

namespace Drupal\lms_classes;

use Drupal\Core\Session\AccountInterface;
use Drupal\group\Entity\GroupInterface;
use Drupal\lms\Entity\Bundle\Course;

/**
 * Class helper methods.
 */
final class ClassHelper {

  /**
   * Get classes of a given course.
   *
   * @return \Drupal\group\Entity\GroupInterface[]
   *   Class groups array.
   */
  public static function getClasses(Course $course): array {
    $classes = [];
    $relationships = $course->getRelationships('lms_classes');
    foreach ($relationships as $relationship) {
      $class = $relationship->getEntity();
      \assert($class instanceof GroupInterface);
      $classes[] = $class;
    }
    return $classes;
  }

  /**
   * Class membership checker.
   *
   * Checks if the given account is a member of any of the classes of this
   * learning path.
   */
  public static function isClassMember(AccountInterface $account, Course $course): bool {
    foreach (self::getClasses($course) as $class) {
      if ($class->getMember($account) !== FALSE) {
        return TRUE;
      }
    }

    return FALSE;
  }

}
