<?php

declare(strict_types=1);

namespace Drupal\lms_certificate_entity\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;
use Drupal\Core\Entity\Attribute\ConfigEntityType;
use Drupal\Core\Entity\EntityDeleteForm;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\lms_certificate_entity\Form\LmsCertificateEntityTypeForm;
use Drupal\lms_certificate_entity\LmsCertificateEntityTypeListBuilder;

/**
 * Defines the lms_certificate_entity type configuration entity.
 */
#[ConfigEntityType(
  id: 'lms_certificate_entity_type',
  label: new TranslatableMarkup('LMS Certificate Entity Type'),
  label_collection: new TranslatableMarkup('LMS Certificate Entity Types'),
  label_singular: new TranslatableMarkup('LMS Certificate Entity Type'),
  label_plural: new TranslatableMarkup('LMS Certificate Entity Types'),
  config_prefix: 'lms_certificate_entity_type',
  entity_keys: [
    'id' => 'id',
    'label' => 'label',
    'uuid' => 'uuid',
  ],
  handlers: [
    'list_builder' => LmsCertificateEntityTypeListBuilder::class,
    'route_provider' => [
      'html' => AdminHtmlRouteProvider::class,
    ],
    'form' => [
      'add' => LmsCertificateEntityTypeForm::class,
      'edit' => LmsCertificateEntityTypeForm::class,
      'delete' => EntityDeleteForm::class,
    ],
  ],
  links: [
    'add-form' => '/admin/structure/lms_certificate_entity_types/add',
    'edit-form' => '/admin/structure/lms_certificate_entity_types/manage/{lms_certificate_entity_type}',
    'delete-form' => '/admin/structure/lms_certificate_entity_types/manage/{lms_certificate_entity_type}/delete',
    'collection' => '/admin/structure/lms_certificate_entity_types',
  ],
  admin_permission: 'administer lms_certificate_entity types',
  bundle_of: 'lms_certificate_entity',
  label_count: [
    'singular' => '@count LMS Certificate Entity Type',
    'plural' => '@count LMS Certificate Entity Types',
  ],
  config_export: [
    'id',
    'label',
    'uuid',
  ],
)]
final class LmsCertificateEntityType extends ConfigEntityBundleBase {

  /**
   * The machine name of this lms_certificate_entity type.
   */
  protected string $id;

  /**
   * The human-readable name of the lms_certificate_entity type.
   */
  protected string $label;

}
