<?php

declare(strict_types=1);

namespace Drupal\lms_certificate_entity\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Entity\EntityTypeInterface;

/**
 * Hook implementations.
 */
class LmsCertificateEntityHooks {

  /**
   * Implements hook_entity_bundle_info_alter().
   */
  #[Hook('entity_bundle_field_info_alter')]
  public function entityBundleFieldInfoAlter(array &$fields, EntityTypeInterface $entity_type, string $bundle): void {

    if ($bundle === 'lms_course' && $entity_type->id() === 'group') {
      $entity_type_ids = $fields['certificate']->getSetting('entity_type_ids');
      $entity_type_ids[] = 'lms_certificate_entity';
      $fields['certificate']->setSetting('entity_type_ids', $entity_type_ids);
    }

  }

}
