<?php

declare(strict_types=1);

namespace Drupal\lms_certificate_entity;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of lms_certificate_entity type entities.
 *
 * @see \Drupal\lms_certificate_entity\Entity\LmsCertificateEntityType
 */
final class LmsCertificateEntityTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Label');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    $row['label'] = $entity->label();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render(): array {
    $build = parent::render();

    $build['table']['#empty'] = $this->t(
      'No lms_certificate_entity types available. <a href=":link">Add a LMS Certificate Entity type</a>.',
      [':link' => Url::fromRoute('entity.lms_certificate_entity_type.add_form')->toString()],
    );

    return $build;
  }

}
