<?php

declare(strict_types=1);

namespace Drupal\lms_file_upload\Hook;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\lms\TrainingManager;
use Drupal\lms_file_upload\Plugin\ActivityAnswer\FileUpload;
use Symfony\Component\DependencyInjection\Attribute\AutowireCallable;

/**
 * Form alter hooks for LMS File Upload module.
 */
final class LmsFileUploadFormHooks {

  public function __construct(
    #[AutowireCallable(service: TrainingManager::class, method: 'getActivityAnswerPlugin', lazy: TRUE)]
    protected \Closure $getActivityAnswerPlugin,
  ) {}

  /**
   * The obvious.
   */
  #[Hook('form_lms_activity_form_alter')]
  public function formAlter(array &$form, FormStateInterface $form_state): void {
    /** @var \Drupal\Core\Entity\EntityFormInterface $form_object */
    $form_object = $form_state->getFormObject();
    $activity = $form_object->getEntity();
    if (!$activity->isNew()) {
      return;
    }

    $plugin = ($this->getActivityAnswerPlugin)($form_object->getEntity());
    if (!$plugin instanceof FileUpload) {
      return;
    }
    // Set default value for file extensions.
    $form['field_file_extensions']['widget'][0]['value']['#default_value'] = $plugin->getDefaultAllowedFileExtensions();
  }

}
