<?php

namespace Drupal\lms_membership_request\Routing;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Routing\RouteMatch;
use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\lms\Entity\Bundle\Course;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * LMS Membership request route subscriber.
 */
final class LmsMembershipRequestRouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    if ($route = $collection->get('entity.group.join')) {
      $route->setRequirement('_custom_access', self::class . '::joinGroupAccess');
    }

    if ($route = $collection->get('view.opigno_classes.all')) {
      $route->setOption('_admin_route', TRUE);
    }
  }

  /**
   * Prevent access to join group route on Courses with membership validation.
   */
  public static function joinGroupAccess(AccountInterface $account, Route $route, RouteMatch $route_match): AccessResult {
    $group = $route_match->getParameter('group');
    if (!$group instanceof Course) {
      return AccessResult::neutral();
    }

    if ($group->get('membership_validation')->value === '1') {
      $access = AccessResult::forbidden();
    }
    else {
      $access = AccessResult::neutral();
    }
    return $access->addCacheableDependency($group);
  }

}
