<?php

declare(strict_types=1);

namespace Drupal\lms_migrate\Plugin\migrate\process;

use Drupal\migrate\Attribute\MigrateProcess;
use Drupal\migrate\MigrateExecutableInterface;
use Drupal\migrate\Plugin\migrate\process\MigrationLookup;
use Drupal\migrate\Row;

/**
 * Logs message when migration lookup operation fails.
 */
#[MigrateProcess('migration_lookup_verbose')]
final class MigrationLookupVerbose extends MigrationLookup {

  /**
   * {@inheritdoc}
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    if (is_null($value)) {
      return NULL;
    }

    $result = parent::transform($value, $migrate_executable, $row, $destination_property);

    if (is_null($result)) {
      if (!is_array($value)) {
        $value = [$value];
      }

      $destination_property_name_override = $this->configuration['destination_property_name_override'] ?? $destination_property;
      $message = sprintf('Migration lookup failed for %s destination property with source value: %s.', $destination_property_name_override, implode(', ', $value));
      $migrate_executable->saveMessage($message);
    }

    return $result;
  }

}
