<?php

declare(strict_types=1);

namespace Drupal\lms_migrate\Plugin\migrate\source;

use Drupal\migrate\Plugin\MigrateIdMapInterface;
use Drupal\migrate\Row;
use Drupal\migrate_drupal\Plugin\migrate\source\ContentEntity;

/**
 * Opigno user learning path status content entities.
 *
 * @MigrateSource(
 *   id = "content_entity:user_lp_status",
 *   source_module = "migrate_drupal"
 * )
 */
final class ContentEntityUserLpStatus extends ContentEntity {

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row) {
    $result = parent::prepareRow($row);

    $finished = (int) $row->getSourceProperty('finished/0/value');

    // Handle multiple in-progress course status.
    // @see \Drupal\lms\Entity\CourseStatus::isFinished().
    // @see \Drupal\lms\Entity\CourseStatus::preSave()
    if ($finished === 0) {
      $id = (int) $row->getSourceProperty('id');
      $gid = (int) $row->getSourceProperty('gid/0/target_id');
      $uid = (int) $row->getSourceProperty('uid/0/target_id');

      $query = parent::query();
      $query->condition('gid', $gid)
        ->condition('uid', $uid)
        ->condition('finished', 0);
      $results = $query->execute();

      if (is_array($results)) {
        $ids = array_keys($results);
        if (count($ids) > 1 && $id !== max($ids)) {
          $message = sprintf('Multiple course status found for gid %s and uid %s. ID %s will be used instead.', $gid, $uid, max($ids));
          $this->idMap->saveMessage($row->getSourceIdValues(), $message);
          $this->idMap->saveIdMapping($row, [], MigrateIdMapInterface::STATUS_IGNORED);
          return FALSE;
        }
      }
    }

    return $result;
  }

}
