<?php

declare(strict_types=1);

namespace Drupal\lms_migrate\Plugin\migrate\process;

use Drupal\migrate\Attribute\MigrateProcess;
use Drupal\migrate\MigrateExecutableInterface;
use Drupal\migrate\Row;
use Drupal\migrate_plus\Plugin\migrate\process\EntityLookup;

/**
 * Logs message when entity lookup operation fails.
 */
#[MigrateProcess('entity_lookup_verbose')]
final class EntityLookupVerbose extends EntityLookup {

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\migrate\MigrateException
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    if (is_null($value)) {
      return NULL;
    }

    $result = parent::transform($value, $migrate_executable, $row, $destination_property);

    if (is_null($result)) {
      if (!is_array($value)) {
        $value = [$value];
      }

      $destination_property_name_override = $this->configuration['destination_property_name_override'] ?? $destination_property;
      $message = sprintf('Entity lookup failed for %s destination property with source value: %s.', $destination_property_name_override, implode(', ', $value));
      $migrate_executable->saveMessage($message);
    }

    return $result;
  }

}
