<?php

declare(strict_types=1);

namespace Drupal\lms_migrate\Plugin\migrate\source;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\migrate_drupal\Plugin\migrate\source\ContentEntity;
use Drupal\opigno_module\Entity\OpignoModule;

/**
 * Opigno module content entities.
 *
 * @MigrateSource(
 *   id = "content_entity:opigno_module",
 *   source_module = "migrate_drupal"
 * )
 */
final class ContentEntityOpignoModule extends ContentEntity {

  /**
   * {@inheritdoc}
   */
  protected function toArray(ContentEntityInterface $entity): array {
    $return = parent::toArray($entity);
    assert($entity instanceof OpignoModule);
    $module_activities = $entity->getModuleActivities();
    if (is_array($module_activities)) {
      $return['_module_activities'] = array_map('get_object_vars', $module_activities);
    }
    return $return;
  }

}
