<?php

namespace Drupal\lms_scorm\Plugin\Field\FieldType;

use Drupal\Core\Form\FormStateInterface;
use Drupal\file\Plugin\Field\FieldType\FileItem;

/**
 * Plugin implementation of the 'lms_scorm_package' field type.
 *
 * @FieldType(
 *   id = "lms_scorm_package",
 *   label = @Translation("Scorm package"),
 *   description = @Translation("This field stores the ID of a Scorm package file."),
 *   category = "lms",
 *   default_widget = "file_generic",
 *   default_formatter = "lms_scorm_field_formatter",
 *   list_class = "\Drupal\lms_scorm\Plugin\Field\FieldType\LmsScormPackageItemList",
 *   constraints = {"ReferenceAccess" = {}, "FileValidation" = {}}
 * )
 */
class LmsScormPackage extends FileItem {

  /**
   * {@inheritdoc}
   */
  public static function defaultFieldSettings() {
    $settings = parent::defaultFieldSettings();
    $settings['file_extensions'] = 'zip';
    $settings['file_directory'] = 'lms_scorm';
    return $settings;
  }

  /**
   * {@inheritdoc}
   */
  public function storageSettingsForm(array &$form, FormStateInterface $form_state, $has_data) {
    $element = [];
    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function fieldSettingsForm(array $form, FormStateInterface $form_state) {
    $element = [];
    return $element;
  }

}
