<?php

declare(strict_types=1);

namespace Drupal\lms_xapi_lesson\Entity\Bundle;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\lms\Entity\Handlers\LmsLessonHandlerInterface;
use Drupal\lms\Entity\Lesson;

/**
 * Articulate 360 lesson bundle.
 */
final class XapiLesson extends Lesson {

  public const XAPI_PACKAGE = 'xapi_package';

  /**
   * {@inheritdoc}
   */
  public function getLessonHandlerService(): LmsLessonHandlerInterface {
    return \Drupal::service('lms.lesson_handler.xapi');
  }

  /**
   * {@inheritdoc}
   */
  public static function bundleFieldDefinitions(EntityTypeInterface $entity_type, $bundle, array $base_field_definitions): array {
    $fields = parent::bundleFieldDefinitions($entity_type, $bundle, $base_field_definitions);

    $fields[self::XAPI_PACKAGE] = BaseFieldDefinition::create('lms_xapi')
      ->setLabel(\t('Xapi Package'))
      ->setDescription(\t('Upload an Xapi package in zip format.'))
      ->setCardinality(1)
      ->setRequired(TRUE)
      ->setDisplayOptions('form', [
        'type' => 'lms_xapi',
        'weight' => 1,
      ])
      ->setDisplayOptions('view', [
        'type' => 'lms_xapi',
        'weight' => 0,
        'label' => 'hidden',
      ])
      ->setDisplayConfigurable('form', TRUE);

    // We need to drop validation and form display from the parent class
    // since activities field is not used in Xapi lessons.
    $fields[self::ACTIVITIES] = BaseFieldDefinition::create('lms_reference');

    return $fields;
  }

}
