<?php

declare(strict_types=1);

namespace Drupal\lms_xapi\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Defines Xapi reference operation event.
 */
final class ReferenceEvent extends Event {

  public const NAME = 'xapi_reference_operation';

  public function __construct(
    private string $operation,
    private array $registrationIds,
  ) {}

  /**
   * Affected registration IDs setter.
   */
  public function setRegistrationIds(array $registration_ids): void {
    $this->registrationIds = $registration_ids;
  }

  /**
   * Affected registration IDs getter.
   */
  public function getRegistrationIds(): array {
    return $this->registrationIds;
  }

  /**
   * Operation getter.
   */
  public function getOperation(): string {
    return $this->operation;
  }

}
