<?php

declare(strict_types=1);

namespace Drupal\lms_xapi;

use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines an interface for classes that build breadcrumbs.
 */
interface XapiIdGeneratorInterface {

  /**
   * Whether this ID generator should be used to generate the ID.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity that the XAPI export is attached to.
   * @param \Drupal\Core\Session\AccountInterface $student
   *   The student assigned to the generated LRS reference.
   * @param \Drupal\Core\Cache\CacheableMetadata $cacheable_metadata
   *   The cacheable metadata to add to if your check varies by or depends
   *   on something. Anything you specify here does not have to be repeated in
   *   the generate() method as it will be merged in automatically.
   *
   * @return bool
   *   TRUE if this generator should be used or FALSE to let other builders
   *   decide.
   */
  public function applies(
    EntityInterface $entity,
    AccountInterface $student,
    CacheableMetadata $cacheable_metadata,
  ): bool;

  /**
   * Generates parts for the LRS ID.
   *
   * Generate parts unique but repeatable ID which will be used to store and
   * retrieve the statement from the LRS.
   *   The current route match.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity that the XAPI export is attached to.
   * @param \Drupal\Core\Session\AccountInterface $student
   *   The student assigned to the generated LRS reference.
   * @param \Drupal\Core\Cache\CacheableMetadata $cacheable_metadata
   *   The cacheable metadata to add to if your check ID varies by or depends
   *   on something. Anything added by the ::applies() method does not need to
   *   be added again here.
   *
   * @return string[]
   *   An array of strings to create the ID.
   */
  public function generate(
    EntityInterface $entity,
    AccountInterface $student,
    CacheableMetadata $cacheable_metadata,
  ): array;

}
