<?php

declare(strict_types=1);

namespace Drupal\lrs_xapi\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\ConfigTarget;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\lrs_xapi\Controller\LrsXapiEndpoint;

/**
 * LMS Xapi settings form class.
 */
final class LrsXapiSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'lrs_xapi_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [LrsXapiEndpoint::CONFIG_NAME];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['endpoint'] = [
      '#type' => 'item',
      '#title' => $this->t('LRS endpoint'),
      '#description' => Url::fromRoute('<front>', [], [
        'absolute' => TRUE,
      ])->toString() . '/lrs/endpoint',
    ];
    $form['username'] = [
      '#type' => 'textfield',
      '#title' => $this->t('LRS API user name'),
      '#config_target' => new ConfigTarget(LrsXapiEndpoint::CONFIG_NAME, 'username'),
      '#required' => TRUE,
    ];
    $form['password'] = [
      '#type' => 'password',
      '#title' => $this->t('LRS API password'),
      '#config_target' => new ConfigTarget(LrsXapiEndpoint::CONFIG_NAME, 'password'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

}
