# LocalGov Drupal: Directories

Provides directories (channels) which have entries (pages, venues, etc.) which
can be filtered and searched.

## Enabling the module

The 'LocalGov Directories' module enables the core functionality. You will need
a search backend: 'LocalGov Directories Database' will provide this. You can use
other search backends, for example solr, if doing so it is advisable to disable
the Database module first.

For the directories you will also need at least one content Entry type, these
can be created or supplied by the Directories submodules, see the Directory
Entries section below.

## Facets

Facets types, and their facet values. Create types (eg. "Size"), and values (eg.
"Large", "Medium", "Small"). These can then be used on entries to filter to them.

The automatically enabled Facets are their own entity type. They are intended
for creation and management by content editors on the production site. Adding
a facet type will automatically make it available on Directory Channels, and
add any values to the Facet block on the page, without any additional site
building. As such by design they are excluded from configuration export.

### Using Taxonomy Term Facets

If you want a controlled or imported taxonomy you can add standard taxonomy term
facets to you directory index. Do this as you would with any search api index:
This requires creating the vocabulary. Adding the vocabulary to the appropriate
content type. Adding it to the index. Placing the block on the appropriate
channel pages.

## Directories (Channels)

A content type that defines which entries can be posted into the directory, and
which facets are enabled on it.

### Manage display of directory channel - listings

The localgov_directories module provides a couple of extra psuedo-field to help
with the listing of entries by embedding the view 'localgov_directory_channel'.

- "Directory listing": display a list of directory entries generated by the embedded view.
- "Directory listing (with search box)": display a list of directory entries generated by the embedded view with an exposed search form.

You can enable or disable these at /admin/structure/types/manage/localgov_directory/display

### Manage display of directory channel - maps

The localgov_directories_location module provides an extra psuedo-field to help
with the display of entries on a map by embedding the 'embed_map' display of the
'localgov_directory_channel' view.

- "Directory map": display a map of directory entries which have locations.

You can enable or disable these at /admin/structure/types/manage/localgov_directory/display

## Directory Entries

Entries are put into one or more directory (channel). The primary directory
defines the path, and breadcrumb to the item.

### Page

The basic directory entry. It has fields for which directory (channel), and
what facet values (depending on the available facet types defined by the
enabled channels. It also has contact information.

### Venue

A directory entry with a location to be shown on a map. Requires the
localgov geo module.

### Organisation

This simple entry is primarily used if you enable Directories Open Referral.
The standard requires all Services, by default mapped to Venues, have an
Organisation. Other directory entry types (see Extending directory entries)
can be mapped to Open Referral as appropriate.

### Promotional pages

A directory entry with additional fields with paragraphs for richer
presentation. Better for brouchure type entries than services information.
This type of entry would be more difficult to map for Open Referral or any
other standard or format, but good for adding images and styling on the site.

## LocalGov Drupal Services Integration

If you have the LocalGov Services module installed, directories (channels) can
optionally be put into services. The path to the directory channel will then be
service > directory, and an entry: service > directory > entry.

## Extending directory entries

New content types can be created to go into directories by adding the
`localgov_directory_channels` and `localgov_directory_facets_select` fields.

The form widgets, and selection type, for each field ensure the correct options
for the content creator: Selector "LocalGov: Directories channels selection"
ensures only the channels that allow that content type can be posted,
"Directories facets selection" is relatively redundant; the two widgets
"Directory channels" and "Directory entry facets" work together to ensure the
correct directories can be chosen as primary and secondary, and that with them
the correct facets can then be selected.

New content types in directories can have which ever other fields you want
added to them.

The content type should be automatically added to the search index when you add
the directory fields. You may want to create a `directory index` display mode
as this will be used for the full text search indexing.

### Staging 'Directory facet types'

By default facet types are not exported to configuration and are treated as
content an administrator user can create on production. If you want to have
types in configuration as vocabularies would be on the site to create and
export the facet types set:
`$settings['localgov_directories_stage_site'] = TRUE;`
and it will be exported with other configuration. Any types that exist in
configuration will be imported.

### Proximity search

Proximity search is made available when:
- The Directory search backend supports location search.  At the moment the *search_api_solr* search backend from the [search_api_solr module](https://www.drupal.org/project/search_api_solr) is the only such known backend.
- At least one of the available Directory entry content types (e.g. localgov_directories_venue) is using location through the
localgov_location field.

When location search is available, a new "Proximity search settings" choice field becomes available in Directory channel forms.  Activating this will present a Proximity search filter as part of the channel search form.

The Proximity search filter uses the following distances out-of-the-box: 1km for 1/2 mile, 2km for 1 mile, 3km for 2 miles, 5km for 3 miles, 8km for 5 miles, and 16km for 10 miles.  These mappings are not exact.  This is due to Solr's insistence on using round Kilometer values during location-based filtering.  To update these distance values, edit the Proximity filter's settings in the *Directory channel* view's *Embed: Proximity search* and *Embed map* displays.

#### Supported database backends
The [dev release of the search_api module](https://www.drupal.org/project/search_api/releases/8.x-1.x-dev) now supports location-based search in database search backends.  Supported database versions are:
- MySQL 5.7 and later.
- MariaDB 10.2.38, 10.3.29, 10.4.19, 10.5.10 and later.

## Block placement

When using a theme other than the default LocalGov Base or LocalGov Scarfolk, the
**Directory channel search** (machine id: localgov_directories_channel_search_block),
**Directory facets** (machine id: facet_block:localgov_directories_facets) and
**Directory facets for proximity search** (machine id: facet_block:localgov_directories_facets_proximity_search)
blocks should be made visible for the **Directory Channel** content type.
They can be added to a sidebar region (or equivalent) of the site theme.

Note that the facet_block:localgov_directories_facets block becomes available only
after you have created at least one Directory entry content type.  On the other
hand the facet_block:localgov_directories_facets_proximity_search block becomes
available when a Directory entry content type with a localgov_location field is
created (e.g. localgov_directories_venue).

On the Directory entry content types the blocks are also available as 'fields'
in the Fields display configuration if you prefer to place them within the
content that way.
