/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function setupCookieSettingsBlock($, Drupal) {
  Drupal.behaviors.activateCookieSettingsForm = {
    attach(context) {
      const selectedCookieCategories = Drupal.eu_cookie_compliance.getAcceptedCategories();

      Drupal.eu_cookie_compliance.setAcceptedCategories(selectedCookieCategories);
      Drupal.eu_cookie_compliance.loadCategoryScripts(selectedCookieCategories);

      Drupal.eu_cookie_compliance.setPreferenceCheckboxes(selectedCookieCategories);
      Drupal.eu_cookie_compliance.attachSavePreferencesEvents();

      once("localgov-eu-cookie-compliance-radios", "#eu-cookie-compliance-categories", context).forEach(displayCheckboxAsRadios);
    }
  };

  function displayCheckboxAsRadios() {
    setTimeout(() => {
      hideCheckboxes();
      clickRadiosBasedOnCheckboxStatus();
      setupUpClickHandlersForRadios();
      setupSaveSettingsFeedback();
    }, 300);
  }

  function hideCheckboxes() {
    $("[name=cookie-categories]:checkbox").hide();
  }

  function clickRadiosBasedOnCheckboxStatus() {
    $("[name=cookie-categories]:checked + .eu-cookie-compliance-categories--on :radio:not(:checked)").prop("checked", true);
    $("[name=cookie-categories]:not(:checked) + .eu-cookie-compliance-categories--on + .eu-cookie-compliance-categories--off :radio:not(:checked)").prop("checked", true);
  }

  function setupUpClickHandlersForRadios() {
    $(".eu-cookie-compliance-categories--on :radio").click(event => {
      const key = event.target.value;
      const relatedCheckboxId = `cookie-category-${key}:not(:checked)`;

      $(`#${relatedCheckboxId}`).click();
    });
    $(".eu-cookie-compliance-categories--off :radio").click(event => {
      const key = event.target.value;
      const relatedCheckboxId = `cookie-category-${key}:checked`;

      $(`#${relatedCheckboxId}`).click();
    });
  }

  function setupSaveSettingsFeedback() {
    const saveButton = document.querySelector('.eu-cookie-compliance-save-preferences-button');
    const saveButtonLabel = saveButton.innerHTML;

    saveButton.addEventListener("click", function () {
      saveButton.innerHTML = `${Drupal.t("Saving")}`;
      saveButton.classList.add('spinning');

      setTimeout(function () {
        saveButton.classList.remove('spinning');
        saveButton.innerHTML = `${Drupal.t("Preferences saved")}  <i class="fas fa-check"></i>`;
      }, 2000);
    }, false);

    saveButton.addEventListener("blur", function () {
      saveButton.innerHTML = saveButtonLabel;
    }, false);
  }
})(jQuery, Drupal);