## INTRODUCTION

The LocalGov France module provides French language support for LocalGov Drupal installations.

This module:

- Sets French as the default language
- Imports French translations for all interface strings
- Translates configuration entities (content types, fields, taxonomies, etc.)
- Sets the default timezone to Europe/Paris
- Provides comprehensive translations via `.po` files and YAML configuration
- Optionally enables the LocalGov Base France theme

## REQUIREMENTS

- Drupal 10 or 11
- LocalGov Drupal distribution
- The following core modules (enabled automatically):
  - Language
  - Content Translation
  - Configuration Translation
  - Locale

## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

```bash
composer require localgovdrupal/localgov_france
drush en localgov_france
```

## CONFIGURATION

The module configures French language settings automatically on installation:

- Sets French (fr) as the default site language
- Removes English language (if not needed)
- Sets timezone to Europe/Paris
- Sets country to France
- Imports French translations from drupal.org
- Imports custom LocalGov translations from included `.po` file
- Translates all LocalGov configuration entities

### Optional Theme

If you have the `localgov_base_france` theme available, it will be enabled and set as default automatically.

## TRANSLATION FILES

The module includes two types of translation files:

1. **Interface translations** (`translations/localgov_france.fr.po`):
   - Translates UI strings from PHP code (`t()` functions)
   - Translates UI strings from Twig templates (`|t` filter and `{% trans %}` tags)
   - Translates JavaScript strings (`Drupal.t()`)

2. **Configuration translations** (`translations/localgov_france.config_translations.yml`):
   - Translates content types, fields, taxonomies
   - Translates workflows, user roles
   - Translates paragraph types, view modes
   - Translates menus and other configuration entities

## MAINTAINERS

Current maintainers:

- Mark Conroy - https://www.drupal.org/u/markconroy

