<?php
// phpcs:ignoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 9.5.9 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

$connection->schema()->createTable('block_content', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'uuid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'unique keys' => array(
    'block_content_field__uuid__value' => array(
      'uuid',
    ),
    'block_content__revision_id' => array(
      'revision_id',
    ),
  ),
  'indexes' => array(
    'block_content_field__type__target_id' => array(
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content__body', array(
  'fields' => array(
    'bundle' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_format' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_id',
    'deleted',
    'delta',
    'langcode',
  ),
  'indexes' => array(
    'bundle' => array(
      'bundle',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content_field_data', array(
  'fields' => array(
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'reusable' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'revision_translation_affected' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'id',
    'langcode',
  ),
  'indexes' => array(
    'block_content__id__default_langcode__langcode' => array(
      'id',
      'default_langcode',
      'langcode',
    ),
    'block_content__revision_id' => array(
      'revision_id',
    ),
    'block_content_field__type__target_id' => array(
      'type',
    ),
    'block_content__status_type' => array(
      'status',
      'type',
      'id',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content_field_revision', array(
  'fields' => array(
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'revision_translation_affected' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'revision_id',
    'langcode',
  ),
  'indexes' => array(
    'block_content__id__default_langcode__langcode' => array(
      'id',
      'default_langcode',
      'langcode',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content_revision', array(
  'fields' => array(
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'revision_user' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_created' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'revision_log' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'revision_default' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'revision_id',
  ),
  'indexes' => array(
    'block_content__id' => array(
      'id',
    ),
    'block_content_field__revision_user__target_id' => array(
      'revision_user',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('block_content_revision__body', array(
  'fields' => array(
    'bundle' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_format' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'langcode',
  ),
  'indexes' => array(
    'bundle' => array(
      'bundle',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_config', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_container', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_data', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_default', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_discovery', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_entity', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_geocoder', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'checksum' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
    'created' => array(
      'created',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('cachetags', array(
  'fields' => array(
    'tag' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tag',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('comment', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'uuid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'unique keys' => array(
    'comment_field__uuid__value' => array(
      'uuid',
    ),
  ),
  'indexes' => array(
    'comment_field__comment_type__target_id' => array(
      'comment_type',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('comment__comment_body', array(
  'fields' => array(
    'bundle' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_body_value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'comment_body_format' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_id',
    'deleted',
    'delta',
    'langcode',
  ),
  'indexes' => array(
    'bundle' => array(
      'bundle',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'comment_body_format' => array(
      'comment_body_format',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('comment_entity_statistics', array(
  'fields' => array(
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'entity_type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => 'node',
    ),
    'field_name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'last_comment_uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'comment_count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_id',
    'entity_type',
    'field_name',
  ),
  'indexes' => array(
    'last_comment_timestamp' => array(
      'last_comment_timestamp',
    ),
    'comment_count' => array(
      'comment_count',
    ),
    'last_comment_uid' => array(
      'last_comment_uid',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('comment_field_data', array(
  'fields' => array(
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'subject' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
    ),
    'homepage' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'thread' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'entity_type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'field_name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'cid',
    'langcode',
  ),
  'indexes' => array(
    'comment__id__default_langcode__langcode' => array(
      'cid',
      'default_langcode',
      'langcode',
    ),
    'comment_field__comment_type__target_id' => array(
      'comment_type',
    ),
    'comment_field__uid__target_id' => array(
      'uid',
    ),
    'comment_field__created' => array(
      'created',
    ),
    'comment__status_comment_type' => array(
      'status',
      'comment_type',
      'cid',
    ),
    'comment__status_pid' => array(
      'pid',
      'status',
    ),
    'comment__num_new' => array(
      'entity_id',
      'entity_type',
      'comment_type',
      'status',
      'created',
      'cid',
      array(
        'thread',
        '191',
      ),
    ),
    'comment__entity_langcode' => array(
      'entity_id',
      'entity_type',
      'comment_type',
      'default_langcode',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('config', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('config')
->fields(array(
  'collection',
  'name',
  'data',
))
->values(array(
  'collection' => '',
  'name' => 'automated_cron.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs";}s:8:"interval";i:10800;}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_breadcrumbs',
  'data' => 'a:13:{s:4:"uuid";s:36:"1c03139c-6229-4034-83b7-d1e95a95e663";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NjcxOBrPOiK5-38t56DwFBDVY4yer7YSlbRWXFuHe7A";}s:2:"id";s:17:"claro_breadcrumbs";s:5:"theme";s:5:"claro";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"6021fad7-bfa0-40ac-950c-bd84d27dde6b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0Yyx1GeyKarZ4T_yXQBR_ZFKnXiFLtxAb6gWLd8nr0";}s:2:"id";s:13:"claro_content";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_help',
  'data' => 'a:13:{s:4:"uuid";s:36:"b3e8b0aa-165c-4baf-aed8-e5fcd3f7febd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jccFSSVqV0WCDb6NtML1VWAWTtDbZ-zn5YgTRMgMrIM";}s:2:"id";s:10:"claro_help";s:5:"theme";s:5:"claro";s:6:"region";s:4:"help";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_local_actions',
  'data' => 'a:13:{s:4:"uuid";s:36:"55e3dd8b-6ca7-49e9-a700-f76c40257fa9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CdXfDmRgAvms7EQovxxWPdYi0GitxeRbVtScYK16ZH0";}s:2:"id";s:19:"claro_local_actions";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_messages',
  'data' => 'a:13:{s:4:"uuid";s:36:"28d30d62-961c-44a2-b88e-34d095a61f24";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-Ac3ISpIT0PQ-whzD7_dw0SdKi6dAbRFNWdSjOiVDqg";}s:2:"id";s:14:"claro_messages";s:5:"theme";s:5:"claro";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_page_title',
  'data' => 'a:13:{s:4:"uuid";s:36:"12f03826-0e80-45b0-9337-9b76421b34cf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fNwDdW063tk_ktzSWzZVeQS9wzvLooVO280BQ9WrsIs";}s:2:"id";s:16:"claro_page_title";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_primary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"4f154a5d-4dcc-4243-a1a2-27ebe782c842";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ACjBZI5shAMiiUpsz-inLYVXDqNNXRnSzAWV3kV_8Hw";}s:2:"id";s:25:"claro_primary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.claro_secondary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"42e06a81-0d11-495a-95b6-347997266bf2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2L0geP-ixCbCkEpW6BVF6H7vDUZN4ea07_Y9CociQm4";}s:2:"id";s:27:"claro_secondary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:11:"pre_content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_account_menu',
  'data' => 'a:13:{s:4:"uuid";s:36:"722b6244-0997-4fe0-83d7-377d72ee60d6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:19:"system.menu.account";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gmxYWWHmgbe0Pnv8y48ZLSLH5mEHejOjAP6RLxUfdzU";}s:2:"id";s:20:"olivero_account_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:25:"system_menu_block:account";s:8:"settings";a:7:{s:2:"id";s:25:"system_menu_block:account";s:5:"label";s:17:"User account menu";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_breadcrumbs',
  'data' => 'a:13:{s:4:"uuid";s:36:"2393a0dc-db9c-468a-886d-f30405263f23";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VhBzWb7lMRtIOg9G7VSw_0uopi-7zXeHq4vXqqV1HFE";}s:2:"id";s:19:"olivero_breadcrumbs";s:5:"theme";s:7:"olivero";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"3b710adb-fb67-4632-bad8-a3f76e974d7b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"erQSEZF2XUjNmgTl0uNRBzmg18ZGXwUcw2FhApoeuHk";}s:2:"id";s:15:"olivero_content";s:5:"theme";s:7:"olivero";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_help',
  'data' => 'a:13:{s:4:"uuid";s:36:"90f84ff2-9712-47e9-8f27-5a80271a32d8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VfPFqqxfkomud5CO8DUijw85QIl9GIxh_nIxLOYESxg";}s:2:"id";s:12:"olivero_help";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_main_menu',
  'data' => 'a:13:{s:4:"uuid";s:36:"ae89dee0-c571-445f-b1d5-cfd20d283204";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KWAiziL39uEzmOJEql_wbUP2RtqGceL3WM2CfxhMelE";}s:2:"id";s:17:"olivero_main_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:22:"system_menu_block:main";s:8:"settings";a:7:{s:2:"id";s:22:"system_menu_block:main";s:5:"label";s:15:"Main navigation";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:2;s:16:"expand_all_items";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_messages',
  'data' => 'a:13:{s:4:"uuid";s:36:"eb1b630c-94c5-4956-be90-1d957e20bd71";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BZ5tpW7H8X4PVGRm3MImTIHd2tN0eF7zOtp4SpRYUA0";}s:2:"id";s:16:"olivero_messages";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_page_title',
  'data' => 'a:13:{s:4:"uuid";s:36:"e2fc9dc6-546a-42c7-8ebb-9bf68deb5081";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6aOgWsNTXjqrDm98TXSAjP6qd2nCijD1xw45MrnbK-Y";}s:2:"id";s:18:"olivero_page_title";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_powered',
  'data' => 'a:13:{s:4:"uuid";s:36:"4e76b954-5b9e-4a88-9684-44296e54433d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eYL19CLDyinGTWYQfBD1DswWzglEotE_kHnHx3AxTXM";}s:2:"id";s:15:"olivero_powered";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"footer_bottom";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_powered_by_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_powered_by_block";s:5:"label";s:17:"Powered by Drupal";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_primary_admin_actions',
  'data' => 'a:13:{s:4:"uuid";s:36:"90509a8f-8e7b-4872-bb99-5ead43c8ffa7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q9_2whdOj1YIomfvsIfopROW4FT_X5pY0DjdOiOaQ5U";}s:2:"id";s:29:"olivero_primary_admin_actions";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_primary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"acea13cf-490d-4685-af31-38aa431e6346";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nGE3EoPQQaQCuqTUtZgw0-KIzmrqdKDzdNQf2JyPUt4";}s:2:"id";s:27:"olivero_primary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_search_form_narrow',
  'data' => 'a:13:{s:4:"uuid";s:36:"1c46e333-ac56-4bbb-893c-ce92948adfee";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yEBET0cqDbk8dkWzaJw-8CKft0961VBflsISoSR6Lj8";}s:2:"id";s:26:"olivero_search_form_narrow";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:20:"Search form (narrow)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_search_form_wide',
  'data' => 'a:13:{s:4:"uuid";s:36:"189913bb-2384-4d1c-805d-0bf01396b4e5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"imMyHD6LYci0gtXq56qr9ZKGHzbEG9uFydrN5EhKtSU";}s:2:"id";s:24:"olivero_search_form_wide";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:18:"Search form (wide)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";s:0:"";}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_secondary_local_tasks',
  'data' => 'a:13:{s:4:"uuid";s:36:"3f047fed-971f-449f-87f4-54e73c01ed16";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ydSxdq7R66I8UMC460rOzlfzvlUL4VRbdwc6z9DWaUI";}s:2:"id";s:29:"olivero_secondary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-2;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_site_branding',
  'data' => 'a:13:{s:4:"uuid";s:36:"58ae22e1-6c70-42fc-b782-29f31c2d7c20";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"n_nlgjggHVfQt2H__zvLOKB2YtjPDbQ5tHijF9LE1aM";}s:2:"id";s:21:"olivero_site_branding";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:0;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block.block.olivero_syndicate',
  'data' => 'a:13:{s:4:"uuid";s:36:"1ec2a766-2240-4dce-b3dc-f3f72e806af3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"node";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0gq3VPg-_UM69FCCWurLFIrrnIjC2HLKhwo9iQNtcUo";}s:2:"id";s:17:"olivero_syndicate";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"social";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:20:"node_syndicate_block";s:8:"settings";a:5:{s:2:"id";s:20:"node_syndicate_block";s:5:"label";s:8:"RSS feed";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"node";s:11:"block_count";i:10;}s:10:"visibility";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'block_content.type.basic',
  'data' => 'a:9:{s:4:"uuid";s:36:"85637652-6757-43f8-bd34-10d045ec7bdd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zglzjmYxi0G0ag9MZ02y0LSJOdpWRwJxyP_OvFojFyo";}s:2:"id";s:5:"basic";s:5:"label";s:11:"Basic block";s:8:"revision";i:0;s:11:"description";s:42:"A basic block contains a title and a body.";}',
))
->values(array(
  'collection' => '',
  'name' => 'claro.settings',
  'data' => 'a:1:{s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'comment.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YNUW2Ij5uE7a4oaXp3i_2lvaFdYM1zNKPPfnEjB0jEc";}s:16:"log_ip_addresses";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'comment.type.comment',
  'data' => 'a:9:{s:4:"uuid";s:36:"4ac7d714-924c-4b4d-a144-7ddcdcd633a7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bqZsN31T2n0UjcbyCpOPi9D2iO0sAOHR7FnEs9qMvaA";}s:2:"id";s:7:"comment";s:5:"label";s:16:"Default comments";s:21:"target_entity_type_id";s:4:"node";s:11:"description";s:28:"Allows commenting on content";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.form.feedback',
  'data' => 'a:12:{s:4:"uuid";s:36:"7e8431c4-8dbd-447b-9a05-e6af054be352";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vymHlgJy26BuI5GGj9-IXjwR3dRC5C0tij4BpWJnoqw";}s:2:"id";s:8:"feedback";s:5:"label";s:16:"Website feedback";s:10:"recipients";a:1:{i:0;s:17:"admin@example.com";}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.form.personal',
  'data' => 'a:12:{s:4:"uuid";s:36:"c9f445c2-96ba-4582-a483-4d37f1f04524";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jonvgt3CkUM2eMLTFwWfHileWWDC4YtXCuIlCahTk_I";}s:2:"id";s:8:"personal";s:5:"label";s:21:"Personal contact form";s:10:"recipients";a:0:{}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'contact.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U69DBeuvXuNVOC15rVNaBjDPK2fWFbo9v4takdYSSO8";}s:12:"default_form";s:8:"feedback";s:5:"flood";a:2:{s:5:"limit";i:5;s:8:"interval";i:3600;}s:20:"user_default_enabled";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.localgov_directories_venue.promote',
  'data' => 'a:17:{s:4:"uuid";s:36:"f8e67334-63dc-40ef-836d-00f71088e08b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:36:"node.type.localgov_directories_venue";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"K4uF1FXhVlMsFO-z-_QzxVYRrU4A6h18UocngIjJiJU";}s:2:"id";s:39:"node.localgov_directories_venue.promote";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:22:"Promoted to front page";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.localgov_directory.promote',
  'data' => 'a:17:{s:4:"uuid";s:36:"5fb535e3-5fb5-4cc1-9b1e-3f5d00fdc621";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:28:"node.type.localgov_directory";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OCndP-fcwPW00gnAmEqQo74w1GrWiYtYRUNytfpRgfQ";}s:2:"id";s:31:"node.localgov_directory.promote";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";s:18:"localgov_directory";s:5:"label";s:22:"Promoted to front page";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.base_field_override.node.page.promote',
  'data' => 'a:17:{s:4:"uuid";s:36:"0bffcd58-9323-4a45-a856-7d8e4824ac00";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fPUEnm4T5zfZRr3ttDUqq7yCDd2uW3clWD-pvos4tlQ";}s:2:"id";s:17:"node.page.promote";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:22:"Promoted to front page";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.fallback',
  'data' => 'a:9:{s:4:"uuid";s:36:"84d6a496-9546-40ef-97f9-9b4e677c0b2f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE";}s:2:"id";s:8:"fallback";s:5:"label";s:20:"Fallback date format";s:6:"locked";b:1;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"f8c82e3f-eca4-48ea-89e8-98273a47fa1f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk";}s:2:"id";s:9:"html_date";s:5:"label";s:9:"HTML Date";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_datetime',
  'data' => 'a:9:{s:4:"uuid";s:36:"3146fdb2-3407-47b7-ac58-bca884c14d94";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE";}s:2:"id";s:13:"html_datetime";s:5:"label";s:13:"HTML Datetime";s:6:"locked";b:1;s:7:"pattern";s:13:"Y-m-d\TH:i:sO";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_month',
  'data' => 'a:9:{s:4:"uuid";s:36:"be433a4f-f1e2-461d-9ac9-532f97bd14c9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM";}s:2:"id";s:10:"html_month";s:5:"label";s:10:"HTML Month";s:6:"locked";b:1;s:7:"pattern";s:3:"Y-m";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_time',
  'data' => 'a:9:{s:4:"uuid";s:36:"cb06b328-81c4-4e1a-9c02-3f32fe0685f6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE";}s:2:"id";s:9:"html_time";s:5:"label";s:9:"HTML Time";s:6:"locked";b:1;s:7:"pattern";s:5:"H:i:s";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_week',
  'data' => 'a:9:{s:4:"uuid";s:36:"abb878f6-87d4-4738-be8c-ee1d5e6c1f46";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY";}s:2:"id";s:9:"html_week";s:5:"label";s:9:"HTML Week";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-\WW";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_year',
  'data' => 'a:9:{s:4:"uuid";s:36:"7488e7c0-6021-4f44-b268-c34c192944f9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk";}s:2:"id";s:9:"html_year";s:5:"label";s:9:"HTML Year";s:6:"locked";b:1;s:7:"pattern";s:1:"Y";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.html_yearless_date',
  'data' => 'a:9:{s:4:"uuid";s:36:"d27e1929-fa0d-4c61-8ce8-d0bd11320e87";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc";}s:2:"id";s:18:"html_yearless_date";s:5:"label";s:18:"HTML Yearless date";s:6:"locked";b:1;s:7:"pattern";s:3:"m-d";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.localgov_event_date_full',
  'data' => 'a:9:{s:4:"uuid";s:36:"58c1dbb5-8940-4636-8673-0dfeb310dab7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1vhClpCCTC5ahEYQ5GORlPtpcTadhNOPA1yHVEBCsRs";}s:2:"id";s:24:"localgov_event_date_full";s:5:"label";s:15:"Event date full";s:6:"locked";b:0;s:7:"pattern";s:15:"l, jS F Y, g.ia";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.localgov_event_date_hour',
  'data' => 'a:9:{s:4:"uuid";s:36:"bc81f2a7-63e1-464c-9430-9fe0ed334542";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-yQtRZTqIfDGbZJ-IXU0YH4KDMP6B_z6woonSaWe7VA";}s:2:"id";s:24:"localgov_event_date_hour";s:5:"label";s:15:"Event date hour";s:6:"locked";b:0;s:7:"pattern";s:4:"g.ia";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.long',
  'data' => 'a:9:{s:4:"uuid";s:36:"a93528e3-70f3-41d6-9b46-f18ddcac5cd7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo";}s:2:"id";s:4:"long";s:5:"label";s:17:"Default long date";s:6:"locked";b:0;s:7:"pattern";s:15:"l, F j, Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.medium',
  'data' => 'a:9:{s:4:"uuid";s:36:"e33f1d3c-99a7-4e1d-a3f8-4d21696a1131";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE";}s:2:"id";s:6:"medium";s:5:"label";s:19:"Default medium date";s:6:"locked";b:0;s:7:"pattern";s:14:"D, m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.olivero_medium',
  'data' => 'a:9:{s:4:"uuid";s:36:"59a4b606-c534-495c-bd4d-ae9d60b0682e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mt6cmxUbDZ9XxD6p25WQ8tj3_JcX8ylfcddwZc8gcAE";}s:2:"id";s:14:"olivero_medium";s:5:"label";s:14:"Olivero Medium";s:6:"locked";b:0;s:7:"pattern";s:8:"j  F,  Y";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.date_format.short',
  'data' => 'a:9:{s:4:"uuid";s:36:"e75cc929-4d8d-4168-9d54-f4d4c4556b36";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA";}s:2:"id";s:5:"short";s:5:"label";s:18:"Default short date";s:6:"locked";b:0;s:7:"pattern";s:11:"m/d/Y - H:i";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.block_content.basic.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"9d1e6bd4-1acd-4b1e-8596-61b36c5e5d2a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jAps3FCxvKecABS_tgExbhCZrBLQB3bNPWw18WjE3ss";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:4:"info";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.comment.comment.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"48f319a4-f5ac-4af3-b6a6-caaff2af93ce";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I0Pa0aQvT_jawlPo9oz4FE3h_ickc55dYKTPl6gILes";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:6:"author";a:2:{s:6:"weight";i:-2;s:6:"region";s:7:"content";}s:12:"comment_body";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:7:"subject";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.localgov_geo.address.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"a1b3514e-914b-430b-a007-770cd998cc20";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:46:"field.field.localgov_geo.address.accessibility";i:1;s:44:"field.field.localgov_geo.address.external_id";i:2;s:41:"field.field.localgov_geo.address.location";i:3;s:47:"field.field.localgov_geo.address.postal_address";i:4;s:38:"localgov_geo.localgov_geo_type.address";}s:6:"module";a:3:{i:0;s:12:"geofield_map";i:1;s:20:"localgov_geo_address";i:2;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jfUnajWSAB4egEC507hsq8AQ204Kf6bmz-sg0_BlSAI";}s:2:"id";s:28:"localgov_geo.address.default";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:7:"address";s:4:"mode";s:7:"default";s:7:"content";a:6:{s:13:"accessibility";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:8:"location";a:5:{s:4:"type";s:12:"geofield_map";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:16:{s:17:"html5_geolocation";b:0;s:13:"default_value";a:2:{s:3:"lat";d:0;s:3:"lon";d:0;}s:11:"map_library";s:7:"leaflet";s:18:"map_google_api_key";s:0:"";s:17:"map_google_places";a:2:{s:14:"places_control";b:0;s:25:"places_additional_options";s:0:"";}s:14:"map_dimensions";a:2:{s:5:"width";s:4:"100%";s:6:"height";s:5:"450px";}s:15:"map_type_google";s:7:"roadmap";s:16:"map_type_leaflet";s:20:"OpenStreetMap_Mapnik";s:17:"map_type_selector";b:1;s:10:"zoom_level";i:5;s:4:"zoom";a:4:{s:5:"start";i:6;s:5:"focus";i:12;s:3:"min";i:0;s:3:"max";i:22;}s:20:"click_to_find_marker";b:0;s:21:"click_to_place_marker";b:0;s:16:"hide_coordinates";b:0;s:16:"geoaddress_field";a:3:{s:5:"field";s:1:"0";s:6:"hidden";b:0;s:8:"disabled";b:1;}s:12:"map_geocoder";a:2:{s:7:"control";i:0;s:8:"settings";a:4:{s:9:"providers";a:1:{s:20:"localgov_default_osm";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}}s:9:"min_terms";i:4;s:5:"delay";i:800;s:7:"options";s:0:"";}}}s:20:"third_party_settings";a:0:{}}s:14:"postal_address";a:5:{s:4:"type";s:20:"localgov_geo_address";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:9:"providers";a:1:{s:20:"localgov_default_osm";a:2:{s:7:"checked";b:1;s:6:"weight";i:0;}}s:16:"geocode_geofield";s:8:"location";}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:0;}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:4;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:2:{s:11:"external_id";b:1;s:5:"label";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.localgov_geo.address.inline',
  'data' => 'a:11:{s:4:"uuid";s:36:"aec829be-0208-4912-b4cc-2b541cc726de";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:41:"core.entity_form_mode.localgov_geo.inline";i:1;s:46:"field.field.localgov_geo.address.accessibility";i:2;s:44:"field.field.localgov_geo.address.external_id";i:3;s:41:"field.field.localgov_geo.address.location";i:4;s:47:"field.field.localgov_geo.address.postal_address";i:5;s:38:"localgov_geo.localgov_geo_type.address";}s:6:"module";a:3:{i:0;s:12:"geofield_map";i:1;s:20:"localgov_geo_address";i:2;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lfQCbtGC686vBeZf7vJ7C62w6h-NcB6bNayH9WcsUnY";}s:2:"id";s:27:"localgov_geo.address.inline";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:7:"address";s:4:"mode";s:6:"inline";s:7:"content";a:3:{s:13:"accessibility";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:8:"location";a:5:{s:4:"type";s:12:"geofield_map";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:16:{s:17:"html5_geolocation";b:0;s:13:"default_value";a:2:{s:3:"lat";d:0;s:3:"lon";d:0;}s:11:"map_library";s:7:"leaflet";s:18:"map_google_api_key";s:0:"";s:17:"map_google_places";a:2:{s:14:"places_control";b:0;s:25:"places_additional_options";s:0:"";}s:14:"map_dimensions";a:2:{s:5:"width";s:4:"100%";s:6:"height";s:5:"450px";}s:15:"map_type_google";s:7:"roadmap";s:16:"map_type_leaflet";s:20:"OpenStreetMap_Mapnik";s:17:"map_type_selector";b:1;s:10:"zoom_level";i:5;s:4:"zoom";a:4:{s:5:"start";i:6;s:5:"focus";i:12;s:3:"min";i:0;s:3:"max";i:22;}s:20:"click_to_find_marker";b:0;s:21:"click_to_place_marker";b:0;s:16:"hide_coordinates";b:0;s:16:"geoaddress_field";a:3:{s:5:"field";s:1:"0";s:6:"hidden";b:0;s:8:"disabled";b:1;}s:12:"map_geocoder";a:2:{s:7:"control";i:0;s:8:"settings";a:4:{s:9:"providers";a:1:{s:20:"localgov_default_osm";a:2:{s:6:"weight";i:0;s:7:"checked";b:1;}}s:9:"min_terms";i:4;s:5:"delay";i:800;s:7:"options";s:0:"";}}}s:20:"third_party_settings";a:0:{}}s:14:"postal_address";a:5:{s:4:"type";s:20:"localgov_geo_address";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:9:"providers";a:1:{s:20:"localgov_default_osm";a:2:{s:7:"checked";b:1;s:6:"weight";i:0;}}s:16:"geocode_geofield";s:8:"location";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:5:{s:7:"created";b:1;s:11:"external_id";b:1;s:5:"label";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.localgov_geo.area.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"4cff9bcc-4e8d-4c6c-a4ec-ef1b7a701687";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"field.field.localgov_geo.area.external_id";i:1;s:38:"field.field.localgov_geo.area.geo_file";i:2;s:38:"field.field.localgov_geo.area.location";i:3;s:35:"localgov_geo.localgov_geo_type.area";}s:6:"module";a:2:{i:0;s:4:"file";i:1;s:8:"geofield";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HzLeDysnJPtSmzQuGdgN6uSOUPx8f1vwBROy-OLjPiI";}s:2:"id";s:25:"localgov_geo.area.default";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:4:"area";s:4:"mode";s:7:"default";s:7:"content";a:6:{s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:8:"geo_file";a:5:{s:6:"weight";i:2;s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}s:20:"third_party_settings";a:0:{}s:4:"type";s:12:"file_generic";s:6:"region";s:7:"content";}s:5:"label";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:8:"location";a:5:{s:6:"weight";i:1;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:16:"geofield_default";s:6:"region";s:7:"content";}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:0;}s:6:"weight";i:3;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";i:60;s:11:"placeholder";s:0:"";s:11:"match_limit";i:10;}s:6:"weight";i:4;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:1:{s:11:"external_id";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.localgov_geo.area.inline',
  'data' => 'a:11:{s:4:"uuid";s:36:"709f13fc-0515-40fe-bff2-4c2dc494d2ad";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:41:"core.entity_form_mode.localgov_geo.inline";i:1;s:41:"field.field.localgov_geo.area.external_id";i:2;s:38:"field.field.localgov_geo.area.geo_file";i:3;s:38:"field.field.localgov_geo.area.location";i:4;s:35:"localgov_geo.localgov_geo_type.area";}s:6:"module";a:2:{i:0;s:4:"file";i:1;s:8:"geofield";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"XldhFtj4qtml5ppqqBDmdFZzalGVBQeVWVh01D02_jw";}s:2:"id";s:24:"localgov_geo.area.inline";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:4:"area";s:4:"mode";s:6:"inline";s:7:"content";a:3:{s:8:"geo_file";a:5:{s:6:"weight";i:2;s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}s:20:"third_party_settings";a:0:{}s:4:"type";s:12:"file_generic";s:6:"region";s:7:"content";}s:5:"label";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:8:"location";a:5:{s:6:"weight";i:1;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:16:"geofield_default";s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:11:"external_id";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.audio.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"0ba94dc5-26a4-4baf-a59a-0661f59ab37f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:46:"field.field.media.audio.field_media_audio_file";i:1;s:16:"media.type.audio";}s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"path";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"G2_SKH3jmI9FQeXSUxo3KgQqiyF1hPDEkc7-3-rCSbc";}s:2:"id";s:19:"media.audio.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"audio";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:22:"field_media_audio_file";a:5:{s:4:"type";s:12:"file_generic";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:1:{s:4:"name";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.audio.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"6001f079-1e25-4214-8bf6-22810147fb79";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:41:"core.entity_form_mode.media.media_library";i:1;s:46:"field.field.media.audio.field_media_audio_file";i:2;s:16:"media.type.audio";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"28vwMIYtvyjPcD4RyciZXIztxtZgmuWRCNgYemr_SZE";}s:2:"id";s:25:"media.audio.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"audio";s:4:"mode";s:13:"media_library";s:7:"content";a:0:{}s:6:"hidden";a:6:{s:7:"created";b:1;s:22:"field_media_audio_file";b:1;s:4:"name";b:1;s:4:"path";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.document.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"49d467cc-2674-4bf0-b2b9-5291b86b6dc7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:47:"field.field.media.document.field_media_document";i:1;s:19:"media.type.document";}s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"path";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aewrRkePgJzdD5kPOq8JeMcKHs6yat49nE7ZeCQzQZg";}s:2:"id";s:22:"media.document.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:8:"document";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:20:"field_media_document";a:5:{s:4:"type";s:12:"file_generic";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:1:{s:4:"name";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.document.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"f123b768-eb97-45c8-9abd-d4f15658e881";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:41:"core.entity_form_mode.media.media_library";i:1;s:47:"field.field.media.document.field_media_document";i:2;s:19:"media.type.document";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dcpfpqyLXOSGpulacMAJW3H-G34_LeNsjdfxd1_oCfY";}s:2:"id";s:28:"media.document.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:8:"document";s:4:"mode";s:13:"media_library";s:7:"content";a:0:{}s:6:"hidden";a:6:{s:7:"created";b:1;s:20:"field_media_document";b:1;s:4:"name";b:1;s:4:"path";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.image.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"06b5ccc5-c737-47e5-bbb4-0b6efe82447a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:41:"field.field.media.image.field_media_image";i:1;s:21:"image.style.thumbnail";i:2;s:16:"media.type.image";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"path";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JSY4-JPyNZBiYYo6imdRYF6_SdtWQexPndrLvn3-vw4";}s:2:"id";s:19:"media.image.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:17:"field_media_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:1:{s:4:"name";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.image.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"907d63f7-2602-455f-8766-eb1134628092";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_form_mode.media.media_library";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:21:"image.style.thumbnail";i:3;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BMLrK4zKp8-FFnMseBdT_6h6YipUsKRfbDf_3WUB5HA";}s:2:"id";s:25:"media.image.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:17:"field_media_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:4:"path";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.remote_video.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"108c95d9-cd6c-44eb-a348-e43823e456ee";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:55:"field.field.media.remote_video.field_media_oembed_video";i:1;s:23:"media.type.remote_video";}s:6:"module";a:2:{i:0;s:5:"media";i:1;s:4:"path";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pM8mGlwfpvfG_y5tZn0lGAXFLXz2_yKkL7MvWZsRqdA";}s:2:"id";s:26:"media.remote_video.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:24:"field_media_oembed_video";a:5:{s:4:"type";s:16:"oembed_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:1:{s:4:"name";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.remote_video.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"f324e077-2212-4be8-bf47-f76367cf6969";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:41:"core.entity_form_mode.media.media_library";i:1;s:55:"field.field.media.remote_video.field_media_oembed_video";i:2;s:23:"media.type.remote_video";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TBgPW-uaXRaICBwLaVc16rXpRiLSknDIdF9q0XL7qso";}s:2:"id";s:32:"media.remote_video.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:13:"media_library";s:7:"content";a:0:{}s:6:"hidden";a:6:{s:7:"created";b:1;s:24:"field_media_oembed_video";b:1;s:4:"name";b:1;s:4:"path";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.video.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"16ee1cfc-6b8e-44c8-8c33-33f49457058a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:46:"field.field.media.video.field_media_video_file";i:1;s:16:"media.type.video";}s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"path";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0kIIaDTt6dixXy8TZkat2MNGZJ6vkRG8TaBWTy3E1bM";}s:2:"id";s:19:"media.video.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"video";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:22:"field_media_video_file";a:5:{s:4:"type";s:12:"file_generic";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:1:{s:4:"name";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.media.video.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"7641d751-09b1-426e-acb0-3835c461b061";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:41:"core.entity_form_mode.media.media_library";i:1;s:46:"field.field.media.video.field_media_video_file";i:2;s:16:"media.type.video";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"kGv8YsopqHvzTzb7QTINWcv0fnNa5ZDQyZxpOQR2vro";}s:2:"id";s:25:"media.video.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"video";s:4:"mode";s:13:"media_library";s:7:"content";a:0:{}s:6:"hidden";a:6:{s:7:"created";b:1;s:22:"field_media_video_file";b:1;s:4:"name";b:1;s:4:"path";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.article.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"be366e88-86ba-4af0-bfc7-a606e720fc54";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:29:"field.field.node.article.body";i:1;s:32:"field.field.node.article.comment";i:2;s:36:"field.field.node.article.field_image";i:3;s:35:"field.field.node.article.field_tags";i:4;s:21:"image.style.thumbnail";i:5;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"path";i:3;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ewbd6G2uX456-bgwseM2Q-KQG3RkASoyHmTh-XR3oLU";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:11:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"comment";a:5:{s:4:"type";s:15:"comment_default";s:6:"weight";i:20;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:11:"field_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:10:"field_tags";a:5:{s:4:"type";s:34:"entity_reference_autocomplete_tags";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.localgov_directories_venue.default',
  'data' => 'a:12:{s:4:"uuid";s:36:"edbc164c-0ea2-4886-8e92-751179345179";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:15:{i:0;s:43:"entity_browser.browser.localgov_geo_library";i:1;s:48:"field.field.node.localgov_directories_venue.body";i:2;s:71:"field.field.node.localgov_directories_venue.localgov_directory_channels";i:3;s:68:"field.field.node.localgov_directories_venue.localgov_directory_email";i:4;s:76:"field.field.node.localgov_directories_venue.localgov_directory_facets_select";i:5;s:68:"field.field.node.localgov_directories_venue.localgov_directory_files";i:6;s:72:"field.field.node.localgov_directories_venue.localgov_directory_job_title";i:7;s:67:"field.field.node.localgov_directories_venue.localgov_directory_name";i:8;s:68:"field.field.node.localgov_directories_venue.localgov_directory_notes";i:9;s:76:"field.field.node.localgov_directories_venue.localgov_directory_opening_times";i:10;s:68:"field.field.node.localgov_directories_venue.localgov_directory_phone";i:11;s:73:"field.field.node.localgov_directories_venue.localgov_directory_title_sort";i:12;s:70:"field.field.node.localgov_directories_venue.localgov_directory_website";i:13;s:61:"field.field.node.localgov_directories_venue.localgov_location";i:14;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:8:{i:0;s:14:"entity_browser";i:1;s:11:"field_group";i:2;s:4:"link";i:3;s:20:"localgov_directories";i:4;s:13:"media_library";i:5;s:4:"path";i:6;s:9:"telephone";i:7;s:4:"text";}}s:20:"third_party_settings";a:1:{s:11:"field_group";a:5:{s:10:"group_tabs";a:7:{s:8:"children";a:4:{i:0;s:17:"group_description";i:1;s:15:"group_directory";i:2;s:15:"group_enquiries";i:3;s:11:"group_venue";}s:11:"parent_name";s:0:"";s:6:"weight";i:0;s:11:"format_type";s:4:"tabs";s:6:"region";s:7:"content";s:15:"format_settings";a:3:{s:2:"id";s:0:"";s:7:"classes";s:0:"";s:9:"direction";s:8:"vertical";}s:5:"label";s:4:"tabs";}s:17:"group_description";a:7:{s:8:"children";a:4:{i:0;s:5:"title";i:1;s:29:"localgov_directory_title_sort";i:2;s:4:"body";i:3;s:24:"localgov_directory_files";}s:11:"parent_name";s:10:"group_tabs";s:6:"weight";i:6;s:11:"format_type";s:3:"tab";s:6:"region";s:7:"content";s:15:"format_settings";a:5:{s:2:"id";s:0:"";s:7:"classes";s:0:"";s:11:"description";s:0:"";s:9:"formatter";s:6:"closed";s:15:"required_fields";b:1;}s:5:"label";s:11:"Description";}s:15:"group_directory";a:7:{s:8:"children";a:2:{i:0;s:27:"localgov_directory_channels";i:1;s:32:"localgov_directory_facets_select";}s:11:"parent_name";s:10:"group_tabs";s:6:"weight";i:7;s:11:"format_type";s:3:"tab";s:6:"region";s:7:"content";s:15:"format_settings";a:5:{s:2:"id";s:0:"";s:7:"classes";s:0:"";s:11:"description";s:0:"";s:9:"formatter";s:6:"closed";s:15:"required_fields";b:1;}s:5:"label";s:19:"Channels and facets";}s:15:"group_enquiries";a:7:{s:8:"children";a:5:{i:0;s:23:"localgov_directory_name";i:1;s:28:"localgov_directory_job_title";i:2;s:24:"localgov_directory_phone";i:3;s:24:"localgov_directory_email";i:4;s:26:"localgov_directory_website";}s:11:"parent_name";s:10:"group_tabs";s:6:"weight";i:8;s:11:"format_type";s:3:"tab";s:6:"region";s:7:"content";s:15:"format_settings";a:5:{s:2:"id";s:0:"";s:7:"classes";s:0:"";s:11:"description";s:0:"";s:9:"formatter";s:6:"closed";s:15:"required_fields";b:1;}s:5:"label";s:9:"Enquiries";}s:11:"group_venue";a:7:{s:8:"children";a:3:{i:0;s:17:"localgov_location";i:1;s:32:"localgov_directory_opening_times";i:2;s:24:"localgov_directory_notes";}s:11:"parent_name";s:10:"group_tabs";s:6:"weight";i:9;s:11:"format_type";s:3:"tab";s:6:"region";s:7:"content";s:15:"format_settings";a:5:{s:2:"id";s:0:"";s:7:"classes";s:0:"";s:11:"description";s:0:"";s:9:"formatter";s:6:"closed";s:15:"required_fields";b:1;}s:5:"label";s:5:"Venue";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fGGCppy8qdMYXq0fgpTDOBTmF0lwBRbFrJ8EaTsCyq4";}s:2:"id";s:39:"node.localgov_directories_venue.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:4:"mode";s:7:"default";s:7:"content";a:20:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:26;s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:1;}s:20:"third_party_settings";a:0:{}s:6:"region";s:7:"content";}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:27:"localgov_directory_channels";a:5:{s:6:"weight";i:9;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:37:"localgov_directories_channel_selector";s:6:"region";s:7:"content";}s:24:"localgov_directory_email";a:5:{s:6:"weight";i:15;s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:13:"email_default";s:6:"region";s:7:"content";}s:32:"localgov_directory_facets_select";a:5:{s:6:"weight";i:10;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:35:"localgov_directories_facet_checkbox";s:6:"region";s:7:"content";}s:24:"localgov_directory_files";a:5:{s:6:"weight";i:27;s:8:"settings";a:1:{s:11:"media_types";a:0:{}}s:20:"third_party_settings";a:0:{}s:4:"type";s:20:"media_library_widget";s:6:"region";s:7:"content";}s:28:"localgov_directory_job_title";a:5:{s:6:"weight";i:13;s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:16:"string_textfield";s:6:"region";s:7:"content";}s:23:"localgov_directory_name";a:5:{s:6:"weight";i:12;s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:16:"string_textfield";s:6:"region";s:7:"content";}s:24:"localgov_directory_notes";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:32:"localgov_directory_opening_times";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:8;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:24:"localgov_directory_phone";a:5:{s:6:"weight";i:14;s:8:"settings";a:1:{s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:17:"telephone_default";s:6:"region";s:7:"content";}s:29:"localgov_directory_title_sort";a:5:{s:6:"weight";i:25;s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:16:"string_textfield";s:6:"region";s:7:"content";}s:26:"localgov_directory_website";a:5:{s:6:"weight";i:16;s:8:"settings";a:2:{s:15:"placeholder_url";s:0:"";s:17:"placeholder_title";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:12:"link_default";s:6:"region";s:7:"content";}s:17:"localgov_location";a:5:{s:4:"type";s:31:"entity_browser_entity_reference";s:6:"weight";i:7;s:6:"region";s:7:"content";s:8:"settings";a:8:{s:14:"entity_browser";s:20:"localgov_geo_library";s:20:"field_widget_display";s:5:"label";s:17:"field_widget_edit";b:1;s:19:"field_widget_remove";b:1;s:20:"field_widget_replace";b:1;s:4:"open";b:1;s:14:"selection_mode";s:16:"selection_append";s:29:"field_widget_display_settings";a:0:{}}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:3;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:6;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:4;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:24;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:1;s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";i:60;s:11:"placeholder";s:0:"";s:11:"match_limit";i:10;}s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.localgov_directory.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"992375f1-ead0-435d-a9ff-8d9ccda64976";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:40:"field.field.node.localgov_directory.body";i:1;s:68:"field.field.node.localgov_directory.localgov_directory_channel_types";i:2;s:68:"field.field.node.localgov_directory.localgov_directory_facets_enable";i:3;s:28:"node.type.localgov_directory";}s:6:"module";a:2:{i:0;s:4:"path";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HfgP4-gJWsj2jzxpuxfmChH0TWYIQSBlDxQORTXyxvg";}s:2:"id";s:31:"node.localgov_directory.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:18:"localgov_directory";s:4:"mode";s:7:"default";s:7:"content";a:10:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:121;s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:1;}s:20:"third_party_settings";a:0:{}s:6:"region";s:7:"content";}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:32:"localgov_directory_channel_types";a:5:{s:6:"weight";i:123;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:15:"options_buttons";s:6:"region";s:7:"content";}s:32:"localgov_directory_facets_enable";a:5:{s:6:"weight";i:122;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:15:"options_buttons";s:6:"region";s:7:"content";}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:15;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:120;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:16;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";i:60;s:11:"placeholder";s:0:"";s:11:"match_limit";i:10;}s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.localgov_event.default',
  'data' => 'a:12:{s:4:"uuid";s:36:"5deaf829-1b55-42c1-b10a-2128533aee7c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:11:{i:0;s:43:"entity_browser.browser.localgov_geo_library";i:1;s:36:"field.field.node.localgov_event.body";i:2;s:61:"field.field.node.localgov_event.localgov_event_call_to_action";i:3;s:57:"field.field.node.localgov_event.localgov_event_categories";i:4;s:51:"field.field.node.localgov_event.localgov_event_date";i:5;s:52:"field.field.node.localgov_event.localgov_event_image";i:6;s:55:"field.field.node.localgov_event.localgov_event_locality";i:7;s:55:"field.field.node.localgov_event.localgov_event_location";i:8;s:52:"field.field.node.localgov_event.localgov_event_price";i:9;s:52:"field.field.node.localgov_event.localgov_event_venue";i:10;s:24:"node.type.localgov_event";}s:6:"module";a:7:{i:0;s:18:"date_recur_modular";i:1;s:14:"entity_browser";i:2;s:11:"field_group";i:3;s:4:"link";i:4;s:13:"media_library";i:5;s:4:"path";i:6;s:4:"text";}}s:20:"third_party_settings";a:1:{s:11:"field_group";a:5:{s:10:"group_tags";a:7:{s:8:"children";a:4:{i:0;s:13:"group_details";i:1;s:10:"group_date";i:2;s:14:"group_location";i:3;s:12:"group_facets";}s:5:"label";s:4:"tags";s:6:"region";s:7:"content";s:11:"parent_name";s:0:"";s:6:"weight";i:0;s:11:"format_type";s:4:"tabs";s:15:"format_settings";a:3:{s:7:"classes";s:0:"";s:2:"id";s:0:"";s:9:"direction";s:8:"vertical";}}s:13:"group_details";a:7:{s:8:"children";a:4:{i:0;s:5:"title";i:1;s:4:"body";i:2;s:20:"localgov_event_image";i:3;s:29:"localgov_event_call_to_action";}s:5:"label";s:7:"Details";s:6:"region";s:7:"content";s:11:"parent_name";s:10:"group_tags";s:6:"weight";i:4;s:11:"format_type";s:3:"tab";s:15:"format_settings";a:5:{s:7:"classes";s:0:"";s:2:"id";s:0:"";s:9:"formatter";s:6:"closed";s:11:"description";s:0:"";s:15:"required_fields";b:1;}}s:10:"group_date";a:7:{s:8:"children";a:1:{i:0;s:19:"localgov_event_date";}s:5:"label";s:4:"Date";s:6:"region";s:7:"content";s:11:"parent_name";s:10:"group_tags";s:6:"weight";i:5;s:11:"format_type";s:3:"tab";s:15:"format_settings";a:5:{s:7:"classes";s:0:"";s:2:"id";s:0:"";s:9:"formatter";s:6:"closed";s:11:"description";s:0:"";s:15:"required_fields";b:1;}}s:14:"group_location";a:7:{s:8:"children";a:3:{i:0;s:23:"localgov_event_provider";i:1;s:20:"localgov_event_venue";i:2;s:23:"localgov_event_location";}s:5:"label";s:8:"Location";s:6:"region";s:7:"content";s:11:"parent_name";s:10:"group_tags";s:6:"weight";i:6;s:11:"format_type";s:3:"tab";s:15:"format_settings";a:5:{s:7:"classes";s:0:"";s:2:"id";s:0:"";s:9:"formatter";s:6:"closed";s:11:"description";s:0:"";s:15:"required_fields";b:1;}}s:12:"group_facets";a:7:{s:8:"children";a:3:{i:0;s:20:"localgov_event_price";i:1;s:23:"localgov_event_locality";i:2;s:25:"localgov_event_categories";}s:5:"label";s:6:"Facets";s:6:"region";s:7:"content";s:11:"parent_name";s:10:"group_tags";s:6:"weight";i:7;s:11:"format_type";s:3:"tab";s:15:"format_settings";a:5:{s:7:"classes";s:0:"";s:2:"id";s:0:"";s:9:"formatter";s:6:"closed";s:11:"description";s:0:"";s:15:"required_fields";b:1;}}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Zfqg72MdkLXIU4eOKtQrjfQQkB6_ToAmFpn09O5eckk";}s:2:"id";s:27:"node.localgov_event.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:4:"mode";s:7:"default";s:7:"content";a:17:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:1;}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:29:"localgov_event_call_to_action";a:5:{s:4:"type";s:12:"link_default";s:6:"weight";i:4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:15:"placeholder_url";s:0:"";s:17:"placeholder_title";s:0:"";}s:20:"third_party_settings";a:0:{}}s:25:"localgov_event_categories";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:19:"localgov_event_date";a:5:{s:4:"type";s:24:"date_recur_modular_alpha";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:20:"localgov_event_image";a:5:{s:4:"type";s:20:"media_library_widget";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:11:"media_types";a:0:{}}s:20:"third_party_settings";a:0:{}}s:23:"localgov_event_locality";a:5:{s:4:"type";s:14:"options_select";s:6:"weight";i:9;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:23:"localgov_event_location";a:5:{s:4:"type";s:31:"entity_browser_entity_reference";s:6:"weight";i:12;s:6:"region";s:7:"content";s:8:"settings";a:8:{s:14:"entity_browser";s:20:"localgov_geo_library";s:20:"field_widget_display";s:5:"label";s:17:"field_widget_edit";b:1;s:19:"field_widget_remove";b:1;s:20:"field_widget_replace";b:0;s:4:"open";b:1;s:29:"field_widget_display_settings";a:0:{}s:14:"selection_mode";s:16:"selection_append";}s:20:"third_party_settings";a:0:{}}s:20:"localgov_event_price";a:5:{s:4:"type";s:14:"options_select";s:6:"weight";i:7;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:23:"localgov_event_provider";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:20:"localgov_event_venue";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:14;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:12;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:13;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.page.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"8421e03d-c8ef-4f5c-8be9-84910c536c98";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"path";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SfpLhPExzvR0MgFp0Wp7CrmgEnhcqQ-fXIWFhbf4ue0";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:8:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:31;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.node.test.default',
  'data' => 'a:10:{s:4:"uuid";s:36:"33447aa4-8599-433c-9a13-64ba425c633e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:43:"entity_browser.browser.localgov_geo_library";i:1;s:47:"field.field.node.test.field_alternate_reference";i:2;s:14:"node.type.test";}s:6:"module";a:2:{i:0;s:14:"entity_browser";i:1;s:4:"path";}}s:2:"id";s:17:"node.test.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"test";s:4:"mode";s:7:"default";s:7:"content";a:8:{s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:25:"field_alternate_reference";a:5:{s:4:"type";s:31:"entity_browser_entity_reference";s:6:"weight";i:121;s:6:"region";s:7:"content";s:8:"settings";a:8:{s:14:"entity_browser";s:20:"localgov_geo_library";s:20:"field_widget_display";s:5:"label";s:17:"field_widget_edit";b:0;s:19:"field_widget_remove";b:0;s:20:"field_widget_replace";b:0;s:4:"open";b:0;s:29:"field_widget_display_settings";a:0:{}s:14:"selection_mode";s:16:"selection_append";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_display.user.user.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"0ab0c2be-4cf5-4173-9fff-98d3939d14f8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FaQ9Ptcpxpg30AtiqRDtl_8zbJArHP1LPfug_s59TOA";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"account";a:2:{s:6:"weight";i:-10;s:6:"region";s:7:"content";}s:7:"contact";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:8:"language";a:2:{s:6:"weight";i:0;s:6:"region";s:7:"content";}s:8:"timezone";a:2:{s:6:"weight";i:6;s:6:"region";s:7:"content";}s:12:"user_picture";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_mode.localgov_geo.inline',
  'data' => 'a:9:{s:4:"uuid";s:36:"1a04479f-c6d6-4589-9c6b-539f6724ad8b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:12:"localgov_geo";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uh4Qm1-_I0AQ3pojBu1RkAcbwtbFYsGfLlvflYUjhes";}s:2:"id";s:19:"localgov_geo.inline";s:5:"label";s:6:"Inline";s:16:"targetEntityType";s:12:"localgov_geo";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_mode.media.media_library',
  'data' => 'a:9:{s:4:"uuid";s:36:"831a82e4-fb15-47a6-bc61-61e8c7357965";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:5:"media";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:13:"media_library";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Tdhz-aDHfDoV1Ul9umtItxGTrjkFzoNAkDw8FWXjYA0";}s:2:"id";s:19:"media.media_library";s:5:"label";s:13:"Media library";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_form_mode.user.register',
  'data' => 'a:9:{s:4:"uuid";s:36:"2c809aac-a415-4ec8-818f-238d48b41cf0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"flXhTcp55yLcyy7ZLOhPGKGZobZQJdkAFVWV3LseiuI";}s:2:"id";s:13:"user.register";s:5:"label";s:8:"Register";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.block_content.basic.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"214dbd66-776e-4de0-8f91-0e1fb7a3b1f3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hBNNDTFwakREOTa6GGMqN899Iyrii0hInwSJtQ7Kj30";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.comment.comment.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"122a008b-9078-4052-a7a3-f96c8be4b802";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aBQUGsQ46M4048fIlFuTXwl2zV0j2cJX89CTUobh9hA";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:12:"comment_body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.localgov_geo.address.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"d016774f-1935-4015-9359-5bdec1fda36a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:46:"field.field.localgov_geo.address.accessibility";i:1;s:44:"field.field.localgov_geo.address.external_id";i:2;s:41:"field.field.localgov_geo.address.location";i:3;s:47:"field.field.localgov_geo.address.postal_address";i:4;s:38:"localgov_geo.localgov_geo_type.address";}s:6:"module";a:3:{i:0;s:7:"address";i:1;s:7:"leaflet";i:2;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lSeaAxgBqUauSKrMOxnS7heoucx2zEyIIf8DFlH_mXw";}s:2:"id";s:28:"localgov_geo.address.default";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:7:"address";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:13:"accessibility";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:2;s:6:"region";s:7:"content";}s:8:"location";a:6:{s:4:"type";s:25:"leaflet_formatter_default";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:20:{s:12:"multiple_map";b:0;s:11:"leaflet_map";s:10:"OSM Mapnik";s:6:"height";i:400;s:11:"height_unit";s:2:"px";s:14:"hide_empty_map";b:0;s:13:"disable_wheel";b:0;s:16:"gesture_handling";b:0;s:9:"reset_map";a:2:{s:7:"control";b:0;s:7:"options";s:43:"{"position":"topleft","title":"Reset View"}";}s:6:"locate";a:3:{s:7:"control";b:0;s:7:"options";s:145:"{"position":"topright","setView":"untilPanOrZoom","returnToPrevBounds":true,"keepCurrentZoomLevel":true,"strings":{"title":"Locate my position"}}";s:9:"automatic";b:0;}s:15:"leaflet_tooltip";a:2:{s:5:"value";s:0:"";s:7:"options";s:40:"{"permanent":false,"direction":"center"}";}s:5:"popup";b:0;s:13:"popup_content";s:0:"";s:13:"leaflet_popup";a:3:{s:7:"control";s:1:"0";s:7:"content";s:0:"";s:7:"options";s:49:"{"maxWidth":"300","minWidth":"50","autoPan":true}";}s:12:"map_position";a:6:{s:5:"force";b:0;s:6:"center";a:2:{s:3:"lat";d:0;s:3:"lon";d:0;}s:4:"zoom";i:12;s:7:"minZoom";i:1;s:7:"maxZoom";i:18;s:9:"zoomFiner";i:0;}s:4:"icon";a:12:{s:8:"iconType";s:6:"marker";s:7:"iconUrl";s:0:"";s:9:"shadowUrl";s:0:"";s:9:"className";s:0:"";s:8:"iconSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"iconAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"shadowSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:12:"shadowAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:11:"popupAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:4:"html";s:11:"<div></div>";s:10:"html_class";s:19:"leaflet-map-divicon";s:21:"circle_marker_options";s:65:"{"radius":100,"color":"red","fillColor":"#f03","fillOpacity":0.5}";}s:21:"leaflet_markercluster";a:4:{s:7:"control";b:0;s:7:"options";s:89:"{"spiderfyOnMaxZoom":true,"showCoverageOnHover":true,"removeOutsideVisibleBounds": false}";s:8:"excluded";s:0:"";s:12:"include_path";b:0;}s:10:"fullscreen";a:2:{s:7:"control";b:0;s:7:"options";s:47:"{"position":"topleft","pseudoFullscreen":false}";}s:4:"path";s:113:"{"color":"#3388ff","opacity":"1.0","stroke":true,"weight":3,"fill":"depends","fillColor":"*","fillOpacity":"0.2"}";s:18:"feature_properties";a:1:{s:6:"values";s:0:"";}s:8:"geocoder";a:2:{s:7:"control";b:0;s:8:"settings";a:8:{s:8:"position";s:8:"topright";s:10:"input_size";i:25;s:9:"providers";a:1:{s:20:"localgov_default_osm";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}}s:9:"min_terms";i:4;s:5:"delay";i:800;s:4:"zoom";i:16;s:5:"popup";b:0;s:7:"options";s:0:"";}}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:14:"postal_address";a:6:{s:4:"type";s:15:"address_default";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:11:"external_id";b:1;s:18:"search_api_excerpt";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.localgov_geo.address.embed',
  'data' => 'a:11:{s:4:"uuid";s:36:"5c48b8d3-fa4c-4dc6-ab26-7f6b164c985e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:40:"core.entity_view_mode.localgov_geo.embed";i:1;s:46:"field.field.localgov_geo.address.accessibility";i:2;s:44:"field.field.localgov_geo.address.external_id";i:3;s:41:"field.field.localgov_geo.address.location";i:4;s:47:"field.field.localgov_geo.address.postal_address";i:5;s:38:"localgov_geo.localgov_geo_type.address";}s:6:"module";a:3:{i:0;s:7:"address";i:1;s:7:"leaflet";i:2;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AwXk7X730MtzQI1KWtCTxCM2zIptLhvuHFIcaKQp6i4";}s:2:"id";s:26:"localgov_geo.address.embed";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:7:"address";s:4:"mode";s:5:"embed";s:7:"content";a:3:{s:13:"accessibility";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:2;s:6:"region";s:7:"content";}s:8:"location";a:6:{s:4:"type";s:25:"leaflet_formatter_default";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:20:{s:12:"multiple_map";b:0;s:11:"leaflet_map";s:10:"OSM Mapnik";s:6:"height";i:400;s:11:"height_unit";s:2:"px";s:14:"hide_empty_map";b:0;s:13:"disable_wheel";b:0;s:16:"gesture_handling";b:0;s:9:"reset_map";a:2:{s:7:"control";b:0;s:7:"options";s:43:"{"position":"topleft","title":"Reset View"}";}s:6:"locate";a:3:{s:7:"control";b:0;s:7:"options";s:145:"{"position":"topright","setView":"untilPanOrZoom","returnToPrevBounds":true,"keepCurrentZoomLevel":true,"strings":{"title":"Locate my position"}}";s:9:"automatic";b:0;}s:15:"leaflet_tooltip";a:2:{s:5:"value";s:0:"";s:7:"options";s:40:"{"permanent":false,"direction":"center"}";}s:5:"popup";b:0;s:13:"popup_content";s:0:"";s:13:"leaflet_popup";a:3:{s:7:"control";s:1:"0";s:7:"content";s:0:"";s:7:"options";s:49:"{"maxWidth":"300","minWidth":"50","autoPan":true}";}s:12:"map_position";a:6:{s:5:"force";b:0;s:6:"center";a:2:{s:3:"lat";d:0;s:3:"lon";d:0;}s:4:"zoom";i:12;s:7:"minZoom";i:1;s:7:"maxZoom";i:18;s:9:"zoomFiner";i:0;}s:4:"icon";a:12:{s:8:"iconType";s:6:"marker";s:7:"iconUrl";s:0:"";s:9:"shadowUrl";s:0:"";s:9:"className";s:0:"";s:8:"iconSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"iconAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"shadowSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:12:"shadowAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:11:"popupAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:4:"html";s:11:"<div></div>";s:10:"html_class";s:19:"leaflet-map-divicon";s:21:"circle_marker_options";s:65:"{"radius":100,"color":"red","fillColor":"#f03","fillOpacity":0.5}";}s:21:"leaflet_markercluster";a:4:{s:7:"control";b:0;s:7:"options";s:89:"{"spiderfyOnMaxZoom":true,"showCoverageOnHover":true,"removeOutsideVisibleBounds": false}";s:8:"excluded";s:0:"";s:12:"include_path";b:0;}s:10:"fullscreen";a:2:{s:7:"control";b:0;s:7:"options";s:47:"{"position":"topleft","pseudoFullscreen":false}";}s:4:"path";s:113:"{"color":"#3388ff","opacity":"1.0","stroke":true,"weight":3,"fill":"depends","fillColor":"*","fillOpacity":"0.2"}";s:18:"feature_properties";a:1:{s:6:"values";s:0:"";}s:8:"geocoder";a:2:{s:7:"control";b:0;s:8:"settings";a:8:{s:8:"position";s:8:"topright";s:10:"input_size";i:25;s:9:"providers";a:1:{s:20:"localgov_default_osm";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}}s:9:"min_terms";i:4;s:5:"delay";i:800;s:4:"zoom";i:16;s:5:"popup";b:0;s:7:"options";s:0:"";}}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:14:"postal_address";a:6:{s:4:"type";s:15:"address_default";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:11:"external_id";b:1;s:18:"search_api_excerpt";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.localgov_geo.address.full',
  'data' => 'a:11:{s:4:"uuid";s:36:"e141f688-936f-412f-ac89-eb5d42ddcc1d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:39:"core.entity_view_mode.localgov_geo.full";i:1;s:46:"field.field.localgov_geo.address.accessibility";i:2;s:44:"field.field.localgov_geo.address.external_id";i:3;s:41:"field.field.localgov_geo.address.location";i:4;s:47:"field.field.localgov_geo.address.postal_address";i:5;s:38:"localgov_geo.localgov_geo_type.address";}s:6:"module";a:3:{i:0;s:7:"address";i:1;s:7:"leaflet";i:2;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ORa8PkNzCgPgPJQT18zFrW6SI4BEDU4bxoyD1zG5aLY";}s:2:"id";s:25:"localgov_geo.address.full";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:7:"address";s:4:"mode";s:4:"full";s:7:"content";a:3:{s:13:"accessibility";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:2;s:6:"region";s:7:"content";}s:8:"location";a:6:{s:4:"type";s:25:"leaflet_formatter_default";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:20:{s:12:"multiple_map";b:0;s:11:"leaflet_map";s:10:"OSM Mapnik";s:6:"height";i:400;s:11:"height_unit";s:2:"px";s:14:"hide_empty_map";b:0;s:13:"disable_wheel";b:0;s:16:"gesture_handling";b:0;s:9:"reset_map";a:2:{s:7:"control";b:0;s:7:"options";s:43:"{"position":"topleft","title":"Reset View"}";}s:6:"locate";a:3:{s:7:"control";b:0;s:7:"options";s:145:"{"position":"topright","setView":"untilPanOrZoom","returnToPrevBounds":true,"keepCurrentZoomLevel":true,"strings":{"title":"Locate my position"}}";s:9:"automatic";b:0;}s:15:"leaflet_tooltip";a:2:{s:5:"value";s:0:"";s:7:"options";s:40:"{"permanent":false,"direction":"center"}";}s:5:"popup";b:0;s:13:"popup_content";s:0:"";s:13:"leaflet_popup";a:3:{s:7:"control";s:1:"0";s:7:"content";s:0:"";s:7:"options";s:49:"{"maxWidth":"300","minWidth":"50","autoPan":true}";}s:12:"map_position";a:6:{s:5:"force";b:0;s:6:"center";a:2:{s:3:"lat";d:0;s:3:"lon";d:0;}s:4:"zoom";i:12;s:7:"minZoom";i:1;s:7:"maxZoom";i:18;s:9:"zoomFiner";i:0;}s:4:"icon";a:12:{s:8:"iconType";s:6:"marker";s:7:"iconUrl";s:0:"";s:9:"shadowUrl";s:0:"";s:9:"className";s:0:"";s:8:"iconSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"iconAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"shadowSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:12:"shadowAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:11:"popupAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:4:"html";s:11:"<div></div>";s:10:"html_class";s:19:"leaflet-map-divicon";s:21:"circle_marker_options";s:65:"{"radius":100,"color":"red","fillColor":"#f03","fillOpacity":0.5}";}s:21:"leaflet_markercluster";a:4:{s:7:"control";b:0;s:7:"options";s:89:"{"spiderfyOnMaxZoom":true,"showCoverageOnHover":true,"removeOutsideVisibleBounds": false}";s:8:"excluded";s:0:"";s:12:"include_path";b:0;}s:10:"fullscreen";a:2:{s:7:"control";b:0;s:7:"options";s:47:"{"position":"topleft","pseudoFullscreen":false}";}s:4:"path";s:113:"{"color":"#3388ff","opacity":"1.0","stroke":true,"weight":3,"fill":"depends","fillColor":"*","fillOpacity":"0.2"}";s:18:"feature_properties";a:1:{s:6:"values";s:0:"";}s:8:"geocoder";a:2:{s:7:"control";b:0;s:8:"settings";a:8:{s:8:"position";s:8:"topright";s:10:"input_size";i:25;s:9:"providers";a:1:{s:20:"localgov_default_osm";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}}s:9:"min_terms";i:4;s:5:"delay";i:800;s:4:"zoom";i:16;s:5:"popup";b:0;s:7:"options";s:0:"";}}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:14:"postal_address";a:6:{s:4:"type";s:15:"address_default";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:11:"external_id";b:1;s:18:"search_api_excerpt";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.localgov_geo.area.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"507d2ccb-bd15-4d28-9d6a-2d8950273fa0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"field.field.localgov_geo.area.external_id";i:1;s:38:"field.field.localgov_geo.area.geo_file";i:2;s:38:"field.field.localgov_geo.area.location";i:3;s:35:"localgov_geo.localgov_geo_type.area";}s:6:"module";a:1:{i:0;s:7:"leaflet";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LTI_xdcWNS14joAJsWcvAMmAqHVWmS1IhCqSKrJP4nc";}s:2:"id";s:25:"localgov_geo.area.default";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:4:"area";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:8:"location";a:6:{s:4:"type";s:25:"leaflet_formatter_default";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:17:{s:12:"multiple_map";b:0;s:11:"leaflet_map";s:10:"OSM Mapnik";s:6:"height";i:400;s:11:"height_unit";s:2:"px";s:14:"hide_empty_map";b:0;s:13:"disable_wheel";b:0;s:16:"gesture_handling";b:0;s:9:"reset_map";a:2:{s:7:"control";b:0;s:8:"position";s:8:"topright";}s:5:"popup";b:0;s:13:"popup_content";s:0:"";s:12:"map_position";a:6:{s:5:"force";b:0;s:6:"center";a:2:{s:3:"lat";d:0;s:3:"lon";d:0;}s:4:"zoom";i:12;s:7:"minZoom";i:1;s:7:"maxZoom";i:18;s:9:"zoomFiner";i:0;}s:4:"icon";a:12:{s:8:"iconType";s:6:"marker";s:7:"iconUrl";s:0:"";s:9:"shadowUrl";s:0:"";s:9:"className";s:0:"";s:8:"iconSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"iconAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"shadowSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:12:"shadowAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:11:"popupAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:4:"html";s:11:"<div></div>";s:10:"html_class";s:19:"leaflet-map-divicon";s:21:"circle_marker_options";s:65:"{"radius":100,"color":"red","fillColor":"#f03","fillOpacity":0.5}";}s:21:"leaflet_markercluster";a:3:{s:7:"control";b:0;s:7:"options";s:89:"{"spiderfyOnMaxZoom":true,"showCoverageOnHover":true,"removeOutsideVisibleBounds": false}";s:12:"include_path";b:0;}s:10:"fullscreen";a:2:{s:7:"control";b:0;s:7:"options";s:47:"{"position":"topleft","pseudoFullscreen":false}";}s:4:"path";s:126:"{"color":"#3388ff","opacity":"1.0","stroke":true,"weight":3,"fill":"depends","fillColor":"*","fillOpacity":"0.2","radius":"6"}";s:8:"geocoder";a:2:{s:7:"control";b:0;s:8:"settings";a:8:{s:8:"position";s:8:"topright";s:10:"input_size";i:25;s:9:"providers";a:5:{s:4:"file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:8:"gpx_file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:12:"geojson_file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:8:"kml_file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:20:"localgov_default_osm";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}}s:9:"min_terms";i:4;s:5:"delay";i:800;s:4:"zoom";i:16;s:5:"popup";b:0;s:7:"options";s:0:"";}}s:6:"weight";N;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:6:{s:7:"created";b:1;s:11:"external_id";b:1;s:8:"geo_file";b:1;s:18:"search_api_excerpt";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.localgov_geo.area.embed',
  'data' => 'a:11:{s:4:"uuid";s:36:"54860996-affc-4d12-9e07-a59e9dfbb81c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:40:"core.entity_view_mode.localgov_geo.embed";i:1;s:41:"field.field.localgov_geo.area.external_id";i:2;s:38:"field.field.localgov_geo.area.geo_file";i:3;s:38:"field.field.localgov_geo.area.location";i:4;s:35:"localgov_geo.localgov_geo_type.area";}s:6:"module";a:1:{i:0;s:7:"leaflet";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hrUVJc3bi5YFS_cirLnWhH61NyrYeAeRuEA_DCj-6Zw";}s:2:"id";s:23:"localgov_geo.area.embed";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:4:"area";s:4:"mode";s:5:"embed";s:7:"content";a:1:{s:8:"location";a:6:{s:4:"type";s:25:"leaflet_formatter_default";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:17:{s:12:"multiple_map";b:0;s:11:"leaflet_map";s:10:"OSM Mapnik";s:6:"height";i:400;s:11:"height_unit";s:2:"px";s:14:"hide_empty_map";b:0;s:13:"disable_wheel";b:0;s:16:"gesture_handling";b:0;s:9:"reset_map";a:2:{s:7:"control";b:0;s:8:"position";s:8:"topright";}s:5:"popup";b:0;s:13:"popup_content";s:0:"";s:12:"map_position";a:6:{s:5:"force";b:0;s:6:"center";a:2:{s:3:"lat";d:0;s:3:"lon";d:0;}s:4:"zoom";i:12;s:7:"minZoom";i:1;s:7:"maxZoom";i:18;s:9:"zoomFiner";i:0;}s:4:"icon";a:12:{s:8:"iconType";s:6:"marker";s:7:"iconUrl";s:0:"";s:9:"shadowUrl";s:0:"";s:9:"className";s:0:"";s:8:"iconSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"iconAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"shadowSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:12:"shadowAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:11:"popupAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:4:"html";s:11:"<div></div>";s:10:"html_class";s:19:"leaflet-map-divicon";s:21:"circle_marker_options";s:65:"{"radius":100,"color":"red","fillColor":"#f03","fillOpacity":0.5}";}s:21:"leaflet_markercluster";a:3:{s:7:"control";b:0;s:7:"options";s:89:"{"spiderfyOnMaxZoom":true,"showCoverageOnHover":true,"removeOutsideVisibleBounds": false}";s:12:"include_path";b:0;}s:10:"fullscreen";a:2:{s:7:"control";b:0;s:7:"options";s:47:"{"position":"topleft","pseudoFullscreen":false}";}s:4:"path";s:126:"{"color":"#3388ff","opacity":"1.0","stroke":true,"weight":3,"fill":"depends","fillColor":"*","fillOpacity":"0.2","radius":"6"}";s:8:"geocoder";a:2:{s:7:"control";b:0;s:8:"settings";a:8:{s:8:"position";s:8:"topright";s:10:"input_size";i:25;s:9:"providers";a:5:{s:4:"file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:8:"gpx_file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:12:"geojson_file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:8:"kml_file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:20:"localgov_default_osm";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}}s:9:"min_terms";i:4;s:5:"delay";i:800;s:4:"zoom";i:16;s:5:"popup";b:0;s:7:"options";s:0:"";}}s:6:"weight";N;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:6:{s:7:"created";b:1;s:11:"external_id";b:1;s:8:"geo_file";b:1;s:18:"search_api_excerpt";b:1;s:6:"status";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.localgov_geo.area.full',
  'data' => 'a:11:{s:4:"uuid";s:36:"f73eefce-2e56-4320-82ea-ab4bb787c890";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:39:"core.entity_view_mode.localgov_geo.full";i:1;s:41:"field.field.localgov_geo.area.external_id";i:2;s:38:"field.field.localgov_geo.area.geo_file";i:3;s:38:"field.field.localgov_geo.area.location";i:4;s:35:"localgov_geo.localgov_geo_type.area";}s:6:"module";a:3:{i:0;s:4:"file";i:1;s:7:"leaflet";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UoRyrS6RgXpjP6u_pLGFqlkUthJ-B-NqKt0DKdiC9Fs";}s:2:"id";s:22:"localgov_geo.area.full";s:16:"targetEntityType";s:12:"localgov_geo";s:6:"bundle";s:4:"area";s:4:"mode";s:4:"full";s:7:"content";a:4:{s:7:"created";a:6:{s:4:"type";s:9:"timestamp";s:5:"label";s:5:"above";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:3;s:6:"region";s:7:"content";}s:8:"geo_file";a:6:{s:4:"type";s:12:"file_default";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:28:"use_description_as_link_text";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}s:8:"location";a:6:{s:4:"type";s:25:"leaflet_formatter_default";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:17:{s:12:"multiple_map";b:0;s:11:"leaflet_map";s:10:"OSM Mapnik";s:6:"height";i:400;s:11:"height_unit";s:2:"px";s:14:"hide_empty_map";b:0;s:13:"disable_wheel";b:0;s:16:"gesture_handling";b:0;s:9:"reset_map";a:2:{s:7:"control";b:0;s:8:"position";s:8:"topright";}s:5:"popup";b:0;s:13:"popup_content";s:0:"";s:12:"map_position";a:6:{s:5:"force";b:0;s:6:"center";a:2:{s:3:"lat";d:0;s:3:"lon";d:0;}s:4:"zoom";i:12;s:7:"minZoom";i:1;s:7:"maxZoom";i:18;s:9:"zoomFiner";i:0;}s:4:"icon";a:12:{s:8:"iconType";s:6:"marker";s:7:"iconUrl";s:0:"";s:9:"shadowUrl";s:0:"";s:9:"className";s:0:"";s:8:"iconSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"iconAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:10:"shadowSize";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:12:"shadowAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:11:"popupAnchor";a:2:{s:1:"x";s:0:"";s:1:"y";s:0:"";}s:4:"html";s:11:"<div></div>";s:10:"html_class";s:19:"leaflet-map-divicon";s:21:"circle_marker_options";s:65:"{"radius":100,"color":"red","fillColor":"#f03","fillOpacity":0.5}";}s:21:"leaflet_markercluster";a:3:{s:7:"control";b:0;s:7:"options";s:89:"{"spiderfyOnMaxZoom":true,"showCoverageOnHover":true,"removeOutsideVisibleBounds": false}";s:12:"include_path";b:0;}s:10:"fullscreen";a:2:{s:7:"control";b:0;s:7:"options";s:47:"{"position":"topleft","pseudoFullscreen":false}";}s:4:"path";s:126:"{"color":"#3388ff","opacity":"1.0","stroke":true,"weight":3,"fill":"depends","fillColor":"*","fillOpacity":"0.2","radius":"6"}";s:8:"geocoder";a:2:{s:7:"control";b:0;s:8:"settings";a:8:{s:8:"position";s:8:"topright";s:10:"input_size";i:25;s:9:"providers";a:5:{s:4:"file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:8:"gpx_file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:12:"geojson_file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:8:"kml_file";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}s:20:"localgov_default_osm";a:2:{s:6:"weight";i:0;s:7:"checked";b:0;}}s:9:"min_terms";i:4;s:5:"delay";i:800;s:4:"zoom";i:16;s:5:"popup";b:0;s:7:"options";s:0:"";}}s:6:"weight";N;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:3:"uid";a:6:{s:4:"type";s:6:"author";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:2;s:6:"region";s:7:"content";}}s:6:"hidden";a:3:{s:11:"external_id";b:1;s:18:"search_api_excerpt";b:1;s:6:"status";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.audio.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"835bdfd7-f54b-468a-849b-f38443dfdb3c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:46:"field.field.media.audio.field_media_audio_file";i:1;s:16:"media.type.audio";}s:6:"module";a:1:{i:0;s:4:"file";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AS765MdDfNpK6K5eE7WVnBvpynClz_havy1R3bO3gVo";}s:2:"id";s:19:"media.audio.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"audio";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:22:"field_media_audio_file";a:6:{s:4:"type";s:10:"file_audio";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:4:{s:8:"controls";b:1;s:8:"autoplay";b:0;s:4:"loop";b:0;s:26:"multiple_file_display_type";s:4:"tags";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.audio.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"230f1803-f6a4-4e48-82b0-714c48de33c9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:46:"field.field.media.audio.field_media_audio_file";i:2;s:21:"image.style.thumbnail";i:3;s:16:"media.type.audio";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tcAUW1Xzq5Tjw5jomR6XKGSgfiXO7QiRAHJBF-n0akg";}s:2:"id";s:25:"media.audio.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"audio";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:9:"thumbnail";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:22:"field_media_audio_file";b:1;s:4:"name";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.document.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"e2bad0fb-ab83-4f9b-a42a-37301b6d4ffe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:47:"field.field.media.document.field_media_document";i:1;s:19:"media.type.document";}s:6:"module";a:1:{i:0;s:4:"file";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"XxUyhaTuM0OUUZpr8G6jdrFBEh5eag7auWxBKhm6cvY";}s:2:"id";s:22:"media.document.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:8:"document";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:20:"field_media_document";a:6:{s:4:"type";s:12:"file_default";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.document.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"96cec1dd-62c3-483d-bf19-2ae624214458";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:47:"field.field.media.document.field_media_document";i:2;s:21:"image.style.thumbnail";i:3;s:19:"media.type.document";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YcWqjhIlo-2RZUM5ogvRsrKB7M3voF2XB3lVLwgOlLU";}s:2:"id";s:28:"media.document.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:8:"document";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:9:"thumbnail";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:20:"field_media_document";b:1;s:4:"name";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"4c081225-aff6-4890-89af-08607af491fb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:41:"field.field.media.image.field_media_image";i:1;s:17:"image.style.large";i:2;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"73xaTNkI5J6sfFcBmNYeuk070X3mQS_iwwWaPYyfG2M";}s:2:"id";s:19:"media.image.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:11:"image_style";s:5:"large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.localgov_event_thumbnail',
  'data' => 'a:11:{s:4:"uuid";s:36:"3fd6e567-57ed-4f44-a452-b3c4e822f79e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:52:"core.entity_view_mode.media.localgov_event_thumbnail";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:24:"image.style.square_small";i:3;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lCfFrqbeP-s9VRXJNadPdwsBSxYB-nUQXx59HPiFL9Y";}s:2:"id";s:36:"media.image.localgov_event_thumbnail";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:24:"localgov_event_thumbnail";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:12:"square_small";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:4:"type";s:5:"image";s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.localgov_featured',
  'data' => 'a:11:{s:4:"uuid";s:36:"300c9c4d-388b-481a-b8a7-bb5012ccac64";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:45:"core.entity_view_mode.media.localgov_featured";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:28:"image.style.localgov_248x181";i:3;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"GkoeYn6VJ61inD6BCoU0WUX8mMRh12BFO1VlnDhvydU";}s:2:"id";s:29:"media.image.localgov_featured";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:17:"localgov_featured";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:16:"localgov_248x181";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.localgov_featured_large',
  'data' => 'a:11:{s:4:"uuid";s:36:"f3995438-f9da-42af-b7c2-2fa3fa7b464c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:51:"core.entity_view_mode.media.localgov_featured_large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:50:"responsive_image.styles.localgov_newsroom_featured";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"GjyIlNlTLl7pREMUYgFschfFpDeED0612rnpzkqpmDg";}s:2:"id";s:35:"media.image.localgov_featured_large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:23:"localgov_featured_large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:22:"responsive_image_style";s:26:"localgov_newsroom_featured";s:10:"image_link";s:0:"";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.localgov_newsroom_teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"4ec43995-b02f-48c3-8bd3-814cd7015b98";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:52:"core.entity_view_mode.media.localgov_newsroom_teaser";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:36:"image.style.localgov_newsroom_teaser";i:3;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RMQihvlFgSbGtcZbdMcjN-T6fSCTa5tHgBVll1f1Tq4";}s:2:"id";s:36:"media.image.localgov_newsroom_teaser";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:24:"localgov_newsroom_teaser";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:24:"localgov_newsroom_teaser";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"735c4dad-6cf0-4d80-bf6c-e66bbeb9c188";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:18:"image.style.medium";i:3;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ILLWu5KFvbsX6J7sh2Itd4w8-lBBRhR_H8ZrmQiN2yo";}s:2:"id";s:25:"media.image.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:9:"thumbnail";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:17:"field_media_image";b:1;s:4:"name";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.medium_8_7',
  'data' => 'a:11:{s:4:"uuid";s:36:"b97e597d-0dc2-4dfb-b344-135a47e00fd8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.medium_8_7";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:22:"image.style.medium_8_7";i:3;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-WDYQ8IUZgPvYLpGMZvzAoN767rAZkg-n75hq9pGHhM";}s:2:"id";s:22:"media.image.medium_8_7";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:10:"medium_8_7";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:10:"medium_8_7";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.responsive_3x2',
  'data' => 'a:11:{s:4:"uuid";s:36:"980ea716-e43e-41ad-b20f-5b6594457779";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:42:"core.entity_view_mode.media.responsive_3x2";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.3_2_image";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0x9ujBx9o_Hh71LmTBxJUqJzV_qANf332ut4gRBtSd4";}s:2:"id";s:26:"media.image.responsive_3x2";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:14:"responsive_3x2";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:22:"responsive_image_style";s:9:"3_2_image";s:10:"image_link";s:0:"";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.responsive_banner',
  'data' => 'a:11:{s:4:"uuid";s:36:"aceff9dc-91d9-4b37-9e4f-105a0e0ad0e5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:45:"core.entity_view_mode.media.responsive_banner";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:35:"responsive_image.styles.banner_28_9";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"XnFMAgssl3TEiNIIseSkLL2gU0mu77yJfzThRkNxrPE";}s:2:"id";s:29:"media.image.responsive_banner";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:17:"responsive_banner";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:22:"responsive_image_style";s:11:"banner_28_9";s:10:"image_link";s:0:"";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.scale_crop_7_3_large',
  'data' => 'a:11:{s:4:"uuid";s:36:"de4735d2-4139-435f-8033-7bae1f504a88";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:48:"core.entity_view_mode.media.scale_crop_7_3_large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:32:"image.style.scale_crop_7_3_large";i:3;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pAgM_wVibvWsLMe04cxb1erllsapd3xnF5ucC8drz64";}s:2:"id";s:32:"media.image.scale_crop_7_3_large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:20:"scale_crop_7_3_large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:20:"scale_crop_7_3_large";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.image.square',
  'data' => 'a:11:{s:4:"uuid";s:36:"766dfbfc-4725-4a01-9a4e-6bb1d9c332cd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:34:"core.entity_view_mode.media.square";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:30:"responsive_image.styles.square";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TisoF4_HfuXR8TbdXjnOobu_bEURKxgm_9m0FRqtj9E";}s:2:"id";s:18:"media.image.square";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:6:"square";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:22:"responsive_image_style";s:6:"square";s:10:"image_link";s:0:"";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.remote_video.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"df286224-1f4c-4503-a139-174bfe1207cd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:55:"field.field.media.remote_video.field_media_oembed_video";i:1;s:23:"media.type.remote_video";}s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zQoBQ0BtnMM_rlDdgftyu6eI4AVs9mo5K8xq7NFO2Zc";}s:2:"id";s:26:"media.remote_video.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:24:"field_media_oembed_video";a:6:{s:4:"type";s:6:"oembed";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"max_width";i:0;s:10:"max_height";i:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.remote_video.full',
  'data' => 'a:11:{s:4:"uuid";s:36:"2fa07fac-c04f-4c0f-a9fe-8b0acc05e667";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:32:"core.entity_view_mode.media.full";i:1;s:55:"field.field.media.remote_video.field_media_oembed_video";i:2;s:23:"media.type.remote_video";}s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TuGwbrYbT19Rf1w1Sm9JCbTxHeeqENjvQxByf13lIpY";}s:2:"id";s:23:"media.remote_video.full";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:4:"full";s:7:"content";a:1:{s:24:"field_media_oembed_video";a:6:{s:4:"type";s:6:"oembed";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"max_width";i:1600;s:10:"max_height";i:1200;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:7:"created";b:1;s:4:"name";b:1;s:18:"search_api_excerpt";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.remote_video.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"0f7d39c2-3127-4b16-8133-f0fb48bbbd5e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:55:"field.field.media.remote_video.field_media_oembed_video";i:2;s:18:"image.style.medium";i:3;s:23:"media.type.remote_video";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PGGoP-hVkXe_S-GiJRAub4PHDu0KhMExylclrqjdJb4";}s:2:"id";s:32:"media.remote_video.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:9:"thumbnail";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:24:"field_media_oembed_video";b:1;s:4:"name";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.video.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"a5ac11ca-e7c0-4903-99d7-d07b3cb96980";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:46:"field.field.media.video.field_media_video_file";i:1;s:16:"media.type.video";}s:6:"module";a:1:{i:0;s:4:"file";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SxvbuGh-6cQMxl9bBV27-hGI46u7ZvwlMm5ObaJMNnw";}s:2:"id";s:19:"media.video.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"video";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:22:"field_media_video_file";a:6:{s:4:"type";s:10:"file_video";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:7:{s:8:"controls";b:1;s:8:"autoplay";b:0;s:4:"loop";b:0;s:26:"multiple_file_display_type";s:4:"tags";s:5:"muted";b:0;s:5:"width";i:640;s:6:"height";i:480;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.media.video.media_library',
  'data' => 'a:11:{s:4:"uuid";s:36:"aeb1a23f-02c2-4a4e-8aea-0bd1bc5f702a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:46:"field.field.media.video.field_media_video_file";i:2;s:21:"image.style.thumbnail";i:3;s:16:"media.type.video";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_fnkUKwQYHkXO1Ngmq9nE6FqWUNAmkddOxAH1h5aiKg";}s:2:"id";s:25:"media.video.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"video";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:9:"thumbnail";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:22:"field_media_video_file";b:1;s:4:"name";b:1;s:3:"uid";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"3942cbc0-8682-4547-a54a-2eda48a1d4da";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:48:"core.entity_view_display.comment.comment.default";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:16:"image.style.wide";i:6;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"text";i:3;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7fb0j9HnIXfP9ndewzgPPzzeX_SV532wuYpkscrCMCk";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:7:"comment";a:6:{s:4:"type";s:15:"comment_default";s:5:"label";s:5:"above";s:8:"settings";a:2:{s:9:"view_mode";s:7:"default";s:8:"pager_id";i:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:110;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:4:"wide";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.rss',
  'data' => 'a:11:{s:4:"uuid";s:36:"d517e4f2-9e29-471a-af6e-26fca360ce3d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2rIr6K5Q0UQ9khg0zE_CK-PtJH76UL-BDDZcZnZzwCc";}s:2:"id";s:16:"node.article.rss";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:3:"rss";s:7:"content";a:1:{s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:4:"body";b:1;s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.article.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"d05abbcd-56b5-4953-8ff5-ccf4e737c25a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:18:"image.style.medium";i:6;s:17:"node.type.article";}s:6:"module";a:3:{i:0;s:5:"image";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"83jX5ChAGdMzOxiDA_B1NjgebVMuD8lNVDgClg_QVP8";}s:2:"id";s:19:"node.article.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:6:"teaser";s:7:"content";a:4:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:3:{s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_directories_venue.default',
  'data' => 'a:12:{s:4:"uuid";s:36:"a7cb987f-9f6a-4ca4-a5ea-aeb875e14405";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:14:{i:0;s:48:"field.field.node.localgov_directories_venue.body";i:1;s:71:"field.field.node.localgov_directories_venue.localgov_directory_channels";i:2;s:68:"field.field.node.localgov_directories_venue.localgov_directory_email";i:3;s:76:"field.field.node.localgov_directories_venue.localgov_directory_facets_select";i:4;s:68:"field.field.node.localgov_directories_venue.localgov_directory_files";i:5;s:72:"field.field.node.localgov_directories_venue.localgov_directory_job_title";i:6;s:67:"field.field.node.localgov_directories_venue.localgov_directory_name";i:7;s:68:"field.field.node.localgov_directories_venue.localgov_directory_notes";i:8;s:76:"field.field.node.localgov_directories_venue.localgov_directory_opening_times";i:9;s:68:"field.field.node.localgov_directories_venue.localgov_directory_phone";i:10;s:73:"field.field.node.localgov_directories_venue.localgov_directory_title_sort";i:11;s:70:"field.field.node.localgov_directories_venue.localgov_directory_website";i:12;s:61:"field.field.node.localgov_directories_venue.localgov_location";i:13;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:5:{i:0;s:11:"field_group";i:1;s:4:"link";i:2;s:9:"telephone";i:3;s:4:"text";i:4;s:4:"user";}}s:20:"third_party_settings";a:1:{s:11:"field_group";a:2:{s:15:"group_enquiries";a:7:{s:8:"children";a:5:{i:0;s:23:"localgov_directory_name";i:1;s:28:"localgov_directory_job_title";i:2;s:24:"localgov_directory_phone";i:3;s:24:"localgov_directory_email";i:4;s:26:"localgov_directory_website";}s:11:"parent_name";s:0:"";s:6:"weight";i:3;s:11:"format_type";s:8:"fieldset";s:6:"region";s:7:"content";s:15:"format_settings";a:3:{s:2:"id";s:0:"";s:7:"classes";s:0:"";s:11:"description";s:0:"";}s:5:"label";s:9:"Enquiries";}s:11:"group_venue";a:7:{s:8:"children";a:3:{i:0;s:17:"localgov_location";i:1;s:32:"localgov_directory_opening_times";i:2;s:24:"localgov_directory_notes";}s:11:"parent_name";s:0:"";s:6:"weight";i:2;s:11:"format_type";s:8:"fieldset";s:6:"region";s:7:"content";s:15:"format_settings";a:3:{s:2:"id";s:0:"";s:7:"classes";s:0:"";s:11:"description";s:0:"";}s:5:"label";s:5:"Venue";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QSk3UiE5Jz66Zf3hqjzQg5MVD3USfMDnTeSU1W1KWmk";}s:2:"id";s:39:"node.localgov_directories_venue.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:4:"mode";s:7:"default";s:7:"content";a:10:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"region";s:7:"content";}s:24:"localgov_directory_email";a:6:{s:6:"weight";i:8;s:5:"label";s:6:"inline";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:12:"basic_string";s:6:"region";s:7:"content";}s:24:"localgov_directory_files";a:6:{s:6:"weight";i:1;s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:4:"type";s:22:"entity_reference_label";s:6:"region";s:7:"content";}s:28:"localgov_directory_job_title";a:6:{s:6:"weight";i:6;s:5:"label";s:6:"inline";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:4:"type";s:6:"string";s:6:"region";s:7:"content";}s:23:"localgov_directory_name";a:6:{s:6:"weight";i:4;s:5:"label";s:6:"inline";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:4:"type";s:6:"string";s:6:"region";s:7:"content";}s:24:"localgov_directory_notes";a:6:{s:6:"weight";i:4;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:12:"text_default";s:6:"region";s:7:"content";}s:32:"localgov_directory_opening_times";a:6:{s:6:"weight";i:3;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:12:"text_default";s:6:"region";s:7:"content";}s:24:"localgov_directory_phone";a:6:{s:6:"weight";i:7;s:5:"label";s:6:"inline";s:8:"settings";a:1:{s:5:"title";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:14:"telephone_link";s:6:"region";s:7:"content";}s:26:"localgov_directory_website";a:6:{s:6:"weight";i:9;s:5:"label";s:5:"above";s:8:"settings";a:5:{s:11:"trim_length";i:80;s:8:"url_only";b:0;s:9:"url_plain";b:0;s:3:"rel";s:0:"";s:6:"target";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:4:"link";s:6:"region";s:7:"content";}s:17:"localgov_location";a:6:{s:6:"weight";i:2;s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"view_mode";s:5:"embed";s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:4:"type";s:28:"entity_reference_entity_view";s:6:"region";s:7:"content";}}s:6:"hidden";a:6:{s:5:"links";b:1;s:27:"localgov_directory_channels";b:1;s:32:"localgov_directory_facets_select";b:1;s:25:"localgov_directory_search";b:1;s:29:"localgov_directory_title_sort";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_directories_venue.directory_index',
  'data' => 'a:11:{s:4:"uuid";s:36:"b01b7baf-b14d-4054-b598-66dd5cd10dea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:15:{i:0;s:42:"core.entity_view_mode.node.directory_index";i:1;s:48:"field.field.node.localgov_directories_venue.body";i:2;s:71:"field.field.node.localgov_directories_venue.localgov_directory_channels";i:3;s:68:"field.field.node.localgov_directories_venue.localgov_directory_email";i:4;s:76:"field.field.node.localgov_directories_venue.localgov_directory_facets_select";i:5;s:68:"field.field.node.localgov_directories_venue.localgov_directory_files";i:6;s:72:"field.field.node.localgov_directories_venue.localgov_directory_job_title";i:7;s:67:"field.field.node.localgov_directories_venue.localgov_directory_name";i:8;s:68:"field.field.node.localgov_directories_venue.localgov_directory_notes";i:9;s:76:"field.field.node.localgov_directories_venue.localgov_directory_opening_times";i:10;s:68:"field.field.node.localgov_directories_venue.localgov_directory_phone";i:11;s:73:"field.field.node.localgov_directories_venue.localgov_directory_title_sort";i:12;s:70:"field.field.node.localgov_directories_venue.localgov_directory_website";i:13;s:61:"field.field.node.localgov_directories_venue.localgov_location";i:14;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:3:{i:0;s:4:"link";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zgl9nFjdizo4bsh2pzzNImNh5Pox0y2FHklW_RotFj8";}s:2:"id";s:47:"node.localgov_directories_venue.directory_index";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:4:"mode";s:15:"directory_index";s:7:"content";a:13:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:1;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"region";s:7:"content";}s:5:"links";a:4:{s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:27:"localgov_directory_channels";a:6:{s:6:"weight";i:3;s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:4:"type";s:22:"entity_reference_label";s:6:"region";s:7:"content";}s:24:"localgov_directory_email";a:6:{s:4:"type";s:12:"basic_string";s:6:"weight";i:4;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:32:"localgov_directory_facets_select";a:6:{s:6:"weight";i:2;s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:4:"type";s:22:"entity_reference_label";s:6:"region";s:7:"content";}s:24:"localgov_directory_files";a:6:{s:4:"type";s:22:"entity_reference_label";s:6:"weight";i:6;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}}s:28:"localgov_directory_job_title";a:6:{s:4:"type";s:6:"string";s:6:"weight";i:5;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}}s:23:"localgov_directory_name";a:6:{s:4:"type";s:6:"string";s:6:"weight";i:7;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}}s:24:"localgov_directory_notes";a:6:{s:4:"type";s:12:"text_default";s:6:"weight";i:8;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:32:"localgov_directory_opening_times";a:6:{s:4:"type";s:12:"text_default";s:6:"weight";i:9;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:24:"localgov_directory_phone";a:6:{s:4:"type";s:6:"string";s:6:"weight";i:11;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}}s:26:"localgov_directory_website";a:6:{s:4:"type";s:13:"link_separate";s:6:"weight";i:10;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:5:{s:11:"trim_length";i:80;s:8:"url_only";b:0;s:9:"url_plain";b:0;s:3:"rel";s:0:"";s:6:"target";s:0:"";}s:20:"third_party_settings";a:0:{}}s:17:"localgov_location";a:6:{s:6:"weight";i:12;s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:4:"link";b:1;s:9:"view_mode";s:7:"default";}s:20:"third_party_settings";a:0:{}s:4:"type";s:28:"entity_reference_entity_view";s:6:"region";s:7:"content";}}s:6:"hidden";a:3:{s:25:"localgov_directory_search";b:1;s:29:"localgov_directory_title_sort";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_directories_venue.search_index',
  'data' => 'a:11:{s:4:"uuid";s:36:"60e0240f-84ff-4594-bb97-63a93872034c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:15:{i:0;s:39:"core.entity_view_mode.node.search_index";i:1;s:48:"field.field.node.localgov_directories_venue.body";i:2;s:71:"field.field.node.localgov_directories_venue.localgov_directory_channels";i:3;s:68:"field.field.node.localgov_directories_venue.localgov_directory_email";i:4;s:76:"field.field.node.localgov_directories_venue.localgov_directory_facets_select";i:5;s:68:"field.field.node.localgov_directories_venue.localgov_directory_files";i:6;s:72:"field.field.node.localgov_directories_venue.localgov_directory_job_title";i:7;s:67:"field.field.node.localgov_directories_venue.localgov_directory_name";i:8;s:68:"field.field.node.localgov_directories_venue.localgov_directory_notes";i:9;s:76:"field.field.node.localgov_directories_venue.localgov_directory_opening_times";i:10;s:68:"field.field.node.localgov_directories_venue.localgov_directory_phone";i:11;s:73:"field.field.node.localgov_directories_venue.localgov_directory_title_sort";i:12;s:70:"field.field.node.localgov_directories_venue.localgov_directory_website";i:13;s:61:"field.field.node.localgov_directories_venue.localgov_location";i:14;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:4:{i:0;s:4:"link";i:1;s:9:"telephone";i:2;s:4:"text";i:3;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0qpNGm020DGftmq_aAvjyVsKyOYaLJAm9Ofgebea9a0";}s:2:"id";s:44:"node.localgov_directories_venue.search_index";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:4:"mode";s:12:"search_index";s:7:"content";a:11:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"region";s:7:"content";}s:27:"localgov_directory_channels";a:6:{s:4:"type";s:22:"entity_reference_label";s:6:"weight";i:10;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}}s:24:"localgov_directory_email";a:6:{s:6:"weight";i:8;s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:12:"basic_string";s:6:"region";s:7:"content";}s:24:"localgov_directory_files";a:6:{s:6:"weight";i:1;s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:4:"type";s:22:"entity_reference_label";s:6:"region";s:7:"content";}s:28:"localgov_directory_job_title";a:6:{s:6:"weight";i:6;s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:4:"type";s:6:"string";s:6:"region";s:7:"content";}s:23:"localgov_directory_name";a:6:{s:6:"weight";i:4;s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:4:"type";s:6:"string";s:6:"region";s:7:"content";}s:24:"localgov_directory_notes";a:6:{s:6:"weight";i:5;s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:12:"text_default";s:6:"region";s:7:"content";}s:32:"localgov_directory_opening_times";a:6:{s:6:"weight";i:3;s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:4:"type";s:12:"text_default";s:6:"region";s:7:"content";}s:24:"localgov_directory_phone";a:6:{s:6:"weight";i:7;s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:5:"title";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:14:"telephone_link";s:6:"region";s:7:"content";}s:26:"localgov_directory_website";a:6:{s:6:"weight";i:9;s:5:"label";s:6:"hidden";s:8:"settings";a:5:{s:11:"trim_length";i:80;s:8:"url_only";b:0;s:9:"url_plain";b:0;s:3:"rel";s:0:"";s:6:"target";s:0:"";}s:20:"third_party_settings";a:0:{}s:4:"type";s:4:"link";s:6:"region";s:7:"content";}s:17:"localgov_location";a:6:{s:6:"weight";i:2;s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"view_mode";s:7:"default";s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:4:"type";s:28:"entity_reference_entity_view";s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:5:"links";b:1;s:32:"localgov_directory_facets_select";b:1;s:25:"localgov_directory_search";b:1;s:29:"localgov_directory_title_sort";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_directories_venue.search_result',
  'data' => 'a:12:{s:4:"uuid";s:36:"212d73c9-e1ab-466e-9e1f-02995bca7ea1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:15:{i:0;s:40:"core.entity_view_mode.node.search_result";i:1;s:48:"field.field.node.localgov_directories_venue.body";i:2;s:71:"field.field.node.localgov_directories_venue.localgov_directory_channels";i:3;s:68:"field.field.node.localgov_directories_venue.localgov_directory_email";i:4;s:76:"field.field.node.localgov_directories_venue.localgov_directory_facets_select";i:5;s:68:"field.field.node.localgov_directories_venue.localgov_directory_files";i:6;s:72:"field.field.node.localgov_directories_venue.localgov_directory_job_title";i:7;s:67:"field.field.node.localgov_directories_venue.localgov_directory_name";i:8;s:68:"field.field.node.localgov_directories_venue.localgov_directory_notes";i:9;s:76:"field.field.node.localgov_directories_venue.localgov_directory_opening_times";i:10;s:68:"field.field.node.localgov_directories_venue.localgov_directory_phone";i:11;s:73:"field.field.node.localgov_directories_venue.localgov_directory_title_sort";i:12;s:70:"field.field.node.localgov_directories_venue.localgov_directory_website";i:13;s:61:"field.field.node.localgov_directories_venue.localgov_location";i:14;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:2:{i:0;s:11:"field_group";i:1;s:4:"user";}}s:20:"third_party_settings";a:1:{s:11:"field_group";a:2:{s:15:"group_enquiries";a:7:{s:8:"children";a:5:{i:0;s:23:"localgov_directory_name";i:1;s:28:"localgov_directory_job_title";i:2;s:24:"localgov_directory_phone";i:3;s:24:"localgov_directory_email";i:4;s:26:"localgov_directory_website";}s:5:"label";s:9:"Enquiries";s:11:"parent_name";s:0:"";s:6:"region";s:6:"hidden";s:6:"weight";i:6;s:11:"format_type";s:8:"fieldset";s:15:"format_settings";a:3:{s:7:"classes";s:0:"";s:2:"id";s:0:"";s:11:"description";s:0:"";}}s:11:"group_venue";a:7:{s:8:"children";a:3:{i:0;s:17:"localgov_location";i:1;s:32:"localgov_directory_opening_times";i:2;s:24:"localgov_directory_notes";}s:5:"label";s:5:"Venue";s:11:"parent_name";s:0:"";s:6:"region";s:6:"hidden";s:6:"weight";i:5;s:11:"format_type";s:8:"fieldset";s:15:"format_settings";a:3:{s:7:"classes";s:0:"";s:2:"id";s:0:"";s:11:"description";s:0:"";}}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6s6wTQVMpgplagvJtlpqqi2aC0-zAWRzT5h7Fh40XlU";}s:2:"id";s:45:"node.localgov_directories_venue.search_result";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:4:"mode";s:13:"search_result";s:7:"content";a:1:{s:18:"search_api_excerpt";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:16:{s:4:"body";b:1;s:26:"content_moderation_control";b:1;s:5:"links";b:1;s:27:"localgov_directory_channels";b:1;s:24:"localgov_directory_email";b:1;s:32:"localgov_directory_facets_select";b:1;s:24:"localgov_directory_files";b:1;s:28:"localgov_directory_job_title";b:1;s:23:"localgov_directory_name";b:1;s:24:"localgov_directory_notes";b:1;s:32:"localgov_directory_opening_times";b:1;s:24:"localgov_directory_phone";b:1;s:25:"localgov_directory_search";b:1;s:29:"localgov_directory_title_sort";b:1;s:26:"localgov_directory_website";b:1;s:17:"localgov_location";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_directories_venue.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"19c51549-8adb-49a4-a1e9-68dc9221f2ee";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:15:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:48:"field.field.node.localgov_directories_venue.body";i:2;s:71:"field.field.node.localgov_directories_venue.localgov_directory_channels";i:3;s:68:"field.field.node.localgov_directories_venue.localgov_directory_email";i:4;s:76:"field.field.node.localgov_directories_venue.localgov_directory_facets_select";i:5;s:68:"field.field.node.localgov_directories_venue.localgov_directory_files";i:6;s:72:"field.field.node.localgov_directories_venue.localgov_directory_job_title";i:7;s:67:"field.field.node.localgov_directories_venue.localgov_directory_name";i:8;s:68:"field.field.node.localgov_directories_venue.localgov_directory_notes";i:9;s:76:"field.field.node.localgov_directories_venue.localgov_directory_opening_times";i:10;s:68:"field.field.node.localgov_directories_venue.localgov_directory_phone";i:11;s:73:"field.field.node.localgov_directories_venue.localgov_directory_title_sort";i:12;s:70:"field.field.node.localgov_directories_venue.localgov_directory_website";i:13;s:61:"field.field.node.localgov_directories_venue.localgov_location";i:14;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uudmI0u_vlkH1dMWxDYCikqAFMfJj1pZjPQ404i_dts";}s:2:"id";s:38:"node.localgov_directories_venue.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:4:"mode";s:6:"teaser";s:7:"content";a:1:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:6:"weight";i:0;s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"region";s:7:"content";}}s:6:"hidden";a:15:{s:5:"links";b:1;s:27:"localgov_directory_channels";b:1;s:24:"localgov_directory_email";b:1;s:32:"localgov_directory_facets_select";b:1;s:24:"localgov_directory_files";b:1;s:28:"localgov_directory_job_title";b:1;s:23:"localgov_directory_name";b:1;s:24:"localgov_directory_notes";b:1;s:32:"localgov_directory_opening_times";b:1;s:24:"localgov_directory_phone";b:1;s:25:"localgov_directory_search";b:1;s:29:"localgov_directory_title_sort";b:1;s:26:"localgov_directory_website";b:1;s:17:"localgov_location";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_directory.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"4d5d3dbd-95a5-4d66-ba00-f5762fc6a092";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:40:"field.field.node.localgov_directory.body";i:1;s:68:"field.field.node.localgov_directory.localgov_directory_channel_types";i:2;s:68:"field.field.node.localgov_directory.localgov_directory_facets_enable";i:3;s:28:"node.type.localgov_directory";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"47ht0JK7dizMS7L0unPWEF5VFpgs-I1VM-JFu4UY1u4";}s:2:"id";s:31:"node.localgov_directory.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:18:"localgov_directory";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"region";s:7:"content";}s:23:"localgov_directory_view";a:4:{s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:6:{s:5:"links";b:1;s:32:"localgov_directory_channel_types";b:1;s:25:"localgov_directory_facets";b:1;s:32:"localgov_directory_facets_enable";b:1;s:35:"localgov_directory_view_with_search";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_directory.search_index',
  'data' => 'a:11:{s:4:"uuid";s:36:"143f8460-5057-46b2-bb87-541dd79572b0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:39:"core.entity_view_mode.node.search_index";i:1;s:40:"field.field.node.localgov_directory.body";i:2;s:68:"field.field.node.localgov_directory.localgov_directory_channel_types";i:3;s:68:"field.field.node.localgov_directory.localgov_directory_facets_enable";i:4;s:28:"node.type.localgov_directory";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EgiUZ_nhGCpm3oQ3xWIEQPfdAkL1vqQFvAgpwhADBAk";}s:2:"id";s:36:"node.localgov_directory.search_index";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:18:"localgov_directory";s:4:"mode";s:12:"search_index";s:7:"content";a:3:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"region";s:7:"content";}s:32:"localgov_directory_facets_enable";a:6:{s:4:"type";s:22:"entity_reference_label";s:6:"weight";i:1;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}}s:24:"localgov_services_parent";a:6:{s:4:"type";s:22:"entity_reference_label";s:6:"weight";i:2;s:6:"region";s:7:"content";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:7:{s:5:"links";b:1;s:32:"localgov_directory_channel_types";b:1;s:25:"localgov_directory_facets";b:1;s:22:"localgov_directory_map";b:1;s:23:"localgov_directory_view";b:1;s:35:"localgov_directory_view_with_search";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_directory.search_result',
  'data' => 'a:11:{s:4:"uuid";s:36:"0b36f6e6-0f35-46e0-9824-f4e91a4eac12";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:40:"core.entity_view_mode.node.search_result";i:1;s:40:"field.field.node.localgov_directory.body";i:2;s:68:"field.field.node.localgov_directory.localgov_directory_channel_types";i:3;s:68:"field.field.node.localgov_directory.localgov_directory_facets_enable";i:4;s:28:"node.type.localgov_directory";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mb2ryiUF-eT7GTiCmGpe23iRVpvS070lE3hA-HhiknM";}s:2:"id";s:37:"node.localgov_directory.search_result";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:18:"localgov_directory";s:4:"mode";s:13:"search_result";s:7:"content";a:1:{s:18:"search_api_excerpt";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:10:{s:4:"body";b:1;s:26:"content_moderation_control";b:1;s:5:"links";b:1;s:32:"localgov_directory_channel_types";b:1;s:25:"localgov_directory_facets";b:1;s:32:"localgov_directory_facets_enable";b:1;s:22:"localgov_directory_map";b:1;s:23:"localgov_directory_view";b:1;s:35:"localgov_directory_view_with_search";b:1;s:24:"localgov_services_parent";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_directory.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"f2b8a677-631f-46ec-a002-c366ffa74415";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:40:"field.field.node.localgov_directory.body";i:2;s:68:"field.field.node.localgov_directory.localgov_directory_channel_types";i:3;s:68:"field.field.node.localgov_directory.localgov_directory_facets_enable";i:4;s:28:"node.type.localgov_directory";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7tjD0unwyjxdvD9RezuFZPSEf9M8ue6CAA9aa5sT-jU";}s:2:"id";s:30:"node.localgov_directory.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:18:"localgov_directory";s:4:"mode";s:6:"teaser";s:7:"content";a:1:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:6:"weight";i:0;s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"region";s:7:"content";}}s:6:"hidden";a:8:{s:5:"links";b:1;s:32:"localgov_directory_channel_types";b:1;s:25:"localgov_directory_facets";b:1;s:32:"localgov_directory_facets_enable";b:1;s:22:"localgov_directory_map";b:1;s:23:"localgov_directory_view";b:1;s:35:"localgov_directory_view_with_search";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_event.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"f587afbe-70d6-426b-a310-c217e36d62b6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:12:{i:0;s:41:"core.date_format.localgov_event_date_full";i:1;s:41:"core.date_format.localgov_event_date_hour";i:2;s:36:"field.field.node.localgov_event.body";i:3;s:61:"field.field.node.localgov_event.localgov_event_call_to_action";i:4;s:57:"field.field.node.localgov_event.localgov_event_categories";i:5;s:51:"field.field.node.localgov_event.localgov_event_date";i:6;s:52:"field.field.node.localgov_event.localgov_event_image";i:7;s:55:"field.field.node.localgov_event.localgov_event_locality";i:8;s:55:"field.field.node.localgov_event.localgov_event_location";i:9;s:52:"field.field.node.localgov_event.localgov_event_price";i:10;s:52:"field.field.node.localgov_event.localgov_event_venue";i:11;s:24:"node.type.localgov_event";}s:6:"module";a:4:{i:0;s:10:"date_recur";i:1;s:4:"link";i:2;s:4:"text";i:3;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZidxXfdXmkSCEcxtHbLaPne28S4d3CnKsB-tmG57yc0";}s:2:"id";s:27:"node.localgov_event.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:4:"mode";s:7:"default";s:7:"content";a:7:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:3;s:6:"region";s:7:"content";}s:29:"localgov_event_call_to_action";a:6:{s:4:"type";s:4:"link";s:5:"label";s:6:"hidden";s:8:"settings";a:5:{s:11:"trim_length";N;s:8:"url_only";b:0;s:9:"url_plain";b:0;s:3:"rel";s:1:"0";s:6:"target";s:1:"0";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:2;s:6:"region";s:7:"content";}s:19:"localgov_event_date";a:6:{s:4:"type";s:26:"date_recur_basic_formatter";s:5:"label";s:6:"hidden";s:8:"settings";a:8:{s:17:"timezone_override";s:0:"";s:11:"format_type";s:24:"localgov_event_date_full";s:9:"separator";s:2:"to";s:9:"show_next";i:10;s:14:"count_per_item";b:0;s:22:"occurrence_format_type";s:24:"localgov_event_date_full";s:25:"same_end_date_format_type";s:24:"localgov_event_date_hour";s:11:"interpreter";s:0:"";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}s:20:"localgov_event_image";a:6:{s:4:"type";s:28:"entity_reference_entity_view";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"view_mode";s:20:"scale_crop_7_3_large";s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:23:"localgov_event_location";a:6:{s:4:"type";s:28:"entity_reference_entity_view";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"view_mode";s:5:"embed";s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:6;s:6:"region";s:7:"content";}s:23:"localgov_event_provider";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:6:"inline";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:4;s:6:"region";s:7:"content";}s:20:"localgov_event_venue";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:6:"inline";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:5;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:5:"links";b:1;s:25:"localgov_event_categories";b:1;s:23:"localgov_event_locality";b:1;s:20:"localgov_event_price";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_event.search_index',
  'data' => 'a:11:{s:4:"uuid";s:36:"1bf00f70-9b70-498b-b3cc-455027fb55f7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:11:{i:0;s:39:"core.entity_view_mode.node.search_index";i:1;s:36:"field.field.node.localgov_event.body";i:2;s:61:"field.field.node.localgov_event.localgov_event_call_to_action";i:3;s:57:"field.field.node.localgov_event.localgov_event_categories";i:4;s:51:"field.field.node.localgov_event.localgov_event_date";i:5;s:52:"field.field.node.localgov_event.localgov_event_image";i:6;s:55:"field.field.node.localgov_event.localgov_event_locality";i:7;s:55:"field.field.node.localgov_event.localgov_event_location";i:8;s:52:"field.field.node.localgov_event.localgov_event_price";i:9;s:52:"field.field.node.localgov_event.localgov_event_venue";i:10;s:24:"node.type.localgov_event";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gmxnpyJ0GYXVPzUqVsFwBm2Fl_BKsKOrQbcbulLoNC4";}s:2:"id";s:32:"node.localgov_event.search_index";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:4:"mode";s:12:"search_index";s:7:"content";a:1:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:10:{s:5:"links";b:1;s:29:"localgov_event_call_to_action";b:1;s:25:"localgov_event_categories";b:1;s:19:"localgov_event_date";b:1;s:20:"localgov_event_image";b:1;s:23:"localgov_event_locality";b:1;s:23:"localgov_event_location";b:1;s:20:"localgov_event_price";b:1;s:20:"localgov_event_venue";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_event.search_result',
  'data' => 'a:11:{s:4:"uuid";s:36:"d355da0c-dfbb-494f-b507-ef08e9d2f3ce";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:11:{i:0;s:40:"core.entity_view_mode.node.search_result";i:1;s:36:"field.field.node.localgov_event.body";i:2;s:61:"field.field.node.localgov_event.localgov_event_call_to_action";i:3;s:57:"field.field.node.localgov_event.localgov_event_categories";i:4;s:51:"field.field.node.localgov_event.localgov_event_date";i:5;s:52:"field.field.node.localgov_event.localgov_event_image";i:6;s:55:"field.field.node.localgov_event.localgov_event_locality";i:7;s:55:"field.field.node.localgov_event.localgov_event_location";i:8;s:52:"field.field.node.localgov_event.localgov_event_price";i:9;s:52:"field.field.node.localgov_event.localgov_event_venue";i:10;s:24:"node.type.localgov_event";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sfzseaYy33PNKIW4YnGL8HcFWGB-bcKsfwYvPT3Sa7Y";}s:2:"id";s:33:"node.localgov_event.search_result";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:4:"mode";s:13:"search_result";s:7:"content";a:1:{s:18:"search_api_excerpt";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:12:{s:4:"body";b:1;s:26:"content_moderation_control";b:1;s:5:"links";b:1;s:29:"localgov_event_call_to_action";b:1;s:25:"localgov_event_categories";b:1;s:19:"localgov_event_date";b:1;s:20:"localgov_event_image";b:1;s:23:"localgov_event_locality";b:1;s:23:"localgov_event_location";b:1;s:20:"localgov_event_price";b:1;s:23:"localgov_event_provider";b:1;s:20:"localgov_event_venue";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.localgov_event.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"8145750d-5523-4500-8544-90b1c31e7069";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:13:{i:0;s:41:"core.date_format.localgov_event_date_full";i:1;s:41:"core.date_format.localgov_event_date_hour";i:2;s:33:"core.entity_view_mode.node.teaser";i:3;s:36:"field.field.node.localgov_event.body";i:4;s:61:"field.field.node.localgov_event.localgov_event_call_to_action";i:5;s:57:"field.field.node.localgov_event.localgov_event_categories";i:6;s:51:"field.field.node.localgov_event.localgov_event_date";i:7;s:52:"field.field.node.localgov_event.localgov_event_image";i:8;s:55:"field.field.node.localgov_event.localgov_event_locality";i:9;s:55:"field.field.node.localgov_event.localgov_event_location";i:10;s:52:"field.field.node.localgov_event.localgov_event_price";i:11;s:52:"field.field.node.localgov_event.localgov_event_venue";i:12;s:24:"node.type.localgov_event";}s:6:"module";a:3:{i:0;s:10:"date_recur";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ydJMWGHVgdJTIj4omnGi9gjq3FKP91_e3K8YQkBlNCo";}s:2:"id";s:26:"node.localgov_event.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:4:"mode";s:6:"teaser";s:7:"content";a:3:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:2;s:6:"region";s:7:"content";}s:19:"localgov_event_date";a:6:{s:4:"type";s:26:"date_recur_basic_formatter";s:5:"label";s:6:"hidden";s:8:"settings";a:8:{s:17:"timezone_override";s:0:"";s:11:"format_type";s:24:"localgov_event_date_full";s:9:"separator";s:2:"to";s:9:"show_next";i:1;s:14:"count_per_item";b:0;s:22:"occurrence_format_type";s:24:"localgov_event_date_full";s:25:"same_end_date_format_type";s:24:"localgov_event_date_hour";s:11:"interpreter";s:0:"";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}s:20:"localgov_event_image";a:6:{s:4:"type";s:28:"entity_reference_entity_view";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"view_mode";s:24:"localgov_event_thumbnail";s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:8:{s:5:"links";b:1;s:29:"localgov_event_call_to_action";b:1;s:25:"localgov_event_categories";b:1;s:23:"localgov_event_locality";b:1;s:23:"localgov_event_location";b:1;s:20:"localgov_event_price";b:1;s:20:"localgov_event_venue";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"8e72275c-a754-4e90-a539-1f8d9bb505ab";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Y8L5tfmhx7DR143E05YyZSpvgil6VFvqcfBWykalg";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.page.teaser',
  'data' => 'a:11:{s:4:"uuid";s:36:"58016a87-1ea0-4d0f-92fe-3cea28400891";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:26:"field.field.node.page.body";i:2;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8BgdRtLbtQ0F__o0FHSH0Mx5fvXOra9tfT1GmNKbRYw";}s:2:"id";s:16:"node.page.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:6:"teaser";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.test.default',
  'data' => 'a:10:{s:4:"uuid";s:36:"ce766910-a9ad-476f-a248-363d8a3f217b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:47:"field.field.node.test.field_alternate_reference";i:1;s:14:"node.type.test";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:17:"node.test.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"test";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:25:"field_alternate_reference";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:101;s:6:"region";s:7:"content";}s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.node.test.teaser',
  'data' => 'a:10:{s:4:"uuid";s:36:"d1ec116e-ed6d-4450-8d61-716e22c50fd5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:47:"field.field.node.test.field_alternate_reference";i:2;s:14:"node.type.test";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:16:"node.test.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"test";s:4:"mode";s:6:"teaser";s:7:"content";a:1:{s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:2:{s:25:"field_alternate_reference";b:1;s:18:"search_api_excerpt";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.user.user.compact',
  'data' => 'a:11:{s:4:"uuid";s:36:"9bf93f92-f0f2-4ead-9977-a01d5f6972ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:34:"core.entity_view_mode.user.compact";i:1;s:34:"field.field.user.user.user_picture";i:2;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"00zr_RBdTjPjBGITD3h4c1ESQZimjdVCcHGt1trLqIY";}s:2:"id";s:17:"user.user.compact";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"compact";s:7:"content";a:1:{s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:10:"member_for";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_display.user.user.default',
  'data' => 'a:11:{s:4:"uuid";s:36:"39a25664-52e3-4672-93f3-f68c84690219";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mZLyuWM9CQx2ZJVqFGSbzgFnHzudVbHBYmdU256A5Wk";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:10:"member_for";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.block.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"810db1f4-24a8-477a-aa06-78a61e02e8d3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"block";}}s:2:"id";s:11:"block.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:5:"block";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.block_content.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"25f07832-775b-400b-a3f4-10e56cd01377";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:13:"block_content";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4tedlMuvQjDOdvHdw86_e-2Rt78aR7TGFMfOK8Ejppg";}s:2:"id";s:18:"block_content.full";s:5:"label";s:4:"Full";s:16:"targetEntityType";s:13:"block_content";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.block_content.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"4539280d-eb03-43da-8feb-88d5d162c9ce";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:13:"block_content";}}s:2:"id";s:19:"block_content.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:13:"block_content";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.comment.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"ba64f911-c8d0-41fe-9fac-bcb21df2a3cf";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"K7eNlfU7NEUajz01wItywZklr2oaPgL6s1_97fmDXLA";}s:2:"id";s:12:"comment.full";s:5:"label";s:12:"Full comment";s:16:"targetEntityType";s:7:"comment";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.comment.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"0e9dbacd-b875-4de4-8da1-fdffa40104ad";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:2:"id";s:13:"comment.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:7:"comment";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.contact_message.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"cb943c07-cbb7-43fb-a9b5-0538f114d42a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"contact";}}s:2:"id";s:21:"contact_message.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:15:"contact_message";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.crop.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"b4b12b80-c1a3-496c-97f2-3588fddc8e58";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"crop";}}s:2:"id";s:10:"crop.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:4:"crop";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.file.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"4ad5286b-642d-48b3-932a-ed76af3794a0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"file";}}s:2:"id";s:10:"file.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:4:"file";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.localgov_geo.embed',
  'data' => 'a:9:{s:4:"uuid";s:36:"42557e06-0e4a-44c5-bfd0-3245f1aa48ba";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:12:"localgov_geo";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EjyNMV9gsaGNKj9LOamw_q5X8L6tTgk1j5EpjXiiNyE";}s:2:"id";s:18:"localgov_geo.embed";s:5:"label";s:5:"Embed";s:16:"targetEntityType";s:12:"localgov_geo";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.localgov_geo.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"6a896ac3-751d-4381-be7b-86d731a9a314";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:12:"localgov_geo";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VHxcX6j20BvlAWw0HHIQYfFyP7oKUsV8iRLc35BL2PY";}s:2:"id";s:17:"localgov_geo.full";s:5:"label";s:4:"Full";s:16:"targetEntityType";s:12:"localgov_geo";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.freestyle',
  'data' => 'a:9:{s:4:"uuid";s:36:"46209c3e-4ac8-4a9c-8985-9616944d9649";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Xp1wB04w_ybGJkHrCuoxxtkgfUSJeEO9hqU1g6MxlO4";}s:2:"id";s:15:"media.freestyle";s:5:"label";s:9:"Freestyle";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"15df2a0e-d8cf-45c7-92c9-aba60279e15d";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6NBUEuGmlkClK8Fb76tSMMpO2eZ4LWCBdbUk4z7CuP0";}s:2:"id";s:10:"media.full";s:5:"label";s:12:"Full content";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.localgov_event_thumbnail',
  'data' => 'a:9:{s:4:"uuid";s:36:"d3e12972-1cc8-4534-8ebb-43ec4f90cd8e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Yzvvpxwzq-D8nwjNgKjVkQTScJluiYQLWqqKQ8Gg2wU";}s:2:"id";s:30:"media.localgov_event_thumbnail";s:5:"label";s:15:"Event thumbnail";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.localgov_featured',
  'data' => 'a:9:{s:4:"uuid";s:36:"53bb41ee-e41a-4e87-9fc1-66442bbf6de7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6TN7TO22lrA_lUHUUubDM_9Lxl-r78gkJ_NTndS0GRQ";}s:2:"id";s:23:"media.localgov_featured";s:5:"label";s:8:"Featured";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.localgov_featured_large',
  'data' => 'a:9:{s:4:"uuid";s:36:"ce8ffd8d-1903-473a-b37f-924b9b1bdb38";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hmAwdVWyuyENXPnpTW_-BkhTgvMosn3wHjgcKMulwZE";}s:2:"id";s:29:"media.localgov_featured_large";s:5:"label";s:14:"Featured large";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.localgov_newsroom_teaser',
  'data' => 'a:9:{s:4:"uuid";s:36:"7db23a0b-c1e5-43d5-8cb4-be04b7cf574b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"O79cil-8jZ1UbgWsevakAykC8Bcyhek69tUFqxPWtE0";}s:2:"id";s:30:"media.localgov_newsroom_teaser";s:5:"label";s:15:"Newsroom teaser";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.media_library',
  'data' => 'a:9:{s:4:"uuid";s:36:"c5d86058-c60c-4b67-8067-69cf4ebb0465";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:5:"media";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:13:"media_library";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Tdhz-aDHfDoV1Ul9umtItxGTrjkFzoNAkDw8FWXjYA0";}s:2:"id";s:19:"media.media_library";s:5:"label";s:13:"Media library";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.medium_8_7',
  'data' => 'a:9:{s:4:"uuid";s:36:"31b91e6d-e874-4daf-91ab-0f1ee33b95ab";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MLQ-b8I239yOJy9cH7ZG9vuo3lvjRyVoQhebrlHVPF8";}s:2:"id";s:16:"media.medium_8_7";s:5:"label";s:10:"Medium 8:7";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.responsive_3x2',
  'data' => 'a:9:{s:4:"uuid";s:36:"ce21a3b8-4cd4-4262-88c7-c017dbfa3890";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UcWQWYgwhS23gSbklT6rN_MnalDvby-xDzzKtT3jalc";}s:2:"id";s:20:"media.responsive_3x2";s:5:"label";s:14:"Responsive 3x2";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.responsive_banner',
  'data' => 'a:9:{s:4:"uuid";s:36:"4a0a527e-7579-4f20-afb8-9504df1e5319";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HRT9XglZtpTEYkXLdQfMqU4QnpDus9pgWSKDbYow1qE";}s:2:"id";s:23:"media.responsive_banner";s:5:"label";s:17:"Responsive banner";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.scale_crop_7_3_large',
  'data' => 'a:9:{s:4:"uuid";s:36:"718d0508-1342-44dc-bdc7-52147b2f3e4a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"B_sFTb1IDrYepEpv0JbwaccNjBlIQFiG12gZaheHge4";}s:2:"id";s:26:"media.scale_crop_7_3_large";s:5:"label";s:20:"Scale crop 7:3 large";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.square',
  'data' => 'a:9:{s:4:"uuid";s:36:"8b88057d-798b-4296-8e21-8370fd454dce";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jhFdVZaHLJb5b_ZoaAjYGuBZYVoeK6IZG5x3afIT1vI";}s:2:"id";s:12:"media.square";s:5:"label";s:6:"Square";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.media.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"8e921e97-9708-4292-bbaa-a82b1de0149b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:2:"id";s:11:"media.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.menu_link_content.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"5e875912-c97b-4ca7-b231-7735853291c0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:17:"menu_link_content";}}s:2:"id";s:23:"menu_link_content.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:17:"menu_link_content";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.directory_index',
  'data' => 'a:9:{s:4:"uuid";s:36:"0c6f1344-3c61-48cf-bdd5-4e469765898e";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JjGLeSBcEFJlRSSlReJ_0h1mPAu7IRJB8zjTydlt6sQ";}s:2:"id";s:20:"node.directory_index";s:5:"label";s:22:"Directory search index";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"7ad00d09-6476-466a-beea-5da003573d80";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ElrtInxGjZd7GaapJ5O9n-ugi2hG2IxFivtgn0tHOsk";}s:2:"id";s:9:"node.full";s:5:"label";s:12:"Full content";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.rss',
  'data' => 'a:9:{s:4:"uuid";s:36:"97e911ac-f526-45e8-a0fe-89e6e1bf244c";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vlYzr-rp2f9NMp-Qlr4sFjlqRq-90mco5-afLNGwCrU";}s:2:"id";s:8:"node.rss";s:5:"label";s:3:"RSS";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_index',
  'data' => 'a:9:{s:4:"uuid";s:36:"70b5b570-4191-4e5b-86dd-8b9863f4b382";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fVFfJv_GzBRE-wpRHbfD5a3VjnhbEOXG6lvRd3uaccY";}s:2:"id";s:17:"node.search_index";s:5:"label";s:12:"Search index";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.search_result',
  'data' => 'a:9:{s:4:"uuid";s:36:"99be6f26-2b38-45f7-becc-8996e43bcea2";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6GCOQ-jP2RbdbHA5YWQ6bT8CfGbqrBYKOSC_XY4E3ZM";}s:2:"id";s:18:"node.search_result";s:5:"label";s:32:"Search result highlighting input";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.teaser',
  'data' => 'a:9:{s:4:"uuid";s:36:"a11aa545-5afe-4f46-8901-12d746684478";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mz9qWr1kUYK0mjRAGDsr5XS6PvtZ24en_7ndt-pyWe4";}s:2:"id";s:11:"node.teaser";s:5:"label";s:6:"Teaser";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.node.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"c45ba79f-7c51-435b-9b58-499bce4d8206";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:2:"id";s:10:"node.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.path_alias.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"0554f75f-67c5-4910-9dba-32c36b68efb8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:10:"path_alias";}}s:2:"id";s:16:"path_alias.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:10:"path_alias";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.search_api_task.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"d6909cb7-ff09-4108-9e95-9cd775650862";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:10:"search_api";}}s:2:"id";s:21:"search_api_task.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:15:"search_api_task";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.shortcut.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"e1d7613f-8a5a-4a4b-a969-c6ca7f8bccc1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"shortcut";}}s:2:"id";s:14:"shortcut.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:8:"shortcut";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.taxonomy_term.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"7b012c94-45d9-451a-a2ef-fa1d47b15ded";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-PPKjsNQPvoIDjOuUAvlLocYD976MNjb9Zpgyz5_BWE";}s:2:"id";s:18:"taxonomy_term.full";s:5:"label";s:18:"Taxonomy term page";s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.taxonomy_term.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"7f985ae8-c688-4da9-8212-d05a8bc0187b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:2:"id";s:19:"taxonomy_term.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.tour.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"408b0800-a4df-4343-812d-33ba58b99036";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"tour";}}s:2:"id";s:10:"tour.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:4:"tour";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.compact',
  'data' => 'a:9:{s:4:"uuid";s:36:"898a0ae1-7763-4a78-9da6-ce8e74814cbb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"71CSAr_LNPcgu6D6jI4INl1KATkahmeyUFBETAWya8g";}s:2:"id";s:12:"user.compact";s:5:"label";s:7:"Compact";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.full',
  'data' => 'a:9:{s:4:"uuid";s:36:"03d3391e-366b-4806-97ba-fe5759940a99";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mQIF_foYjmnVSr9MpcD4CTaJE_FpO1AyDd_DskztGhM";}s:2:"id";s:9:"user.full";s:5:"label";s:12:"User account";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.entity_view_mode.user.token',
  'data' => 'a:8:{s:4:"uuid";s:36:"8e6c4975-6884-4846-8804-1a4fcde8c05b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:10:"user.token";s:5:"label";s:5:"Token";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'core.extension',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"R4IF-ClDHXxblLcG0L7MgsLvfBIMAvi_skumNFQwkDc";}s:6:"module";a:82:{s:7:"address";i:0;s:14:"automated_cron";i:0;s:8:"big_pipe";i:0;s:5:"block";i:0;s:13:"block_content";i:0;s:10:"breakpoint";i:0;s:9:"ckeditor5";i:0;s:7:"comment";i:0;s:6:"config";i:0;s:7:"contact";i:0;s:10:"contextual";i:0;s:4:"crop";i:0;s:10:"date_recur";i:0;s:18:"date_recur_modular";i:0;s:8:"datetime";i:0;s:14:"datetime_range";i:0;s:5:"dblog";i:0;s:18:"dynamic_page_cache";i:0;s:6:"editor";i:0;s:14:"entity_browser";i:0;s:26:"entity_browser_entity_form";i:0;s:6:"facets";i:0;s:5:"field";i:0;s:11:"field_group";i:0;s:8:"field_ui";i:0;s:4:"file";i:0;s:6:"filter";i:0;s:8:"geocoder";i:0;s:14:"geocoder_field";i:0;s:17:"geocoder_geofield";i:0;s:8:"geofield";i:0;s:12:"geofield_map";i:0;s:4:"help";i:0;s:7:"history";i:0;s:5:"image";i:0;s:17:"image_widget_crop";i:0;s:18:"inline_entity_form";i:0;s:7:"leaflet";i:0;s:13:"leaflet_views";i:0;s:4:"link";i:0;s:6:"linkit";i:0;s:13:"localgov_core";i:0;s:20:"localgov_directories";i:0;s:29:"localgov_directories_location";i:0;s:26:"localgov_directories_venue";i:0;s:15:"localgov_events";i:0;s:12:"localgov_geo";i:0;s:20:"localgov_geo_address";i:0;s:17:"localgov_geo_area";i:0;s:14:"localgov_media";i:0;s:5:"media";i:0;s:13:"media_library";i:0;s:18:"media_library_edit";i:0;s:17:"menu_link_content";i:0;s:7:"menu_ui";i:0;s:5:"mysql";i:0;s:4:"node";i:0;s:7:"options";i:0;s:10:"page_cache";i:0;s:4:"path";i:0;s:10:"path_alias";i:0;s:16:"responsive_image";i:0;s:6:"search";i:0;s:10:"search_api";i:0;s:13:"search_api_db";i:0;s:19:"search_api_location";i:0;s:28:"search_api_location_geocoder";i:0;s:25:"search_api_location_views";i:0;s:8:"shortcut";i:0;s:6:"system";i:0;s:8:"taxonomy";i:0;s:9:"telephone";i:0;s:4:"text";i:0;s:5:"token";i:0;s:7:"toolbar";i:0;s:4:"tour";i:0;s:6:"update";i:0;s:4:"user";i:0;s:8:"views_ui";i:0;s:8:"pathauto";i:1;s:5:"views";i:10;s:8:"standard";i:1000;}s:5:"theme";a:2:{s:7:"olivero";i:0;s:5:"claro";i:0;}s:7:"profile";s:8:"standard";}',
))
->values(array(
  'collection' => '',
  'name' => 'core.menu.static_menu_link_overrides',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CXhei_vpaZk-3f_Mj2cH0YmpK-ZpKHoSzVA3yZrDq0g";}s:11:"definitions";a:1:{s:18:"contact__site_page";a:5:{s:9:"menu_name";s:6:"footer";s:6:"parent";s:0:"";s:6:"weight";i:0;s:8:"expanded";b:0;s:7:"enabled";b:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'crop.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7eGOTSG7bRv_AAqu-Ls8CSnob7zPF1ez-lD2OLZgBHs";}s:23:"flush_derivative_images";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'crop.type.16_9',
  'data' => 'a:13:{s:4:"uuid";s:36:"98647bd5-7e73-4d09-bec0-08dd00e6b1fc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mCgzXhONdVbTa12rFiyl09O1cJXfPYgP9RC0kBsh270";}s:2:"id";s:4:"16_9";s:5:"label";s:4:"16:9";s:11:"description";s:0:"";s:12:"aspect_ratio";s:4:"16:9";s:16:"soft_limit_width";N;s:17:"soft_limit_height";N;s:16:"hard_limit_width";N;s:17:"hard_limit_height";N;}',
))
->values(array(
  'collection' => '',
  'name' => 'crop.type.28_9',
  'data' => 'a:13:{s:4:"uuid";s:36:"d0a704f6-fd9c-45a8-8736-31d068cec121";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wFjZ2ZUHr_x1hTDlmlb6gA7sO_0hdvyA7QVNzcQInS8";}s:2:"id";s:4:"28_9";s:5:"label";s:4:"28:9";s:11:"description";s:0:"";s:12:"aspect_ratio";s:4:"28:9";s:16:"soft_limit_width";N;s:17:"soft_limit_height";N;s:16:"hard_limit_width";N;s:17:"hard_limit_height";N;}',
))
->values(array(
  'collection' => '',
  'name' => 'crop.type.3_2',
  'data' => 'a:13:{s:4:"uuid";s:36:"90d393e1-d6f0-41de-acf2-9e78e6b3aeec";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sNQ61xvGh-uhoAiVqKW6Oig9JVywoMwWZF1hrE_cpDQ";}s:2:"id";s:3:"3_2";s:5:"label";s:3:"3:2";s:11:"description";s:0:"";s:12:"aspect_ratio";s:3:"3:2";s:16:"soft_limit_width";N;s:17:"soft_limit_height";N;s:16:"hard_limit_width";N;s:17:"hard_limit_height";N;}',
))
->values(array(
  'collection' => '',
  'name' => 'crop.type.7_3',
  'data' => 'a:13:{s:4:"uuid";s:36:"5cc9713b-1cac-4af2-b090-86363a2b8597";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"deYYBttooAYkDLkqa35eU-VfGsLkYECnLG46xnvbUtc";}s:2:"id";s:3:"7_3";s:5:"label";s:3:"7:3";s:11:"description";s:0:"";s:12:"aspect_ratio";s:3:"7:3";s:16:"soft_limit_width";N;s:17:"soft_limit_height";N;s:16:"hard_limit_width";N;s:17:"hard_limit_height";N;}',
))
->values(array(
  'collection' => '',
  'name' => 'crop.type.8_7',
  'data' => 'a:13:{s:4:"uuid";s:36:"f017b933-32d5-4e2f-8c13-a16a250993b8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z4rshySxnH2HYoqF0OJcALkxFPqckbCHfplhl-U8ucA";}s:2:"id";s:3:"8_7";s:5:"label";s:3:"8:7";s:11:"description";s:0:"";s:12:"aspect_ratio";s:3:"8:7";s:16:"soft_limit_width";N;s:17:"soft_limit_height";N;s:16:"hard_limit_width";N;s:17:"hard_limit_height";N;}',
))
->values(array(
  'collection' => '',
  'name' => 'crop.type.freestyle',
  'data' => 'a:13:{s:4:"uuid";s:36:"c2bdc132-f2f1-499f-8dfb-eb2fad997003";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-WRJU5SdlE-zJg7aQTLL6oXpSJgTnrfGWCPbTnX_Xhk";}s:2:"id";s:9:"freestyle";s:5:"label";s:9:"Freestyle";s:11:"description";s:44:"User defined crop, with no aspect ratio set.";s:12:"aspect_ratio";s:0:"";s:16:"soft_limit_width";N;s:17:"soft_limit_height";N;s:16:"hard_limit_width";N;s:17:"hard_limit_height";N;}',
))
->values(array(
  'collection' => '',
  'name' => 'crop.type.localgov_news_16_9',
  'data' => 'a:13:{s:4:"uuid";s:36:"a755f74f-2a84-4385-923c-3a52bca81482";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EFvH1C81Szr6CBCMk6YeZ1HOP3PEoitgixDdQeDIrqE";}s:2:"id";s:18:"localgov_news_16_9";s:5:"label";s:19:"16:9 for News image";s:11:"description";s:0:"";s:12:"aspect_ratio";s:4:"16:9";s:16:"soft_limit_width";N;s:17:"soft_limit_height";N;s:16:"hard_limit_width";N;s:17:"hard_limit_height";N;}',
))
->values(array(
  'collection' => '',
  'name' => 'crop.type.square',
  'data' => 'a:13:{s:4:"uuid";s:36:"71697a3a-bed5-43af-bb90-815c70ccda70";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Bl0yZxDk_n84ambWpE5tRQBzzGkv8cHUuFrFF4lLrKw";}s:2:"id";s:6:"square";s:5:"label";s:6:"Square";s:11:"description";s:0:"";s:12:"aspect_ratio";s:3:"1:1";s:16:"soft_limit_width";N;s:17:"soft_limit_height";N;s:16:"hard_limit_width";N;s:17:"hard_limit_height";N;}',
))
->values(array(
  'collection' => '',
  'name' => 'date_recur.interpreter.default_interpreter',
  'data' => 'a:9:{s:4:"uuid";s:36:"8b532bec-68ac-4d37-92fc-d64e1819e169";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:21:"core.date_format.long";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zx_IJn4SosQt8RbdEHFJSrxMvuMTTGiSgVioy1porhY";}s:2:"id";s:19:"default_interpreter";s:5:"label";s:19:"Default Interpreter";s:6:"plugin";s:2:"rl";s:8:"settings";a:4:{s:15:"show_start_date";b:1;s:10:"show_until";b:1;s:11:"date_format";s:4:"long";s:13:"show_infinite";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'dblog.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"e883aGsrt1wFrsydlYU584PZONCSfRy0DtkZ9KzHb58";}s:9:"row_limit";i:1000;}',
))
->values(array(
  'collection' => '',
  'name' => 'editor.editor.basic_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"ebd50ec2-05ac-45d8-9bb6-626137d93f90";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uXAqOeMiQVnzE5yk7-v1DsBagmkCI2h_q5WAf0bir-o";}s:6:"format";s:10:"basic_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:15:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:1:"|";i:3;s:4:"link";i:4;s:1:"|";i:5;s:12:"bulletedList";i:6;s:12:"numberedList";i:7;s:1:"|";i:8;s:10:"blockQuote";i:9;s:17:"drupalInsertImage";i:10;s:1:"|";i:11;s:7:"heading";i:12;s:4:"code";i:13;s:1:"|";i:14;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:13:{i:0;s:6:"<cite>";i:1;s:4:"<dl>";i:2;s:4:"<dt>";i:3;s:4:"<dd>";i:4;s:12:"<a hreflang>";i:5;s:17:"<blockquote cite>";i:6;s:9:"<ul type>";i:7;s:15:"<ol start type>";i:8;s:7:"<h2 id>";i:9;s:7:"<h3 id>";i:10;s:7:"<h4 id>";i:11;s:7:"<h5 id>";i:12;s:7:"<h6 id>";}}s:14:"ckeditor5_list";a:2:{s:8:"reversed";b:0;s:10:"startIndex";b:1;}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'editor.editor.full_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"66677893-d268-4464-b033-ccdbf2bbe54b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"filter.format.full_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0UeuvbLLshU7EeXK0lLcsZYdDuR4ByvaYRhrX_84mo";}s:6:"format";s:9:"full_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:21:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:13:"strikethrough";i:3;s:11:"superscript";i:4;s:9:"subscript";i:5;s:12:"removeFormat";i:6;s:1:"|";i:7;s:4:"link";i:8;s:1:"|";i:9;s:12:"bulletedList";i:10;s:12:"numberedList";i:11;s:1:"|";i:12;s:10:"blockQuote";i:13;s:17:"drupalInsertImage";i:14;s:11:"insertTable";i:15;s:14:"horizontalLine";i:16;s:1:"|";i:17;s:7:"heading";i:18;s:9:"codeBlock";i:19;s:1:"|";i:20;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:0:{}}s:14:"ckeditor5_list";a:2:{s:8:"reversed";b:1;s:10:"startIndex";b:1;}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'entity_browser.browser.localgov_geo_library',
  'data' => 'a:14:{s:4:"uuid";s:36:"fb73a4b4-0903-4115-a2c0-6d5b71a1a4f3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"views.view.localgov_geo_library";}s:6:"module";a:2:{i:0;s:26:"entity_browser_entity_form";i:1;s:5:"views";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VpwzHKKqCY4zSHnbnxTd5z3CNRrwaGPhMBEbKE7-8rE";}s:4:"name";s:20:"localgov_geo_library";s:5:"label";s:11:"Geo Browser";s:7:"display";s:5:"modal";s:21:"display_configuration";a:4:{s:5:"width";s:4:"1200";s:6:"height";s:3:"800";s:9:"link_text";s:15:"Select location";s:9:"auto_open";b:0;}s:17:"selection_display";s:10:"no_display";s:31:"selection_display_configuration";a:0:{}s:15:"widget_selector";s:4:"tabs";s:29:"widget_selector_configuration";a:0:{}s:7:"widgets";a:3:{s:36:"d5750416-1d97-43b9-95b1-f843724c8ecd";a:5:{s:8:"settings";a:4:{s:11:"submit_text";s:15:"Select location";s:11:"auto_select";b:0;s:4:"view";s:20:"localgov_geo_library";s:12:"view_display";s:16:"entity_browser_1";}s:4:"uuid";s:36:"d5750416-1d97-43b9-95b1-f843724c8ecd";s:6:"weight";i:1;s:5:"label";s:25:"Search existing locations";s:2:"id";s:4:"view";}s:36:"3edf0a0f-cb61-4324-8d36-1898e23a16ed";a:5:{s:8:"settings";a:4:{s:11:"submit_text";s:12:"Save address";s:11:"entity_type";s:12:"localgov_geo";s:6:"bundle";s:7:"address";s:9:"form_mode";s:6:"inline";}s:4:"uuid";s:36:"3edf0a0f-cb61-4324-8d36-1898e23a16ed";s:6:"weight";i:2;s:5:"label";s:18:"Create new address";s:2:"id";s:11:"entity_form";}s:36:"beda8d11-9000-4069-95e7-dbb4282941db";a:5:{s:8:"settings";a:4:{s:11:"submit_text";s:9:"Save area";s:11:"entity_type";s:12:"localgov_geo";s:6:"bundle";s:4:"area";s:9:"form_mode";s:6:"inline";}s:4:"uuid";s:36:"beda8d11-9000-4069-95e7-dbb4282941db";s:6:"weight";i:3;s:5:"label";s:15:"Create new area";s:2:"id";s:11:"entity_form";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'facets.facet.localgov_events_category',
  'data' => 'a:28:{s:4:"uuid";s:36:"f5a01929-f11d-40c0-9267-d5f35d969485";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:32:"search_api.index.localgov_events";i:1;s:33:"views.view.localgov_events_search";}s:6:"module";a:1:{i:0;s:10:"search_api";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9qzrYzP3Kv5nOKvzs-0BfTWsXOk41Otar2hIh6f7R-I";}s:2:"id";s:24:"localgov_events_category";s:4:"name";s:8:"Category";s:9:"url_alias";s:8:"category";s:6:"weight";i:0;s:9:"min_count";i:1;s:7:"missing";b:0;s:13:"missing_label";s:6:"others";s:20:"show_only_one_result";b:0;s:16:"field_identifier";s:25:"localgov_event_categories";s:15:"facet_source_id";s:58:"search_api:views_page__localgov_events_search__events_page";s:6:"widget";a:2:{s:4:"type";s:8:"dropdown";s:6:"config";a:2:{s:12:"show_numbers";b:0;s:20:"default_option_label";s:7:"- All -";}}s:14:"query_operator";s:2:"or";s:13:"use_hierarchy";b:0;s:29:"keep_hierarchy_parents_active";b:0;s:9:"hierarchy";a:2:{s:4:"type";s:8:"taxonomy";s:6:"config";a:0:{}}s:16:"expand_hierarchy";b:0;s:38:"enable_parent_when_child_gets_disabled";b:1;s:10:"hard_limit";i:0;s:7:"exclude";b:0;s:41:"only_visible_when_facet_source_is_visible";b:1;s:17:"processor_configs";a:3:{s:24:"term_weight_widget_order";a:3:{s:12:"processor_id";s:24:"term_weight_widget_order";s:7:"weights";a:1:{s:4:"sort";i:60;}s:8:"settings";a:1:{s:4:"sort";s:3:"ASC";}}s:16:"translate_entity";a:3:{s:12:"processor_id";s:16:"translate_entity";s:7:"weights";a:1:{s:5:"build";i:5;}s:8:"settings";a:0:{}}s:21:"url_processor_handler";a:3:{s:12:"processor_id";s:21:"url_processor_handler";s:7:"weights";a:2:{s:9:"pre_query";i:50;s:5:"build";i:15;}s:8:"settings";a:0:{}}}s:14:"empty_behavior";a:1:{s:8:"behavior";s:4:"none";}s:10:"show_title";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'facets.facet.localgov_events_locality',
  'data' => 'a:28:{s:4:"uuid";s:36:"96a80c59-43de-4a0e-aad3-1e551dba58e0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:32:"search_api.index.localgov_events";i:1;s:33:"views.view.localgov_events_search";}s:6:"module";a:1:{i:0;s:10:"search_api";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AkfpWU5b5M60WRVm_3oVtKiqGgv1A9X9Pr7laZlkxuc";}s:2:"id";s:24:"localgov_events_locality";s:4:"name";s:13:"Neighbourhood";s:9:"url_alias";s:8:"locality";s:6:"weight";i:0;s:9:"min_count";i:1;s:7:"missing";b:0;s:13:"missing_label";s:6:"others";s:20:"show_only_one_result";b:0;s:16:"field_identifier";s:23:"localgov_event_locality";s:15:"facet_source_id";s:58:"search_api:views_page__localgov_events_search__events_page";s:6:"widget";a:2:{s:4:"type";s:8:"dropdown";s:6:"config";a:2:{s:12:"show_numbers";b:0;s:20:"default_option_label";s:7:"- All -";}}s:14:"query_operator";s:2:"or";s:13:"use_hierarchy";b:0;s:29:"keep_hierarchy_parents_active";b:0;s:9:"hierarchy";a:2:{s:4:"type";s:8:"taxonomy";s:6:"config";a:0:{}}s:16:"expand_hierarchy";b:0;s:38:"enable_parent_when_child_gets_disabled";b:1;s:10:"hard_limit";i:0;s:7:"exclude";b:0;s:41:"only_visible_when_facet_source_is_visible";b:1;s:17:"processor_configs";a:3:{s:24:"term_weight_widget_order";a:3:{s:12:"processor_id";s:24:"term_weight_widget_order";s:7:"weights";a:1:{s:4:"sort";i:60;}s:8:"settings";a:1:{s:4:"sort";s:3:"ASC";}}s:16:"translate_entity";a:3:{s:12:"processor_id";s:16:"translate_entity";s:7:"weights";a:1:{s:5:"build";i:5;}s:8:"settings";a:0:{}}s:21:"url_processor_handler";a:3:{s:12:"processor_id";s:21:"url_processor_handler";s:7:"weights";a:2:{s:9:"pre_query";i:50;s:5:"build";i:15;}s:8:"settings";a:0:{}}}s:14:"empty_behavior";a:1:{s:8:"behavior";s:4:"none";}s:10:"show_title";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'facets.facet.localgov_events_price',
  'data' => 'a:28:{s:4:"uuid";s:36:"2fe2b5f2-bc8e-42b5-afd9-4da6dd541a3f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:32:"search_api.index.localgov_events";i:1;s:33:"views.view.localgov_events_search";}s:6:"module";a:1:{i:0;s:10:"search_api";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ufjUWCAP17vZ_yPnGQlcgesmy_QA2wMMYKWlsaVza9Y";}s:2:"id";s:21:"localgov_events_price";s:4:"name";s:4:"Cost";s:9:"url_alias";s:4:"cost";s:6:"weight";i:0;s:9:"min_count";i:1;s:7:"missing";b:0;s:13:"missing_label";s:6:"others";s:20:"show_only_one_result";b:0;s:16:"field_identifier";s:20:"localgov_event_price";s:15:"facet_source_id";s:58:"search_api:views_page__localgov_events_search__events_page";s:6:"widget";a:2:{s:4:"type";s:8:"dropdown";s:6:"config";a:2:{s:12:"show_numbers";b:0;s:20:"default_option_label";s:7:"- All -";}}s:14:"query_operator";s:2:"or";s:13:"use_hierarchy";b:0;s:29:"keep_hierarchy_parents_active";b:0;s:9:"hierarchy";a:2:{s:4:"type";s:8:"taxonomy";s:6:"config";a:0:{}}s:16:"expand_hierarchy";b:0;s:38:"enable_parent_when_child_gets_disabled";b:1;s:10:"hard_limit";i:0;s:7:"exclude";b:0;s:41:"only_visible_when_facet_source_is_visible";b:1;s:17:"processor_configs";a:3:{s:24:"term_weight_widget_order";a:3:{s:12:"processor_id";s:24:"term_weight_widget_order";s:7:"weights";a:1:{s:4:"sort";i:60;}s:8:"settings";a:1:{s:4:"sort";s:3:"ASC";}}s:16:"translate_entity";a:3:{s:12:"processor_id";s:16:"translate_entity";s:7:"weights";a:1:{s:5:"build";i:5;}s:8:"settings";a:0:{}}s:21:"url_processor_handler";a:3:{s:12:"processor_id";s:21:"url_processor_handler";s:7:"weights";a:2:{s:9:"pre_query";i:50;s:5:"build";i:15;}s:8:"settings";a:0:{}}}s:14:"empty_behavior";a:1:{s:8:"behavior";s:4:"none";}s:10:"show_title";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.block_content.basic.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"062314fc-0763-4dd9-b054-e8bdbadeb51c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:32:"field.storage.block_content.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"foetbaMhlB6uLc2bn-PESvaPkbuDWj0MEjpQVwQiP-o";}s:2:"id";s:24:"block_content.basic.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:0;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.comment.comment.comment_body',
  'data' => 'a:17:{s:4:"uuid";s:36:"9a1ee23a-ec89-4715-b461-771971fa807b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:34:"field.storage.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TmAKjNrJ7RR60YpqvJq_QqEewYe_S8Kd23n8VRCqiWs";}s:2:"id";s:28:"comment.comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Comment";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"text_long";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.localgov_geo.address.accessibility',
  'data' => 'a:17:{s:4:"uuid";s:36:"579474a6-e571-4e06-8baf-a5c504869365";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:40:"field.storage.localgov_geo.accessibility";i:1;s:38:"localgov_geo.localgov_geo_type.address";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fpJFm_mWMrZMJyIeIoKxFwfh_t_7lxabRH1oRuDp3bg";}s:2:"id";s:34:"localgov_geo.address.accessibility";s:10:"field_name";s:13:"accessibility";s:11:"entity_type";s:12:"localgov_geo";s:6:"bundle";s:7:"address";s:5:"label";s:13:"Accessibility";s:11:"description";s:62:"Any information about access, or restrictions, at the address.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"text_long";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.localgov_geo.address.external_id',
  'data' => 'a:17:{s:4:"uuid";s:36:"7479bc95-37b6-4845-a844-f2f6fc37c2fd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:2:{i:0;s:38:"field.storage.localgov_geo.external_id";i:1;s:38:"localgov_geo.localgov_geo_type.address";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OklkF9Z0-5QXmoTBqy9ji1IHxGXfM5nUGly6Qsbwlfs";}s:2:"id";s:32:"localgov_geo.address.external_id";s:10:"field_name";s:11:"external_id";s:11:"entity_type";s:12:"localgov_geo";s:6:"bundle";s:7:"address";s:5:"label";s:11:"External ID";s:11:"description";s:85:"An field for storing external identifier for synchronising with geoservice providers.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.localgov_geo.address.location',
  'data' => 'a:17:{s:4:"uuid";s:36:"87c36ae2-aa11-4b96-8cce-a372e3e93819";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:35:"field.storage.localgov_geo.location";i:1;s:38:"localgov_geo.localgov_geo_type.address";}s:6:"module";a:1:{i:0;s:8:"geofield";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"O97o22y5dBtzkBvBps0GD5ktNFnI28F1kTi05x87bJE";}s:2:"id";s:29:"localgov_geo.address.location";s:10:"field_name";s:8:"location";s:11:"entity_type";s:12:"localgov_geo";s:6:"bundle";s:7:"address";s:5:"label";s:8:"location";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:8:"geofield";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.localgov_geo.address.postal_address',
  'data' => "a:17:{s:4:\"uuid\";s:36:\"f7595e19-73ea-4e8a-a3fc-c0c567c20104\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:41:\"field.storage.localgov_geo.postal_address\";i:1;s:38:\"localgov_geo.localgov_geo_type.address\";}s:6:\"module\";a:1:{i:0;s:7:\"address\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cPVK8esAh6ldr15OeJ1HraSlpFybhOxQ4l-nhoF2hAA\";}s:2:\"id\";s:35:\"localgov_geo.address.postal_address\";s:10:\"field_name\";s:14:\"postal_address\";s:11:\"entity_type\";s:12:\"localgov_geo\";s:6:\"bundle\";s:7:\"address\";s:5:\"label\";s:7:\"Address\";s:11:\"description\";s:100:\"Enter the address here, and then use the 'Populate from address field' button to find it on the map.\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:4:{s:19:\"available_countries\";a:1:{s:2:\"GB\";s:2:\"GB\";}s:17:\"langcode_override\";s:0:\"\";s:15:\"field_overrides\";a:4:{s:9:\"givenName\";a:1:{s:8:\"override\";s:6:\"hidden\";}s:14:\"additionalName\";a:1:{s:8:\"override\";s:6:\"hidden\";}s:10:\"familyName\";a:1:{s:8:\"override\";s:6:\"hidden\";}s:12:\"organization\";a:1:{s:8:\"override\";s:6:\"hidden\";}}s:6:\"fields\";a:0:{}}s:10:\"field_type\";s:7:\"address\";}",
))
->values(array(
  'collection' => '',
  'name' => 'field.field.localgov_geo.area.external_id',
  'data' => 'a:17:{s:4:"uuid";s:36:"7cc774cb-4b79-4491-92bb-5ce3d722a893";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:2:{i:0;s:38:"field.storage.localgov_geo.external_id";i:1;s:35:"localgov_geo.localgov_geo_type.area";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JSigzl0RXkovNr-7qTnjG5lJwb6jcwTnc4cAv9L8oEg";}s:2:"id";s:29:"localgov_geo.area.external_id";s:10:"field_name";s:11:"external_id";s:11:"entity_type";s:12:"localgov_geo";s:6:"bundle";s:4:"area";s:5:"label";s:11:"External ID";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.localgov_geo.area.geo_file',
  'data' => 'a:17:{s:4:"uuid";s:36:"a6aae2fd-d322-4050-b9f9-470d556981a6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:35:"field.storage.localgov_geo.geo_file";i:1;s:35:"localgov_geo.localgov_geo_type.area";}s:6:"module";a:1:{i:0;s:4:"file";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NKnJOOifTYyvd4J9NbV2OgMXDoCbeAAXKzBCGn0o5Wk";}s:2:"id";s:26:"localgov_geo.area.geo_file";s:10:"field_name";s:8:"geo_file";s:11:"entity_type";s:12:"localgov_geo";s:6:"bundle";s:4:"area";s:5:"label";s:8:"Geo file";s:11:"description";s:92:"The data file describing the area. Formats currently imported are KML, GPX, WKT and GeoJSON.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:6:{s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:24:"kml gpx wkt json geojson";s:12:"max_filesize";s:0:"";s:17:"description_field";b:0;s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}}s:10:"field_type";s:4:"file";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.localgov_geo.area.location',
  'data' => 'a:18:{s:4:"uuid";s:36:"f0f532dd-625f-45c3-9f3e-21091cfc938c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:35:"field.storage.localgov_geo.location";i:1;s:35:"localgov_geo.localgov_geo_type.area";}s:6:"module";a:2:{i:0;s:14:"geocoder_field";i:1;s:8:"geofield";}}s:20:"third_party_settings";a:1:{s:14:"geocoder_field";a:10:{s:6:"method";s:7:"geocode";s:6:"weight";i:0;s:20:"skip_not_empty_value";b:0;s:8:"disabled";b:0;s:6:"hidden";b:1;s:9:"providers";a:4:{i:0;s:8:"gpx_file";i:1;s:8:"kml_file";i:2;s:12:"geojson_file";i:3;s:4:"file";}s:6:"dumper";s:3:"wkt";s:7:"failure";a:3:{s:8:"handling";s:8:"preserve";s:14:"status_message";b:1;s:3:"log";b:1;}s:5:"field";s:8:"geo_file";s:14:"delta_handling";s:7:"default";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DI4biAttReU0XraC6ZI45A-fdPMfyRcndB0yPn5ZnjM";}s:2:"id";s:26:"localgov_geo.area.location";s:10:"field_name";s:8:"location";s:11:"entity_type";s:12:"localgov_geo";s:6:"bundle";s:4:"area";s:5:"label";s:8:"location";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:8:"geofield";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.media.audio.field_media_audio_file',
  'data' => 'a:17:{s:4:"uuid";s:36:"a382540c-18e3-4307-beb8-c21a22934541";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:42:"field.storage.media.field_media_audio_file";i:1;s:16:"media.type.audio";}s:6:"module";a:1:{i:0;s:4:"file";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UlZPIbHcLyNqGY5bvydCTijGcKDmwn4Fo8oYZT85wlk";}s:2:"id";s:34:"media.audio.field_media_audio_file";s:10:"field_name";s:22:"field_media_audio_file";s:11:"entity_type";s:5:"media";s:6:"bundle";s:5:"audio";s:5:"label";s:10:"Audio file";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:6:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:11:"mp3 wav aac";s:12:"max_filesize";s:0:"";s:17:"description_field";b:0;}s:10:"field_type";s:4:"file";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.media.document.field_media_document',
  'data' => 'a:17:{s:4:"uuid";s:36:"617487aa-fcf6-4c7c-8f16-3a488cc31aea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:2:{i:0;s:40:"field.storage.media.field_media_document";i:1;s:19:"media.type.document";}s:6:"module";a:1:{i:0;s:4:"file";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DY5HtJTxUjFRGU_PaY6ifo2nhR-nAZ0y0s6kLmUbv5g";}s:2:"id";s:35:"media.document.field_media_document";s:10:"field_name";s:20:"field_media_document";s:11:"entity_type";s:5:"media";s:6:"bundle";s:8:"document";s:5:"label";s:8:"Document";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:6:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:96:"txt rtf doc docx ppt pptx xls xlsx pdf odf odg odp ods odt fodt fods fodp fodg key numbers pages";s:12:"max_filesize";s:0:"";s:17:"description_field";b:0;}s:10:"field_type";s:4:"file";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.media.image.field_media_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"bd2e901f-7f0d-46c8-ade0-b825c3742516";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:2:{i:0;s:37:"field.storage.media.field_media_image";i:1;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HGRX21ciyn7K-q8KMxsKHQvIB4SHT-A3bqzmNDnGKyc";}s:2:"id";s:29:"media.image.field_media_image";s:10:"field_name";s:17:"field_media_image";s:11:"entity_type";s:5:"media";s:6:"bundle";s:5:"image";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:18:"alt_field_required";b:1;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.media.remote_video.field_media_oembed_video',
  'data' => 'a:17:{s:4:"uuid";s:36:"9823c9ec-155e-470c-9146-e3f9f048eef5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:2:{i:0;s:44:"field.storage.media.field_media_oembed_video";i:1;s:23:"media.type.remote_video";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Eo4HHenV5iZat_kEWgr_wydD3TgwURMCzwt-7qIEyoM";}s:2:"id";s:43:"media.remote_video.field_media_oembed_video";s:10:"field_name";s:24:"field_media_oembed_video";s:11:"entity_type";s:5:"media";s:6:"bundle";s:12:"remote_video";s:5:"label";s:9:"Video URL";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.media.video.field_media_video_file',
  'data' => 'a:17:{s:4:"uuid";s:36:"b8acc4b1-94ad-47fa-a5f4-2f7c3d74d2bf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:42:"field.storage.media.field_media_video_file";i:1;s:16:"media.type.video";}s:6:"module";a:1:{i:0;s:4:"file";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6kMMjmk2r_csGQ52qI9BUaO8r_oAzNLbxlclaj-JlDQ";}s:2:"id";s:34:"media.video.field_media_video_file";s:10:"field_name";s:22:"field_media_video_file";s:11:"entity_type";s:5:"media";s:6:"bundle";s:5:"video";s:5:"label";s:10:"Video file";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:6:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:3:"mp4";s:12:"max_filesize";s:0:"";s:17:"description_field";b:0;}s:10:"field_type";s:4:"file";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"d2ad1bd6-2eaf-499b-a338-eed68d17317c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IjZnOLWk1Pjq3WRg2pLSA1ERh7Po7izCq_p6UztZr2c";}s:2:"id";s:17:"node.article.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.comment',
  'data' => 'a:17:{s:4:"uuid";s:36:"070a966d-163a-49ac-95f8-5ebc9fe830ef";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.storage.node.comment";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UqXlkKC4v2-bDfWx4zcXQrD5YIi3d5byENEmWv-G_Uc";}s:2:"id";s:20:"node.article.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:8:"Comments";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:6:{s:6:"status";i:2;s:3:"cid";i:0;s:22:"last_comment_timestamp";i:0;s:17:"last_comment_name";N;s:16:"last_comment_uid";i:0;s:13:"comment_count";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:5:{s:12:"default_mode";i:1;s:8:"per_page";i:50;s:9:"anonymous";i:0;s:13:"form_location";b:1;s:7:"preview";i:1;}s:10:"field_type";s:7:"comment";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.field_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"5c41959b-585d-4a21-8765-a02aba6c1068";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"field.storage.node.field_image";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PmVL51L3A9QGbPLoeLHw5epAPszeZRasCeC3imeeDRQ";}s:2:"id";s:24:"node.article.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:18:"alt_field_required";b:1;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.article.field_tags',
  'data' => 'a:17:{s:4:"uuid";s:36:"6b45f3d1-a5c7-48ef-b569-9959186d508d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:29:"field.storage.node.field_tags";i:1;s:17:"node.type.article";i:2;s:24:"taxonomy.vocabulary.tags";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QdUgf_beeoaPiyKorFv0q1fcJpWH_uZTqe_xoVJacrw";}s:2:"id";s:23:"node.article.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Tags";s:11:"description";s:84:"Enter a comma-separated list. For example: Amsterdam, Mexico City, "Cleveland, Ohio"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:3:{s:14:"target_bundles";a:1:{s:4:"tags";s:4:"tags";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:1;}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"efc4410c-762e-41fd-a3f1-6c7da10b79ee";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_SWXR-ErCnEEv52WMUUbSkxSaLsr4PD8RFXhY3RT5Ak";}s:2:"id";s:36:"node.localgov_directories_venue.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_channels',
  'data' => 'a:17:{s:4:"uuid";s:36:"6e38544a-19f7-4ccf-9575-92f64dcf1d22";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:46:"field.storage.node.localgov_directory_channels";i:1;s:36:"node.type.localgov_directories_venue";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:20:"localgov_directories";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oNrqFdGCSvCMt74Zu9bW55g4sFlMqcY5o5alf0BadFU";}s:2:"id";s:59:"node.localgov_directories_venue.localgov_directory_channels";s:10:"field_name";s:27:"localgov_directory_channels";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:18:"Directory channels";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:39:"localgov_directories_channels_selection";s:16:"handler_settings";a:1:{s:4:"sort";a:2:{s:5:"field";s:5:"title";s:9:"direction";s:4:"DESC";}}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_email',
  'data' => 'a:17:{s:4:"uuid";s:36:"1ca40fd8-a942-4793-9db7-f990e84c8f98";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:43:"field.storage.node.localgov_directory_email";i:1;s:36:"node.type.localgov_directories_venue";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:20:"localgov_directories";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yJlVDWleFR4UvplSKd41NHwBqjcEqQ_QytMxgolZL5g";}s:2:"id";s:56:"node.localgov_directories_venue.localgov_directory_email";s:10:"field_name";s:24:"localgov_directory_email";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:15:"Enquiries email";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:5:"email";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_facets_select',
  'data' => 'a:17:{s:4:"uuid";s:36:"9c0dd81b-6e8e-4d4d-9530-062c7a50365d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:51:"field.storage.node.localgov_directory_facets_select";i:1;s:36:"node.type.localgov_directories_venue";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:20:"localgov_directories";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"kA2knxU2oMh4lFG2lnvhS6pyu7WHotAPiR7POn8BKa4";}s:2:"id";s:64:"node.localgov_directories_venue.localgov_directory_facets_select";s:10:"field_name";s:32:"localgov_directory_facets_select";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:6:"Facets";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:37:"localgov_directories_facets_selection";s:16:"handler_settings";a:3:{s:4:"sort";a:2:{s:5:"field";s:6:"bundle";s:9:"direction";s:3:"ASC";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_files',
  'data' => 'a:17:{s:4:"uuid";s:36:"a12912dc-e8b4-44a5-94cf-8fce926f484f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:43:"field.storage.node.localgov_directory_files";i:1;s:19:"media.type.document";i:2;s:36:"node.type.localgov_directories_venue";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:20:"localgov_directories";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Lh54iZYPBdiuxlK9fH-d-n6fNpWF388TOKzaayjUfNQ";}s:2:"id";s:56:"node.localgov_directories_venue.localgov_directory_files";s:10:"field_name";s:24:"localgov_directory_files";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:16:"File attachments";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:13:"default:media";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:8:"document";s:8:"document";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_job_title',
  'data' => 'a:17:{s:4:"uuid";s:36:"3200b5a0-e61e-45df-a9cf-afde0fa23a19";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:47:"field.storage.node.localgov_directory_job_title";i:1;s:36:"node.type.localgov_directories_venue";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:20:"localgov_directories";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dg0rUyELeweRj437p8ac8fmiLW466g3LhTzPDyBALa0";}s:2:"id";s:60:"node.localgov_directories_venue.localgov_directory_job_title";s:10:"field_name";s:28:"localgov_directory_job_title";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:17:"Contact job title";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_name',
  'data' => 'a:17:{s:4:"uuid";s:36:"57b89227-41d0-47f5-aa63-61ed87cb682a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:42:"field.storage.node.localgov_directory_name";i:1;s:36:"node.type.localgov_directories_venue";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:20:"localgov_directories";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N6ZSLkigLCb_ya1M0Ozokrx83K1Qp72ny9swnPcQW3w";}s:2:"id";s:55:"node.localgov_directories_venue.localgov_directory_name";s:10:"field_name";s:23:"localgov_directory_name";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:12:"Contact name";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_notes',
  'data' => 'a:17:{s:4:"uuid";s:36:"b3f864da-9233-457b-9abe-10d7f28a1f8c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:43:"field.storage.node.localgov_directory_notes";i:1;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"f8HGdmc0v4BlUtWqj4z3HKlD0Qyk3YAuqANd5hRWLKw";}s:2:"id";s:56:"node.localgov_directories_venue.localgov_directory_notes";s:10:"field_name";s:24:"localgov_directory_notes";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:11:"Venue notes";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"text_long";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_opening_times',
  'data' => 'a:17:{s:4:"uuid";s:36:"bfd70ff3-73fd-4634-8d6a-001462b3130d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:51:"field.storage.node.localgov_directory_opening_times";i:1;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PYSoy8iZF7jm-ui5aPs2h8pJKOr5lLARmfoXb_045Xo";}s:2:"id";s:64:"node.localgov_directories_venue.localgov_directory_opening_times";s:10:"field_name";s:32:"localgov_directory_opening_times";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:19:"Venue opening times";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"text_long";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_phone',
  'data' => 'a:17:{s:4:"uuid";s:36:"a2fb2625-ae07-416b-95a8-b1a3bdaab49a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:2:{i:0;s:43:"field.storage.node.localgov_directory_phone";i:1;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:1:{i:0;s:9:"telephone";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:20:"localgov_directories";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gCvpcJjjOPVWPYr1Ae78xYy9WEVhda85B86T5I2pip4";}s:2:"id";s:56:"node.localgov_directories_venue.localgov_directory_phone";s:10:"field_name";s:24:"localgov_directory_phone";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:13:"Contact phone";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"telephone";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_title_sort',
  'data' => "a:17:{s:4:\"uuid\";s:36:\"61d28a56-0e79-4957-8b0c-5e2b005914f4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:48:\"field.storage.node.localgov_directory_title_sort\";i:1;s:36:\"node.type.localgov_directories_venue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2uRxqKHOZ3f-cbrmUbT_4QDMwiwNu42XltDZLAHK2Ew\";}s:2:\"id\";s:61:\"node.localgov_directories_venue.localgov_directory_title_sort\";s:10:\"field_name\";s:29:\"localgov_directory_title_sort\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:26:\"localgov_directories_venue\";s:5:\"label\";s:22:\"Title used for sorting\";s:11:\"description\";s:204:\"<strong>Can be left blank</strong>. If this field is completed it will be used instead of the <em>Title</em> for alphabetically sorted lists. For example to move 'The' or 'A' from the beginning of a name.\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}",
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_directory_website',
  'data' => 'a:17:{s:4:"uuid";s:36:"0586931b-da49-40c3-86a1-167ac733f9d4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:2:{i:0;s:45:"field.storage.node.localgov_directory_website";i:1;s:36:"node.type.localgov_directories_venue";}s:6:"module";a:1:{i:0;s:4:"link";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:20:"localgov_directories";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3cjAe-m9YKw1QcI8AK0sWuLMdqCLQkhcbevBL9QghCM";}s:2:"id";s:58:"node.localgov_directories_venue.localgov_directory_website";s:10:"field_name";s:26:"localgov_directory_website";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:17:"Enquiries website";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:9:"link_type";i:17;s:5:"title";i:0;}s:10:"field_type";s:4:"link";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directories_venue.localgov_location',
  'data' => 'a:17:{s:4:"uuid";s:36:"4148ddbe-d395-448a-8f6b-a727a3c0bfad";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:36:"field.storage.node.localgov_location";i:1;s:38:"localgov_geo.localgov_geo_type.address";i:2;s:35:"localgov_geo.localgov_geo_type.area";i:3;s:36:"node.type.localgov_directories_venue";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:20:"localgov_geo_address";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dIS8FBFQAzX3W77-Ynqu-FWrEqPgdakjVePKMtmvYBc";}s:2:"id";s:49:"node.localgov_directories_venue.localgov_location";s:10:"field_name";s:17:"localgov_location";s:11:"entity_type";s:4:"node";s:6:"bundle";s:26:"localgov_directories_venue";s:5:"label";s:8:"Location";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:20:"default:localgov_geo";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:2:{s:7:"address";s:7:"address";s:4:"area";s:4:"area";}s:4:"sort";a:2:{s:5:"field";s:5:"_none";s:9:"direction";s:3:"ASC";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:7:"address";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directory.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"272e06b9-b5d2-4b73-93cf-7747c896a0c9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:28:"node.type.localgov_directory";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tQ7X7YO_ePRWvxHt-4WSUirV5eR0vWy448fMO7ztnOE";}s:2:"id";s:28:"node.localgov_directory.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:18:"localgov_directory";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directory.localgov_directory_channel_types',
  'data' => 'a:17:{s:4:"uuid";s:36:"a379217f-fa10-44f7-8595-0cb76c8cf93b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:2:{i:0;s:51:"field.storage.node.localgov_directory_channel_types";i:1;s:28:"node.type.localgov_directory";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FdnrUZ0DQeOiTC4AonrNOBZNLxwehfsV4u70zrQG6pQ";}s:2:"id";s:56:"node.localgov_directory.localgov_directory_channel_types";s:10:"field_name";s:32:"localgov_directory_channel_types";s:11:"entity_type";s:4:"node";s:6:"bundle";s:18:"localgov_directory";s:5:"label";s:21:"Enabled Content types";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:32:"localgov_directories_entry_types";s:16:"handler_settings";a:0:{}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_directory.localgov_directory_facets_enable',
  'data' => 'a:17:{s:4:"uuid";s:36:"74287d46-176e-46a6-9609-70ffaef1e00c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:2:{i:0;s:51:"field.storage.node.localgov_directory_facets_enable";i:1;s:28:"node.type.localgov_directory";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YYGa-gLKtSpfzQsa_TxV2OT1CqU3pLRtHeUjUS6mhog";}s:2:"id";s:56:"node.localgov_directory.localgov_directory_facets_enable";s:10:"field_name";s:32:"localgov_directory_facets_enable";s:11:"entity_type";s:4:"node";s:6:"bundle";s:18:"localgov_directory";s:5:"label";s:14:"Enabled Facets";s:11:"description";s:133:"Which facets are enabled to be shown on this directory channel, and will be added when editing content to be added to this directory.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:40:"default:localgov_directories_facets_type";s:16:"handler_settings";a:2:{s:14:"target_bundles";N;s:11:"auto_create";b:0;}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_event.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"5c36aeb9-9072-43c5-9854-b79bc0a50617";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:24:"node.type.localgov_event";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YtNkxaK2pSTaOWvUC9-_xmLO-cJSG0SKkRb4Us72YN0";}s:2:"id";s:24:"node.localgov_event.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_event.localgov_event_call_to_action',
  'data' => 'a:17:{s:4:"uuid";s:36:"6cf24e86-605c-40f5-b704-ea954e937bd5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:48:"field.storage.node.localgov_event_call_to_action";i:1;s:24:"node.type.localgov_event";}s:6:"module";a:1:{i:0;s:4:"link";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"l-ZvcPYaiILIgwuq4fVAlVLw4ykBRo00GMnybWuEuLk";}s:2:"id";s:49:"node.localgov_event.localgov_event_call_to_action";s:10:"field_name";s:29:"localgov_event_call_to_action";s:11:"entity_type";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:5:"label";s:14:"Call to action";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:9:"link_type";i:17;s:5:"title";i:2;}s:10:"field_type";s:4:"link";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_event.localgov_event_categories',
  'data' => 'a:17:{s:4:"uuid";s:36:"b216b4b4-2fed-49f0-a461-69d0182a4a5f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:44:"field.storage.node.localgov_event_categories";i:1;s:24:"node.type.localgov_event";i:2;s:43:"taxonomy.vocabulary.localgov_event_category";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KTJ1iEyP2hWjnj3J2BvZhlcdtTdBy68gtsrJ5-mAOvc";}s:2:"id";s:45:"node.localgov_event.localgov_event_categories";s:10:"field_name";s:25:"localgov_event_categories";s:11:"entity_type";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:5:"label";s:10:"Categories";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:23:"localgov_event_category";s:23:"localgov_event_category";}s:4:"sort";a:2:{s:5:"field";s:4:"name";s:9:"direction";s:3:"asc";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_event.localgov_event_date',
  'data' => 'a:17:{s:4:"uuid";s:36:"6c7c056f-09fc-4d48-bc05-68ffdf68cdbe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:38:"field.storage.node.localgov_event_date";i:1;s:24:"node.type.localgov_event";}s:6:"module";a:1:{i:0;s:10:"date_recur";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YqRlDKPXqaWJ6CPWLpbajh2_8G9pb0pSvNAaQrQjWuY";}s:2:"id";s:39:"node.localgov_event.localgov_event_date";s:10:"field_name";s:19:"localgov_event_date";s:11:"entity_type";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:5:"label";s:4:"Date";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:7:{s:17:"default_date_type";s:3:"now";s:12:"default_date";s:3:"now";s:21:"default_end_date_type";s:3:"now";s:16:"default_end_date";s:3:"now";s:22:"default_date_time_zone";s:13:"Europe/London";s:17:"default_time_zone";s:13:"Europe/London";s:13:"default_rrule";s:0:"";}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:9:"precreate";s:3:"P2Y";s:5:"parts";a:2:{s:3:"all";b:1;s:11:"frequencies";a:7:{s:8:"SECONDLY";a:0:{}s:8:"MINUTELY";a:0:{}s:6:"HOURLY";a:0:{}s:5:"DAILY";a:0:{}s:6:"WEEKLY";a:0:{}s:7:"MONTHLY";a:0:{}s:6:"YEARLY";a:0:{}}}}s:10:"field_type";s:10:"date_recur";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_event.localgov_event_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"5d75b905-6ff9-4247-beea-30631f5a056d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:39:"field.storage.node.localgov_event_image";i:1;s:16:"media.type.image";i:2;s:24:"node.type.localgov_event";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cvnccWUuVm9JNdV_Mi2Z77Zvua--8LHssyQKWtZXCPc";}s:2:"id";s:40:"node.localgov_event.localgov_event_image";s:10:"field_name";s:20:"localgov_event_image";s:11:"entity_type";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:13:"default:media";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:5:"image";s:5:"image";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_event.localgov_event_locality',
  'data' => 'a:17:{s:4:"uuid";s:36:"0474a352-855e-4145-ac90-733d9c955e10";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:42:"field.storage.node.localgov_event_locality";i:1;s:24:"node.type.localgov_event";i:2;s:43:"taxonomy.vocabulary.localgov_event_locality";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HB9MjVqlhdhQiIDO94TOQXLkgZBgx0zUNPhjvqK1hJQ";}s:2:"id";s:43:"node.localgov_event.localgov_event_locality";s:10:"field_name";s:23:"localgov_event_locality";s:11:"entity_type";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:5:"label";s:13:"Neighbourhood";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:23:"localgov_event_locality";s:23:"localgov_event_locality";}s:4:"sort";a:2:{s:5:"field";s:4:"name";s:9:"direction";s:3:"asc";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_event.localgov_event_location',
  'data' => 'a:17:{s:4:"uuid";s:36:"65d8a3ef-98bc-411c-bef0-eee66c5883fb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:42:"field.storage.node.localgov_event_location";i:1;s:38:"localgov_geo.localgov_geo_type.address";i:2;s:24:"node.type.localgov_event";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"GgXBcCdtTaCofg0w7PFGV3PoPhrfYOfNLjERM0FFs7w";}s:2:"id";s:43:"node.localgov_event.localgov_event_location";s:10:"field_name";s:23:"localgov_event_location";s:11:"entity_type";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:5:"label";s:8:"Location";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:20:"default:localgov_geo";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:7:"address";s:7:"address";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_event.localgov_event_price',
  'data' => 'a:17:{s:4:"uuid";s:36:"b869c117-0cfd-476e-96b0-11e3d21ffee1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:39:"field.storage.node.localgov_event_price";i:1;s:24:"node.type.localgov_event";i:2;s:40:"taxonomy.vocabulary.localgov_event_price";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sWUo3xE-gbWgvEiMeXn6BsRZXjYJX05EpBKPOz0kGuA";}s:2:"id";s:40:"node.localgov_event.localgov_event_price";s:10:"field_name";s:20:"localgov_event_price";s:11:"entity_type";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:5:"label";s:5:"Price";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:20:"localgov_event_price";s:20:"localgov_event_price";}s:4:"sort";a:2:{s:5:"field";s:4:"name";s:9:"direction";s:3:"asc";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.localgov_event.localgov_event_venue',
  'data' => 'a:17:{s:4:"uuid";s:36:"7d38d638-f3f9-432f-856d-6013afca5a7a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:39:"field.storage.node.localgov_event_venue";i:1;s:36:"node.type.localgov_directories_venue";i:2;s:24:"node.type.localgov_event";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a41UiwIoXqgJj0bc2oatun8zruKhTF6EIHPBRsUKWxw";}s:2:"id";s:40:"node.localgov_event.localgov_event_venue";s:10:"field_name";s:20:"localgov_event_venue";s:11:"entity_type";s:4:"node";s:6:"bundle";s:14:"localgov_event";s:5:"label";s:5:"Venue";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:12:"default:node";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.page.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"0c3a1921-4571-414b-bb45-b63a8cdbdb1c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KgVkxLl_K3E3lvN6CEoWQIDT0V8J4Mv-fVYrAIc7-FE";}s:2:"id";s:14:"node.page.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.node.test.field_alternate_reference',
  'data' => 'a:16:{s:4:"uuid";s:36:"9ff38168-afb4-47da-9441-d4b949b46636";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:44:"field.storage.node.field_alternate_reference";i:1;s:38:"localgov_geo.localgov_geo_type.address";i:2;s:14:"node.type.test";}}s:2:"id";s:35:"node.test.field_alternate_reference";s:10:"field_name";s:25:"field_alternate_reference";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"test";s:5:"label";s:19:"Alternate reference";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:20:"default:localgov_geo";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:7:"address";s:7:"address";}s:4:"sort";a:2:{s:5:"field";s:5:"_none";s:9:"direction";s:3:"ASC";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.field.user.user.user_picture',
  'data' => 'a:17:{s:4:"uuid";s:36:"c0dcf408-93ac-4ba4-b10c-1e4b1ab11a16";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"field.storage.user.user_picture";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"twhm-ZOwSVkUjuLI_pQsaPo_pVLcqFfDmY-ojfqw0yk";}s:2:"id";s:22:"user.user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:7:"Picture";s:11:"description";s:29:"Your virtual face or picture.";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:40:"pictures/[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:0;s:18:"alt_field_required";b:0;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}',
))
->values(array(
  'collection' => '',
  'name' => 'field.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0";}s:16:"purge_batch_size";i:50;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.block_content.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"bbd44100-8627-434e-8c8b-378781f82766";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:2:"id";s:18:"block_content.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.comment.comment_body',
  'data' => 'a:17:{s:4:"uuid";s:36:"54b5ac09-c800-4aeb-a091-ddd69f57aee3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:2:"id";s:20:"comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.localgov_geo.accessibility',
  'data' => 'a:17:{s:4:"uuid";s:36:"d49ea706-d522-4c4c-b934-733e80fc9a1c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:12:"localgov_geo";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yVrBXZ34al69gVviC5s1bEuPLQxYIlHL1UZIUzO2RqU";}s:2:"id";s:26:"localgov_geo.accessibility";s:10:"field_name";s:13:"accessibility";s:11:"entity_type";s:12:"localgov_geo";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.localgov_geo.external_id',
  'data' => 'a:17:{s:4:"uuid";s:36:"eba86cf4-f724-4209-b6cf-3b70e020b661";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:12:"localgov_geo";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ClisQUKIyuIktxFFUy_zKmLoqr3F0VXiNQ_bJnzeKwk";}s:2:"id";s:24:"localgov_geo.external_id";s:10:"field_name";s:11:"external_id";s:11:"entity_type";s:12:"localgov_geo";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.localgov_geo.geo_file',
  'data' => 'a:17:{s:4:"uuid";s:36:"3da59a11-4ec0-4084-a734-a7e15c074362";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:12:"localgov_geo";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8jfbLnG3gHo0MvNlGiXWloESsVjfyrAK5XSQBSkV-ak";}s:2:"id";s:21:"localgov_geo.geo_file";s:10:"field_name";s:8:"geo_file";s:11:"entity_type";s:12:"localgov_geo";s:4:"type";s:4:"file";s:8:"settings";a:4:{s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:11:"target_type";s:4:"file";}s:6:"module";s:4:"file";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.localgov_geo.location',
  'data' => 'a:17:{s:4:"uuid";s:36:"37f4507b-f96f-4c27-90b2-50e90bcf7a4a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:8:"geofield";i:1;s:12:"localgov_geo";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PC72HRucTHnf9xj5kbJLajsbMXOfmfm0KhrnvKpK0Vg";}s:2:"id";s:21:"localgov_geo.location";s:10:"field_name";s:8:"location";s:11:"entity_type";s:12:"localgov_geo";s:4:"type";s:8:"geofield";s:8:"settings";a:1:{s:7:"backend";s:24:"geofield_backend_default";}s:6:"module";s:8:"geofield";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.localgov_geo.postal_address',
  'data' => 'a:17:{s:4:"uuid";s:36:"32e2849f-77cd-4018-8796-37800beb54c0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"address";i:1;s:12:"localgov_geo";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VIWZ21SnurbV-haUpJjLETVA-bJqtxqt7g3YWGP7kYY";}s:2:"id";s:27:"localgov_geo.postal_address";s:10:"field_name";s:14:"postal_address";s:11:"entity_type";s:12:"localgov_geo";s:4:"type";s:7:"address";s:8:"settings";a:0:{}s:6:"module";s:7:"address";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.media.field_media_audio_file',
  'data' => 'a:17:{s:4:"uuid";s:36:"0d5bee0f-0cf3-4825-a535-b59f9ea48013";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JCHoh95CpUeBx9ch24Tmi6ru0nwmNz8xWVH4Qs7RnTg";}s:2:"id";s:28:"media.field_media_audio_file";s:10:"field_name";s:22:"field_media_audio_file";s:11:"entity_type";s:5:"media";s:4:"type";s:4:"file";s:8:"settings";a:4:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";}s:6:"module";s:4:"file";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.media.field_media_document',
  'data' => 'a:17:{s:4:"uuid";s:36:"4aad5a9e-3d9f-45d0-96bd-88508a31012b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:5:"media";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BdkTx7IL59MCw5a_fOZprPTOGM_wcjz-Fm8g7HV3vFk";}s:2:"id";s:26:"media.field_media_document";s:10:"field_name";s:20:"field_media_document";s:11:"entity_type";s:5:"media";s:4:"type";s:4:"file";s:8:"settings";a:4:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";}s:6:"module";s:4:"file";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.media.field_media_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"27419451-af38-40c0-8212-821d1ffadc91";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:5:"media";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0N0KSFk57p6qsq3qM4lYVGSuROvzXK-tSsdwByqUh3g";}s:2:"id";s:23:"media.field_media_image";s:10:"field_name";s:17:"field_media_image";s:11:"entity_type";s:5:"media";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.media.field_media_oembed_video',
  'data' => 'a:17:{s:4:"uuid";s:36:"127b7469-4408-4573-82e5-ceac64309950";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cNf_852Dq-fNnSaMI4LxL-J6N7bLkHuDbD9EUqOn4_U";}s:2:"id";s:30:"media.field_media_oembed_video";s:10:"field_name";s:24:"field_media_oembed_video";s:11:"entity_type";s:5:"media";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:14:"case_sensitive";b:0;s:8:"is_ascii";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.media.field_media_video_file',
  'data' => 'a:17:{s:4:"uuid";s:36:"d24262ed-00a7-44d8-b124-4ac29af9ac73";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z5mgbn1PIVZ5TNMByBmivqo_u3Rdk58UIzpyN4ypTeM";}s:2:"id";s:28:"media.field_media_video_file";s:10:"field_name";s:22:"field_media_video_file";s:11:"entity_type";s:5:"media";s:4:"type";s:4:"file";s:8:"settings";a:4:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";}s:6:"module";s:4:"file";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.body',
  'data' => 'a:17:{s:4:"uuid";s:36:"c0288b99-53f7-4261-8fe4-a014da6aa20d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:2:"id";s:9:"node.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.comment',
  'data' => 'a:17:{s:4:"uuid";s:36:"ede08cae-6b92-442d-a31f-d65a569e7027";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:2:"id";s:12:"node.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:4:"type";s:7:"comment";s:8:"settings";a:1:{s:12:"comment_type";s:7:"comment";}s:6:"module";s:7:"comment";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_alternate_reference',
  'data' => 'a:16:{s:4:"uuid";s:36:"92c442bb-bc48-4979-8901-512aebb04313";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:12:"localgov_geo";i:1;s:4:"node";}}s:2:"id";s:30:"node.field_alternate_reference";s:10:"field_name";s:25:"field_alternate_reference";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:12:"localgov_geo";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"a29175bb-7e2a-436b-b2fe-0a97451d447e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE";}s:2:"id";s:16:"node.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_media_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"af08b0d1-2212-4837-a72d-5585fcbeffda";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:5:"media";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0Js1u6vPgc9HfguDX8RT0LRwZh6-JU34vN8DsgMrDPQ";}s:2:"id";s:22:"node.field_media_image";s:10:"field_name";s:17:"field_media_image";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:5:"media";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.field_tags',
  'data' => 'a:17:{s:4:"uuid";s:36:"5b59cd50-9ed2-4467-b78d-6f1da5f458f8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:2:"id";s:15:"node.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_address',
  'data' => 'a:17:{s:4:"uuid";s:36:"05cea849-c240-4104-9707-0cc9881cedd6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"address";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rFSBPYWV0Wes2mq7fDuc9M1rgv_wPFFLvmWHK0-DFm4";}s:2:"id";s:31:"node.localgov_directory_address";s:10:"field_name";s:26:"localgov_directory_address";s:11:"entity_type";s:4:"node";s:4:"type";s:7:"address";s:8:"settings";a:0:{}s:6:"module";s:7:"address";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_channels',
  'data' => 'a:17:{s:4:"uuid";s:36:"e15f7237-4663-41fc-ae91-7d590f170fdb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"84Fw-DA-kAyFo_NyyTnPIhXi57Z7UP_lBAa4jFo7xW0";}s:2:"id";s:32:"node.localgov_directory_channels";s:10:"field_name";s:27:"localgov_directory_channels";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:4:"node";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_channel_types',
  'data' => 'a:17:{s:4:"uuid";s:36:"afc11e4a-8005-4386-9cd5-7b8f592928a2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"L_JDKjSEb7D3Hpxutg4MJCDN36qIChvG0O8zQhS2Rb8";}s:2:"id";s:37:"node.localgov_directory_channel_types";s:10:"field_name";s:32:"localgov_directory_channel_types";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:9:"node_type";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_email',
  'data' => 'a:17:{s:4:"uuid";s:36:"f85f7a02-d138-46bd-9968-adfcb6141dd1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"09rUfkWDzQlS2BIa9zYdicXmD1U2SK3pw9Yg6mE2BCI";}s:2:"id";s:29:"node.localgov_directory_email";s:10:"field_name";s:24:"localgov_directory_email";s:11:"entity_type";s:4:"node";s:4:"type";s:5:"email";s:8:"settings";a:0:{}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_facets_enable',
  'data' => 'a:17:{s:4:"uuid";s:36:"5105a991-8638-4e3b-9e82-74c78a22eb26";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:20:"localgov_directories";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Klc8XMC0MqbNrd-0EW7fAYp_qVPUgi4Z7CI4BoSRvYo";}s:2:"id";s:37:"node.localgov_directory_facets_enable";s:10:"field_name";s:32:"localgov_directory_facets_enable";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:32:"localgov_directories_facets_type";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_facets_select',
  'data' => 'a:17:{s:4:"uuid";s:36:"cf481f7a-5b21-4157-b83f-d73ddef66b84";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:20:"localgov_directories";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JwIkvWuSMJSBsgsyCdz6iKh12KrN7frU0_JaXeJS5mQ";}s:2:"id";s:37:"node.localgov_directory_facets_select";s:10:"field_name";s:32:"localgov_directory_facets_select";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:27:"localgov_directories_facets";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_files',
  'data' => 'a:17:{s:4:"uuid";s:36:"3e825878-5567-4e29-b846-7c624bb2a6f5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:5:"media";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YQRTJWNqYP9wSPe0_duLAqkvA2H4ugKMCORbtdgDSik";}s:2:"id";s:29:"node.localgov_directory_files";s:10:"field_name";s:24:"localgov_directory_files";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:5:"media";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_job_title',
  'data' => 'a:17:{s:4:"uuid";s:36:"2fc286a2-294a-4d63-9fab-83f2499303fd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"qEeRgZ6BrzvrFf_A6RsSlAmDsbSR9v1jYCGf2kBtJO8";}s:2:"id";s:33:"node.localgov_directory_job_title";s:10:"field_name";s:28:"localgov_directory_job_title";s:11:"entity_type";s:4:"node";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_name',
  'data' => 'a:17:{s:4:"uuid";s:36:"4e4b8ec4-4b8a-40e3-a0b7-42ebfbd6f1d9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UahIuJ5Yu-6NibtaCm2319o9bvymXv9XuVfoeYTmJwY";}s:2:"id";s:28:"node.localgov_directory_name";s:10:"field_name";s:23:"localgov_directory_name";s:11:"entity_type";s:4:"node";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_notes',
  'data' => 'a:17:{s:4:"uuid";s:36:"c55c014e-0daa-47fe-942e-86b015352ff4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t-O0WDZ0fVxIoYqd2UaiB_7cOdy8xP4TuZRwsOchw6Q";}s:2:"id";s:29:"node.localgov_directory_notes";s:10:"field_name";s:24:"localgov_directory_notes";s:11:"entity_type";s:4:"node";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_opening_times',
  'data' => 'a:17:{s:4:"uuid";s:36:"fbfcfcb7-b6b9-44b9-a764-fce7334da1b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CsvosQAFs6eYXocNGqxLdxLF3J9NscpSpa8hi74Q9V8";}s:2:"id";s:37:"node.localgov_directory_opening_times";s:10:"field_name";s:32:"localgov_directory_opening_times";s:11:"entity_type";s:4:"node";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_phone',
  'data' => 'a:17:{s:4:"uuid";s:36:"187f86ab-8c5b-448d-90cd-96cdf8fc3d22";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:9:"telephone";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HkUEFc38Nh6p_Y6lnmmebTjXzo77IPAYzNNbIUpBEXg";}s:2:"id";s:29:"node.localgov_directory_phone";s:10:"field_name";s:24:"localgov_directory_phone";s:11:"entity_type";s:4:"node";s:4:"type";s:9:"telephone";s:8:"settings";a:0:{}s:6:"module";s:9:"telephone";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_title_sort',
  'data' => 'a:17:{s:4:"uuid";s:36:"a67dd86a-43a0-4370-b75f-0750d9b0687b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKYSMfF33z4KroklfDAixQtspYvBmtG3XBfdavaq9f8";}s:2:"id";s:34:"node.localgov_directory_title_sort";s:10:"field_name";s:29:"localgov_directory_title_sort";s:11:"entity_type";s:4:"node";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_directory_website',
  'data' => 'a:17:{s:4:"uuid";s:36:"d485b11b-b280-4216-b87f-19c4cc8cd3af";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"link";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6Msq4vx1N_UJkVhwfEEEuToXu-x8gSU5oA3jmFBVnvQ";}s:2:"id";s:31:"node.localgov_directory_website";s:10:"field_name";s:26:"localgov_directory_website";s:11:"entity_type";s:4:"node";s:4:"type";s:4:"link";s:8:"settings";a:0:{}s:6:"module";s:4:"link";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_email_address',
  'data' => 'a:17:{s:4:"uuid";s:36:"96d3c6aa-3331-4482-ba05-c95783876bce";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"i7xswioyMQSGoGyp4FZg2MhjSUIU1Talpk0_rTBn2yA";}s:2:"id";s:27:"node.localgov_email_address";s:10:"field_name";s:22:"localgov_email_address";s:11:"entity_type";s:4:"node";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_event_call_to_action',
  'data' => 'a:17:{s:4:"uuid";s:36:"5a782dc2-2cd8-4d69-9b3b-11f49fe89f38";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"link";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nWNViYeDfr62m34rb5zYS6Y2haqRUKFeZLP-atpVvW0";}s:2:"id";s:34:"node.localgov_event_call_to_action";s:10:"field_name";s:29:"localgov_event_call_to_action";s:11:"entity_type";s:4:"node";s:4:"type";s:4:"link";s:8:"settings";a:0:{}s:6:"module";s:4:"link";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_event_categories',
  'data' => 'a:17:{s:4:"uuid";s:36:"593846c5-c57b-4caa-84c9-a221d50eb977";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1ud2V9Cm0timiYEpywwgzD4_6gZDaOdRc-yVqFyQzH4";}s:2:"id";s:30:"node.localgov_event_categories";s:10:"field_name";s:25:"localgov_event_categories";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_event_date',
  'data' => 'a:17:{s:4:"uuid";s:36:"cadac30b-5414-4f61-a2fe-9b4334466c49";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:10:"date_recur";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mXQQZdfH_Qjw3Ve90JynK9bfFi_aPRhWnrmYng1ArcA";}s:2:"id";s:24:"node.localgov_event_date";s:10:"field_name";s:19:"localgov_event_date";s:11:"entity_type";s:4:"node";s:4:"type";s:10:"date_recur";s:8:"settings";a:2:{s:13:"datetime_type";s:8:"datetime";s:16:"rrule_max_length";i:256;}s:6:"module";s:10:"date_recur";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_event_image',
  'data' => 'a:17:{s:4:"uuid";s:36:"117c16b6-4a0f-4339-9e40-7fbf4bc5b453";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:5:"media";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TWGsuhQypXPCYexMuMpErACUOvF-0bIOlchfUn9STl4";}s:2:"id";s:25:"node.localgov_event_image";s:10:"field_name";s:20:"localgov_event_image";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:5:"media";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_event_locality',
  'data' => 'a:17:{s:4:"uuid";s:36:"c671cfd4-5434-41fa-873b-b6752b80ef84";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fbAUrUbyy03mOco3Xvq26Qq01e9vC-xmHVU3PW-NcKc";}s:2:"id";s:28:"node.localgov_event_locality";s:10:"field_name";s:23:"localgov_event_locality";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_event_location',
  'data' => 'a:17:{s:4:"uuid";s:36:"2ad54306-14e0-4a93-8fb9-97b5aac2c1bf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:12:"localgov_geo";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zG_PsW2sz8I94X2roaDmVTeRACIqe9mVCspKaPKzTYc";}s:2:"id";s:28:"node.localgov_event_location";s:10:"field_name";s:23:"localgov_event_location";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:12:"localgov_geo";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_event_price',
  'data' => 'a:17:{s:4:"uuid";s:36:"eddc630f-9f88-4e23-960a-2b339ba6b6e4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sqyN_vJlD3kddhc4QBDFK3oVCKpAoNMfDtE-mm10RJc";}s:2:"id";s:25:"node.localgov_event_price";s:10:"field_name";s:20:"localgov_event_price";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_event_provider',
  'data' => 'a:17:{s:4:"uuid";s:36:"987180fb-72f3-4aa4-b470-22e1bb6144d3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yfPz8PueRbDhbS5FEEy0nmT1X_J8DXrQS0173nOKCdc";}s:2:"id";s:28:"node.localgov_event_provider";s:10:"field_name";s:23:"localgov_event_provider";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:4:"node";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_event_venue',
  'data' => 'a:17:{s:4:"uuid";s:36:"c97267b6-398e-4c7a-bfa0-a8e2406d524a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0VlFDF7Gju6mEUHI3__VOjdzGFZSCLYwmxjfmaUC4Mw";}s:2:"id";s:25:"node.localgov_event_venue";s:10:"field_name";s:20:"localgov_event_venue";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:4:"node";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_facebook',
  'data' => 'a:17:{s:4:"uuid";s:36:"d74d0c02-adca-4b0a-bd72-a65f30c37bea";s:8:"langcode";s:3:"und";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z-wHqndlcBrJXycSwbrSWMvCboiGFNVgJkfxuHz72A0";}s:2:"id";s:22:"node.localgov_facebook";s:10:"field_name";s:17:"localgov_facebook";s:11:"entity_type";s:4:"node";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_location',
  'data' => 'a:17:{s:4:"uuid";s:36:"9b3fd605-960b-4c22-adb2-70f1ff163aff";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:12:"localgov_geo";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"444N2Z2nKImtiaF0cFmikhnFVIjNjIFeCitnaNsKisE";}s:2:"id";s:22:"node.localgov_location";s:10:"field_name";s:17:"localgov_location";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:12:"localgov_geo";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_phone',
  'data' => 'a:17:{s:4:"uuid";s:36:"ad02794b-e0fe-4d0c-ad35-8651430191bd";s:8:"langcode";s:3:"und";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"59TiZEdRgVVwhOslPlM0eXMUFWbGOTK-RgcO_eMufsw";}s:2:"id";s:19:"node.localgov_phone";s:10:"field_name";s:14:"localgov_phone";s:11:"entity_type";s:4:"node";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_proximity_search_cfg',
  'data' => 'a:17:{s:4:"uuid";s:36:"b3d385e5-642a-40b2-ba44-a9f723c11ea5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fQvI0Vfg_M-kc5CzikK4tMXz6a2wl3ROuFLFeX4QPJU";}s:2:"id";s:34:"node.localgov_proximity_search_cfg";s:10:"field_name";s:29:"localgov_proximity_search_cfg";s:11:"entity_type";s:4:"node";s:4:"type";s:7:"boolean";s:8:"settings";a:0:{}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.node.localgov_twitter',
  'data' => 'a:17:{s:4:"uuid";s:36:"80c84b8b-fadf-4342-814c-b080a21b3914";s:8:"langcode";s:3:"und";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DmlapiDxO1FI-JKNCa23uTKLdQHBa-ezb1UcXFCj_iY";}s:2:"id";s:21:"node.localgov_twitter";s:10:"field_name";s:16:"localgov_twitter";s:11:"entity_type";s:4:"node";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field.storage.user.user_picture',
  'data' => 'a:17:{s:4:"uuid";s:36:"c6dad20d-ce56-4aa9-b6e3-2ab91605221a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E";}s:2:"id";s:17:"user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'field_ui.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q1nMi90W6YQxKzZAgJQw7Ag9U4JrsEUwkomF0lhvbIM";}s:12:"field_prefix";s:6:"field_";}',
))
->values(array(
  'collection' => '',
  'name' => 'file.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0aMkoXYnax5_tHI9C9zHs-K48KJ6K75PHtD9x-0nbgM";}s:11:"description";a:2:{s:4:"type";s:9:"textfield";s:6:"length";i:128;}s:4:"icon";a:1:{s:9:"directory";s:23:"core/modules/file/icons";}s:35:"make_unused_managed_files_temporary";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.basic_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"700ad702-3ba2-45e7-9e9d-65a699c29f42";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RjoJPQLCAE8u1Ys_yCKubpkYlRz_Oy12a5qCVeNIHJ8";}s:4:"name";s:10:"Basic HTML";s:6:"format";s:10:"basic_html";s:6:"weight";i:0;s:7:"filters";a:5:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:243:"<br> <p> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <cite> <dl> <dt> <dd> <a hreflang href> <blockquote cite> <ul type> <ol start type> <strong> <em> <code> <li> <img src alt data-entity-uuid data-entity-type height width data-caption data-align>";s:16:"filter_html_help";b:0;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:7;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:24:"filter_html_image_secure";a:5:{s:2:"id";s:24:"filter_html_image_secure";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.full_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"75944881-838c-4bb1-a08f-042c43d9b2c3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WNeK5FbcY8pXgEpbD_KgRzlF1-5PL3BJXwqaBctPTqw";}s:4:"name";s:9:"Full HTML";s:6:"format";s:9:"full_html";s:6:"weight";i:2;s:7:"filters";a:4:{s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:10;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.plain_text',
  'data' => 'a:9:{s:4:"uuid";s:36:"1b61b49d-5b53-415f-8603-056b7e600a76";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NIKBt6kw_uPhNI0qtR2DnRf7mSOgAQdx7Q94SKMjXbQ";}s:4:"name";s:10:"Plain text";s:6:"format";s:10:"plain_text";s:6:"weight";i:10;s:7:"filters";a:3:{s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.restricted_html',
  'data' => 'a:9:{s:4:"uuid";s:36:"7f188e06-a587-4b21-9177-5f16d1235231";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oz6NyPDAB4HB6N9hgH2LwNVtCd-sXbMG1fbn5KsRIDI";}s:4:"name";s:15:"Restricted HTML";s:6:"format";s:15:"restricted_html";s:6:"weight";i:1;s:7:"filters";a:3:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:149:"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>";s:16:"filter_html_help";b:1;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.format.wysiwyg',
  'data' => 'a:9:{s:4:"uuid";s:36:"ed1bc783-934e-4fea-b392-77e854411e6b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.medium_8_7";i:1;s:42:"core.entity_view_mode.media.responsive_3x2";i:2;s:48:"core.entity_view_mode.media.scale_crop_7_3_large";i:3;s:34:"core.entity_view_mode.media.square";}s:6:"module";a:3:{i:0;s:6:"editor";i:1;s:6:"linkit";i:2;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DsgACm5gAgK8K1UNs_KD3K7ryJg0n9yQIWMYYuKb8Tw";}s:4:"name";s:7:"WYSIWYG";s:6:"format";s:7:"wysiwyg";s:6:"weight";i:0;s:7:"filters";a:11:{s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:-44;s:8:"settings";a:0:{}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-43;s:8:"settings";a:0:{}}s:24:"filter_html_image_secure";a:5:{s:2:"id";s:24:"filter_html_image_secure";s:8:"provider";s:6:"filter";s:6:"status";b:0;s:6:"weight";i:-40;s:8:"settings";a:0:{}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-49;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:0;s:6:"weight";i:-41;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:0;s:6:"weight";i:-42;s:8:"settings";a:0:{}}s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-47;s:8:"settings";a:3:{s:12:"allowed_html";s:711:"<em> <strong> <cite> <blockquote cite> <code> <ol type start> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <p class="alert alert-info alert-danger alert-primary alert-success callout callout-primary callout-success callout-danger callout-teal callout-carbon callout-yellow"> <h1> <pre> <mark> <a href hreflang data-entity-substitution data-entity-type data-entity-uuid title class="external-link pdf-link btn btn-start col-sm-6 mt-3"> <ul type class="list-checked"> <u> <img src alt data-entity-type data-entity-uuid data-align data-caption> <drupal-media data-entity-type data-entity-uuid data-view-mode data-align data-caption alt title> <table> <caption> <tbody> <thead> <tfoot> <th> <td> <tr>";s:16:"filter_html_help";b:1;s:20:"filter_html_nofollow";b:0;}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-48;s:8:"settings";a:0:{}}s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:0;s:6:"weight";i:-45;s:8:"settings";a:0:{}}s:6:"linkit";a:5:{s:2:"id";s:6:"linkit";s:8:"provider";s:6:"linkit";s:6:"status";b:1;s:6:"weight";i:-50;s:8:"settings";a:1:{s:5:"title";b:1;}}s:11:"media_embed";a:5:{s:2:"id";s:11:"media_embed";s:8:"provider";s:5:"media";s:6:"status";b:1;s:6:"weight";i:-46;s:8:"settings";a:3:{s:17:"default_view_mode";s:14:"responsive_3x2";s:18:"allowed_view_modes";a:5:{s:7:"default";s:7:"default";s:10:"medium_8_7";s:10:"medium_8_7";s:14:"responsive_3x2";s:14:"responsive_3x2";s:20:"scale_crop_7_3_large";s:20:"scale_crop_7_3_large";s:6:"square";s:6:"square";}s:19:"allowed_media_types";a:3:{s:8:"document";s:8:"document";s:5:"image";s:5:"image";s:12:"remote_video";s:12:"remote_video";}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'filter.settings',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA";}s:15:"fallback_format";s:10:"plain_text";s:27:"always_show_fallback_choice";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'geocoder.geocoder_provider.file',
  'data' => 'a:9:{s:4:"uuid";s:36:"92e501c2-f16b-4fc0-965b-c40d605bab3d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:14:"geocoder_field";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VWIMgsYPqwO5KxMh1FAGdjk-723plvq8YONcX0RONos";}s:2:"id";s:4:"file";s:5:"label";s:4:"File";s:6:"plugin";s:4:"file";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'geocoder.geocoder_provider.geojson_file',
  'data' => 'a:9:{s:4:"uuid";s:36:"f7ab62af-8edf-4a5d-8f46-40579d7b42e3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:17:"geocoder_geofield";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hPsWn6WhIbkx1E0xAlZ5n_C8aBY2x67swLbXXl8kGrQ";}s:2:"id";s:12:"geojson_file";s:5:"label";s:12:"GeoJson File";s:6:"plugin";s:11:"geojsonfile";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'geocoder.geocoder_provider.gpx_file',
  'data' => 'a:9:{s:4:"uuid";s:36:"ba0c599a-de06-4083-a215-5b8f4401e1a7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:17:"geocoder_geofield";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MUY5wbLRpAnVFjMmQcfHrZ-rzoTvX-xeX8VT-T8yH2M";}s:2:"id";s:8:"gpx_file";s:5:"label";s:8:"GPX File";s:6:"plugin";s:7:"gpxfile";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'geocoder.geocoder_provider.kml_file',
  'data' => 'a:9:{s:4:"uuid";s:36:"bdf25e2e-d96b-4857-8489-a697d01a38d6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:17:"geocoder_geofield";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Iz5RanuE22G7V_Dza-tRy6mZFBV6SU6_61pXPjMamQw";}s:2:"id";s:8:"kml_file";s:5:"label";s:8:"KML File";s:6:"plugin";s:7:"kmlfile";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'geocoder.geocoder_provider.localgov_default_osm',
  'data' => 'a:9:{s:4:"uuid";s:36:"41045779-17a7-485f-84e3-3a6b85b97aca";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zq3uqM0zRR4OQluD3bdNO0faTE8NZoZgTdqp6yUB7nc";}s:2:"id";s:20:"localgov_default_osm";s:5:"label";s:13:"OpenStreetMap";s:6:"plugin";s:13:"openstreetmap";s:13:"configuration";a:4:{s:7:"rootUrl";s:35:"https://nominatim.openstreetmap.org";s:9:"userAgent";s:14:"LocalGovDrupal";s:7:"referer";s:27:"https://localgov.lndo.site/";s:8:"throttle";a:2:{s:6:"period";i:2;s:5:"limit";i:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'geocoder.settings',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5P0QjCOMc-OzCEJUXsMfJWVEj_K97A4OFOhGqnb5Seg";}s:25:"geocoder_presave_disabled";b:0;s:5:"cache";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'geofield_map.settings',
  'data' => 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0cOpr1OyXWdffdvJFlXdoNQpPest7EYeepdwUe7U9pQ";}s:12:"gmap_api_key";s:0:"";s:21:"gmap_api_localization";s:7:"default";s:7:"theming";a:4:{s:16:"markers_location";a:2:{s:8:"security";s:9:"public://";s:8:"rel_path";s:17:"geofieldmap_icons";}s:27:"additional_markers_location";s:0:"";s:18:"markers_extensions";s:16:"gif png jpg jpeg";s:16:"markers_filesize";s:6:"250 KB";}s:8:"geocoder";a:1:{s:7:"caching";a:1:{s:10:"clientside";s:15:"session_storage";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw";}s:13:"preview_image";s:29:"core/modules/image/sample.png";s:26:"allow_insecure_derivatives";b:0;s:20:"suppress_itok_output";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.crop_thumbnail',
  'data' => 'a:8:{s:4:"uuid";s:36:"c685c61d-1a83-4eb4-9b1f-c12f5aea9d89";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N1S0PHZeyxfFqgzB-sDeGPaxi0dDOL8NUiP_d6WXSV0";}s:4:"name";s:14:"crop_thumbnail";s:5:"label";s:14:"Crop thumbnail";s:7:"effects";a:1:{s:36:"8fc26706-68dc-4eb7-8121-33e3936ed55f";a:4:{s:4:"uuid";s:36:"8fc26706-68dc-4eb7-8121-33e3936ed55f";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:400;s:6:"height";N;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.freestyle_lg',
  'data' => 'a:8:{s:4:"uuid";s:36:"e1367425-8c53-4fb7-a2ee-2736d7cee53d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:19:"crop.type.freestyle";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"y-vOF-SLaJPIYAGSaBg41rpzGFp4e47n_hV76tyEJqg";}s:4:"name";s:12:"freestyle_lg";s:5:"label";s:12:"Freestyle LG";s:7:"effects";a:2:{s:36:"b8c9ed50-b967-42d0-ae44-c7ee81e2daa3";a:4:{s:4:"uuid";s:36:"b8c9ed50-b967-42d0-ae44-c7ee81e2daa3";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:9:"freestyle";s:23:"automatic_crop_provider";N;}}s:36:"3905f2d7-b5ce-4004-a356-e6502f7f1700";a:4:{s:4:"uuid";s:36:"3905f2d7-b5ce-4004-a356-e6502f7f1700";s:2:"id";s:11:"image_scale";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:1200;s:6:"height";N;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.freestyle_md',
  'data' => 'a:8:{s:4:"uuid";s:36:"c4de7465-c204-420d-8d83-998382183c79";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:19:"crop.type.freestyle";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q4uJCDHT-oY2EpiEgpPcd0tJ727PXAJhf50l40uG428";}s:4:"name";s:12:"freestyle_md";s:5:"label";s:12:"Freestyle MD";s:7:"effects";a:2:{s:36:"68824022-c5eb-440a-b04e-768413ea85a9";a:4:{s:4:"uuid";s:36:"68824022-c5eb-440a-b04e-768413ea85a9";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:9:"freestyle";s:23:"automatic_crop_provider";N;}}s:36:"f9ab7868-b066-4158-a7ec-eda160621255";a:4:{s:4:"uuid";s:36:"f9ab7868-b066-4158-a7ec-eda160621255";s:2:"id";s:11:"image_scale";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:992;s:6:"height";N;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.freestyle_sm',
  'data' => 'a:8:{s:4:"uuid";s:36:"479df4e0-e074-4c29-aca9-36fafffae5b1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:19:"crop.type.freestyle";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CkYetCCzeBS8NC2vLuxJ6ei1kXIStlCU-06vgZAVvVI";}s:4:"name";s:12:"freestyle_sm";s:5:"label";s:12:"Freestyle SM";s:7:"effects";a:2:{s:36:"33702ab0-f231-4efa-89e7-d64f2d0867d3";a:4:{s:4:"uuid";s:36:"33702ab0-f231-4efa-89e7-d64f2d0867d3";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:9:"freestyle";s:23:"automatic_crop_provider";N;}}s:36:"b3401a80-48de-4c67-816c-d8cd33ac8256";a:4:{s:4:"uuid";s:36:"b3401a80-48de-4c67-816c-d8cd33ac8256";s:2:"id";s:11:"image_scale";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:768;s:6:"height";N;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.freestyle_xl',
  'data' => 'a:8:{s:4:"uuid";s:36:"5e9486c9-47ff-4f71-9d3b-64774fefdacb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:19:"crop.type.freestyle";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oyE5jwkkTjciygbulG1LlwJ4QwmW6-Tb88TStx8ORRU";}s:4:"name";s:12:"freestyle_xl";s:5:"label";s:12:"Freestyle XL";s:7:"effects";a:1:{s:36:"bedb8b60-f088-4af7-9992-48673988a5b7";a:4:{s:4:"uuid";s:36:"bedb8b60-f088-4af7-9992-48673988a5b7";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:9:"freestyle";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.freestyle_xs',
  'data' => 'a:8:{s:4:"uuid";s:36:"f35aa517-f15e-4107-8a73-368a3f02100c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:19:"crop.type.freestyle";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6YWalQ3W9_TXX-1X8W6WPx9GwGdflun-SLNxOYfVjQg";}s:4:"name";s:12:"freestyle_xs";s:5:"label";s:12:"Freestyle XS";s:7:"effects";a:2:{s:36:"f3eb0e0f-2392-45c6-a7de-e4cb4fc1c9cf";a:4:{s:4:"uuid";s:36:"f3eb0e0f-2392-45c6-a7de-e4cb4fc1c9cf";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:9:"freestyle";s:23:"automatic_crop_provider";N;}}s:36:"60a82ceb-fb5b-4657-872c-c1e115529f21";a:4:{s:4:"uuid";s:36:"60a82ceb-fb5b-4657-872c-c1e115529f21";s:2:"id";s:11:"image_scale";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:576;s:6:"height";N;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.geofield_map_default_icon_style',
  'data' => 'a:8:{s:4:"uuid";s:36:"1017be4a-671b-439c-bb3d-dd54143bf44b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"qeXmbpcOBZ_DUk5IscywhUBtP66NYnpVwP-HrtMT7CQ";}s:4:"name";s:31:"geofield_map_default_icon_style";s:5:"label";s:38:"GeofieldMap Default Icon Style (34x34)";s:7:"effects";a:1:{s:36:"5d91fbd4-b0f7-43e0-b7a4-21b19cec068c";a:4:{s:4:"uuid";s:36:"5d91fbd4-b0f7-43e0-b7a4-21b19cec068c";s:2:"id";s:12:"image_resize";s:6:"weight";i:1;s:4:"data";a:2:{s:5:"width";i:34;s:6:"height";i:34;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large',
  'data' => 'a:8:{s:4:"uuid";s:36:"40a06198-9193-415d-bc1c-15d993f39c1c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"J2n0RpFzS0-bgSyxjs6rSdgxB1rb-bTAgqywNx_964M";}s:4:"name";s:5:"large";s:5:"label";s:16:"Large (480×480)";s:7:"effects";a:1:{s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";a:4:{s:4:"uuid";s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:480;s:6:"height";i:480;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large_21_9',
  'data' => 'a:8:{s:4:"uuid";s:36:"ad02a17c-d9eb-4c38-82bc-7dd47c4366e3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.7_3";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Tjl0Ma90LzstQrgt4buBptz9fnV5HesYEKFDcrcfvos";}s:4:"name";s:10:"large_21_9";s:5:"label";s:21:"Large 21:9 (1440x620)";s:7:"effects";a:2:{s:36:"90b69780-6eb1-4cc8-a500-88235ad52f5c";a:4:{s:4:"uuid";s:36:"90b69780-6eb1-4cc8-a500-88235ad52f5c";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:1440;s:6:"height";i:620;}}s:36:"16515f15-3ced-4a56-9020-14ed737fd05d";a:4:{s:4:"uuid";s:36:"16515f15-3ced-4a56-9020-14ed737fd05d";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"7_3";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large_21_9_2x',
  'data' => 'a:8:{s:4:"uuid";s:36:"018637c5-9598-4cc4-ad5f-ad381ed7fcf2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.7_3";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OGN6Mm90-aye9mNQsonRkx1j4UAUDL4LXWKxjevRbsU";}s:4:"name";s:13:"large_21_9_2x";s:5:"label";s:25:"Large 21:9 2x (2880x1240)";s:7:"effects";a:2:{s:36:"6b96b7e5-aabd-406e-86ec-2c2e2c18bd82";a:4:{s:4:"uuid";s:36:"6b96b7e5-aabd-406e-86ec-2c2e2c18bd82";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:2880;s:6:"height";i:1240;}}s:36:"fc3d68ba-e69d-4939-a76f-800c2c5f978b";a:4:{s:4:"uuid";s:36:"fc3d68ba-e69d-4939-a76f-800c2c5f978b";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"7_3";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large_28_9',
  'data' => 'a:8:{s:4:"uuid";s:36:"77c55319-1c7b-446b-bfca-4db6212566ff";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"crop.type.28_9";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BhhL8yawEV_SZYgf0d5jJgcuW1Wp0oOa6zfmG3tA0M0";}s:4:"name";s:10:"large_28_9";s:5:"label";s:21:"Large 28:9 (1440x463)";s:7:"effects";a:2:{s:36:"82d37cdd-c118-43db-984e-76114b834d8c";a:4:{s:4:"uuid";s:36:"82d37cdd-c118-43db-984e-76114b834d8c";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:4:"28_9";s:23:"automatic_crop_provider";N;}}s:36:"7235dcf5-1f60-45a5-95b6-57141d6693a0";a:4:{s:4:"uuid";s:36:"7235dcf5-1f60-45a5-95b6-57141d6693a0";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:1440;s:6:"height";i:463;s:6:"anchor";s:13:"center-center";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large_28_9_2x',
  'data' => 'a:8:{s:4:"uuid";s:36:"23ffcbdf-79ee-4a02-a5a0-2878667ea43f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"crop.type.28_9";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"23Sn7pJyl2ywlWqTRz0RaGNLJ_gE3YC7ZiHjHn0tucY";}s:4:"name";s:13:"large_28_9_2x";s:5:"label";s:24:"Large 28:9 2x (2880x926)";s:7:"effects";a:2:{s:36:"32a425dd-aab6-4f0f-9f0f-6a9a3ce0b228";a:4:{s:4:"uuid";s:36:"32a425dd-aab6-4f0f-9f0f-6a9a3ce0b228";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:4:"28_9";s:23:"automatic_crop_provider";N;}}s:36:"a4d2be16-9925-44d7-9f60-0072aafbd52d";a:4:{s:4:"uuid";s:36:"a4d2be16-9925-44d7-9f60-0072aafbd52d";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:2880;s:6:"height";i:926;s:6:"anchor";s:13:"center-center";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large_3_2_2x',
  'data' => 'a:8:{s:4:"uuid";s:36:"aa9e7e30-9ea5-44fd-83eb-be50f8f530a9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.3_2";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rs5J5Y9eU3dxP5Wvn3H_qzPU78-KVOQXg_Uy-79CGfE";}s:4:"name";s:12:"large_3_2_2x";s:5:"label";s:24:"Large 3:2 2x (1536x1024)";s:7:"effects";a:2:{s:36:"f0d332fd-0884-4f29-9f3c-befd244a63b4";a:4:{s:4:"uuid";s:36:"f0d332fd-0884-4f29-9f3c-befd244a63b4";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:1536;s:6:"height";i:1024;}}s:36:"faba0c2e-0168-4d38-bcc2-2caadf6b7a77";a:4:{s:4:"uuid";s:36:"faba0c2e-0168-4d38-bcc2-2caadf6b7a77";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"3_2";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.large_3_2_768x512',
  'data' => 'a:8:{s:4:"uuid";s:36:"29811fc5-36f8-46b3-9efb-999bd49659e6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.3_2";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rMpc4GWacV1vOKzi11UZ0MT-BJLwwYMgof1CFWdrtSc";}s:4:"name";s:17:"large_3_2_768x512";s:5:"label";s:19:"Large 3:2 (768x512)";s:7:"effects";a:2:{s:36:"36c9f14a-8f5e-4794-92ea-bffab074f52e";a:4:{s:4:"uuid";s:36:"36c9f14a-8f5e-4794-92ea-bffab074f52e";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:768;s:6:"height";i:512;}}s:36:"fc17e4a2-5b74-42f6-851f-5581cbd5089d";a:4:{s:4:"uuid";s:36:"fc17e4a2-5b74-42f6-851f-5581cbd5089d";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"3_2";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.linkit_result_thumbnail',
  'data' => 'a:8:{s:4:"uuid";s:36:"f8d6516f-dd42-4c8f-b9ef-e20e98f6ee34";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PY0kMp7KIxvU4kBi5mcnD_DHTKUc1OkYCfaPliXjpa8";}s:4:"name";s:23:"linkit_result_thumbnail";s:5:"label";s:23:"Linkit result thumbnail";s:7:"effects";a:1:{s:36:"2943df29-38ea-459c-ba1d-290489bb1807";a:4:{s:4:"uuid";s:36:"2943df29-38ea-459c-ba1d-290489bb1807";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:50;s:6:"height";i:50;s:6:"anchor";s:13:"center-center";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.localgov_248x181',
  'data' => 'a:8:{s:4:"uuid";s:36:"22d9b30a-def3-442a-9dfd-e641be3a287c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"squA5wR_4OHvduHlcwVd1zxr0u1hz2ccEh4t_zH0uds";}s:4:"name";s:16:"localgov_248x181";s:5:"label";s:16:"LocalGov 248x181";s:7:"effects";a:1:{s:36:"b8c93f24-2915-4be5-82fd-69940c874fe6";a:4:{s:4:"uuid";s:36:"b8c93f24-2915-4be5-82fd-69940c874fe6";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:248;s:6:"height";i:181;s:6:"anchor";s:13:"center-center";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.localgov_535x302',
  'data' => 'a:8:{s:4:"uuid";s:36:"bddcd8a8-c973-433d-92b4-a9ac23318d95";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:28:"crop.type.localgov_news_16_9";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YAZSPfuMNS2KA9kuI5mlrqf-AQIsDWvqMo9_JVCLmKw";}s:4:"name";s:16:"localgov_535x302";s:5:"label";s:16:"LocalGov 535x302";s:7:"effects";a:2:{s:36:"38cd1939-7fb0-43e0-86b1-604655d7e061";a:4:{s:4:"uuid";s:36:"38cd1939-7fb0-43e0-86b1-604655d7e061";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:5:"width";i:535;s:6:"height";i:302;s:6:"anchor";s:13:"center-center";}}s:36:"ddbdb069-c2e0-4965-b6cc-7f1f2a3bb1d9";a:4:{s:4:"uuid";s:36:"ddbdb069-c2e0-4965-b6cc-7f1f2a3bb1d9";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:18:"localgov_news_16_9";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.localgov_newsroom_teaser',
  'data' => 'a:8:{s:4:"uuid";s:36:"6b4d0fc0-0f5c-4736-8b7e-72252ba193ab";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sXjvgbaQhSfa1CjyOsENdnv_ZAMt5-092z8aZcLD8Kc";}s:4:"name";s:24:"localgov_newsroom_teaser";s:5:"label";s:24:"LocalGov Newsroom teaser";s:7:"effects";a:1:{s:36:"ff65eadb-38a8-471d-ba15-f3e627e8afe1";a:4:{s:4:"uuid";s:36:"ff65eadb-38a8-471d-ba15-f3e627e8afe1";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:360;s:6:"height";i:200;s:6:"anchor";s:13:"center-center";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.manual_16_9_crop',
  'data' => 'a:8:{s:4:"uuid";s:36:"8b06b347-be6f-4ae2-8dfa-8008b364757e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"crop.type.16_9";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UFmtficYNGlXc9ZNqyNENWkdOoPCoZ9YfpfSgkNq_yo";}s:4:"name";s:16:"manual_16_9_crop";s:5:"label";s:16:"Manual 16:9 crop";s:7:"effects";a:1:{s:36:"bd80ba57-385e-4fa7-a89f-37889c221862";a:4:{s:4:"uuid";s:36:"bd80ba57-385e-4fa7-a89f-37889c221862";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:4:"16_9";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.manual_3_2_crop',
  'data' => 'a:8:{s:4:"uuid";s:36:"cef80839-43a1-4d99-82c7-1a45a8b51ec4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.3_2";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LbgFtRjrKnZSgqqUtbJ_51Js_li0tvA7fuV6wfcvNAI";}s:4:"name";s:15:"manual_3_2_crop";s:5:"label";s:15:"Manual 3:2 crop";s:7:"effects";a:1:{s:36:"bba16a8a-e7a8-45e1-ad7e-2402dcf4278f";a:4:{s:4:"uuid";s:36:"bba16a8a-e7a8-45e1-ad7e-2402dcf4278f";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:3:"3_2";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.manual_7_3_crop',
  'data' => 'a:8:{s:4:"uuid";s:36:"1f923e63-8064-444f-927d-cdcc00124f51";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.7_3";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DQk32s4VohWIcgmyU1iVFIwKmv5llmaJunlL5CeQqf0";}s:4:"name";s:15:"manual_7_3_crop";s:5:"label";s:15:"Manual 7:3 crop";s:7:"effects";a:1:{s:36:"6a9056df-03c2-4b09-a3b2-3c5333250735";a:4:{s:4:"uuid";s:36:"6a9056df-03c2-4b09-a3b2-3c5333250735";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:3:"7_3";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.manual_8_7_crop',
  'data' => 'a:8:{s:4:"uuid";s:36:"14eb5a07-37ed-41d9-b5c6-3fff0e79bed1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.8_7";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"edm9B3O7-mslBaKskBAx9oN2Rniur3d6Wl3DyyWrhyg";}s:4:"name";s:15:"manual_8_7_crop";s:5:"label";s:15:"Manual 8:7 crop";s:7:"effects";a:1:{s:36:"b4623fbb-89ce-498f-9f9d-b2b991143d2c";a:4:{s:4:"uuid";s:36:"b4623fbb-89ce-498f-9f9d-b2b991143d2c";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:3:"8_7";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.manual_square_crop',
  'data' => 'a:8:{s:4:"uuid";s:36:"d98ba2f6-107d-49e3-a917-dc1262bc47d3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"crop.type.square";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FtyhNwfeGGu5uihoLdf3frBJRav1JideOAoEc5BF2vM";}s:4:"name";s:18:"manual_square_crop";s:5:"label";s:18:"Manual square crop";s:7:"effects";a:1:{s:36:"e099efd8-f1ae-499d-9276-21affb2a65df";a:4:{s:4:"uuid";s:36:"e099efd8-f1ae-499d-9276-21affb2a65df";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:6:"square";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.max_1300x1300',
  'data' => 'a:8:{s:4:"uuid";s:36:"c2369ab0-2cb5-4e1b-bb47-bbaf16df1e5c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:16:"responsive_image";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TD595kkS8PAS0v5TKF6ylAqyG4uSO1y52SQqy7zdTIw";}s:4:"name";s:13:"max_1300x1300";s:5:"label";s:13:"Max 1300x1300";s:7:"effects";a:1:{s:36:"04caae9a-fa3e-4ea6-ae09-9c26aec7d308";a:4:{s:4:"uuid";s:36:"04caae9a-fa3e-4ea6-ae09-9c26aec7d308";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1300;s:6:"height";i:1300;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.max_2600x2600',
  'data' => 'a:8:{s:4:"uuid";s:36:"d173a1ef-f12b-44ce-8fce-410b42532528";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:16:"responsive_image";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"H3gjFlhgZXCVkzP_u0Nzo3HGVu2JtYEEoD4U6fUO6D0";}s:4:"name";s:13:"max_2600x2600";s:5:"label";s:13:"Max 2600x2600";s:7:"effects";a:1:{s:36:"9b311dd1-0351-45a1-9500-cd069e4670cb";a:4:{s:4:"uuid";s:36:"9b311dd1-0351-45a1-9500-cd069e4670cb";s:2:"id";s:11:"image_scale";s:6:"weight";i:3;s:4:"data";a:3:{s:5:"width";i:2600;s:6:"height";i:2600;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.max_325x325',
  'data' => 'a:8:{s:4:"uuid";s:36:"c38010b5-d3f1-472f-97bc-72e756da0c04";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:16:"responsive_image";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HAJh3VFnKZmYvJF2Rsnc2HETYtffmXFcQr2FhVPmnSU";}s:4:"name";s:11:"max_325x325";s:5:"label";s:11:"Max 325x325";s:7:"effects";a:1:{s:36:"cb842cc8-682f-42a6-bd05-5a1ac726f0d8";a:4:{s:4:"uuid";s:36:"cb842cc8-682f-42a6-bd05-5a1ac726f0d8";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:325;s:6:"height";i:325;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.max_650x650',
  'data' => 'a:8:{s:4:"uuid";s:36:"9579c939-68ec-4ea2-b558-464d945fa07d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:16:"responsive_image";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5_u-TI6Qt78YQWl3DxbMBYKuCScEXKSeXTm8Jyl3eds";}s:4:"name";s:11:"max_650x650";s:5:"label";s:11:"Max 650x650";s:7:"effects";a:1:{s:36:"949c201a-77f5-48f6-ba00-be91eb1aad47";a:4:{s:4:"uuid";s:36:"949c201a-77f5-48f6-ba00-be91eb1aad47";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:650;s:6:"height";i:650;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.media_library',
  'data' => 'a:8:{s:4:"uuid";s:36:"4c0cc9c6-63b7-4b10-9d31-cbf94b0d3b21";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:13:"media_library";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7qJqToD1OQLAyeswpmg7M0LRxQlw1URQkJDWUJCnmR8";}s:4:"name";s:13:"media_library";s:5:"label";s:34:"Media Library thumbnail (220×220)";s:7:"effects";a:1:{s:36:"75b076a8-1234-4b42-85db-bf377c4d8d5f";a:4:{s:4:"uuid";s:36:"75b076a8-1234-4b42-85db-bf377c4d8d5f";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium',
  'data' => 'a:8:{s:4:"uuid";s:36:"b48f3593-e82b-4685-8945-26dcb98032ba";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Y9NmnZHQq20ASSyTNA6JnwtWrJJiSajOehGDtmUFdM0";}s:4:"name";s:6:"medium";s:5:"label";s:17:"Medium (220×220)";s:7:"effects";a:1:{s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";a:4:{s:4:"uuid";s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium_21_9',
  'data' => 'a:8:{s:4:"uuid";s:36:"67ba1f34-a7a5-4155-bdbe-f03f708a01ba";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.7_3";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"INTtDlcky4GaXIWjMJUyNXmBTxM6XBpNNyCDkdYG4T0";}s:4:"name";s:11:"medium_21_9";s:5:"label";s:22:"Medium 21:9 (1024x440)";s:7:"effects";a:2:{s:36:"52985ed4-81d6-4ecf-90c1-4e8c651f76ba";a:4:{s:4:"uuid";s:36:"52985ed4-81d6-4ecf-90c1-4e8c651f76ba";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:1024;s:6:"height";i:440;}}s:36:"a35dd68a-69ae-4798-bf43-ecbf3c450f65";a:4:{s:4:"uuid";s:36:"a35dd68a-69ae-4798-bf43-ecbf3c450f65";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"7_3";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium_28_9',
  'data' => 'a:8:{s:4:"uuid";s:36:"79a85c7d-05b9-42c9-8b5a-ce011f6b7487";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"crop.type.28_9";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ow2AxxFAOs0Zz_gBNlN2xgLcBX3NPEGudszGtVCsQjU";}s:4:"name";s:11:"medium_28_9";s:5:"label";s:22:"Medium 28:9 (1024x329)";s:7:"effects";a:2:{s:36:"724f72ee-70c4-4f8c-9e63-07846b997add";a:4:{s:4:"uuid";s:36:"724f72ee-70c4-4f8c-9e63-07846b997add";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:4:"28_9";s:23:"automatic_crop_provider";N;}}s:36:"b224f2b9-6e18-4f26-a27e-ae3a441e44f7";a:4:{s:4:"uuid";s:36:"b224f2b9-6e18-4f26-a27e-ae3a441e44f7";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:1024;s:6:"height";i:329;s:6:"anchor";s:13:"center-center";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium_28_9_2x',
  'data' => 'a:8:{s:4:"uuid";s:36:"9c2c87ce-f946-437f-bd7d-301703ad9bea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"crop.type.28_9";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"13qZiU5qbmZGvDPvp9l4kh3WSGZ943H3qM3ZJ6ZkOAA";}s:4:"name";s:14:"medium_28_9_2x";s:5:"label";s:25:"Medium 28:9 2x (2048x658)";s:7:"effects";a:2:{s:36:"4b628daf-69ce-42f7-87f9-aa88665e7936";a:4:{s:4:"uuid";s:36:"4b628daf-69ce-42f7-87f9-aa88665e7936";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:4:"28_9";s:23:"automatic_crop_provider";N;}}s:36:"78815fb7-b702-4e7f-9e91-ba1df1c85718";a:4:{s:4:"uuid";s:36:"78815fb7-b702-4e7f-9e91-ba1df1c85718";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:2048;s:6:"height";i:658;s:6:"anchor";s:13:"center-center";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium_3_2_2x',
  'data' => 'a:8:{s:4:"uuid";s:36:"7f2e971b-f334-4949-986a-e3682570a773";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.3_2";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VZx65GlV8PE55JjqcMbHLDd1dUQIfm1UAI-Tz1jZcaE";}s:4:"name";s:13:"medium_3_2_2x";s:5:"label";s:24:"Medium 3:2 2x (1200x800)";s:7:"effects";a:2:{s:36:"4d5a2dc6-8ec0-4a7e-95bb-dd19e8ed248a";a:4:{s:4:"uuid";s:36:"4d5a2dc6-8ec0-4a7e-95bb-dd19e8ed248a";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:1200;s:6:"height";i:800;}}s:36:"9d7a075b-82c4-4d2d-b731-6244f791fee2";a:4:{s:4:"uuid";s:36:"9d7a075b-82c4-4d2d-b731-6244f791fee2";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"3_2";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium_3_2_600x400',
  'data' => 'a:8:{s:4:"uuid";s:36:"46a62189-bec6-4d40-8a10-5876cd23a9d8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.3_2";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z-AiyY7TGTw60fc5kq4i0SCgA1pZNxD36Kn6RcUPuLI";}s:4:"name";s:18:"medium_3_2_600x400";s:5:"label";s:20:"Medium 3:2 (600x400)";s:7:"effects";a:2:{s:36:"75efca62-f371-41b7-8c6e-5ce6103e0fe4";a:4:{s:4:"uuid";s:36:"75efca62-f371-41b7-8c6e-5ce6103e0fe4";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:600;s:6:"height";i:400;}}s:36:"51244200-0f32-4c7e-9861-f152312b0f28";a:4:{s:4:"uuid";s:36:"51244200-0f32-4c7e-9861-f152312b0f28";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"3_2";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.medium_8_7',
  'data' => 'a:8:{s:4:"uuid";s:36:"07729bc9-fa16-4f53-aebe-33360619314c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.8_7";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jMjyJcRRv9QKvNwmAfd6S9pPuwy_8ExDJL58wy0O-DM";}s:4:"name";s:10:"medium_8_7";s:5:"label";s:20:"Medium 8:7 (266x236)";s:7:"effects";a:2:{s:36:"a7d919ee-5a34-476b-b893-c9649a621e60";a:4:{s:4:"uuid";s:36:"a7d919ee-5a34-476b-b893-c9649a621e60";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:266;s:6:"height";i:236;}}s:36:"2237e367-b9af-42e3-a893-60e27ef964e0";a:4:{s:4:"uuid";s:36:"2237e367-b9af-42e3-a893-60e27ef964e0";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"8_7";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.scale_crop_7_3_large',
  'data' => 'a:8:{s:4:"uuid";s:36:"e82dd00a-a48a-4ce1-becc-382ad55a9be9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.7_3";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jGEwGrXme-BwOKKtWTwCCOzEvKJZQryiAhSyyNwCUx0";}s:4:"name";s:20:"scale_crop_7_3_large";s:5:"label";s:20:"Scale crop 7:3 large";s:7:"effects";a:2:{s:36:"6e4edf30-59c0-45d0-ba6d-63dac5128eef";a:4:{s:4:"uuid";s:36:"6e4edf30-59c0-45d0-ba6d-63dac5128eef";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:1440;s:6:"height";i:617;}}s:36:"e88ccb2e-a374-461b-8c15-023ba0a10c34";a:4:{s:4:"uuid";s:36:"e88ccb2e-a374-461b-8c15-023ba0a10c34";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"7_3";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.small_21_9',
  'data' => 'a:8:{s:4:"uuid";s:36:"284ced4e-4f66-4799-8eda-cac5df1a0207";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:13:"crop.type.7_3";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FyXgPghb1ngFG0SDAchm-ibHfGvOYlBc2u6tJuHALQ0";}s:4:"name";s:10:"small_21_9";s:5:"label";s:20:"Small 21:9 (768x330)";s:7:"effects";a:2:{s:36:"06eaf095-124b-435d-af50-442044e91e7d";a:4:{s:4:"uuid";s:36:"06eaf095-124b-435d-af50-442044e91e7d";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:768;s:6:"height";i:330;}}s:36:"0dadbeb9-882a-4138-82d5-ddd13d143142";a:4:{s:4:"uuid";s:36:"0dadbeb9-882a-4138-82d5-ddd13d143142";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:3:"7_3";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.small_28_9',
  'data' => 'a:8:{s:4:"uuid";s:36:"e2adf312-d9da-4a19-af2c-c64b296fbd69";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"crop.type.28_9";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_cNDCjSotgKkESSpzBCpT4pEB0ccZuz0XoZGJ88e20U";}s:4:"name";s:10:"small_28_9";s:5:"label";s:20:"Small 28:9 (768x247)";s:7:"effects";a:2:{s:36:"f9d1a62f-07e1-4d2c-92da-10e40b73c5b0";a:4:{s:4:"uuid";s:36:"f9d1a62f-07e1-4d2c-92da-10e40b73c5b0";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:4:"28_9";s:23:"automatic_crop_provider";N;}}s:36:"c860cb37-e3eb-491d-955d-1e9103be6270";a:4:{s:4:"uuid";s:36:"c860cb37-e3eb-491d-955d-1e9103be6270";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:768;s:6:"height";i:247;s:6:"anchor";s:13:"center-center";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.small_28_9_2x',
  'data' => 'a:8:{s:4:"uuid";s:36:"91a785d9-fe0d-4905-a30e-80c7451f7965";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"crop.type.28_9";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3zOIH4p5-ozTDS1kzHnnJBU-BanCkmxLPMyu89dWgfQ";}s:4:"name";s:13:"small_28_9_2x";s:5:"label";s:13:"Small 28:9 2x";s:7:"effects";a:2:{s:36:"dee69b23-7be1-4f92-ba96-2da06af593e8";a:4:{s:4:"uuid";s:36:"dee69b23-7be1-4f92-ba96-2da06af593e8";s:2:"id";s:9:"crop_crop";s:6:"weight";i:1;s:4:"data";a:2:{s:9:"crop_type";s:4:"28_9";s:23:"automatic_crop_provider";N;}}s:36:"08702f55-9d8b-4b02-aede-001517eac25d";a:4:{s:4:"uuid";s:36:"08702f55-9d8b-4b02-aede-001517eac25d";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:2;s:4:"data";a:3:{s:5:"width";i:1536;s:6:"height";i:494;s:6:"anchor";s:13:"center-center";}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.square_large',
  'data' => 'a:8:{s:4:"uuid";s:36:"fc1cd225-7474-43a9-9d8a-4b6b65a21108";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"crop.type.square";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PA84y17nk5b3TWOz7nw9pHdlbybQuKRXiTmN1SZzfdc";}s:4:"name";s:12:"square_large";s:5:"label";s:12:"Square Large";s:7:"effects";a:2:{s:36:"c7627da6-934e-47e2-a795-f10a424bda34";a:4:{s:4:"uuid";s:36:"c7627da6-934e-47e2-a795-f10a424bda34";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:900;s:6:"height";i:900;}}s:36:"157cfc95-3308-41b3-8297-8e0e671e39d0";a:4:{s:4:"uuid";s:36:"157cfc95-3308-41b3-8297-8e0e671e39d0";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:6:"square";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.square_medium',
  'data' => 'a:8:{s:4:"uuid";s:36:"8b97f509-60d4-4b56-b8b0-0368afc2623f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"crop.type.square";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"S3xGPt2shXJlcqcFd7ZVLJuAbaYW88rUaC4P9zROh8Q";}s:4:"name";s:13:"square_medium";s:5:"label";s:13:"Square Medium";s:7:"effects";a:2:{s:36:"c42becc5-dd14-4384-81e1-8a667c60a705";a:4:{s:4:"uuid";s:36:"c42becc5-dd14-4384-81e1-8a667c60a705";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:600;s:6:"height";i:600;}}s:36:"8bc33a83-2259-4c6a-b6d8-233fed7bfb80";a:4:{s:4:"uuid";s:36:"8bc33a83-2259-4c6a-b6d8-233fed7bfb80";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:6:"square";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.square_small',
  'data' => 'a:8:{s:4:"uuid";s:36:"5aa88c0d-177d-4df0-99e2-59c4e1a830bc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"crop.type.square";}s:6:"module";a:1:{i:0;s:4:"crop";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rVNX4nW_rKVgP77XRGsMQg8Ziuaw6RnjRupD-WuVcdw";}s:4:"name";s:12:"square_small";s:5:"label";s:12:"Square Small";s:7:"effects";a:2:{s:36:"6c19e3f2-f291-4824-bc17-e485a979502c";a:4:{s:4:"uuid";s:36:"6c19e3f2-f291-4824-bc17-e485a979502c";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:-9;s:4:"data";a:3:{s:6:"anchor";s:13:"center-center";s:5:"width";i:300;s:6:"height";i:300;}}s:36:"70961c81-6799-4221-937f-86ecd2c8dda9";a:4:{s:4:"uuid";s:36:"70961c81-6799-4221-937f-86ecd2c8dda9";s:2:"id";s:9:"crop_crop";s:6:"weight";i:-10;s:4:"data";a:2:{s:9:"crop_type";s:6:"square";s:23:"automatic_crop_provider";N;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.thumbnail',
  'data' => 'a:8:{s:4:"uuid";s:36:"b64747a6-fd87-4569-b16a-b4c7d171e954";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cCiWdBHgLwj5omG35lsKc4LkW4MBdmcctkVop4ol5x0";}s:4:"name";s:9:"thumbnail";s:5:"label";s:20:"Thumbnail (100×100)";s:7:"effects";a:1:{s:36:"1cfec298-8620-4749-b100-ccb6c4500779";a:4:{s:4:"uuid";s:36:"1cfec298-8620-4749-b100-ccb6c4500779";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:100;s:6:"height";i:100;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image.style.wide',
  'data' => 'a:8:{s:4:"uuid";s:36:"b6a19927-ee68-48ea-b282-ff82361471e5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LswCVLg8z4Zk1u6pV1Dpj1qUj5YY2CQ7_ojx7bJQ8qk";}s:4:"name";s:4:"wide";s:5:"label";s:11:"Wide (1090)";s:7:"effects";a:1:{s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";a:4:{s:4:"uuid";s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1090;s:6:"height";N;s:7:"upscale";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'image_widget_crop.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYGkeE2iH3UGp9lBPsELb3VSgHz9vkMJeaGzcYwE7Uw";}s:8:"settings";a:9:{s:11:"library_url";s:0:"";s:7:"css_url";s:0:"";s:24:"crop_preview_image_style";s:14:"crop_thumbnail";s:9:"crop_list";a:0:{}s:19:"crop_types_required";a:0:{}s:20:"warn_multiple_usages";b:0;s:17:"show_default_crop";b:1;s:12:"notify_apply";b:0;s:13:"notify_update";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'linkit.linkit_profile.default',
  'data' => 'a:9:{s:4:"uuid";s:36:"462b8139-b04e-453f-94c2-5170f33f8d73";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dccI0aMqbCYWOoBgpP2KeCRjxBV0AjmqzvASrmkLtSc";}s:5:"label";s:7:"Default";s:2:"id";s:7:"default";s:11:"description";s:24:"A default Linkit profile";s:8:"matchers";a:1:{s:36:"556010a3-e317-48b3-b4ed-854c10f4b950";a:4:{s:2:"id";s:11:"entity:node";s:4:"uuid";s:36:"556010a3-e317-48b3-b4ed-854c10f4b950";s:8:"settings";a:6:{s:8:"metadata";s:40:"by [node:author] | [node:created:medium]";s:7:"bundles";a:0:{}s:15:"group_by_bundle";b:0;s:19:"include_unpublished";b:0;s:17:"substitution_type";s:9:"canonical";s:5:"limit";i:100;}s:6:"weight";i:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'localgov_geo.localgov_geo_type.address',
  'data' => 'a:8:{s:4:"uuid";s:36:"e5765239-48fc-45ee-b1de-aa4a8baf1009";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9bTdnZO4V7bSO2c3h3YJ_MHpLAVyD2L_D8tWPb4iS_U";}s:2:"id";s:7:"address";s:5:"label";s:7:"Address";s:11:"label_token";s:29:"[localgov_geo:postal_address]";}',
))
->values(array(
  'collection' => '',
  'name' => 'localgov_geo.localgov_geo_type.area',
  'data' => 'a:8:{s:4:"uuid";s:36:"f6ae3d2f-15d7-4b4c-a61e-c55efd6ce4d1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"g97Ys0BNUy8sSYozrHT8CPhPBbgL2tQyKHovygCcWNY";}s:2:"id";s:4:"area";s:5:"label";s:4:"Area";s:11:"label_token";s:0:"";}',
))
->values(array(
  'collection' => '',
  'name' => 'media.settings',
  'data' => 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PlWtVQXY5oKYZqCMPXh6SPamXagn5BoZqgAI8EY9WsY";}s:13:"icon_base_uri";s:28:"public://media-icons/generic";s:13:"iframe_domain";s:0:"";s:20:"oembed_providers_url";s:33:"https://oembed.com/providers.json";s:14:"standalone_url";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'media.type.audio',
  'data' => 'a:13:{s:4:"uuid";s:36:"a78a1346-b5d3-41ae-8b9a-c68c449770e1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eJw8n6Tk2tO3ZysuEeGR1gZa1yRffaZzR4t0Q7iNurs";}s:2:"id";s:5:"audio";s:5:"label";s:5:"Audio";s:11:"description";s:28:"A locally hosted audio file.";s:6:"source";s:10:"audio_file";s:25:"queue_thumbnail_downloads";b:0;s:12:"new_revision";b:1;s:20:"source_configuration";a:1:{s:12:"source_field";s:22:"field_media_audio_file";}s:9:"field_map";a:1:{s:4:"name";s:4:"name";}}',
))
->values(array(
  'collection' => '',
  'name' => 'media.type.document',
  'data' => 'a:13:{s:4:"uuid";s:36:"1cf02f1d-6be6-42a6-9c25-68f84cea7fd9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_D9q3XSnP6ik9we9UuoTvZsQKPuYNp_G9PfwVtWzgnQ";}s:2:"id";s:8:"document";s:5:"label";s:8:"Document";s:11:"description";s:44:"An uploaded file or document, such as a PDF.";s:6:"source";s:4:"file";s:25:"queue_thumbnail_downloads";b:0;s:12:"new_revision";b:1;s:20:"source_configuration";a:1:{s:12:"source_field";s:20:"field_media_document";}s:9:"field_map";a:1:{s:4:"name";s:4:"name";}}',
))
->values(array(
  'collection' => '',
  'name' => 'media.type.image',
  'data' => 'a:13:{s:4:"uuid";s:36:"fa1b66d3-e584-4e86-b77f-35ecb4c83bcf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6Qope5wG7HUpV0tPOBMtDI_GZkHFcF1Xj4hgD9Cu_hM";}s:2:"id";s:5:"image";s:5:"label";s:5:"Image";s:11:"description";s:36:"Use local images for reusable media.";s:6:"source";s:5:"image";s:25:"queue_thumbnail_downloads";b:0;s:12:"new_revision";b:1;s:20:"source_configuration";a:1:{s:12:"source_field";s:17:"field_media_image";}s:9:"field_map";a:1:{s:4:"name";s:4:"name";}}',
))
->values(array(
  'collection' => '',
  'name' => 'media.type.remote_video',
  'data' => 'a:13:{s:4:"uuid";s:36:"d86547c2-91ba-435b-b927-7b7b40aea91e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hIBTnDGgDKnCiP6HUZm1m7600DHUEpC6FN3LQ4sUgZ4";}s:2:"id";s:12:"remote_video";s:5:"label";s:12:"Remote video";s:11:"description";s:46:"A remotely hosted video from YouTube or Vimeo.";s:6:"source";s:12:"oembed:video";s:25:"queue_thumbnail_downloads";b:0;s:12:"new_revision";b:1;s:20:"source_configuration";a:3:{s:12:"source_field";s:24:"field_media_oembed_video";s:20:"thumbnails_directory";s:44:"public://oembed_thumbnails/[date:custom:Y-m]";s:9:"providers";a:2:{i:0;s:7:"YouTube";i:1;s:5:"Vimeo";}}s:9:"field_map";a:1:{s:5:"title";s:4:"name";}}',
))
->values(array(
  'collection' => '',
  'name' => 'media.type.video',
  'data' => 'a:13:{s:4:"uuid";s:36:"7f4efaed-b451-4804-be83-259d59913457";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hzgvcRgZHltqWf8hBmttoWh95tCJoPL25lPq9YSIRsY";}s:2:"id";s:5:"video";s:5:"label";s:5:"Video";s:11:"description";s:28:"A locally hosted video file.";s:6:"source";s:10:"video_file";s:25:"queue_thumbnail_downloads";b:0;s:12:"new_revision";b:1;s:20:"source_configuration";a:1:{s:12:"source_field";s:22:"field_media_video_file";}s:9:"field_map";a:1:{s:4:"name";s:4:"name";}}',
))
->values(array(
  'collection' => '',
  'name' => 'media_library.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_3gQsCnZELUjUUqHk8SSh8bXnx7TZwN95vctAeVJG60";}s:11:"advanced_ui";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'menu_ui.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SqMarzIjxC3F8dZo9FEOxfqDKD_sdW1tbcFTV1BA2zU";}s:24:"override_parent_selector";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0";}s:15:"use_admin_theme";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.article',
  'data' => 'a:12:{s:4:"uuid";s:36:"47a440b0-99e5-4772-95ce-b587349ab9c7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AeW1SEDgb1OTQACAWGhzvMknMYAJlcZu0jljfeU3oso";}s:4:"name";s:7:"Article";s:4:"type";s:7:"article";s:11:"description";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.localgov_directories_venue',
  'data' => 'a:12:{s:4:"uuid";s:36:"d7a8ce14-d123-4d29-8cb2-e6f33518d3f7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aFAyHHV687JGOdcsXqeVUREICSxQ2Uk5GZ_EfONa0xY";}s:4:"name";s:15:"Directory venue";s:4:"type";s:26:"localgov_directories_venue";s:11:"description";s:28:"A venue entry with location.";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.localgov_directory',
  'data' => 'a:12:{s:4:"uuid";s:36:"c5c7e553-ad74-489c-a2d1-72e3a495554d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-LoEbQrvqOBYG1UMlsby5bRRe4nfZa3c6znjEohpYXw";}s:4:"name";s:17:"Directory channel";s:4:"type";s:18:"localgov_directory";s:11:"description";s:28:"Main directory landing page.";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.localgov_event',
  'data' => 'a:12:{s:4:"uuid";s:36:"db00203f-6aef-49c7-ac28-3b3d77c77927";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hFQR3J7HGHPIoNacxC5kuAW4V6-y8myEz9FT13f8pwQ";}s:4:"name";s:5:"Event";s:4:"type";s:14:"localgov_event";s:11:"description";s:83:"An event to appear in the events listing and optionally integrate into a directory.";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'node.type.page',
  'data' => "a:12:{s:4:\"uuid\";s:36:\"fe2dfe69-088d-4d1d-a41b-dc637d6dc1da\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KuyA4NHPXcmKAjRtwa0vQc2ZcyrUJy6IlS2TAyMNRbc\";}s:4:\"name\";s:10:\"Basic page\";s:4:\"type\";s:4:\"page\";s:11:\"description\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:1;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}",
))
->values(array(
  'collection' => '',
  'name' => 'node.type.test',
  'data' => 'a:12:{s:4:"uuid";s:36:"ccb62b0c-20b0-4f42-9db0-4866cba4a57a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"menu_ui";}}s:20:"third_party_settings";a:1:{s:7:"menu_ui";a:2:{s:15:"available_menus";a:1:{i:0;s:4:"main";}s:6:"parent";s:5:"main:";}}s:4:"name";s:4:"Test";s:4:"type";s:4:"test";s:11:"description";s:0:"";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'olivero.settings',
  'data' => 'a:7:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Ylohp6sdrL1dU4v-KcXzXTP-U8BAMgh4NWJA9eGHtO4";}s:7:"favicon";a:1:{s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:0;}s:4:"logo";a:1:{s:11:"use_default";b:0;}s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}s:22:"mobile_menu_all_widths";i:0;s:22:"site_branding_bg_color";s:7:"default";}',
))
->values(array(
  'collection' => '',
  'name' => 'pathauto.pattern.localgov_directories_venue',
  'data' => 'a:13:{s:4:"uuid";s:36:"6f07a8d4-1d2a-4ade-9085-eca0582694b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zLcBruqrFyXkqhKCoJxBtYCTbziEz3iVEoQY8zttVTM";}s:2:"id";s:26:"localgov_directories_venue";s:5:"label";s:21:"Directory Entry Venue";s:4:"type";s:23:"canonical_entities:node";s:7:"pattern";s:12:"[node:title]";s:18:"selection_criteria";a:1:{s:36:"cf0a2bbc-3869-4912-a0e7-0f25ba4fcd1e";a:5:{s:2:"id";s:18:"entity_bundle:node";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}s:6:"negate";b:0;s:15:"context_mapping";a:1:{s:4:"node";s:4:"node";}s:4:"uuid";s:36:"cf0a2bbc-3869-4912-a0e7-0f25ba4fcd1e";}}s:15:"selection_logic";s:3:"and";s:6:"weight";i:-5;s:13:"relationships";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'pathauto.pattern.localgov_directory_channel',
  'data' => 'a:13:{s:4:"uuid";s:36:"74933d70-d6f9-455e-bbe3-0784cd145556";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FuH4EeSopmFl1GWNjuvKOoHJu7Hab7m3Gei6QhltUiI";}s:2:"id";s:26:"localgov_directory_channel";s:5:"label";s:17:"Directory channel";s:4:"type";s:23:"canonical_entities:node";s:7:"pattern";s:12:"[node:title]";s:18:"selection_criteria";a:1:{s:36:"bf66b3bc-02c2-48db-9c7e-4f9cb2915bc6";a:5:{s:2:"id";s:18:"entity_bundle:node";s:7:"bundles";a:1:{s:18:"localgov_directory";s:18:"localgov_directory";}s:6:"negate";b:0;s:15:"context_mapping";a:1:{s:4:"node";s:4:"node";}s:4:"uuid";s:36:"bf66b3bc-02c2-48db-9c7e-4f9cb2915bc6";}}s:15:"selection_logic";s:3:"and";s:6:"weight";i:-5;s:13:"relationships";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'pathauto.pattern.localgov_event',
  'data' => 'a:13:{s:4:"uuid";s:36:"aa2043f2-fd6e-4037-9a71-1238de062ddd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1_uG_9Lt_oGr6JMRVC-JxXg61T5bUEgdmg9SHxuWRqY";}s:2:"id";s:14:"localgov_event";s:5:"label";s:5:"Event";s:4:"type";s:23:"canonical_entities:node";s:7:"pattern";s:19:"events/[node:title]";s:18:"selection_criteria";a:1:{s:36:"29d4ed96-d72f-468e-9e44-f3c38f79cbcf";a:5:{s:2:"id";s:18:"entity_bundle:node";s:7:"bundles";a:1:{s:14:"localgov_event";s:14:"localgov_event";}s:6:"negate";b:0;s:15:"context_mapping";a:1:{s:4:"node";s:4:"node";}s:4:"uuid";s:36:"29d4ed96-d72f-468e-9e44-f3c38f79cbcf";}}s:15:"selection_logic";s:3:"and";s:6:"weight";i:-5;s:13:"relationships";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'pathauto.settings',
  'data' => 'a:13:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SwvLp8snyPEExF41CaJJYdPUVomofLqtXvwciHc4cPg";}s:20:"enabled_entity_types";a:1:{i:0;s:4:"user";}s:11:"punctuation";a:1:{s:6:"hyphen";i:1;}s:7:"verbose";b:0;s:9:"separator";s:1:"-";s:10:"max_length";i:100;s:20:"max_component_length";i:100;s:13:"transliterate";b:1;s:12:"reduce_ascii";b:0;s:4:"case";b:1;s:12:"ignore_words";s:134:"a, an, as, at, before, but, by, for, from, is, in, into, like, of, off, on, onto, per, since, than, the, this, that, to, up, via, with";s:13:"update_action";i:2;s:11:"safe_tokens";a:6:{i:0;s:5:"alias";i:1;s:4:"path";i:2;s:9:"join-path";i:3;s:9:"login-url";i:4;s:3:"url";i:5;s:9:"url-brief";}}',
))
->values(array(
  'collection' => '',
  'name' => 'responsive_image.styles.3_2_image',
  'data' => 'a:10:{s:4:"uuid";s:36:"4cccaa37-8f07-41a7-876e-83a5ca44381a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"image.style.large_3_2_2x";i:1;s:29:"image.style.large_3_2_768x512";}s:6:"module";a:1:{i:0;s:14:"localgov_media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HFXnFJlHvke0K35rRxC42eS-lSiw1-SYVclSjDCAVt8";}s:2:"id";s:9:"3_2_image";s:5:"label";s:9:"3:2 Image";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:13:"breakpoint_id";s:34:"localgov_media.bootstrap4_md_768px";s:10:"multiplier";s:2:"1x";s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:12:"large_3_2_2x";}}s:16:"breakpoint_group";s:14:"localgov_media";s:20:"fallback_image_style";s:17:"large_3_2_768x512";}',
))
->values(array(
  'collection' => '',
  'name' => 'responsive_image.styles.banner_28_9',
  'data' => 'a:10:{s:4:"uuid";s:36:"80462712-3cdf-4ee2-a43f-16de607cc33a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:22:"image.style.large_28_9";i:1;s:23:"image.style.medium_28_9";i:2;s:22:"image.style.small_28_9";i:3;s:25:"image.style.small_28_9_2x";}s:6:"module";a:1:{i:0;s:14:"localgov_media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7D2GIc8K2gPtxHbrH9-2__-xQVjMlwa13pAxy0zpq1g";}s:2:"id";s:11:"banner_28_9";s:5:"label";s:13:"Banner (28:9)";s:20:"image_style_mappings";a:3:{i:0;a:4:{s:13:"breakpoint_id";s:35:"localgov_media.bootstrap4_xl_1200px";s:10:"multiplier";s:2:"1x";s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:10:"large_28_9";}i:1;a:4:{s:13:"breakpoint_id";s:34:"localgov_media.bootstrap4_md_768px";s:10:"multiplier";s:2:"1x";s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:11:"medium_28_9";}i:2;a:4:{s:13:"breakpoint_id";s:28:"localgov_media.bootstrap4_xs";s:10:"multiplier";s:2:"1x";s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:13:"small_28_9_2x";}}s:16:"breakpoint_group";s:14:"localgov_media";s:20:"fallback_image_style";s:10:"small_28_9";}',
))
->values(array(
  'collection' => '',
  'name' => 'responsive_image.styles.freestyle_responsive',
  'data' => 'a:10:{s:4:"uuid";s:36:"2a2ed215-3279-4885-bcf0-9a45cd565d2b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:24:"image.style.freestyle_lg";i:1;s:24:"image.style.freestyle_md";i:2;s:24:"image.style.freestyle_sm";i:3;s:24:"image.style.freestyle_xl";i:4;s:24:"image.style.freestyle_xs";}s:6:"module";a:1:{i:0;s:14:"localgov_media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BOZHDnD4BmzF8iCAXOCSkZvMWsUJ77A3JxwMjdk8tEI";}s:2:"id";s:20:"freestyle_responsive";s:5:"label";s:20:"Freestyle Responsive";s:20:"image_style_mappings";a:5:{i:0;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:12:"freestyle_xl";s:13:"breakpoint_id";s:35:"localgov_media.bootstrap4_xl_1200px";s:10:"multiplier";s:2:"1x";}i:1;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:12:"freestyle_lg";s:13:"breakpoint_id";s:34:"localgov_media.bootstrap4_lg_992px";s:10:"multiplier";s:2:"1x";}i:2;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:12:"freestyle_md";s:13:"breakpoint_id";s:34:"localgov_media.bootstrap4_md_768px";s:10:"multiplier";s:2:"1x";}i:3;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:12:"freestyle_sm";s:13:"breakpoint_id";s:34:"localgov_media.bootstrap4_sm_576px";s:10:"multiplier";s:2:"1x";}i:4;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:12:"freestyle_xs";s:13:"breakpoint_id";s:28:"localgov_media.bootstrap4_xs";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:14:"localgov_media";s:20:"fallback_image_style";s:12:"freestyle_xs";}',
))
->values(array(
  'collection' => '',
  'name' => 'responsive_image.styles.hero_or_banner',
  'data' => 'a:10:{s:4:"uuid";s:36:"a7bd6267-08de-408c-bd69-bbb936c16fa2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:22:"image.style.large_21_9";i:1;s:25:"image.style.large_21_9_2x";i:2;s:22:"image.style.small_21_9";}s:6:"module";a:1:{i:0;s:14:"localgov_media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Kn0sXgNFwVjiagzgO7kDXU2IVhNg5bzxDiGpFnwm5os";}s:2:"id";s:14:"hero_or_banner";s:5:"label";s:14:"Hero or Banner";s:20:"image_style_mappings";a:2:{i:0;a:4:{s:13:"breakpoint_id";s:35:"localgov_media.bootstrap4_xl_1200px";s:10:"multiplier";s:2:"1x";s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:13:"large_21_9_2x";}i:1;a:4:{s:13:"breakpoint_id";s:34:"localgov_media.bootstrap4_md_768px";s:10:"multiplier";s:2:"1x";s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:10:"large_21_9";}}s:16:"breakpoint_group";s:14:"localgov_media";s:20:"fallback_image_style";s:10:"small_21_9";}',
))
->values(array(
  'collection' => '',
  'name' => 'responsive_image.styles.localgov_newsroom_featured',
  'data' => 'a:10:{s:4:"uuid";s:36:"c22a954d-f1a8-4fbd-b463-771de9110d2b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:28:"image.style.localgov_248x181";i:1;s:28:"image.style.localgov_535x302";}s:6:"module";a:1:{i:0;s:14:"localgov_media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"qEsoPdiJ2ETqscvQF4l-lnFwDPeLc5ULxlz06hxF5NA";}s:2:"id";s:26:"localgov_newsroom_featured";s:5:"label";s:26:"LocalGov Newsroom featured";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:13:"breakpoint_id";s:34:"localgov_media.bootstrap4_md_768px";s:10:"multiplier";s:2:"1x";s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:16:"localgov_535x302";}}s:16:"breakpoint_group";s:14:"localgov_media";s:20:"fallback_image_style";s:16:"localgov_248x181";}',
))
->values(array(
  'collection' => '',
  'name' => 'responsive_image.styles.narrow',
  'data' => 'a:10:{s:4:"uuid";s:36:"8eb79e19-da57-4bd3-8304-4e0b5a147276";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:25:"image.style.max_1300x1300";i:1;s:23:"image.style.max_325x325";i:2;s:23:"image.style.max_650x650";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"E9Pvy75e7AcNQi7TBRvoG0DU2FI8mjFcLARqfB-rlIU";}s:2:"id";s:6:"narrow";s:5:"label";s:6:"Narrow";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:82:"(min-width: 1290px) 325px, (min-width: 851px) 25vw, (min-width: 560px) 50vw, 100vw";s:18:"sizes_image_styles";a:3:{i:0;s:13:"max_1300x1300";i:1;s:11:"max_650x650";i:2;s:11:"max_325x325";}}s:13:"breakpoint_id";s:32:"responsive_image.viewport_sizing";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:16:"responsive_image";s:20:"fallback_image_style";s:11:"max_325x325";}',
))
->values(array(
  'collection' => '',
  'name' => 'responsive_image.styles.square',
  'data' => 'a:10:{s:4:"uuid";s:36:"66cd315d-ee5c-4417-b2b6-ec05c51854a5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"image.style.square_large";i:1;s:25:"image.style.square_medium";}s:6:"module";a:1:{i:0;s:14:"localgov_media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vlsPsFT_xyig28t4yNgWcLg4KvjVNsyV-H0hgHqC0J0";}s:2:"id";s:6:"square";s:5:"label";s:6:"Square";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:13:"breakpoint_id";s:34:"localgov_media.bootstrap4_md_768px";s:10:"multiplier";s:2:"1x";s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:12:"square_large";}}s:16:"breakpoint_group";s:14:"localgov_media";s:20:"fallback_image_style";s:13:"square_medium";}',
))
->values(array(
  'collection' => '',
  'name' => 'responsive_image.styles.wide',
  'data' => 'a:10:{s:4:"uuid";s:36:"5cffd3ef-5656-4446-b200-b771d8076568";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:4:{i:0;s:25:"image.style.max_1300x1300";i:1;s:25:"image.style.max_2600x2600";i:2;s:23:"image.style.max_325x325";i:3;s:23:"image.style.max_650x650";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Pvik9YqtjA9ALn5ccla1mwTIE4gN5fQ-dK1B0zX0b1o";}s:2:"id";s:4:"wide";s:5:"label";s:4:"Wide";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:33:"(min-width: 1290px) 1290px, 100vw";s:18:"sizes_image_styles";a:4:{i:0;s:13:"max_2600x2600";i:1;s:13:"max_1300x1300";i:2;s:11:"max_650x650";i:3;s:11:"max_325x325";}}s:13:"breakpoint_id";s:32:"responsive_image.viewport_sizing";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:16:"responsive_image";s:20:"fallback_image_style";s:11:"max_325x325";}',
))
->values(array(
  'collection' => '',
  'name' => 'search.page.node_search',
  'data' => 'a:11:{s:4:"uuid";s:36:"c19e49ac-940f-48bd-83bd-d72b0cd74838";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U";}s:2:"id";s:11:"node_search";s:5:"label";s:7:"Content";s:4:"path";s:4:"node";s:6:"weight";i:-10;s:6:"plugin";s:11:"node_search";s:13:"configuration";a:1:{s:8:"rankings";a:0:{}}}',
))
->values(array(
  'collection' => '',
  'name' => 'search.page.user_search',
  'data' => 'a:11:{s:4:"uuid";s:36:"eda7f3cc-2e16-4ca0-b929-e57bbd0359d8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A";}s:2:"id";s:11:"user_search";s:5:"label";s:5:"Users";s:4:"path";s:4:"user";s:6:"weight";i:0;s:6:"plugin";s:11:"user_search";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'search.settings',
  'data' => 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk";}s:12:"and_or_limit";i:7;s:12:"default_page";s:11:"node_search";s:5:"index";a:4:{s:10:"cron_limit";i:100;s:11:"overlap_cjk";b:1;s:17:"minimum_word_size";i:3;s:11:"tag_weights";a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:14;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}}s:7:"logging";b:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.localgov_directories_index_default',
  'data' => 'a:15:{s:4:"uuid";s:36:"269374ca-fb01-435b-97ae-ff89fabbfa53";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:46:"field.storage.node.localgov_directory_channels";i:1;s:51:"field.storage.node.localgov_directory_facets_select";i:2;s:48:"field.storage.node.localgov_directory_title_sort";i:3;s:42:"core.entity_view_mode.node.directory_index";}s:6:"module";a:2:{i:0;s:10:"search_api";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"v5DAYsUm4Cod06JxAK_y4fYqBRkOtcUtaNRdI2mPpv8";}s:2:"id";s:34:"localgov_directories_index_default";s:4:"name";s:11:"Directories";s:11:"description";s:0:"";s:9:"read_only";b:0;s:14:"field_settings";a:4:{s:27:"localgov_directory_channels";a:5:{s:5:"label";s:18:"Directory channels";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:27:"localgov_directory_channels";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:46:"field.storage.node.localgov_directory_channels";}}}s:32:"localgov_directory_facets_filter";a:5:{s:5:"label";s:6:"Facets";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:32:"localgov_directory_facets_select";s:4:"type";s:7:"integer";s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:51:"field.storage.node.localgov_directory_facets_select";}}}s:29:"localgov_directory_title_sort";a:5:{s:5:"label";s:12:"Title (sort)";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:29:"localgov_directory_title_sort";s:4:"type";s:6:"string";s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:48:"field.storage.node.localgov_directory_title_sort";}}}s:13:"rendered_item";a:4:{s:5:"label";s:20:"Rendered HTML output";s:13:"property_path";s:13:"rendered_item";s:4:"type";s:4:"text";s:13:"configuration";a:2:{s:5:"roles";a:1:{i:0;s:9:"anonymous";}s:9:"view_mode";a:1:{s:11:"entity:node";a:3:{s:25:"localgov_directories_page";s:15:"directory_index";s:26:"localgov_directories_venue";s:15:"directory_index";s:4:"node";s:15:"directory_index";}}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:0;s:8:"selected";a:1:{i:0;s:26:"localgov_directories_venue";}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:6:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:13:"entity_status";a:0:{}s:11:"entity_type";a:0:{}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:10:"cron_limit";i:50;s:14:"index_directly";b:1;s:27:"track_changes_in_references";b:1;}s:6:"server";N;}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.index.localgov_events',
  'data' => 'a:15:{s:4:"uuid";s:36:"f2269b5f-fc09-461c-be8d-9611b23ad504";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:44:"field.storage.node.localgov_event_categories";i:1;s:38:"field.storage.node.localgov_event_date";i:2;s:42:"field.storage.node.localgov_event_locality";i:3;s:39:"field.storage.node.localgov_event_price";i:4;s:33:"search_api.server.localgov_events";i:5;s:39:"core.entity_view_mode.node.search_index";}s:6:"module";a:2:{i:0;s:10:"search_api";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Dl9TdWlJnB_AX1dsT_ct8nFkWCA7DLZ7aN4DrEnJZ24";}s:2:"id";s:15:"localgov_events";s:4:"name";s:6:"Events";s:11:"description";s:0:"";s:9:"read_only";b:0;s:14:"field_settings";a:5:{s:25:"localgov_event_categories";a:6:{s:5:"label";s:10:"Categories";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:25:"localgov_event_categories";s:4:"type";s:7:"integer";s:5:"boost";d:0.5;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:44:"field.storage.node.localgov_event_categories";}}}s:19:"localgov_event_date";a:5:{s:5:"label";s:4:"Date";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:19:"localgov_event_date";s:4:"type";s:4:"date";s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:38:"field.storage.node.localgov_event_date";}}}s:23:"localgov_event_locality";a:6:{s:5:"label";s:13:"Neighbourhood";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:23:"localgov_event_locality";s:4:"type";s:7:"integer";s:5:"boost";d:0.5;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:42:"field.storage.node.localgov_event_locality";}}}s:20:"localgov_event_price";a:6:{s:5:"label";s:5:"Price";s:13:"datasource_id";s:11:"entity:node";s:13:"property_path";s:20:"localgov_event_price";s:4:"type";s:7:"integer";s:5:"boost";d:0.5;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:39:"field.storage.node.localgov_event_price";}}}s:13:"rendered_item";a:4:{s:5:"label";s:20:"Rendered HTML output";s:13:"property_path";s:13:"rendered_item";s:4:"type";s:4:"text";s:13:"configuration";a:2:{s:5:"roles";a:1:{s:9:"anonymous";s:9:"anonymous";}s:9:"view_mode";a:1:{s:11:"entity:node";a:1:{s:14:"localgov_event";s:12:"search_index";}}}}}s:19:"datasource_settings";a:1:{s:11:"entity:node";a:2:{s:7:"bundles";a:2:{s:7:"default";b:0;s:8:"selected";a:1:{i:0;s:14:"localgov_event";}}s:9:"languages";a:2:{s:7:"default";b:1;s:8:"selected";a:0:{}}}}s:18:"processor_settings";a:11:{s:7:"add_url";a:0:{}s:16:"aggregated_field";a:0:{}s:13:"entity_status";a:0:{}s:11:"html_filter";a:6:{s:10:"all_fields";b:1;s:6:"fields";a:1:{i:0;s:13:"rendered_item";}s:5:"title";b:1;s:3:"alt";b:1;s:4:"tags";a:7:{s:1:"b";i:2;s:2:"em";i:1;s:2:"h1";i:5;s:2:"h2";i:3;s:2:"h3";i:2;s:6:"strong";i:2;s:1:"u";i:1;}s:7:"weights";a:2:{s:16:"preprocess_index";i:-15;s:16:"preprocess_query";i:-15;}}s:10:"ignorecase";a:3:{s:10:"all_fields";b:1;s:6:"fields";a:1:{i:0;s:13:"rendered_item";}s:7:"weights";a:2:{s:16:"preprocess_index";i:-20;s:16:"preprocess_query";i:-20;}}s:22:"language_with_fallback";a:0:{}s:13:"rendered_item";a:0:{}s:7:"stemmer";a:4:{s:10:"all_fields";b:1;s:6:"fields";a:1:{i:0;s:13:"rendered_item";}s:10:"exceptions";a:2:{s:7:"mexican";s:5:"mexic";s:5:"texan";s:4:"texa";}s:7:"weights";a:2:{s:16:"preprocess_index";i:0;s:16:"preprocess_query";i:0;}}s:9:"stopwords";a:4:{s:10:"all_fields";b:1;s:6:"fields";a:1:{i:0;s:13:"rendered_item";}s:9:"stopwords";a:35:{i:0;s:1:"a";i:1;s:2:"an";i:2;s:3:"and";i:3;s:3:"are";i:4;s:2:"as";i:5;s:2:"at";i:6;s:2:"be";i:7;s:3:"but";i:8;s:2:"by";i:9;s:3:"for";i:10;s:2:"if";i:11;s:2:"in";i:12;s:4:"into";i:13;s:2:"is";i:14;s:2:"it";i:15;s:2:"no";i:16;s:3:"not";i:17;s:2:"of";i:18;s:2:"on";i:19;s:2:"or";i:20;s:1:"s";i:21;s:4:"such";i:22;s:1:"t";i:23;s:4:"that";i:24;s:3:"the";i:25;s:5:"their";i:26;s:4:"then";i:27;s:5:"there";i:28;s:5:"these";i:29;s:4:"they";i:30;s:4:"this";i:31;s:2:"to";i:32;s:3:"was";i:33;s:4:"will";i:34;s:4:"with";}s:7:"weights";a:2:{s:16:"preprocess_index";i:-5;s:16:"preprocess_query";i:-2;}}s:9:"tokenizer";a:6:{s:10:"all_fields";b:1;s:6:"fields";a:1:{i:0;s:13:"rendered_item";}s:6:"spaces";s:0:"";s:11:"overlap_cjk";i:1;s:17:"minimum_word_size";s:1:"3";s:7:"weights";a:2:{s:16:"preprocess_index";i:-6;s:16:"preprocess_query";i:-6;}}s:15:"transliteration";a:3:{s:10:"all_fields";b:1;s:6:"fields";a:1:{i:0;s:13:"rendered_item";}s:7:"weights";a:2:{s:16:"preprocess_index";i:-20;s:16:"preprocess_query";i:-20;}}}s:16:"tracker_settings";a:1:{s:7:"default";a:1:{s:14:"indexing_order";s:4:"fifo";}}s:7:"options";a:3:{s:14:"index_directly";b:1;s:10:"cron_limit";i:50;s:27:"track_changes_in_references";b:1;}s:6:"server";s:15:"localgov_events";}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.server.localgov_events',
  'data' => 'a:10:{s:4:"uuid";s:36:"036fd6e8-63e0-4728-aa2d-249b2c76d243";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:13:"search_api_db";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4RgjgXQKgP86M-fhKTbMsdeZUP6Gi1fwqGuytjktDys";}s:2:"id";s:15:"localgov_events";s:4:"name";s:6:"Events";s:11:"description";s:87:"Default events search server. For convenience of installation. Can be used or replaced.";s:7:"backend";s:13:"search_api_db";s:14:"backend_config";a:4:{s:8:"database";s:15:"default:default";s:9:"min_chars";i:3;s:8:"matching";s:6:"prefix";s:12:"autocomplete";a:2:{s:14:"suggest_suffix";b:1;s:13:"suggest_words";b:1;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api.settings',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"b2zIRm9Jv3SB60NYdZkZHxH8-KdEa-Xa48-4NsIi4lg";}s:18:"default_cron_limit";i:50;s:19:"cron_worker_runtime";i:15;s:15:"default_tracker";s:7:"default";s:18:"tracking_page_size";i:100;s:13:"boost_factors";a:21:{i:0;d:0;i:1;d:0.1;i:2;d:0.2;i:3;d:0.3;i:4;d:0.5;i:5;d:0.6;i:6;d:0.7;i:7;d:0.8;i:8;d:0.9;i:9;d:1;i:10;d:1.1;i:11;d:1.2;i:12;d:1.3;i:13;d:1.4;i:14;d:1.5;i:15;d:2;i:16;d:3;i:17;d:5;i:18;d:8;i:19;d:13;i:20;d:21;}}',
))
->values(array(
  'collection' => '',
  'name' => 'search_api_db.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fEmluJPpUL5dVqkWi0Fw89OlZYLhjQqyZIl6HWCDE1s";}s:28:"autocomplete_max_occurrences";d:0.9;}',
))
->values(array(
  'collection' => '',
  'name' => 'shortcut.set.default',
  'data' => 'a:7:{s:4:"uuid";s:36:"1a128911-517c-42ed-988e-af88e4375598";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI";}s:2:"id";s:7:"default";s:5:"label";s:7:"Default";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"851d3c53-56f8-4910-8df4-26e83048544a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpBH8OmL4sdesCdeZLsW8KOutB5gkbreWJbfjhfFKaQ";}s:2:"id";s:21:"comment_delete_action";s:5:"label";s:14:"Delete comment";s:4:"type";s:7:"comment";s:6:"plugin";s:28:"entity:delete_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"0e56764a-f7e4-4d32-8f7d-f80c0505163d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C00dyL_W_5M0nFlgUB3lWUTUs96jn51Jw1MLHVEHZD0";}s:2:"id";s:22:"comment_publish_action";s:5:"label";s:15:"Publish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:29:"entity:publish_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"b9f775ab-a325-4ae7-8769-36a6f3e9e9c3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lfyE_snmvfg_EQ3VDyhUtGAXgmqtEiqa46I3bTMg8DU";}s:2:"id";s:19:"comment_save_action";s:5:"label";s:12:"Save comment";s:4:"type";s:7:"comment";s:6:"plugin";s:26:"entity:save_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.comment_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"aee53f43-b56e-4844-a9d2-ff58c2cdb357";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tWOIjSMobEWOFZddMkNqb9JySbOVwE1diC6NRqcfLTk";}s:2:"id";s:24:"comment_unpublish_action";s:5:"label";s:17:"Unpublish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:31:"entity:unpublish_action:comment";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.media_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"a67634fb-a980-4d63-b1bf-4bb2515a31ce";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FrZy1tmuXJcOxhXlBoI1Hsnen5TT-9OCC1iolWH84go";}s:2:"id";s:19:"media_delete_action";s:5:"label";s:12:"Delete media";s:4:"type";s:5:"media";s:6:"plugin";s:26:"entity:delete_action:media";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.media_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"32b04da4-3210-4cee-a1a2-16279d655feb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nh83qNNrmWE-CDdHz2MdFOAk60T9mzv3R-MaKfZR2jw";}s:2:"id";s:20:"media_publish_action";s:5:"label";s:13:"Publish media";s:4:"type";s:5:"media";s:6:"plugin";s:27:"entity:publish_action:media";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.media_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"61e05b30-fd42-415f-a9d8-a12efa4c3c9a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VVyUA6PIaVeGtcIbgEWqJ6SYDiJdReBeojFswURFpKs";}s:2:"id";s:17:"media_save_action";s:5:"label";s:10:"Save media";s:4:"type";s:5:"media";s:6:"plugin";s:24:"entity:save_action:media";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.media_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"4d690d00-5622-4493-9eb0-de846021bce7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CsK6TseQ2DatEbZgbd30swOlZ28_HHwAESU2LvEnWq0";}s:2:"id";s:22:"media_unpublish_action";s:5:"label";s:15:"Unpublish media";s:4:"type";s:5:"media";s:6:"plugin";s:29:"entity:unpublish_action:media";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_delete_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"cdfbd1c0-fb2e-4418-b16e-62d3e912f6f3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg";}s:2:"id";s:18:"node_delete_action";s:5:"label";s:14:"Delete content";s:4:"type";s:4:"node";s:6:"plugin";s:25:"entity:delete_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_sticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"809bb353-1db4-4c26-a137-aac53ad941d8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0";}s:2:"id";s:23:"node_make_sticky_action";s:5:"label";s:19:"Make content sticky";s:4:"type";s:4:"node";s:6:"plugin";s:23:"node_make_sticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_make_unsticky_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"b74172e3-a34f-4b01-a669-5c0406ea7c06";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k";}s:2:"id";s:25:"node_make_unsticky_action";s:5:"label";s:21:"Make content unsticky";s:4:"type";s:4:"node";s:6:"plugin";s:25:"node_make_unsticky_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_promote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"644e36f0-4bc5-4e2b-8fdf-ea9a4f42875f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U";}s:2:"id";s:19:"node_promote_action";s:5:"label";s:29:"Promote content to front page";s:4:"type";s:4:"node";s:6:"plugin";s:19:"node_promote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"c12dab88-8b9f-483f-95a2-7d3495fe259b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0";}s:2:"id";s:19:"node_publish_action";s:5:"label";s:15:"Publish content";s:4:"type";s:4:"node";s:6:"plugin";s:26:"entity:publish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_save_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"2520c504-1f0c-428a-964a-9c901588a579";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM";}s:2:"id";s:16:"node_save_action";s:5:"label";s:12:"Save content";s:4:"type";s:4:"node";s:6:"plugin";s:23:"entity:save_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpromote_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"68a3bba3-51e7-4c19-a65c-5aa7e324b939";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0";}s:2:"id";s:21:"node_unpromote_action";s:5:"label";s:30:"Remove content from front page";s:4:"type";s:4:"node";s:6:"plugin";s:21:"node_unpromote_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.node_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"ab469203-51e0-4ac8-816d-971eaba82701";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE";}s:2:"id";s:21:"node_unpublish_action";s:5:"label";s:17:"Unpublish content";s:4:"type";s:4:"node";s:6:"plugin";s:28:"entity:unpublish_action:node";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.pathauto_update_alias_node',
  'data' => 'a:10:{s:4:"uuid";s:36:"dd4c373a-ead1-4841-8836-66cd31f6e297";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:8:"pathauto";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lno8QThS348UX-kaUsagJtCnuPHKLXYnTQiF_9HSDWA";}s:2:"id";s:26:"pathauto_update_alias_node";s:5:"label";s:16:"Update URL alias";s:4:"type";s:4:"node";s:6:"plugin";s:21:"pathauto_update_alias";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.pathauto_update_alias_user',
  'data' => 'a:10:{s:4:"uuid";s:36:"42d1073b-6cb9-45b3-945a-1480a84c8891";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:8:"pathauto";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"x_ok_ZsfA4Xk4B_hVW3O4-3PcNoK57nXLz_Dlletidg";}s:2:"id";s:26:"pathauto_update_alias_user";s:5:"label";s:16:"Update URL alias";s:4:"type";s:4:"user";s:6:"plugin";s:21:"pathauto_update_alias";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.taxonomy_term_publish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"9a2d17fb-73f0-459a-9681-55c95f05bd73";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY";}s:2:"id";s:28:"taxonomy_term_publish_action";s:5:"label";s:21:"Publish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:35:"entity:publish_action:taxonomy_term";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.taxonomy_term_unpublish_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"d3c3707f-7eee-4683-b865-040336ca62e4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI";}s:2:"id";s:30:"taxonomy_term_unpublish_action";s:5:"label";s:23:"Unpublish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:37:"entity:unpublish_action:taxonomy_term";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_add_role_action.administrator',
  'data' => 'a:9:{s:4:"uuid";s:36:"84345efd-b462-4c44-99e9-6cf02b5721d2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:34:"user_add_role_action.administrator";s:5:"label";s:50:"Add the Administrator role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_add_role_action.content_editor',
  'data' => 'a:9:{s:4:"uuid";s:36:"d89cd39e-8781-4721-9170-e1207724044f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:35:"user_add_role_action.content_editor";s:5:"label";s:51:"Add the Content editor role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_block_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"cbe27623-cea4-44a1-bdeb-bcd7af1d1c80";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4";}s:2:"id";s:22:"user_block_user_action";s:5:"label";s:26:"Block the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:22:"user_block_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_cancel_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"b1141df3-9794-4ae0-95c8-b3e04f509103";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU";}s:2:"id";s:23:"user_cancel_user_action";s:5:"label";s:35:"Cancel the selected user account(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_cancel_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_remove_role_action.administrator',
  'data' => 'a:9:{s:4:"uuid";s:36:"b37a161f-c164-42c3-8a0b-9f56ae9b2a49";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:37:"user_remove_role_action.administrator";s:5:"label";s:55:"Remove the Administrator role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_remove_role_action.content_editor',
  'data' => 'a:9:{s:4:"uuid";s:36:"e9189b77-7168-4791-bfa9-1b5a7c8f563c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:38:"user_remove_role_action.content_editor";s:5:"label";s:56:"Remove the Content editor role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.action.user_unblock_user_action',
  'data' => 'a:10:{s:4:"uuid";s:36:"585e5285-2c32-42ee-8b2b-51af2439a3b4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0";}s:2:"id";s:24:"user_unblock_user_action";s:5:"label";s:28:"Unblock the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:24:"user_unblock_user_action";s:13:"configuration";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.advisories',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo";}s:7:"enabled";b:1;s:14:"interval_hours";i:6;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.cron',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5Pw921y1EPfFN98wykliBBLArm51pC-SmrXeYCe7d0Y";}s:9:"threshold";a:2:{s:20:"requirements_warning";i:172800;s:18:"requirements_error";i:1209600;}s:7:"logging";i:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.date',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t7clj3mzmOGrXX0HuCH5usf0vEqRtnMTBFVBIEmZ5pc";}s:9:"first_day";i:0;s:7:"country";a:1:{s:7:"default";s:0:"";}s:8:"timezone";a:2:{s:7:"default";s:3:"UTC";s:4:"user";a:3:{s:12:"configurable";b:1;s:7:"default";i:0;s:4:"warn";b:0;}}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.diff',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM";}s:7:"context";a:2:{s:13:"lines_leading";i:2;s:14:"lines_trailing";i:2;}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.file',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g";}s:22:"allow_insecure_uploads";b:0;s:14:"default_scheme";s:6:"public";s:21:"temporary_maximum_age";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24";}s:7:"toolkit";s:2:"gd";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.image.gd',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ";}s:12:"jpeg_quality";i:75;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.logging',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA";}s:11:"error_level";s:4:"hide";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.mail',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rYgt7uhPafP2ngaN_ZUPFuyI4KdE0zU868zLNSlzKoE";}s:9:"interface";a:1:{s:7:"default";s:8:"php_mail";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.maintenance',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1SNdA25INsV5YjlgAJtfC-6AM8VcWe_00xneMLb2yFg";}s:8:"langcode";s:2:"en";s:7:"message";s:93:"@site is currently under maintenance. We should be back shortly. Thank you for your patience.";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.account',
  'data' => 'a:9:{s:4:"uuid";s:36:"1e81ee85-417f-420a-86f8-129d45432ef0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw";}s:2:"id";s:7:"account";s:5:"label";s:17:"User account menu";s:11:"description";s:40:"Links related to the active user account";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.admin',
  'data' => 'a:9:{s:4:"uuid";s:36:"ac1c182e-2e0e-4e9a-b36a-ea22d7a0f3d9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0";}s:2:"id";s:5:"admin";s:5:"label";s:14:"Administration";s:11:"description";s:25:"Administrative task links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.footer',
  'data' => 'a:9:{s:4:"uuid";s:36:"41f8df0f-60b1-4aa6-9efc-679e4ce18813";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc";}s:2:"id";s:6:"footer";s:5:"label";s:6:"Footer";s:11:"description";s:22:"Site information links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.main',
  'data' => 'a:9:{s:4:"uuid";s:36:"7fb6b202-5930-44ac-8a2c-28ebfc32d179";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8";}s:2:"id";s:4:"main";s:5:"label";s:15:"Main navigation";s:11:"description";s:18:"Site section links";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.menu.tools',
  'data' => 'a:9:{s:4:"uuid";s:36:"dfaabd23-d856-4497-96c0-ba9a753daa3e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc";}s:2:"id";s:5:"tools";s:5:"label";s:5:"Tools";s:11:"description";s:39:"User tool links, often added by modules";s:6:"locked";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.performance',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"b2cssrj-lOmATIbdehfCqfCFgVR0qCdxxWhwqa2KBVQ";}s:5:"cache";a:1:{s:4:"page";a:1:{s:7:"max_age";i:0;}}s:3:"css";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:8:"fast_404";a:4:{s:7:"enabled";b:1;s:5:"paths";s:69:"/\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i";s:13:"exclude_paths";s:27:"/\/(?:styles|imagecache)\//";s:4:"html";s:162:"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL "@path" was not found on this server.</p></body></html>";}s:2:"js";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:20:"stale_file_threshold";i:2592000;}',
))
->values(array(
  'collection' => '',
  'name' => 'system.rss',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MIpNzlG4gPunfS7vTCwUPum6QH3GUsEBMj-qS631Jw0";}s:5:"items";a:1:{s:9:"view_mode";s:3:"rss";}}',
))
->values(array(
  'collection' => '',
  'name' => 'system.site',
  'data' => 'a:10:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VDJxTZtQR21qB4lvOq8zszJZLvLKrSPQpdn2E3T71Ww";}s:8:"langcode";s:2:"en";s:4:"uuid";s:36:"6b3cba6d-4e7a-401a-940a-a45610980048";s:4:"name";s:18:"Drush Site-Install";s:4:"mail";s:17:"admin@example.com";s:6:"slogan";s:0:"";s:4:"page";a:3:{i:403;s:0:"";i:404;s:0:"";s:5:"front";s:5:"/node";}s:18:"admin_compact_mode";b:0;s:17:"weight_select_max";i:100;s:16:"default_langcode";s:2:"en";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme',
  'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eJ529VM1gSIA_vgTy2PdiDvJuG0xhSxfQjCyl5WKlv4";}s:5:"admin";s:5:"claro";s:7:"default";s:7:"olivero";}',
))
->values(array(
  'collection' => '',
  'name' => 'system.theme.global',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9rAU4Pku7eMBQxauQqAgjzlcicFZ2As6zEa6zvTlCB8";}s:7:"favicon";a:4:{s:8:"mimetype";s:24:"image/vnd.microsoft.icon";s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:1;}s:4:"logo";a:3:{s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zKpaWT6cJc1tVQQaTqatGELaCqU_oyRym6zTl27Yias";}s:20:"maintain_index_table";b:1;s:17:"override_selector";b:0;s:20:"terms_per_page_admin";i:100;}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.vocabulary.localgov_event_category',
  'data' => 'a:9:{s:4:"uuid";s:36:"0b0c8600-8503-4953-975e-1e6109e41ad3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WToPEf4olAXX9wjmUumuHOMflMYBGZaYRmrgyk4ob1g";}s:4:"name";s:14:"Event category";s:3:"vid";s:23:"localgov_event_category";s:11:"description";s:35:"Category used for filtering events.";s:6:"weight";i:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.vocabulary.localgov_event_locality',
  'data' => 'a:9:{s:4:"uuid";s:36:"6df0fac2-a521-4f73-911a-4fd66295ad61";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eoviERfka0a6e2-xPlA1cApupVOCoIRlwzQEOOUD_NE";}s:4:"name";s:19:"Event neighbourhood";s:3:"vid";s:23:"localgov_event_locality";s:11:"description";s:34:"Locality used for event filtering.";s:6:"weight";i:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.vocabulary.localgov_event_price',
  'data' => 'a:9:{s:4:"uuid";s:36:"ef2a62db-af26-43f3-819e-096245dfaa93";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AgrpujpS36IsYG9xOI4dUow6XaN8oIdU8-EVgHqduKY";}s:4:"name";s:11:"Event price";s:3:"vid";s:20:"localgov_event_price";s:11:"description";s:32:"Price used for filtering events.";s:6:"weight";i:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'taxonomy.vocabulary.tags',
  'data' => 'a:9:{s:4:"uuid";s:36:"84b9fdcc-13b7-4215-a8df-2da8728bdcfd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yoNVreoTdTZTY7GuE8fI9Jmxqdz8vlo4ZJKixMNSosw";}s:4:"name";s:4:"Tags";s:3:"vid";s:4:"tags";s:11:"description";s:61:"Use tags to group articles on similar topics into categories.";s:6:"weight";i:0;}',
))
->values(array(
  'collection' => '',
  'name' => 'text.settings',
  'data' => 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Bkewb77RBOK3_aXMPsp8p87gbc03NvmC5gBLzPl7hVA";}s:22:"default_summary_length";i:600;}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.block-layout',
  'data' => 'a:10:{s:4:"uuid";s:36:"9ab83573-c98e-4df6-a562-30ef8bb16e17";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"block";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ructO0IOsghR3CIbNd-0QfLTDiUo8gIJ7mB_nxSil4o";}s:2:"id";s:12:"block-layout";s:5:"label";s:17:"Block Layout Page";s:6:"module";s:5:"block";s:6:"routes";a:1:{i:0;a:1:{s:10:"route_name";s:19:"block.admin_display";}}s:4:"tips";a:5:{s:12:"block-layout";a:5:{s:2:"id";s:12:"block-layout";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Block Layout";s:6:"weight";i:1;s:4:"body";s:150:"Blocks are boxes of content rendered into an area, or region, of a web page that can be displayed in regions (such as footer or sidebar) on your page.";}s:11:"place-block";a:6:{s:2:"id";s:11:"place-block";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Place Blocks";s:6:"weight";i:2;s:8:"selector";s:14:".button--small";s:4:"body";s:163:"Any custom or contributed block can be added to a particular region by clicking on a button Place block. A new block can also be created by clicking on Place Block";}s:12:"block-region";a:6:{s:2:"id";s:12:"block-region";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Block Region";s:6:"weight";i:3;s:8:"selector";s:20:".block-region-select";s:4:"body";s:151:"Assign or change the region of a block by clicking here. A dropdown list with all the regions will appear. You can place one block in multiple regions.";}s:15:"configure-block";a:6:{s:2:"id";s:15:"configure-block";s:6:"plugin";s:4:"text";s:5:"label";s:15:"Configure Block";s:6:"weight";i:4;s:8:"selector";s:18:".dropbutton-widget";s:4:"body";s:173:"By Clicking on "Configure" you can go ahead and edit the contents of the block, deal with the visibility settings and even change the placement of where it is on your theme.";}s:20:"custom-block-library";a:5:{s:2:"id";s:20:"custom-block-library";s:6:"plugin";s:4:"text";s:5:"label";s:20:"Custom Block Library";s:6:"weight";i:5;s:4:"body";s:203:"The block management screen also has an another tab on the top which is used to add Custom blocks. The name of the tab is "Custom block library". This tab ultimately provides a link to add custom blocks.";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.search-api-index',
  'data' => "a:10:{s:4:\"uuid\";s:36:\"acf9bbcf-fc66-448d-b20c-027cb841f99a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"search_api\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DHNg3a7QdthDmUgBXKgxq-ewQd4uA9hHAmaM9vul95A\";}s:2:\"id\";s:16:\"search-api-index\";s:5:\"label\";s:26:\"Information about an index\";s:6:\"module\";s:10:\"search_api\";s:6:\"routes\";a:1:{i:0;a:1:{s:10:\"route_name\";s:33:\"entity.search_api_index.canonical\";}}s:4:\"tips\";a:12:{s:29:\"search-api-index-introduction\";a:5:{s:2:\"id\";s:29:\"search-api-index-introduction\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:26:\"Information about an index\";s:4:\"body\";s:59:\"This page shows a summary of a search index and its status.\";s:6:\"weight\";i:1;}s:29:\"search-api-index-index-status\";a:6:{s:2:\"id\";s:29:\"search-api-index-index-status\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:12:\"Index status\";s:4:\"body\";s:183:\"This gives a summary about how many items are known for this index, and how many have been indexed in their latest version. Items that are not indexed yet cannot be found by searches.\";s:6:\"weight\";i:2;s:8:\"selector\";s:24:\".search-api-index-status\";}s:23:\"search-api-index-status\";a:6:{s:2:\"id\";s:23:\"search-api-index-status\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:6:\"Status\";s:4:\"body\";s:57:\"Shows whether the index is currently enabled or disabled.\";s:6:\"weight\";i:3;s:8:\"selector\";s:33:\".search-api-index-summary--status\";}s:28:\"search-api-index-datasources\";a:6:{s:2:\"id\";s:28:\"search-api-index-datasources\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:11:\"Datasources\";s:4:\"body\";s:54:\"Lists all datasources that are enabled for this index.\";s:6:\"weight\";i:4;s:8:\"selector\";s:37:\".search-api-index-summary--datasource\";}s:24:\"search-api-index-tracker\";a:6:{s:2:\"id\";s:24:\"search-api-index-tracker\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:7:\"Tracker\";s:4:\"body\";s:76:\"The tracker used by the index. Only one (\"Default\") is available by default.\";s:6:\"weight\";i:5;s:8:\"selector\";s:34:\".search-api-index-summary--tracker\";}s:23:\"search-api-index-server\";a:6:{s:2:\"id\";s:23:\"search-api-index-server\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:6:\"Server\";s:4:\"body\";s:65:\"If the index is attached to a server, this server is listed here.\";s:6:\"weight\";i:6;s:8:\"selector\";s:33:\".search-api-index-summary--server\";}s:36:\"search-api-index-server-index-status\";a:6:{s:2:\"id\";s:36:\"search-api-index-server-index-status\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:19:\"Server index status\";s:4:\"body\";s:340:\"For enabled indexes, the number of items that can actually be retrieved from the server is listed here. For reasons why this number might differ from the number under \"Index status\", <a href=\"https://www.drupal.org/docs/8/modules/search-api/getting-started/frequently-asked-questions#server-index-status\">see the module's documentation</a>.\";s:6:\"weight\";i:7;s:8:\"selector\";s:46:\".search-api-index-summary--server-index-status\";}s:32:\"search-api-index-cron-batch-size\";a:6:{s:2:\"id\";s:32:\"search-api-index-cron-batch-size\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:15:\"Cron batch size\";s:4:\"body\";s:66:\"The number of items that will be indexed at once during cron runs.\";s:6:\"weight\";i:8;s:8:\"selector\";s:42:\".search-api-index-summary--cron-batch-size\";}s:26:\"search-api-index-index-now\";a:6:{s:2:\"id\";s:23:\"search-api-index-remove\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:18:\"Start indexing now\";s:4:\"body\";s:246:\"The \"Start indexing now\" form allows indexing items manually right away, with a batch process. Otherwise, items are only indexed during cron runs. The form might be disabled if indexing is currently not possible for some reason, or not necessary.\";s:6:\"weight\";i:9;s:8:\"selector\";s:11:\"#edit-index\";}s:25:\"search-api-index-tracking\";a:6:{s:2:\"id\";s:25:\"search-api-index-tracking\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:21:\"Track items for index\";s:4:\"body\";s:234:\"In certain situations, the index's tracker doesn't have the latest state of the items available for indexing. This will be automatically rectified during cron runs, but can also be manually triggered here, with the \"Track now\" button.\";s:6:\"weight\";i:10;s:8:\"selector\";s:14:\"#edit-tracking\";}s:24:\"search-api-index-reindex\";a:6:{s:2:\"id\";s:24:\"search-api-index-reindex\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:30:\"Queue all items for reindexing\";s:4:\"body\";s:171:\"This will queue all items on this index for reindexing. Previously indexed data will remain on the search server, so searches on this index will continue to yield results.\";s:6:\"weight\";i:11;s:8:\"selector\";s:13:\".edit-reindex\";}s:22:\"search-api-index-clear\";a:6:{s:2:\"id\";s:22:\"search-api-index-clear\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:22:\"Clear all indexed data\";s:4:\"body\";s:181:\"This will remove all indexed content for this index from the search server and queue it for reindexing. Searches on this index will not return any results until items are reindexed.\";s:6:\"weight\";i:12;s:8:\"selector\";s:11:\"#edit-clear\";}}}",
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.search-api-index-fields',
  'data' => "a:10:{s:4:\"uuid\";s:36:\"d4964658-6d4b-4ed0-a887-1177fa51c1cf\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"search_api\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TtSWlBl_1VI03GJW1yyzVwtlq15Yst0id1vPdvz5qxM\";}s:2:\"id\";s:23:\"search-api-index-fields\";s:5:\"label\";s:28:\"Fields indexed in this index\";s:6:\"module\";s:10:\"search_api\";s:6:\"routes\";a:1:{i:0;a:1:{s:10:\"route_name\";s:30:\"entity.search_api_index.fields\";}}s:4:\"tips\";a:11:{s:36:\"search-api-index-fields-introduction\";a:5:{s:2:\"id\";s:36:\"search-api-index-fields-introduction\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:28:\"Fields indexed in this index\";s:4:\"body\";s:314:\"This page lists which fields are indexed in this index, grouped by datasource. (Datasource-independent fields are listed under \"General\".) Indexed fields can be used to add filters or sorting to views or other search displays based on the index. Fields with type \"Fulltext\" can also be used for fulltext searching.\";s:6:\"weight\";i:1;}s:27:\"search-api-index-fields-add\";a:6:{s:2:\"id\";s:27:\"search-api-index-fields-add\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:10:\"Add fields\";s:4:\"body\";s:73:\"With the \"Add fields\" button you can add additional fields to this index.\";s:6:\"weight\";i:2;s:8:\"selector\";s:53:\".button-action[data-drupal-selector=\"edit-add-field\"]\";}s:29:\"search-api-index-fields-label\";a:6:{s:2:\"id\";s:29:\"search-api-index-fields-label\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:5:\"Label\";s:4:\"body\";s:99:\"A label for the field that will be used to refer to the field in most places in the user interface.\";s:6:\"weight\";i:3;s:8:\"selector\";s:44:\".details-wrapper table thead th:nth-child(1)\";}s:36:\"search-api-index-fields-machine-name\";a:6:{s:2:\"id\";s:36:\"search-api-index-fields-machine-name\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:12:\"Machine name\";s:4:\"body\";s:164:\"The internal ID to use for this field. Can safely be ignored by inexperienced users in most cases. Changing a field's machine name requires reindexing of the index.\";s:6:\"weight\";i:4;s:8:\"selector\";s:44:\".details-wrapper table thead th:nth-child(2)\";}s:37:\"search-api-index-fields-property-path\";a:6:{s:2:\"id\";s:37:\"search-api-index-fields-property-path\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Property path\";s:4:\"body\";s:187:\"The internal relationship linking the indexed item to the field, with links being separated by colons (:). This can be useful information for advanced users, but can otherwise be ignored.\";s:6:\"weight\";i:5;s:8:\"selector\";s:44:\".details-wrapper table thead th:nth-child(3)\";}s:28:\"search-api-index-fields-type\";a:6:{s:2:\"id\";s:28:\"search-api-index-fields-type\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:4:\"Type\";s:4:\"body\";s:228:\"The data type to use when indexing the field. Determines how a field can be used in searches. For information on the available types, see the <a href=\"#search-api-data-types-table\">\"Data types\" box</a> at the bottom of the page.\";s:6:\"weight\";i:6;s:8:\"selector\";s:44:\".details-wrapper table thead th:nth-child(4)\";}s:29:\"search-api-index-fields-boost\";a:6:{s:2:\"id\";s:29:\"search-api-index-fields-boost\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:5:\"Boost\";s:4:\"body\";s:154:\"Only applicable for fulltext fields. Determines how \"important\" the field is compared to other fulltext fields, to influence scoring of fulltext searches.\";s:6:\"weight\";i:7;s:8:\"selector\";s:44:\".details-wrapper table thead th:nth-child(5)\";}s:28:\"search-api-index-fields-edit\";a:6:{s:2:\"id\";s:28:\"search-api-index-fields-edit\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:10:\"Edit field\";s:4:\"body\";s:122:\"Some fields have additional configuration available, in which case an \"Edit\" link is displayed in the \"Operations\" column.\";s:6:\"weight\";i:8;s:8:\"selector\";s:46:\".details-wrapper table tbody td:nth-child(6) a\";}s:30:\"search-api-index-fields-remove\";a:6:{s:2:\"id\";s:30:\"search-api-index-fields-remove\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:12:\"Remove field\";s:4:\"body\";s:129:\"Removes a field from the index again. (Note: Sometimes, a field is required (for example, by a processor) and cannot be removed.)\";s:6:\"weight\";i:9;s:8:\"selector\";s:46:\".details-wrapper table tbody td:nth-child(7) a\";}s:30:\"search-api-index-fields-submit\";a:6:{s:2:\"id\";s:30:\"search-api-index-fields-submit\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:12:\"Save changes\";s:4:\"body\";s:218:\"This saves all changes made to the fields for this index. Until this button is pressed, all added, changed or removed fields will only be stored temporarily and not effect the actual index used in the rest of the site.\";s:6:\"weight\";i:10;s:8:\"selector\";s:20:\"#edit-actions-submit\";}s:30:\"search-api-index-fields-cancel\";a:6:{s:2:\"id\";s:30:\"search-api-index-fields-cancel\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:14:\"Cancel changes\";s:4:\"body\";s:120:\"If you have made changes to the index's fields but not yet saved them, the \"Cancel\" link lets you discard those changes.\";s:6:\"weight\";i:10;s:8:\"selector\";s:20:\"#edit-actions-cancel\";}}}",
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.search-api-index-form',
  'data' => "a:10:{s:4:\"uuid\";s:36:\"68fde9cc-8d90-4e6e-88a1-19869007593e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"search_api\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sQzCtjeNBZnQCDro5e8B7_KNpDYVoetYDs4iaf1xBOA\";}s:2:\"id\";s:21:\"search-api-index-form\";s:5:\"label\";s:30:\"Add or edit a Search API index\";s:6:\"module\";s:10:\"search_api\";s:6:\"routes\";a:2:{i:0;a:1:{s:10:\"route_name\";s:32:\"entity.search_api_index.add_form\";}i:1;a:1:{s:10:\"route_name\";s:33:\"entity.search_api_index.edit_form\";}}s:4:\"tips\";a:7:{s:34:\"search-api-index-form-introduction\";a:5:{s:2:\"id\";s:34:\"search-api-index-form-introduction\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:26:\"Adding or editing an index\";s:4:\"body\";s:156:\"This form can be used to edit an existing index or add a new index to your site. Indexes define a set of data that will be indexed and can then be searched.\";s:6:\"weight\";i:1;}s:26:\"search-api-index-form-name\";a:6:{s:2:\"id\";s:26:\"search-api-index-form-name\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:10:\"Index name\";s:4:\"body\";s:123:\"Enter a name to identify this index. For example, \"Content index\". This will only be displayed in the admin user interface.\";s:6:\"weight\";i:2;s:8:\"selector\";s:10:\"#edit-name\";}s:33:\"search-api-index-form-datasources\";a:6:{s:2:\"id\";s:33:\"search-api-index-form-datasources\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:11:\"Datasources\";s:4:\"body\";s:210:\"Datasources define the types of items that will be indexed in this index. By default, all content entities (like content, comments and taxonomy terms) will be available here, but modules can also add their own.\";s:6:\"weight\";i:3;s:8:\"selector\";s:17:\"#edit-datasources\";}s:29:\"search-api-index-form-tracker\";a:6:{s:2:\"id\";s:29:\"search-api-index-form-tracker\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:7:\"Tracker\";s:4:\"body\";s:223:\"An index's tracker is the system that keeps track of which items there are available for the index, and which of them still need to be indexed. Changing the tracker of an existing index will lead to reindexing of all items.\";s:6:\"weight\";i:4;s:8:\"selector\";s:13:\"#edit-tracker\";}s:28:\"search-api-index-form-server\";a:6:{s:2:\"id\";s:28:\"search-api-index-form-server\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:6:\"Server\";s:4:\"body\";s:211:\"The search server that the index should use for indexing and searching. If no server is selected here, the index cannot be enabled. An index can only have one server, but a server can have any number of indexes.\";s:6:\"weight\";i:5;s:8:\"selector\";s:12:\"#edit-server\";}s:33:\"search-api-index-form-description\";a:6:{s:2:\"id\";s:33:\"search-api-index-form-description\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:17:\"Index description\";s:4:\"body\";s:141:\"Optionally, enter a description to explain the function of the index in more detail. This will only be displayed in the admin user interface.\";s:6:\"weight\";i:6;s:8:\"selector\";s:17:\"#edit-description\";}s:29:\"search-api-index-form-options\";a:6:{s:2:\"id\";s:29:\"search-api-index-form-options\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:16:\"Advanced options\";s:4:\"body\";s:124:\"These options allow more detailed configuration of index behavior, but can usually safely be ignored by inexperienced users.\";s:6:\"weight\";i:7;s:8:\"selector\";s:13:\"#edit-options\";}}}",
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.search-api-index-processors',
  'data' => "a:10:{s:4:\"uuid\";s:36:\"a1aa38cc-d015-4128-a180-882326419ca8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"search_api\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vs6bUgjvoJIdOBQIcX2l2Dp6BXpVFbs-h6PsKOmZfYk\";}s:2:\"id\";s:27:\"search-api-index-processors\";s:5:\"label\";s:30:\"Processors used for this index\";s:6:\"module\";s:10:\"search_api\";s:6:\"routes\";a:1:{i:0;a:1:{s:10:\"route_name\";s:34:\"entity.search_api_index.processors\";}}s:4:\"tips\";a:4:{s:40:\"search-api-index-processors-introduction\";a:5:{s:2:\"id\";s:40:\"search-api-index-processors-introduction\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:30:\"Processors used for this index\";s:4:\"body\";s:169:\"Processors customize different aspects of an index's functionality. They can keep items from being indexed, change how certain fields are indexed and influence searches.\";s:6:\"weight\";i:1;}s:34:\"search-api-index-processors-enable\";a:6:{s:2:\"id\";s:34:\"search-api-index-processors-enable\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:17:\"Enable processors\";s:4:\"body\";s:146:\"This lists all processors available for this index and lets you choose the ones that should be active. (Note: Some processors cannot be disabled.)\";s:6:\"weight\";i:2;s:8:\"selector\";s:12:\"#edit-status\";}s:35:\"search-api-index-processors-weights\";a:6:{s:2:\"id\";s:35:\"search-api-index-processors-weights\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:15:\"Processor order\";s:4:\"body\";s:297:\"This shows you which enabled processors will be active in the different parts of the indexing/searching workflow, and lets you re-arrange them. This should usually not be necessary, and only be used by advanced users as some processors will lead to unexpected results when used in the wrong order.\";s:6:\"weight\";i:3;s:8:\"selector\";s:13:\"#edit-weights\";}s:36:\"search-api-index-processors-settings\";a:6:{s:2:\"id\";s:36:\"search-api-index-processors-settings\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:18:\"Processor settings\";s:4:\"body\";s:91:\"Some processors have additional configuration available, which you are able to change here.\";s:6:\"weight\";i:4;s:8:\"selector\";s:25:\".form-type--vertical-tabs\";}}}",
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.search-api-server',
  'data' => "a:10:{s:4:\"uuid\";s:36:\"5ff90830-b991-42b7-93d1-bf6f37888330\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"search_api\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XF-X52fvU1eywjOhWClTlaZiOmijG87qNfkOFlqg2cI\";}s:2:\"id\";s:17:\"search-api-server\";s:5:\"label\";s:26:\"Information about a server\";s:6:\"module\";s:10:\"search_api\";s:6:\"routes\";a:1:{i:0;a:1:{s:10:\"route_name\";s:34:\"entity.search_api_server.canonical\";}}s:4:\"tips\";a:5:{s:30:\"search-api-server-introduction\";a:5:{s:2:\"id\";s:30:\"search-api-server-introduction\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:26:\"Information about a server\";s:4:\"body\";s:45:\"This page shows a summary of a search server.\";s:6:\"weight\";i:1;}s:24:\"search-api-server-status\";a:6:{s:2:\"id\";s:24:\"search-api-server-status\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:6:\"Status\";s:4:\"body\";s:58:\"Shows whether the server is currently enabled or disabled.\";s:6:\"weight\";i:2;s:8:\"selector\";s:34:\".search-api-server-summary--status\";}s:25:\"search-api-server-backend\";a:6:{s:2:\"id\";s:25:\"search-api-server-backend\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Backend class\";s:4:\"body\";s:167:\"The backend plugin used for this server. The backend plugin determines how items are indexed and searched – for example, using the database or an Apache Solr server.\";s:6:\"weight\";i:3;s:8:\"selector\";s:35:\".search-api-server-summary--backend\";}s:25:\"search-api-server-indexes\";a:6:{s:2:\"id\";s:25:\"search-api-server-indexes\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:14:\"Search indexes\";s:4:\"body\";s:58:\"Lists all search indexes that are attached to this server.\";s:6:\"weight\";i:4;s:8:\"selector\";s:35:\".search-api-server-summary--indexes\";}s:23:\"search-api-server-clear\";a:6:{s:2:\"id\";s:23:\"search-api-server-clear\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:23:\"Delete all indexed data\";s:4:\"body\";s:226:\"This will permanently remove all data currently indexed on this server for indexes that aren't read-only. Items are queued for reindexing. Until reindexing occurs, searches for the affected indexes will not return any results.\";s:6:\"weight\";i:5;s:8:\"selector\";s:11:\"#edit-clear\";}}}",
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.search-api-server-form',
  'data' => 'a:10:{s:4:"uuid";s:36:"e387a1e1-6f9a-4e9c-8e14-80fc11f0e0e8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:10:"search_api";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0kIrvs9YL0PKR2nGfa7deQoPoXrWR5nUI0UtCfj04LA";}s:2:"id";s:22:"search-api-server-form";s:5:"label";s:31:"Add or edit a Search API server";s:6:"module";s:10:"search_api";s:6:"routes";a:2:{i:0;a:1:{s:10:"route_name";s:33:"entity.search_api_server.add_form";}i:1;a:1:{s:10:"route_name";s:34:"entity.search_api_server.edit_form";}}s:4:"tips";a:4:{s:35:"search-api-server-form-introduction";a:5:{s:2:"id";s:35:"search-api-server-form-introduction";s:6:"plugin";s:4:"text";s:5:"label";s:26:"Adding or editing a Server";s:4:"body";s:119:"This form can be used to edit an existing server or add a new server to your site. Servers will hold your indexed data.";s:6:"weight";i:1;}s:27:"search-api-server-form-name";a:6:{s:2:"id";s:27:"search-api-server-form-name";s:6:"plugin";s:4:"text";s:5:"label";s:11:"Server name";s:4:"body";s:122:"Enter a name to identify this server. For example, "Solr server". This will only be displayed in the admin user interface.";s:6:"weight";i:2;s:8:"selector";s:10:"#edit-name";}s:34:"search-api-server-form-description";a:6:{s:2:"id";s:34:"search-api-server-form-description";s:6:"plugin";s:4:"text";s:5:"label";s:18:"Server description";s:4:"body";s:142:"Optionally, enter a description to explain the function of the server in more detail. This will only be displayed in the admin user interface.";s:6:"weight";i:3;s:8:"selector";s:17:"#edit-description";}s:30:"search-api-server-form-backend";a:6:{s:2:"id";s:30:"search-api-server-form-backend";s:6:"plugin";s:4:"text";s:5:"label";s:14:"Server backend";s:4:"body";s:366:"Servers can be based on different technologies. These are called "backends". A server uses exactly one backend and cannot change it later. You can make the "Database" backend available by enabling the "Database Search" module. Another very common backend is <a href="https://www.drupal.org/project/search_api_solr">"Solr"</a>, which requires to be set up separately.";s:6:"weight";i:4;s:8:"selector";s:13:"#edit-backend";}}}',
))
->values(array(
  'collection' => '',
  'name' => 'tour.tour.views-ui',
  'data' => "a:10:{s:4:\"uuid\";s:36:\"bf4fc1d1-41ac-49b2-8d22-e34f3a6bf5d9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"views_ui\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XIYL1KF7ND2XQRa5AxvEcp8vgCN2kUGiuBNhCgxrPME\";}s:2:\"id\";s:8:\"views-ui\";s:5:\"label\";s:14:\"View edit page\";s:6:\"module\";s:8:\"views_ui\";s:6:\"routes\";a:2:{i:0;a:1:{s:10:\"route_name\";s:21:\"entity.view.edit_form\";}i:1;a:1:{s:10:\"route_name\";s:29:\"entity.view.edit_display_form\";}}s:4:\"tips\";a:10:{s:10:\"views-main\";a:5:{s:2:\"id\";s:10:\"views-main\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:20:\"Manage view settings\";s:6:\"weight\";i:1;s:4:\"body\";s:31:\"View or edit the configuration.\";}s:17:\"views-ui-displays\";a:6:{s:2:\"id\";s:17:\"views-ui-displays\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:21:\"Displays in this view\";s:6:\"weight\";i:2;s:8:\"selector\";s:18:\"#views-display-top\";s:4:\"body\";s:169:\"A display is a way of outputting the results, e.g., as a page or a block. A view can contain multiple displays, which are listed here. The active display is highlighted.\";}s:19:\"views-ui-view-admin\";a:7:{s:2:\"id\";s:19:\"views-ui-view-admin\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:19:\"View administration\";s:6:\"weight\";i:3;s:8:\"position\";s:5:\"right\";s:8:\"selector\";s:28:\"#views-display-extra-actions\";s:4:\"body\";s:140:\"Perform administrative tasks, including adding a description and creating a clone. Click the drop-down button to view the available options.\";}s:15:\"views-ui-format\";a:6:{s:2:\"id\";s:15:\"views-ui-format\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Output format\";s:6:\"weight\";i:4;s:8:\"selector\";s:35:\".views-ui-display-tab-bucket.format\";s:4:\"body\";s:325:\"Choose how to output results. E.g., choose <em>Content</em> to output each item completely, using your configured display settings. Or choose <em>Fields</em>, which allows you to output only specific fields for each result. Additional formats can be added by installing modules to <em>extend</em> Drupal's base functionality.\";}s:15:\"views-ui-fields\";a:6:{s:2:\"id\";s:15:\"views-ui-fields\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:6:\"Fields\";s:6:\"weight\";i:5;s:8:\"selector\";s:34:\".views-ui-display-tab-bucket.field\";s:4:\"body\";s:89:\"If this view uses fields, they are listed here. You can click on a field to configure it.\";}s:15:\"views-ui-filter\";a:6:{s:2:\"id\";s:15:\"views-ui-filter\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:16:\"Filter your view\";s:6:\"weight\";i:6;s:8:\"selector\";s:35:\".views-ui-display-tab-bucket.filter\";s:4:\"body\";s:173:\"Add filters to limit the results in the output. E.g., to only show content that is <em>published</em>, you would add a filter for <em>Published</em> and select <em>Yes</em>.\";}s:26:\"views-ui-filter-operations\";a:6:{s:2:\"id\";s:26:\"views-ui-filter-operations\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:14:\"Filter actions\";s:6:\"weight\";i:7;s:8:\"selector\";s:54:\".views-ui-display-tab-bucket.filter .dropbutton-widget\";s:4:\"body\";s:33:\"Add, rearrange or remove filters.\";}s:14:\"views-ui-sorts\";a:6:{s:2:\"id\";s:14:\"views-ui-sorts\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:13:\"Sort Criteria\";s:6:\"weight\";i:8;s:8:\"selector\";s:33:\".views-ui-display-tab-bucket.sort\";s:4:\"body\";s:96:\"Control the order in which the results are output. Click on an active sort rule to configure it.\";}s:25:\"views-ui-sorts-operations\";a:6:{s:2:\"id\";s:25:\"views-ui-sorts-operations\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:12:\"Sort actions\";s:6:\"weight\";i:9;s:8:\"selector\";s:52:\".views-ui-display-tab-bucket.sort .dropbutton-widget\";s:4:\"body\";s:39:\"Add, rearrange or remove sorting rules.\";}s:16:\"views-ui-preview\";a:7:{s:2:\"id\";s:16:\"views-ui-preview\";s:6:\"plugin\";s:4:\"text\";s:5:\"label\";s:7:\"Preview\";s:6:\"weight\";i:10;s:8:\"position\";s:5:\"right\";s:8:\"selector\";s:15:\"#preview-submit\";s:4:\"body\";s:34:\"Show a preview of the view output.\";}}}",
))
->values(array(
  'collection' => '',
  'name' => 'update.settings',
  'data' => 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2QzULf0zovJQx3J06Y9rufzzfi-CY2CTTlEfJJh2Qyw";}s:5:"check";a:2:{s:19:"disabled_extensions";b:0;s:13:"interval_days";i:1;}s:5:"fetch";a:3:{s:3:"url";s:0:"";s:12:"max_attempts";i:2;s:7:"timeout";i:30;}s:12:"notification";a:2:{s:6:"emails";a:1:{i:0;s:17:"admin@example.com";}s:9:"threshold";s:3:"all";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.flood',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs";}s:8:"uid_only";b:0;s:8:"ip_limit";i:50;s:9:"ip_window";i:3600;s:10:"user_limit";i:5;s:11:"user_window";i:21600;}',
))
->values(array(
  'collection' => '',
  'name' => 'user.mail',
  'data' => "a:11:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6CZIzFifRq3qbdq3n3nDpEOO4hWIQtKOAQNPvGNGKeM\";}s:8:\"langcode\";s:2:\"en\";s:14:\"cancel_confirm\";a:2:{s:7:\"subject\";s:67:\"Account cancellation request for [user:display-name] at [site:name]\";s:4:\"body\";s:376:\"[user:display-name]\n\nA request to cancel your account has been made at [site:name].\n\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\n\n[user:cancel-url]\n\nNOTE: The cancellation of your account is not reversible.\n\nThis link expires in one day and nothing will happen if it is not used.\n\n--  [site:name] team\";}s:14:\"password_reset\";a:2:{s:7:\"subject\";s:68:\"Replacement login information for [user:display-name] at [site:name]\";s:4:\"body\";s:407:\"[user:display-name],\n\nA request to reset the password for your account has been made at [site:name].\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it's not used.\n\n--  [site:name] team\";}s:22:\"register_admin_created\";a:2:{s:7:\"subject\";s:58:\"An administrator created an account for you at [site:name]\";s:4:\"body\";s:473:\"[user:display-name],\n\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team\";}s:29:\"register_no_approval_required\";a:2:{s:7:\"subject\";s:54:\"Account details for [user:display-name] at [site:name]\";s:4:\"body\";s:447:\"[user:display-name],\n\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team\";}s:25:\"register_pending_approval\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:288:\"[user:display-name],\n\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n--  [site:name] team\";}s:31:\"register_pending_approval_admin\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:64:\"[user:display-name] has applied for an account.\n\n[user:edit-url]\";}s:16:\"status_activated\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (approved)\";s:4:\"body\";s:462:\"[user:display-name],\n\nYour account at [site:name] has been activated.\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:account-name]\npassword: Your password\n\n--  [site:name] team\";}s:14:\"status_blocked\";a:2:{s:7:\"subject\";s:64:\"Account details for [user:display-name] at [site:name] (blocked)\";s:4:\"body\";s:89:\"[user:display-name],\n\nYour account on [site:name] has been blocked.\n\n--  [site:name] team\";}s:15:\"status_canceled\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (canceled)\";s:4:\"body\";s:90:\"[user:display-name],\n\nYour account on [site:name] has been canceled.\n\n--  [site:name] team\";}}",
))
->values(array(
  'collection' => '',
  'name' => 'user.role.administrator',
  'data' => 'a:10:{s:4:"uuid";s:36:"fcb87241-6a39-4701-80ce-e2dad89a74a2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OeKGIkmZA_c-t6QLH81WNQx8gDCc1MRmxaTuQgxBByU";}s:2:"id";s:13:"administrator";s:5:"label";s:13:"Administrator";s:6:"weight";i:3;s:8:"is_admin";b:1;s:11:"permissions";a:0:{}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.anonymous',
  'data' => 'a:10:{s:4:"uuid";s:36:"8afec650-295d-4112-a86f-03b2aca774c1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:29:"filter.format.restricted_html";}s:6:"module";a:7:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:6:"filter";i:3;s:12:"localgov_geo";i:4;s:5:"media";i:5;s:6:"search";i:6;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6WavjUYXIegP9AAg2zXGx54MWIVoomC3SZhNiqe-Dyk";}s:2:"id";s:9:"anonymous";s:5:"label";s:14:"Anonymous user";s:6:"weight";i:0;s:8:"is_admin";b:0;s:11:"permissions";a:7:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:29:"access site-wide contact form";i:3;s:14:"search content";i:4;s:31:"use text format restricted_html";i:5;s:8:"view geo";i:6;s:10:"view media";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.authenticated',
  'data' => 'a:10:{s:4:"uuid";s:36:"92046314-fe87-42fc-87b9-468b9dc61b59";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"filter.format.basic_html";i:1;s:21:"filter.format.wysiwyg";}s:6:"module";a:8:{i:0;s:7:"comment";i:1;s:7:"contact";i:2;s:6:"filter";i:3;s:12:"localgov_geo";i:4;s:5:"media";i:5;s:6:"search";i:6;s:8:"shortcut";i:7;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I44QAB4es39lNzMQWiJLq2dfjX7VRSOzT_5KzAcUq_M";}s:2:"id";s:13:"authenticated";s:5:"label";s:18:"Authenticated user";s:6:"weight";i:1;s:8:"is_admin";b:0;s:11:"permissions";a:11:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:16:"access shortcuts";i:3;s:29:"access site-wide contact form";i:4;s:13:"post comments";i:5;s:14:"search content";i:6;s:21:"skip comment approval";i:7;s:26:"use text format basic_html";i:8;s:23:"use text format wysiwyg";i:9;s:8:"view geo";i:10;s:10:"view media";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.role.content_editor',
  'data' => 'a:10:{s:4:"uuid";s:36:"1e21d688-0ce4-4383-ac54-cf36cc6094f0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:17:"node.type.article";i:1;s:14:"node.type.page";i:2;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:9:{i:0;s:7:"comment";i:1;s:10:"contextual";i:2;s:4:"file";i:3;s:4:"node";i:4;s:4:"path";i:5;s:6:"system";i:6;s:8:"taxonomy";i:7;s:7:"toolbar";i:8;s:4:"tour";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Wur9kcEOwY1Jal81NssKnz3RhVJxAvBwyWQBGcA_1Go";}s:2:"id";s:14:"content_editor";s:5:"label";s:14:"Content editor";s:6:"weight";i:2;s:8:"is_admin";b:0;s:11:"permissions";a:23:{i:0;s:27:"access administration pages";i:1;s:23:"access content overview";i:2;s:23:"access contextual links";i:3;s:21:"access files overview";i:4;s:14:"access toolbar";i:5;s:11:"access tour";i:6;s:22:"administer url aliases";i:7;s:22:"create article content";i:8;s:19:"create page content";i:9;s:20:"create terms in tags";i:10;s:18:"create url aliases";i:11;s:24:"delete article revisions";i:12;s:26:"delete own article content";i:13;s:23:"delete own page content";i:14;s:21:"delete page revisions";i:15;s:24:"edit own article content";i:16;s:17:"edit own comments";i:17;s:21:"edit own page content";i:18;s:18:"edit terms in tags";i:19;s:20:"revert all revisions";i:20;s:18:"view all revisions";i:21;s:28:"view own unpublished content";i:22;s:29:"view the administration theme";}}',
))
->values(array(
  'collection' => '',
  'name' => 'user.settings',
  'data' => 'a:9:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-htDFWUv1S4OlJMzta2nhFl4QbhJvu0D9xsJ-clxo-M";}s:8:"langcode";s:2:"en";s:9:"anonymous";s:9:"Anonymous";s:11:"verify_mail";b:1;s:6:"notify";a:8:{s:14:"cancel_confirm";b:1;s:14:"password_reset";b:1;s:16:"status_activated";b:1;s:14:"status_blocked";b:0;s:15:"status_canceled";b:0;s:22:"register_admin_created";b:1;s:29:"register_no_approval_required";b:1;s:25:"register_pending_approval";b:1;}s:8:"register";s:23:"visitors_admin_approval";s:13:"cancel_method";s:17:"user_cancel_block";s:22:"password_reset_timeout";i:86400;s:17:"password_strength";b:1;}',
))
->values(array(
  'collection' => '',
  'name' => 'views.settings',
  'data' => 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uZHsLrDp1ThO0RvupHKcPzLOyVvWexm58JTTHNDo7yc";}s:17:"display_extenders";a:0:{}s:10:"skip_cache";b:0;s:13:"sql_signature";b:0;s:2:"ui";a:3:{s:4:"show";a:7:{s:18:"additional_queries";b:0;s:15:"advanced_column";b:0;s:15:"default_display";b:0;s:22:"performance_statistics";b:0;s:19:"preview_information";b:1;s:9:"sql_query";a:2:{s:7:"enabled";b:0;s:5:"where";s:5:"above";}s:13:"display_embed";b:0;}s:19:"always_live_preview";b:1;s:24:"exposed_filter_any_label";s:7:"old_any";}s:22:"field_rewrite_elements";a:29:{s:3:"div";s:3:"DIV";s:4:"span";s:4:"SPAN";s:2:"h1";s:2:"H1";s:2:"h2";s:2:"H2";s:2:"h3";s:2:"H3";s:2:"h4";s:2:"H4";s:2:"h5";s:2:"H5";s:2:"h6";s:2:"H6";s:1:"p";s:1:"P";s:6:"header";s:6:"HEADER";s:6:"footer";s:6:"FOOTER";s:7:"article";s:7:"ARTICLE";s:7:"section";s:7:"SECTION";s:5:"aside";s:5:"ASIDE";s:7:"details";s:7:"DETAILS";s:10:"blockquote";s:10:"BLOCKQUOTE";s:6:"figure";s:6:"FIGURE";s:7:"address";s:7:"ADDRESS";s:4:"code";s:4:"CODE";s:3:"pre";s:3:"PRE";s:3:"var";s:3:"VAR";s:4:"samp";s:4:"SAMP";s:3:"kbd";s:3:"KBD";s:6:"strong";s:6:"STRONG";s:2:"em";s:2:"EM";s:3:"del";s:3:"DEL";s:3:"ins";s:3:"INS";s:1:"q";s:1:"Q";s:1:"s";s:1:"S";}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.archive',
  'data' => 'a:13:{s:4:"uuid";s:36:"8c6d48fa-5ef0-4ee5-925f-c29f96e63fd9";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ko9GznzNBXHkuz09OCaBQ1YOSJYYjTY0TBpNV3WKnog";}s:2:"id";s:7:"archive";s:5:"label";s:7:"Archive";s:6:"module";s:4:"node";s:11:"description";s:22:"All content, by month.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:15:"Monthly archive";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:2:{s:8:"override";b:1;s:14:"items_per_page";i:30;}s:7:"summary";a:2:{s:10:"sort_order";s:4:"desc";s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:0;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:1:{s:14:"items_per_page";i:30;}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"archive";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.block_content',
  'data' => 'a:13:{s:4:"uuid";s:36:"ba7c1c4f-713f-40fd-a09b-6fb6c7df04f1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jvd5Pu6jy-lra4oMr-mR7zuY6CVDv9CaNeoj0Y70gV4";}s:2:"id";s:13:"block_content";s:5:"label";s:20:"Custom block library";s:6:"module";s:5:"views";s:11:"description";s:30:"Find and manage custom blocks.";s:3:"tag";s:7:"default";s:10:"base_table";s:24:"block_content_field_data";s:10:"base_field";s:2:"id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:20:"Custom block library";s:6:"fields";a:4:{s:4:"info";a:37:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:5:"field";s:5:"label";s:17:"Block description";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Block type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:13:"block_content";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:17:"administer blocks";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:2:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:37:"There are no custom blocks available.";s:8:"tokenize";b:0;}s:27:"block_content_listing_empty";a:10:{s:2:"id";s:27:"block_content_listing_empty";s:5:"table";s:13:"block_content";s:5:"field";s:27:"block_content_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:27:"block_content_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:4:"info";a:16:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"info_op";s:5:"label";s:17:"Block description";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"info_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"info";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:10:"Block type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"reusable";a:16:{s:2:"id";s:8:"reusable";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:8:"reusable";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:8:"reusable";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:4:"info";s:4:"info";s:4:"type";s:4:"type";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:4:{s:4:"info";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:35:"admin/structure/block/block-content";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:20:"Custom block library";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:19:"block.admin_display";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.comment',
  'data' => 'a:13:{s:4:"uuid";s:36:"3bf1a4e0-618d-4f52-a1ee-67aef466ea00";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CgXkKY33fd-yaHz89du2hSw6MJOoIeNUJ-VHE5BiSdQ";}s:2:"id";s:7:"comment";s:5:"label";s:8:"Comments";s:6:"module";s:7:"comment";s:11:"description";s:25:"Find and manage comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:26:{s:5:"title";s:8:"Comments";s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:24:"comment_unpublish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"next ›";s:8:"previous";s:12:"‹ previous";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"administer comments";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:6:{s:17:"comment_bulk_form";s:17:"comment_bulk_form";s:7:"subject";s:7:"subject";s:3:"uid";s:3:"uid";s:9:"entity_id";s:9:"entity_id";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:6:{s:17:"comment_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"subject";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"entity_id";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:1;s:13:"use_more_text";s:4:"more";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:14:"page_published";a:6:{s:2:"id";s:14:"page_published";s:13:"display_title";s:18:"Published comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:19:"display_description";s:30:"The approved comments listing.";s:15:"display_comment";s:0:"";s:13:"exposed_block";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:21:"admin/content/comment";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:8:"Comments";s:11:"description";s:18:"Comments published";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:15:"page_unapproved";a:6:{s:2:"id";s:15:"page_unapproved";s:13:"display_title";s:19:"Unapproved comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:8:{s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:22:"comment_publish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:8:"defaults";a:3:{s:6:"fields";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:19:"display_description";s:32:"The unapproved comments listing.";s:17:"display_extenders";a:0:{}s:4:"path";s:30:"admin/content/comment/approval";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:19:"Unapproved comments";s:11:"description";s:19:"Comments unapproved";s:6:"weight";i:1;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.comments_recent',
  'data' => 'a:13:{s:4:"uuid";s:36:"930ce418-8e21-4fc0-af93-4e5c717dbf36";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:7:"comment";i:1;s:4:"node";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"S_NN2ubd_NovTfgzbHVlZMmIJJQS-3h9h3inzbaFUMY";}s:2:"id";s:15:"comments_recent";s:5:"label";s:15:"Recent comments";s:6:"module";s:5:"views";s:11:"description";s:16:"Recent comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:14:{s:5:"title";s:15:"Recent comments";s:6:"fields";a:2:{s:7:"subject";a:26:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:1:{s:4:"type";s:5:"basic";}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:15:"access comments";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:2:{s:7:"created";a:12:{s:2:"id";s:7:"created";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;}s:3:"cid";a:12:{s:2:"id";s:3:"cid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"cid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"cid";s:9:"plugin_id";s:5:"field";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"cid";}s:7:"exposed";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:11:"status_node";a:10:{s:2:"id";s:11:"status_node";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"node";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:2:{s:22:"default_field_elements";b:1;s:10:"hide_empty";b:0;}}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:4:"node";a:5:{s:2:"id";s:4:"node";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"node";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:17:"block_description";s:15:"Recent comments";s:14:"block_category";s:13:"Lists (Views)";s:5:"allow";a:1:{s:14:"items_per_page";b:1;}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.content',
  'data' => 'a:13:{s:4:"uuid";s:36:"0cfeb7bc-f30c-4eae-aeda-5b3089dd2e0d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vBKWYGGDoAX-tFd1JErB8tZLSxx3lJ0foouVsgpcbB4";}s:2:"id";s:7:"content";s:5:"label";s:7:"Content";s:6:"module";s:4:"node";s:11:"description";s:24:"Find and manage content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:7:"Content";s:6:"fields";a:7:{s:14:"node_bulk_form";a:14:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:14:"node_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"title";a:17:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Content type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:17:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:17:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}}s:7:"changed";a:17:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:10:"operations";a:23:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:2:{s:14:"items_per_page";i:50;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:23:"access content overview";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"status_extra";a:9:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:10:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:7:"changed";s:7:"changed";s:9:"edit_node";s:9:"edit_node";s:11:"delete_node";s:11:"delete_node";s:10:"dropbutton";s:10:"dropbutton";s:9:"timestamp";s:5:"title";}s:7:"default";s:7:"changed";s:4:"info";a:10:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"delete_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:3:"uid";a:6:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:4:"path";s:18:"admin/content/node";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:7:"Content";s:11:"description";s:0:"";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:23:"Find and manage content";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.content_recent',
  'data' => 'a:13:{s:4:"uuid";s:36:"496bd9df-282a-4c32-8c55-3492e02198ba";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YqZN5rc7XDQcFcInc8wkzuaHJmC5YvirhTmDcrarT6M";}s:2:"id";s:14:"content_recent";s:5:"label";s:14:"Recent content";s:6:"module";s:4:"node";s:11:"description";s:15:"Recent content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:22:{s:5:"title";s:14:"Recent content";s:6:"fields";a:2:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"More";s:12:"link_display";s:1:"0";s:8:"link_url";s:0:"";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:1:{s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.files',
  'data' => 'a:13:{s:4:"uuid";s:36:"495a5ebb-b92c-4b41-b6a5-d9ad6e2abba1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DaGeEDJMcbbQtgV96AuPeZ-0irMc_Oa6Zzh2U3Kmul8";}s:2:"id";s:5:"files";s:5:"label";s:5:"Files";s:6:"module";s:4:"file";s:11:"description";s:22:"Find and manage files.";s:3:"tag";s:7:"default";s:10:"base_table";s:12:"file_managed";s:10:"base_field";s:3:"fid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:5:"Files";s:6:"fields";a:8:{s:3:"fid";a:24:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:5:"field";s:5:"label";s:3:"Fid";s:7:"exclude";b:1;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"filename";a:36:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Name";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"file_link";s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:8:"filemime";a:25:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"MIME type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"file_filemime";}s:8:"filesize";a:25:{s:2:"id";s:8:"filesize";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filesize";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filesize";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Size";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"file_size";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:9:"Temporary";s:18:"format_custom_true";s:9:"Permanent";}}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Upload date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Changed date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:3:"fid";s:10:"group_type";s:3:"sum";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:7:"Used in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/content/files/usage/{{ fid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:1;s:20:"format_plural_string";s:21:"1 place@count places";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access files overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No files available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:8:"filename";a:16:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:8:"Filename";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filename_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filename";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"filemime";a:16:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:9:"MIME type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filemime_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filemime";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:11:"file_status";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"status_op";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:3:"fid";s:3:"fid";s:8:"filename";s:8:"filename";s:8:"filemime";s:8:"filemime";s:8:"filesize";s:8:"filesize";s:6:"status";s:6:"status";s:7:"created";s:7:"created";s:7:"changed";s:7:"changed";s:5:"count";s:5:"count";}s:7:"default";s:7:"changed";s:4:"info";a:8:{s:3:"fid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filename";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filemime";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:8:"filesize";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:1;s:16:"show_admin_links";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:14:"Files overview";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:2:{s:5:"pager";b:1;s:13:"relationships";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:0;}}s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/files";s:4:"menu";a:6:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Files";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_2";a:6:{s:2:"id";s:6:"page_2";s:13:"display_title";s:10:"File usage";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:15:{s:5:"title";s:10:"File usage";s:6:"fields";a:4:{s:12:"entity_label";a:23:{s:2:"id";s:12:"entity_label";s:5:"table";s:10:"file_usage";s:5:"field";s:12:"entity_label";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"entity_label";s:5:"label";s:6:"Entity";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:14:"link_to_entity";b:1;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:10:"file_usage";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:11:"Entity type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:6:"module";a:22:{s:2:"id";s:6:"module";s:5:"table";s:10:"file_usage";s:5:"field";s:6:"module";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:18:"Registering module";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:9:"Use count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:0;s:20:"format_plural_string";s:8:"1@count";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:5:"empty";a:0:{}s:9:"arguments";a:1:{s:3:"fid";a:23:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:8:"file_fid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:46:"File usage information for {{ arguments.fid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:3:"not";b:0;}}s:7:"filters";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:0:{}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:12:"entity_label";s:12:"entity_label";s:4:"type";s:4:"type";s:6:"module";s:6:"module";s:5:"count";s:5:"count";}s:7:"default";s:12:"entity_label";s:4:"info";a:4:{s:12:"entity_label";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:6:"module";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:0:{}}s:8:"defaults";a:11:{s:5:"empty";b:0;s:5:"title";b:0;s:5:"pager";b:0;s:8:"group_by";b:0;s:5:"style";b:0;s:3:"row";b:0;s:13:"relationships";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:0;s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:27:"admin/content/files/usage/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.frontpage',
  'data' => 'a:13:{s:4:"uuid";s:36:"accd6b89-7cad-47bf-b77f-d79916509e7a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6eeliKIydPjqyv5V__QqTfahvJMWkHjOVUUuUIdB1ik";}s:2:"id";s:9:"frontpage";s:5:"label";s:9:"Frontpage";s:6:"module";s:4:"node";s:11:"description";s:39:"All content promoted to the front page.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:0:"";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:3:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:181:"No front page content has been created yet.<br/>Follow the <a target="_blank" href="https://www.drupal.org/docs/user_guide/en/index.html">User Guide</a> to start building your site.";s:8:"tokenize";b:0;}s:18:"node_listing_empty";a:10:{s:2:"id";s:18:"node_listing_empty";s:5:"table";s:4:"node";s:5:"field";s:18:"node_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:18:"node_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}s:5:"title";a:10:{s:2:"id";s:5:"title";s:5:"table";s:5:"views";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:5:"title";s:5:"label";s:0:"";s:5:"empty";b:1;s:5:"title";s:8:"Welcome!";}}s:5:"sorts";a:2:{s:6:"sticky";a:12:{s:2:"id";s:6:"sticky";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"sticky";s:9:"plugin_id";s:7:"boolean";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:7:"promote";a:16:{s:2:"id";s:7:"promote";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"promote";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"promote";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:3:"rss";}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"rss.xml";s:14:"sitename_title";b:1;s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:28:"languages:language_interface";i:1;s:21:"user.node_grants:view";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:4:"node";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.glossary',
  'data' => 'a:13:{s:4:"uuid";s:36:"47633682-00ab-4dae-a4c9-117c5b3db267";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sz_FoMz5aClG4jFy4UDlkenXQtgTUXohEDjWVBuHaro";}s:2:"id";s:8:"glossary";s:5:"label";s:8:"Glossary";s:6:"module";s:4:"node";s:11:"description";s:23:"All content, by letter.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"fields";a:3:{s:5:"title";a:24:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:36;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:0:{}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"default";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:0:{}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;s:7:"columns";a:3:{s:5:"title";s:5:"title";s:4:"name";s:4:"name";s:7:"changed";s:7:"changed";}s:7:"default";s:5:"title";s:4:"info";a:3:{s:5:"title";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:4:"name";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:7:"changed";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:5:"order";s:3:"asc";s:11:"empty_table";b:0;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:22:"default_field_elements";b:1;s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:8:"use_ajax";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:12:"attachment_1";a:6:{s:2:"id";s:12:"attachment_1";s:13:"display_title";s:10:"Attachment";s:14:"display_plugin";s:10:"attachment";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"none";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:0;}}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:3:{s:14:"items_per_page";i:25;s:6:"inline";b:1;s:9:"separator";s:3:" | ";}s:7:"summary";a:1:{s:6:"format";s:19:"unformatted_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}s:8:"displays";a:2:{s:7:"default";s:7:"default";s:6:"page_1";s:6:"page_1";}s:17:"inherit_arguments";b:0;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:8:"glossary";s:4:"menu";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:8:"Glossary";s:6:"weight";i:0;s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.localgov_directory_channel',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"26bdcc8e-091f-472b-9ccb-06c6d73c5c6e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:35:\"field.storage.localgov_geo.location\";i:1;s:51:\"search_api.index.localgov_directories_index_default\";}s:6:\"module\";a:4:{i:0;s:8:\"geofield\";i:1;s:13:\"leaflet_views\";i:2;s:12:\"localgov_geo\";i:3;s:10:\"search_api\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eN4zGMUiShe29x5JZoARS7Vsl_Jqsy9sCDbE13bH6pY\";}s:2:\"id\";s:26:\"localgov_directory_channel\";s:5:\"label\";s:17:\"Directory channel\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:55:\"View to embed to display a particular directory channel\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:51:\"search_api_index_localgov_directories_index_default\";s:10:\"base_field\";s:13:\"search_api_id\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:16:{s:6:\"fields\";a:1:{s:32:\"localgov_directory_facets_select\";a:40:{s:2:\"id\";s:32:\"localgov_directory_facets_select\";s:5:\"table\";s:51:\"search_api_index_localgov_directories_index_default\";s:5:\"field\";s:32:\"localgov_directory_facets_select\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";N;s:12:\"entity_field\";N;s:9:\"plugin_id\";s:16:\"search_api_field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:15:\"field_rendering\";b:1;s:16:\"fallback_handler\";s:17:\"search_api_entity\";s:16:\"fallback_options\";a:5:{s:12:\"link_to_item\";b:0;s:16:\"use_highlighting\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:15:\"multi_separator\";s:2:\", \";s:15:\"display_methods\";a:0:{}}}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:0:{}}s:5:\"cache\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:2:{s:20:\"search_api_relevance\";a:10:{s:2:\"id\";s:20:\"search_api_relevance\";s:5:\"table\";s:51:\"search_api_index_localgov_directories_index_default\";s:5:\"field\";s:20:\"search_api_relevance\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:10:\"search_api\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:20:\"search_api_relevance\";}s:7:\"exposed\";b:0;}s:29:\"localgov_directory_title_sort\";a:10:{s:2:\"id\";s:29:\"localgov_directory_title_sort\";s:5:\"table\";s:51:\"search_api_index_localgov_directories_index_default\";s:5:\"field\";s:29:\"localgov_directory_title_sort\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:10:\"search_api\";s:5:\"order\";s:3:\"ASC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:29:\"localgov_directory_title_sort\";}s:7:\"exposed\";b:0;}}s:9:\"arguments\";a:1:{s:27:\"localgov_directory_channels\";a:21:{s:2:\"id\";s:27:\"localgov_directory_channels\";s:5:\"table\";s:51:\"search_api_index_localgov_directories_index_default\";s:5:\"field\";s:27:\"localgov_directory_channels\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:10:\"search_api\";s:14:\"default_action\";s:9:\"not found\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:0:{}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:3:\"not\";b:0;}}s:7:\"filters\";a:1:{s:19:\"search_api_fulltext\";a:17:{s:2:\"id\";s:19:\"search_api_fulltext\";s:5:\"table\";s:51:\"search_api_index_localgov_directories_index_default\";s:5:\"field\";s:19:\"search_api_fulltext\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:19:\"search_api_fulltext\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:22:\"search_api_fulltext_op\";s:5:\"label\";s:6:\"Search\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:22:\"search_api_fulltext_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:19:\"search_api_fulltext\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:2:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";}s:11:\"placeholder\";s:0:\"\";}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:10:\"parse_mode\";s:5:\"terms\";s:10:\"min_length\";N;s:6:\"fields\";a:0:{}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:10:\"search_api\";s:7:\"options\";a:1:{s:10:\"view_modes\";a:1:{s:11:\"entity:node\";a:2:{s:26:\"localgov_directories_venue\";s:6:\"teaser\";s:23:\"localgov_directory_page\";s:13:\"search_result\";}}}}s:5:\"query\";a:2:{s:4:\"type\";s:16:\"search_api_query\";s:7:\"options\";a:3:{s:13:\"bypass_access\";b:0;s:11:\"skip_access\";b:0;s:25:\"preserve_facet_query_args\";b:0;}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";}s:4:\"tags\";a:0:{}}}s:9:\"embed_map\";a:6:{s:2:\"id\";s:9:\"embed_map\";s:13:\"display_title\";s:10:\"Embed: map\";s:14:\"display_plugin\";s:5:\"embed\";s:8:\"position\";i:2;s:15:\"display_options\";a:11:{s:6:\"fields\";a:3:{s:5:\"title\";a:39:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:68:\"search_api_datasource_localgov_directories_index_default_entity_node\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:16:\"search_api_field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:15:\"field_rendering\";b:1;s:16:\"fallback_handler\";s:10:\"search_api\";s:16:\"fallback_options\";a:4:{s:12:\"link_to_item\";b:0;s:16:\"use_highlighting\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:15:\"multi_separator\";s:2:\", \";}}s:8:\"location\";a:39:{s:2:\"id\";s:8:\"location\";s:5:\"table\";s:30:\"search_api_entity_localgov_geo\";s:5:\"field\";s:8:\"location\";s:12:\"relationship\";s:17:\"localgov_location\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:12:\"localgov_geo\";s:9:\"plugin_id\";s:16:\"search_api_field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:16:\"geofield_default\";s:8:\"settings\";a:2:{s:13:\"output_format\";s:4:\"json\";s:13:\"output_escape\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:15:\"field_rendering\";b:1;s:16:\"fallback_handler\";s:10:\"search_api\";s:16:\"fallback_options\";a:4:{s:12:\"link_to_item\";b:0;s:16:\"use_highlighting\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:15:\"multi_separator\";s:2:\", \";}}s:24:\"search_api_rendered_item\";a:23:{s:2:\"id\";s:24:\"search_api_rendered_item\";s:5:\"table\";s:51:\"search_api_index_localgov_directories_index_default\";s:5:\"field\";s:24:\"search_api_rendered_item\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:24:\"search_api_rendered_item\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:10:\"view_modes\";a:1:{s:11:\"entity:node\";a:2:{s:25:\"localgov_directories_page\";s:6:\"teaser\";s:26:\"localgov_directories_venue\";s:6:\"teaser\";}}}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:1:{s:6:\"offset\";i:0;}}s:5:\"empty\";a:0:{}s:7:\"filters\";a:2:{s:19:\"search_api_fulltext\";a:17:{s:2:\"id\";s:19:\"search_api_fulltext\";s:5:\"table\";s:51:\"search_api_index_localgov_directories_index_default\";s:5:\"field\";s:19:\"search_api_fulltext\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:19:\"search_api_fulltext\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:22:\"search_api_fulltext_op\";s:5:\"label\";s:6:\"Search\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:22:\"search_api_fulltext_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:19:\"search_api_fulltext\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:2:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";}s:11:\"placeholder\";s:0:\"\";}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:10:\"parse_mode\";s:5:\"terms\";s:10:\"min_length\";N;s:6:\"fields\";a:0:{}}s:17:\"localgov_location\";a:18:{s:2:\"id\";s:17:\"localgov_location\";s:5:\"table\";s:51:\"search_api_index_localgov_directories_index_default\";s:5:\"field\";s:17:\"localgov_location\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:9:\"Proximity\";s:9:\"plugin_id\";s:19:\"search_api_location\";s:8:\"operator\";s:1:\"<\";s:5:\"value\";a:2:{s:5:\"value\";s:0:\"\";s:8:\"distance\";a:2:{s:4:\"from\";s:1:\"-\";s:2:\"to\";s:1:\"-\";}}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:20:\"localgov_location_op\";s:5:\"label\";s:8:\"Location\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:20:\"localgov_location_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:17:\"localgov_location\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:4:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:14:\"content_editor\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:6:\"plugin\";s:7:\"geocode\";s:14:\"plugin-geocode\";a:4:{s:7:\"plugins\";a:1:{s:20:\"localgov_default_osm\";a:2:{s:7:\"checked\";s:1:\"1\";s:6:\"weight\";s:1:\"0\";}}s:11:\"radius_type\";s:6:\"select\";s:14:\"radius_options\";s:71:\"- -\r\n1 1/2 mile\r\n2 1 mile\r\n3 2 miles\r\n5 3 miles\r\n8 5 miles\r\n16 10 miles\";s:12:\"radius_units\";s:2:\"km\";}s:18:\"plugin-geocode_map\";a:5:{s:19:\"radius_border_color\";s:0:\"\";s:20:\"radius_border_weight\";s:0:\"\";s:23:\"radius_background_color\";s:0:\"\";s:30:\"radius_background_transparency\";s:0:\"\";s:12:\"marker_image\";s:0:\"\";}s:10:\"plugin-raw\";a:3:{s:11:\"radius_type\";s:6:\"select\";s:14:\"radius_options\";s:71:\"- -\r\n1 1/2 mile\r\n2 1 mile\r\n3 2 miles\r\n5 3 miles\r\n8 5 miles\r\n16 10 miles\";s:12:\"radius_units\";s:2:\"km\";}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:11:\"leaflet_map\";s:7:\"options\";a:18:{s:8:\"grouping\";a:0:{}s:11:\"data_source\";a:1:{s:8:\"location\";s:8:\"location\";}s:13:\"entity_source\";s:12:\"__base_table\";s:20:\"entity_source_submit\";s:20:\"Update Entity Source\";s:10:\"name_field\";s:5:\"title\";s:9:\"view_mode\";s:4:\"full\";s:11:\"leaflet_map\";s:10:\"OSM Mapnik\";s:6:\"height\";s:3:\"400\";s:11:\"height_unit\";s:2:\"px\";s:14:\"hide_empty_map\";b:1;s:13:\"disable_wheel\";b:0;s:16:\"gesture_handling\";b:0;s:12:\"map_position\";a:6:{s:5:\"force\";b:0;s:6:\"center\";a:2:{s:3:\"lat\";d:0;s:3:\"lon\";d:0;}s:4:\"zoom\";i:12;s:7:\"minZoom\";i:1;s:7:\"maxZoom\";i:18;s:9:\"zoomFiner\";i:0;}s:6:\"weight\";s:0:\"\";s:4:\"icon\";a:12:{s:8:\"iconType\";s:6:\"marker\";s:7:\"iconUrl\";s:0:\"\";s:9:\"shadowUrl\";s:0:\"\";s:9:\"className\";s:0:\"\";s:8:\"iconSize\";a:2:{s:1:\"x\";s:0:\"\";s:1:\"y\";s:0:\"\";}s:10:\"iconAnchor\";a:2:{s:1:\"x\";s:0:\"\";s:1:\"y\";s:0:\"\";}s:10:\"shadowSize\";a:2:{s:1:\"x\";s:0:\"\";s:1:\"y\";s:0:\"\";}s:12:\"shadowAnchor\";a:2:{s:1:\"x\";s:0:\"\";s:1:\"y\";s:0:\"\";}s:11:\"popupAnchor\";a:2:{s:1:\"x\";s:0:\"\";s:1:\"y\";s:0:\"\";}s:4:\"html\";s:11:\"<div></div>\";s:10:\"html_class\";s:19:\"leaflet-map-divicon\";s:21:\"circle_marker_options\";s:65:\"{\"radius\":100,\"color\":\"red\",\"fillColor\":\"#f03\",\"fillOpacity\":0.5}\";}s:10:\"fullscreen\";a:2:{s:7:\"control\";b:1;s:7:\"options\";s:47:\"{\"position\":\"topleft\",\"pseudoFullscreen\":false}\";}s:4:\"path\";s:113:\"{\"color\":\"#3388ff\",\"opacity\":\"1.0\",\"stroke\":true,\"weight\":3,\"fill\":\"depends\",\"fillColor\":\"*\",\"fillOpacity\":\"0.2\"}\";s:8:\"geocoder\";a:2:{s:7:\"control\";b:0;s:8:\"settings\";a:8:{s:8:\"position\";s:8:\"topright\";s:10:\"input_size\";i:25;s:9:\"providers\";a:5:{s:4:\"file\";a:2:{s:6:\"weight\";s:1:\"0\";s:7:\"checked\";i:0;}s:8:\"gpx_file\";a:2:{s:6:\"weight\";s:1:\"0\";s:7:\"checked\";i:0;}s:12:\"geojson_file\";a:2:{s:6:\"weight\";s:1:\"0\";s:7:\"checked\";i:0;}s:8:\"kml_file\";a:2:{s:6:\"weight\";s:1:\"0\";s:7:\"checked\";i:0;}s:20:\"localgov_default_osm\";a:2:{s:6:\"weight\";s:1:\"0\";s:7:\"checked\";i:0;}}s:9:\"min_terms\";i:4;s:5:\"delay\";i:800;s:4:\"zoom\";i:16;s:5:\"popup\";b:0;s:7:\"options\";s:0:\"\";}}}}s:3:\"row\";a:2:{s:4:\"type\";s:10:\"search_api\";s:7:\"options\";a:1:{s:10:\"view_modes\";a:1:{s:11:\"entity:node\";a:2:{s:25:\"localgov_directories_page\";s:6:\"teaser\";s:26:\"localgov_directories_venue\";s:6:\"teaser\";}}}}s:8:\"defaults\";a:8:{s:5:\"empty\";b:0;s:5:\"pager\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:13:\"relationships\";b:0;s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:13:\"relationships\";a:1:{s:17:\"localgov_location\";a:10:{s:2:\"id\";s:17:\"localgov_location\";s:5:\"table\";s:68:\"search_api_datasource_localgov_directories_index_default_entity_node\";s:5:\"field\";s:17:\"localgov_location\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:13:\"Location: Geo\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:10:\"search_api\";s:8:\"required\";b:0;s:11:\"skip_access\";b:0;}}s:19:\"display_description\";s:0:\"\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";}s:4:\"tags\";a:1:{i:0;s:42:\"config:field.storage.localgov_geo.location\";}}}s:10:\"node_embed\";a:6:{s:2:\"id\";s:10:\"node_embed\";s:13:\"display_title\";s:5:\"Embed\";s:14:\"display_plugin\";s:5:\"embed\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:5:\"cache\";a:1:{s:4:\"type\";s:4:\"none\";}s:8:\"defaults\";a:1:{s:5:\"cache\";b:0;}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";}s:4:\"tags\";a:0:{}}}}}",
))
->values(array(
  'collection' => '',
  'name' => 'views.view.localgov_events_listing',
  'data' => 'a:13:{s:4:"uuid";s:36:"677471ae-5812-4ef5-89b4-24c4566e9453";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:23:"field.storage.node.body";i:1;s:39:"field.storage.node.localgov_event_image";i:2;s:24:"node.type.localgov_event";i:3;s:43:"taxonomy.vocabulary.localgov_event_category";i:4;s:43:"taxonomy.vocabulary.localgov_event_locality";i:5;s:40:"taxonomy.vocabulary.localgov_event_price";}s:6:"module";a:6:{i:0;s:10:"date_recur";i:1;s:8:"datetime";i:2;s:4:"node";i:3;s:8:"taxonomy";i:4;s:4:"text";i:5;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-xLbdRerpYlma9Br77AP4XX1zZ3E8rCLWhY5PpIxoKs";}s:2:"id";s:23:"localgov_events_listing";s:5:"label";s:14:"Events listing";s:6:"module";s:5:"views";s:11:"description";s:52:"Listing of events with filtering by facets and date.";s:3:"tag";s:0:"";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:18:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:14:"items_per_page";i:20;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";N;s:4:"tags";a:4:{s:8:"previous";s:6:"‹‹";s:4:"next";s:6:"››";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:5:"style";a:1:{s:4:"type";s:7:"default";}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:8:{s:5:"title";a:37:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:2:"h2";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";}s:20:"localgov_event_image";a:35:{s:2:"id";s:20:"localgov_event_image";s:5:"table";s:26:"node__localgov_event_image";s:5:"field";s:20:"localgov_event_image";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:28:"entity_reference_entity_view";s:8:"settings";a:1:{s:9:"view_mode";s:24:"localgov_event_thumbnail";}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:9:"plugin_id";s:5:"field";}s:25:"localgov_event_date_value";a:25:{s:2:"id";s:25:"localgov_event_date_value";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:25:"localgov_event_date_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:9:"html_date";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:9:"plugin_id";s:15:"date_recur_date";}s:29:"localgov_event_date_end_value";a:25:{s:2:"id";s:29:"localgov_event_date_end_value";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:29:"localgov_event_date_end_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:9:"html_date";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:9:"plugin_id";s:15:"date_recur_date";}s:31:"localgov_event_date_end_value_1";a:25:{s:2:"id";s:31:"localgov_event_date_end_value_1";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:29:"localgov_event_date_end_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:24:"localgov_event_date_full";s:18:"custom_date_format";s:15:"l, jS F Y, g.ia";s:8:"timezone";s:0:"";s:9:"plugin_id";s:15:"date_recur_date";}s:31:"localgov_event_date_end_value_2";a:25:{s:2:"id";s:31:"localgov_event_date_end_value_2";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:29:"localgov_event_date_end_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:24:"localgov_event_date_hour";s:18:"custom_date_format";s:4:"g.ia";s:8:"timezone";s:0:"";s:9:"plugin_id";s:15:"date_recur_date";}s:27:"localgov_event_date_value_1";a:25:{s:2:"id";s:27:"localgov_event_date_value_1";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:25:"localgov_event_date_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:200:"{{ localgov_event_date_value_1 }} to {% if localgov_event_date_value ==  localgov_event_date_end_value %}{{ localgov_event_date_end_value_2 }}{% else %}{{ localgov_event_date_end_value_1 }}{% endif %}";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:24:"localgov_event_date_full";s:18:"custom_date_format";s:15:"l, jS F Y, g.ia";s:8:"timezone";s:0:"";s:9:"plugin_id";s:15:"date_recur_date";}s:4:"body";a:35:{s:2:"id";s:4:"body";s:5:"table";s:10:"node__body";s:5:"field";s:4:"body";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:9:"plugin_id";s:5:"field";}}s:7:"filters";a:12:{s:6:"status";a:9:{s:5:"value";s:1:"1";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:2:"id";s:6:"status";s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:5:"group";i:1;}s:4:"type";a:9:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:5:"value";a:1:{s:14:"localgov_event";s:14:"localgov_event";}s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:5:"group";i:1;}s:33:"localgov_event_locality_target_id";a:20:{s:2:"id";s:33:"localgov_event_locality_target_id";s:5:"table";s:29:"node__localgov_event_locality";s:5:"field";s:33:"localgov_event_locality_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:36:"localgov_event_locality_target_id_op";s:5:"label";s:13:"Neighbourhood";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:36:"localgov_event_locality_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:13:"neighbourhood";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;s:4:"type";s:6:"select";s:5:"limit";b:1;s:3:"vid";s:23:"localgov_event_locality";s:9:"hierarchy";b:0;s:13:"error_message";b:1;s:9:"plugin_id";s:18:"taxonomy_index_tid";}s:30:"localgov_event_price_target_id";a:20:{s:2:"id";s:30:"localgov_event_price_target_id";s:5:"table";s:26:"node__localgov_event_price";s:5:"field";s:30:"localgov_event_price_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:33:"localgov_event_price_target_id_op";s:5:"label";s:5:"Price";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:33:"localgov_event_price_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"price";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;s:4:"type";s:6:"select";s:5:"limit";b:1;s:3:"vid";s:20:"localgov_event_price";s:9:"hierarchy";b:0;s:13:"error_message";b:1;s:9:"plugin_id";s:18:"taxonomy_index_tid";}s:35:"localgov_event_categories_target_id";a:20:{s:2:"id";s:35:"localgov_event_categories_target_id";s:5:"table";s:31:"node__localgov_event_categories";s:5:"field";s:35:"localgov_event_categories_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:8:"category";s:5:"label";s:8:"Category";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:38:"localgov_event_categories_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"category";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;s:4:"type";s:6:"select";s:5:"limit";b:1;s:3:"vid";s:23:"localgov_event_category";s:9:"hierarchy";b:0;s:13:"error_message";b:1;s:9:"plugin_id";s:18:"taxonomy_index_tid";}s:27:"localgov_event_date_value_1";a:14:{s:2:"id";s:27:"localgov_event_date_value_1";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:25:"localgov_event_date_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:">=";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:5:"today";s:4:"type";s:4:"date";}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:30:"localgov_event_date_value_1_op";s:5:"label";s:10:"Start date";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:30:"localgov_event_date_value_1_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"start";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:11:"placeholder";s:0:"";s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:26:"Date (localgov_event_date)";s:11:"description";N;s:10:"identifier";s:27:"localgov_event_date_value_1";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:3:{i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}}}s:9:"plugin_id";s:8:"datetime";}s:29:"localgov_event_date_end_value";a:14:{s:2:"id";s:29:"localgov_event_date_end_value";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:29:"localgov_event_date_end_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"<=";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";s:4:"type";s:4:"date";}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:32:"localgov_event_date_end_value_op";s:5:"label";s:8:"End date";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:32:"localgov_event_date_end_value_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:3:"end";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:11:"placeholder";s:0:"";s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"datetime";}s:8:"status_1";a:16:{s:2:"id";s:8:"status_1";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:2;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";}s:6:"type_1";a:16:{s:2:"id";s:6:"type_1";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:14:"localgov_event";s:14:"localgov_event";}s:5:"group";i:2;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";}s:25:"localgov_event_date_value";a:14:{s:2:"id";s:25:"localgov_event_date_value";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:25:"localgov_event_date_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"<";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:5:"today";s:4:"type";s:4:"date";}s:5:"group";i:2;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:28:"localgov_event_date_value_op";s:5:"label";s:10:"Start date";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:28:"localgov_event_date_value_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"start";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:11:"placeholder";s:0:"";s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"datetime";}s:31:"localgov_event_date_end_value_1";a:14:{s:2:"id";s:31:"localgov_event_date_end_value_1";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:29:"localgov_event_date_end_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:">=";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:5:"today";s:4:"type";s:4:"date";}s:5:"group";i:2;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:34:"localgov_event_date_end_value_1_op";s:5:"label";s:10:"Start date";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:34:"localgov_event_date_end_value_1_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"start";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:11:"placeholder";s:0:"";s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"datetime";}s:31:"localgov_event_date_end_value_2";a:14:{s:2:"id";s:31:"localgov_event_date_end_value_2";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:29:"localgov_event_date_end_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"<=";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";s:4:"type";s:4:"date";}s:5:"group";i:2;s:7:"exposed";b:1;s:6:"expose";a:15:{s:11:"operator_id";s:34:"localgov_event_date_end_value_2_op";s:5:"label";s:8:"End date";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:34:"localgov_event_date_end_value_2_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:3:"end";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:11:"placeholder";s:0:"";s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"datetime";}}s:5:"sorts";a:1:{s:25:"localgov_event_date_value";a:11:{s:2:"id";s:25:"localgov_event_date_value";s:5:"table";s:37:"date_recur__node__localgov_event_date";s:5:"field";s:25:"localgov_event_date_value";s:12:"relationship";s:31:"localgov_event_date_occurrences";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:3:"ASC";s:7:"exposed";b:0;s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:25:"localgov_event_date_value";}s:11:"granularity";s:6:"second";s:9:"plugin_id";s:8:"datetime";}}s:5:"title";s:6:"Events";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:1:{s:4:"area";a:10:{s:2:"id";s:4:"area";s:5:"table";s:5:"views";s:5:"field";s:4:"area";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";a:2:{s:5:"value";s:44:"Sorry, there are currently no events listed.";s:6:"format";s:7:"wysiwyg";}s:9:"plugin_id";s:4:"text";}}s:13:"relationships";a:1:{s:31:"localgov_event_date_occurrences";a:9:{s:2:"id";s:31:"localgov_event_date_occurrences";s:5:"table";s:15:"node_field_data";s:5:"field";s:31:"localgov_event_date_occurrences";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:19:"Occurrences of Date";s:8:"required";b:0;s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:8:"standard";}}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:2:"OR";s:6:"groups";a:2:{i:1;s:3:"AND";i:2;s:3:"AND";}}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:2:{i:0;s:30:"config:field.storage.node.body";i:1;s:46:"config:field.storage.node.localgov_event_image";}}}s:15:"page_all_events";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:15:"page_all_events";s:13:"display_title";s:4:"Page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:6:"events";s:13:"exposed_block";b:1;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:2:{i:0;s:30:"config:field.storage.node.body";i:1;s:46:"config:field.storage.node.localgov_event_image";}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.localgov_events_search',
  'data' => 'a:13:{s:4:"uuid";s:36:"24572f97-9302-4c32-b828-b7c80a871bda";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:44:"field.storage.node.localgov_event_categories";i:1;s:32:"search_api.index.localgov_events";}s:6:"module";a:2:{i:0;s:10:"search_api";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Rdu5fSR8sBzgo3xwxU7gTkNkwWg-HRvSZWNHDusyS1s";}s:2:"id";s:22:"localgov_events_search";s:5:"label";s:13:"Events search";s:6:"module";s:5:"views";s:11:"description";s:19:"Events search view.";s:3:"tag";s:0:"";s:10:"base_table";s:32:"search_api_index_localgov_events";s:10:"base_field";s:13:"search_api_id";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:16:"search_api_query";s:7:"options";a:0:{}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:14:"items_per_page";i:20;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";N;s:4:"tags";a:4:{s:8:"previous";s:6:"‹‹";s:4:"next";s:6:"››";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:5:"style";a:1:{s:4:"type";s:7:"default";}s:3:"row";a:2:{s:4:"type";s:10:"search_api";s:7:"options";a:1:{s:10:"view_modes";a:1:{s:11:"entity:node";a:1:{s:14:"localgov_event";s:6:"teaser";}}}}s:6:"fields";a:1:{s:25:"localgov_event_categories";a:40:{s:5:"table";s:32:"search_api_index_localgov_events";s:5:"field";s:25:"localgov_event_categories";s:2:"id";s:25:"localgov_event_categories";s:11:"entity_type";N;s:12:"entity_field";N;s:9:"plugin_id";s:16:"search_api_field";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:0:{}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:15:"field_rendering";b:1;s:16:"fallback_handler";s:17:"search_api_entity";s:16:"fallback_options";a:5:{s:12:"link_to_item";b:0;s:16:"use_highlighting";b:0;s:10:"multi_type";s:9:"separator";s:15:"multi_separator";s:2:", ";s:15:"display_methods";a:0:{}}}}s:7:"filters";a:1:{s:19:"search_api_fulltext";a:17:{s:2:"id";s:19:"search_api_fulltext";s:5:"table";s:32:"search_api_index_localgov_events";s:5:"field";s:19:"search_api_fulltext";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"or";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:22:"search_api_fulltext_op";s:5:"label";s:6:"Search";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:22:"search_api_fulltext_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"search";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:2:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";}s:11:"placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:10:"parse_mode";s:5:"terms";s:10:"min_length";N;s:6:"fields";a:1:{i:0;s:13:"rendered_item";}s:9:"plugin_id";s:19:"search_api_fulltext";}}s:5:"sorts";a:2:{s:20:"search_api_relevance";a:10:{s:2:"id";s:20:"search_api_relevance";s:5:"table";s:32:"search_api_index_localgov_events";s:5:"field";s:20:"search_api_relevance";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:3:"ASC";s:7:"exposed";b:0;s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:20:"search_api_relevance";}s:9:"plugin_id";s:10:"search_api";}s:19:"localgov_event_date";a:10:{s:2:"id";s:19:"localgov_event_date";s:5:"table";s:32:"search_api_index_localgov_events";s:5:"field";s:19:"localgov_event_date";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:3:"ASC";s:7:"exposed";b:0;s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:19:"localgov_event_date";}s:9:"plugin_id";s:10:"search_api";}}s:5:"title";s:13:"Events search";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:1:{s:4:"area";a:10:{s:2:"id";s:4:"area";s:5:"table";s:5:"views";s:5:"field";s:4:"area";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";a:2:{s:5:"value";s:33:"No results found for your search.";s:6:"format";s:7:"wysiwyg";}s:9:"plugin_id";s:4:"text";}}s:13:"relationships";a:0:{}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:2:{i:0;s:51:"config:field.storage.node.localgov_event_categories";i:1;s:39:"config:search_api.index.localgov_events";}}}s:11:"events_page";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:11:"events_page";s:13:"display_title";s:4:"Page";s:8:"position";i:1;s:15:"display_options";a:5:{s:17:"display_extenders";a:0:{}s:4:"path";s:13:"events/search";s:5:"cache";a:1:{s:4:"type";s:4:"none";}s:8:"defaults";a:1:{s:5:"cache";b:0;}s:13:"exposed_block";b:1;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:2:{i:0;s:51:"config:field.storage.node.localgov_event_categories";i:1;s:39:"config:search_api.index.localgov_events";}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.localgov_geo_library',
  'data' => 'a:13:{s:4:"uuid";s:36:"ed0a59e9-963a-4852-ab1e-7632a3008d45";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:14:"entity_browser";i:1;s:12:"localgov_geo";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"g1a37HWGGozwIItYeuAmnmtmEMVzVBPrCynxXLzAB0o";}s:2:"id";s:20:"localgov_geo_library";s:5:"label";s:11:"Geo library";s:6:"module";s:5:"views";s:11:"description";s:0:"";s:3:"tag";s:0:"";s:10:"base_table";s:23:"localgov_geo_field_data";s:10:"base_field";s:2:"id";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:16:{s:6:"access";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:14:"items_per_page";i:10;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";N;s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:4:"tags";a:2:{s:8:"previous";s:6:"‹‹";s:4:"next";s:6:"››";}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;s:22:"default_field_elements";b:1;}}s:6:"fields";a:2:{s:21:"entity_browser_select";a:24:{s:2:"id";s:21:"entity_browser_select";s:5:"table";s:12:"localgov_geo";s:5:"field";s:21:"entity_browser_select";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:21:"use_field_cardinality";b:0;s:11:"entity_type";s:12:"localgov_geo";s:9:"plugin_id";s:21:"entity_browser_select";}s:5:"label";a:37:{s:5:"table";s:23:"localgov_geo_field_data";s:5:"field";s:5:"label";s:2:"id";s:5:"label";s:11:"entity_type";N;s:12:"entity_field";s:5:"label";s:9:"plugin_id";s:5:"field";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:7:"filters";a:1:{s:5:"label";a:16:{s:2:"id";s:5:"label";s:5:"table";s:23:"localgov_geo_field_data";s:5:"field";s:5:"label";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:8:"label_op";s:5:"label";s:6:"Search";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"label_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"label";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:4:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:15:"localgov_editor";s:1:"0";s:15:"localgov_author";s:1:"0";}s:11:"placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:12:"localgov_geo";s:12:"entity_field";s:5:"label";s:9:"plugin_id";s:6:"string";}}s:5:"sorts";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:0:{}s:13:"relationships";a:0:{}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:0:{}}}s:16:"entity_browser_1";a:6:{s:14:"display_plugin";s:14:"entity_browser";s:2:"id";s:16:"entity_browser_1";s:13:"display_title";s:14:"Entity browser";s:8:"position";i:1;s:15:"display_options";a:1:{s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.media',
  'data' => 'a:13:{s:4:"uuid";s:36:"c4289462-149b-49c8-8003-9d7700c1c79a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:21:"image.style.thumbnail";}s:6:"module";a:3:{i:0;s:5:"image";i:1;s:5:"media";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"diywn6VdMoQOlDA-xslKdKrDko3SsTKfaK3WBG45UAg";}s:2:"id";s:5:"media";s:5:"label";s:5:"Media";s:6:"module";s:5:"views";s:11:"description";s:22:"Find and manage media.";s:3:"tag";s:0:"";s:10:"base_table";s:16:"media_field_data";s:10:"base_field";s:3:"mid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:5:"Media";s:6:"fields";a:8:{s:15:"media_bulk_form";a:26:{s:2:"id";s:15:"media_bulk_form";s:5:"table";s:5:"media";s:5:"field";s:15:"media_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:9:"bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}}s:20:"thumbnail__target_id";a:37:{s:2:"id";s:20:"thumbnail__target_id";s:5:"table";s:16:"media_field_data";s:5:"field";s:20:"thumbnail__target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:9:"thumbnail";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"Thumbnail";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:5:"image";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:9:"thumbnail";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:12:"group_column";s:0:"";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:5:"media";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Media name";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:6:"bundle";a:37:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:16:"media_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:6:"status";a:37:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:16:"media_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"media";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access media overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No media available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"media_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:10:"Media name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"bundle";a:16:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"bundle_op";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"bundle_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:4:"True";s:11:"description";N;s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:1;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:16:"media_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:12:"media_status";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:16:"media_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:6:{s:4:"name";s:4:"name";s:6:"bundle";s:6:"bundle";s:7:"changed";s:7:"changed";s:3:"uid";s:3:"uid";s:6:"status";s:6:"status";s:20:"thumbnail__target_id";s:20:"thumbnail__target_id";}s:7:"default";s:7:"changed";s:4:"info";a:6:{s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"bundle";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:20:"thumbnail__target_id";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:15:"media_page_list";a:6:{s:2:"id";s:15:"media_page_list";s:13:"display_title";s:5:"Media";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/media";s:4:"menu";a:8:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Media";s:11:"description";s:0:"";s:6:"weight";i:0;s:8:"expanded";b:0;s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.media_library',
  'data' => 'a:13:{s:4:"uuid";s:36:"beac4130-2946-4f71-bd4e-7b8d8ec567a3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:2:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:25:"image.style.media_library";}s:6:"module";a:4:{i:0;s:5:"image";i:1;s:5:"media";i:2;s:13:"media_library";i:3;s:4:"user";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:13:"media_library";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"GDIFCs-lTKQIMvaNZ95zofFcqpTxDYakxx02_zZFkmM";}s:2:"id";s:13:"media_library";s:5:"label";s:13:"Media library";s:6:"module";s:5:"views";s:11:"description";s:22:"Find and manage media.";s:3:"tag";s:0:"";s:10:"base_table";s:16:"media_field_data";s:10:"base_field";s:3:"mid";s:7:"display";a:4:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:5:"title";s:5:"Media";s:6:"fields";a:2:{s:15:"media_bulk_form";a:26:{s:2:"id";s:15:"media_bulk_form";s:5:"table";s:5:"media";s:5:"field";s:15:"media_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:9:"bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}}s:15:"rendered_entity";a:24:{s:2:"id";s:15:"rendered_entity";s:5:"table";s:5:"media";s:5:"field";s:15:"rendered_entity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:15:"rendered_entity";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"view_mode";s:13:"media_library";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:24;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"6, 12, 24, 48";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:13:"Apply filters";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:0;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access media overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No media available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:3:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"media_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:12:"Newest first";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:1;s:11:"granularity";s:6:"second";}s:4:"name";a:12:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:8:"standard";s:5:"order";s:3:"ASC";s:6:"expose";a:2:{s:5:"label";s:10:"Name (A-Z)";s:16:"field_identifier";s:4:"name";}s:7:"exposed";b:1;}s:6:"name_1";a:12:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:10:"Name (Z-A)";s:16:"field_identifier";s:6:"name_1";}s:7:"exposed";b:1;}}s:7:"filters";a:5:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:17:"Publishing status";s:11:"description";N;s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:1;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:9:"Published";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:4:"Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"bundle";a:16:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"bundle_op";s:5:"label";s:10:"Media type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"bundle_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:10:"Media type";s:11:"description";N;s:10:"identifier";s:6:"bundle";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:3:{i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}}}}s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:16:"media_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:12:"media_status";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:16:"media_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:22:"default_field_elements";b:1;s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:9:"css_class";s:0:"";s:8:"use_ajax";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:6:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:22:"url.query_args:sort_by";i:4;s:4:"user";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:4:"page";a:6:{s:2:"id";s:4:"page";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:6:"fields";a:5:{s:15:"media_bulk_form";a:26:{s:2:"id";s:15:"media_bulk_form";s:5:"table";s:5:"media";s:5:"field";s:15:"media_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:9:"bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"edit_media";a:26:{s:2:"id";s:10:"edit_media";s:5:"table";s:5:"media";s:5:"field";s:10:"edit_media";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:16:"entity_link_edit";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:15:"Edit {{ name }}";s:9:"make_link";b:1;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:15:"Edit {{ name }}";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:1:"0";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:0;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"text";s:4:"Edit";s:18:"output_url_as_text";b:0;s:8:"absolute";b:0;}s:12:"delete_media";a:26:{s:2:"id";s:12:"delete_media";s:5:"table";s:5:"media";s:5:"field";s:12:"delete_media";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:18:"entity_link_delete";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:17:"Delete {{ name }}";s:9:"make_link";b:1;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:17:"Delete {{ name }}";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:1:"0";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:0;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"text";s:6:"Delete";s:18:"output_url_as_text";b:0;s:8:"absolute";b:0;}s:15:"rendered_entity";a:24:{s:2:"id";s:15:"rendered_entity";s:5:"table";s:5:"media";s:5:"field";s:15:"rendered_entity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:15:"rendered_entity";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"view_mode";s:13:"media_library";}}s:8:"defaults";a:1:{s:6:"fields";b:0;}s:17:"display_extenders";a:0:{}s:4:"path";s:24:"admin/content/media-grid";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:22:"url.query_args:sort_by";i:5;s:4:"user";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"widget";a:6:{s:2:"id";s:6:"widget";s:13:"display_title";s:6:"Widget";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:12:{s:6:"fields";a:2:{s:25:"media_library_select_form";a:23:{s:2:"id";s:25:"media_library_select_form";s:5:"table";s:5:"media";s:5:"field";s:25:"media_library_select_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:25:"media_library_select_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:15:"rendered_entity";a:24:{s:2:"id";s:15:"rendered_entity";s:5:"table";s:5:"media";s:5:"field";s:15:"rendered_entity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:15:"rendered_entity";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"view_mode";s:13:"media_library";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:10:"view media";}}s:9:"arguments";a:1:{s:6:"bundle";a:27:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:6:"ignore";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:24;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:0;s:5:"limit";i:0;s:4:"case";s:4:"none";s:9:"path_case";s:4:"none";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:3:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:4:"Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"media_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:8:"defaults";a:7:{s:6:"access";b:0;s:9:"css_class";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;s:6:"header";b:0;}s:9:"css_class";s:0:"";s:19:"display_description";s:0:"";s:6:"header";a:2:{s:17:"display_link_grid";a:7:{s:2:"id";s:17:"display_link_grid";s:5:"table";s:5:"views";s:5:"field";s:12:"display_link";s:9:"plugin_id";s:12:"display_link";s:5:"label";s:4:"Grid";s:5:"empty";b:1;s:10:"display_id";s:6:"widget";}s:18:"display_link_table";a:7:{s:2:"id";s:18:"display_link_table";s:5:"table";s:5:"views";s:5:"field";s:12:"display_link";s:9:"plugin_id";s:12:"display_link";s:5:"label";s:5:"Table";s:5:"empty";b:1;s:10:"display_id";s:12:"widget_table";}}s:18:"rendering_language";s:33:"***LANGUAGE_language_interface***";s:17:"display_extenders";a:0:{}s:4:"path";s:26:"admin/content/media-widget";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:22:"url.query_args:sort_by";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:12:"widget_table";a:6:{s:2:"id";s:12:"widget_table";s:13:"display_title";s:14:"Widget (table)";s:14:"display_plugin";s:4:"page";s:8:"position";i:3;s:15:"display_options";a:13:{s:6:"fields";a:5:{s:25:"media_library_select_form";a:9:{s:2:"id";s:25:"media_library_select_form";s:5:"table";s:5:"media";s:5:"field";s:25:"media_library_select_form";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:25:"media_library_select_form";s:5:"label";s:0:"";s:13:"element_class";s:0:"";s:21:"element_wrapper_class";s:0:"";}s:20:"thumbnail__target_id";a:10:{s:2:"id";s:20:"thumbnail__target_id";s:5:"table";s:16:"media_field_data";s:5:"field";s:20:"thumbnail__target_id";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:9:"thumbnail";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"Thumbnail";s:4:"type";s:5:"image";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:13:"media_library";s:13:"image_loading";a:1:{s:9:"attribute";s:5:"eager";}}}s:4:"name";a:10:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Name";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}}s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:20:"media_field_revision";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}}s:7:"changed";a:10:{s:2:"id";s:7:"changed";s:5:"table";s:16:"media_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:10:"view media";}}s:9:"arguments";a:1:{s:6:"bundle";a:27:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:6:"ignore";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:24;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:0;s:5:"limit";i:0;s:4:"case";s:4:"none";s:9:"path_case";s:4:"none";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:3:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:4:"Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"media_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:2:{s:9:"row_class";s:85:"media-library-item media-library-item--table js-media-library-item js-click-to-select";s:17:"default_row_class";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:8:"defaults";a:9:{s:6:"access";b:0;s:9:"css_class";b:0;s:5:"style";b:0;s:3:"row";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;s:6:"header";b:0;}s:9:"css_class";s:0:"";s:6:"header";a:2:{s:17:"display_link_grid";a:7:{s:2:"id";s:17:"display_link_grid";s:5:"table";s:5:"views";s:5:"field";s:12:"display_link";s:9:"plugin_id";s:12:"display_link";s:5:"label";s:4:"Grid";s:5:"empty";b:1;s:10:"display_id";s:6:"widget";}s:18:"display_link_table";a:7:{s:2:"id";s:18:"display_link_table";s:5:"table";s:5:"views";s:5:"field";s:12:"display_link";s:9:"plugin_id";s:12:"display_link";s:5:"label";s:5:"Table";s:5:"empty";b:1;s:10:"display_id";s:12:"widget_table";}}s:18:"rendering_language";s:33:"***LANGUAGE_language_interface***";s:17:"display_extenders";a:0:{}s:4:"path";s:32:"admin/content/media-widget-table";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:22:"url.query_args:sort_by";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.taxonomy_term',
  'data' => 'a:13:{s:4:"uuid";s:36:"ffe53f4a-2b4a-4231-8beb-10c449d11617";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:3:{i:0;s:4:"node";i:1;s:8:"taxonomy";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YKgw0f77GEmCu6_6Om9Mbig0mON9JdfVuMxTtd0WQaI";}s:2:"id";s:13:"taxonomy_term";s:5:"label";s:13:"Taxonomy term";s:6:"module";s:8:"taxonomy";s:11:"description";s:45:"Content belonging to a certain taxonomy term.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:2:{s:6:"sticky";a:10:{s:2:"id";s:6:"sticky";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:11:{s:2:"id";s:7:"created";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:3:"tid";a:23:{s:2:"id";s:3:"tid";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:3:"tid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:18:"taxonomy_index_tid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:19:"{{ arguments.tid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:20:"entity:taxonomy_term";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:4:{s:7:"bundles";a:0:{}s:6:"access";b:1;s:9:"operation";s:4:"view";s:8:"multiple";i:0;}s:12:"break_phrase";b:0;s:9:"add_table";b:0;s:13:"require_value";b:0;s:17:"reduce_duplicates";b:0;}}s:7:"filters";a:2:{s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:14:{s:2:"id";s:6:"status";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:6:"header";a:1:{s:20:"entity_taxonomy_term";a:12:{s:2:"id";s:20:"entity_taxonomy_term";s:5:"table";s:5:"views";s:5:"field";s:20:"entity_taxonomy_term";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:6:"entity";s:5:"empty";b:1;s:6:"target";s:23:"{{ raw_arguments.tid }}";s:9:"view_mode";s:4:"full";s:8:"tokenize";b:1;s:13:"bypass_access";b:0;}}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:7:"default";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:20:"taxonomy/term/%/feed";s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:15:"taxonomy/term/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.user_admin_people',
  'data' => 'a:13:{s:4:"uuid";s:36:"b0524b7d-6c03-421d-ba50-517e9d4bce91";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"njaZigMvB4ap21Fg_tQcJhWgYJCGNi49Z5rRL_N6RI0";}s:2:"id";s:17:"user_admin_people";s:5:"label";s:6:"People";s:6:"module";s:4:"user";s:11:"description";s:50:"Find and manage people interacting with your site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:25:{s:5:"title";s:6:"People";s:6:"fields";a:8:{s:14:"user_bulk_form";a:23:{s:2:"id";s:14:"user_bulk_form";s:5:"table";s:5:"users";s:5:"field";s:14:"user_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:14:"user_bulk_form";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:8:"Username";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:7:"Blocked";s:18:"format_custom_true";s:6:"Active";}}s:15:"roles_target_id";a:24:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:5:"label";s:5:"Roles";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:2:"ul";s:9:"separator";s:2:", ";}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Member for";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:9:"@interval";s:11:"past_format";s:9:"@interval";s:11:"granularity";i:2;}}s:6:"access";a:26:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last access";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"users";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:4:"mail";a:37:{s:2:"id";s:4:"mail";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"mail";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"mail";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"basic_string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:16:"administer users";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:20:"No people available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:7:"filters";a:6:{s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:22:"Name or email contains";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"user";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:4:"mail";s:4:"mail";}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:6:"Active";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:7:"Blocked";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:15:"roles_target_id";a:15:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:18:"roles_target_id_op";s:5:"label";s:4:"Role";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:18:"roles_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"role";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:10:"permission";a:15:{s:2:"id";s:10:"permission";s:5:"table";s:11:"user__roles";s:5:"field";s:10:"permission";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"user_permissions";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:13:"permission_op";s:5:"label";s:10:"Permission";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:13:"permission_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:10:"permission";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"users_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"uid_raw";a:15:{s:2:"id";s:7:"uid_raw";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"uid_raw";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:7:"numeric";s:8:"operator";s:2:"!=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:1:"0";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:10:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:14:"user_bulk_form";s:14:"user_bulk_form";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:3:"rid";s:3:"rid";s:7:"created";s:7:"created";s:6:"access";s:6:"access";s:9:"edit_node";s:9:"edit_node";s:10:"dropbutton";s:10:"dropbutton";}s:7:"default";s:7:"created";s:4:"info";a:8:{s:14:"user_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:3:"rid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"access";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"more";s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:15:"display_comment";s:0:"";s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:1:{s:16:"show_admin_links";b:0;}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:17:"admin/people/list";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:4:"List";s:11:"description";s:50:"Find and manage people interacting with your site.";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:6:"People";s:11:"description";s:45:"Manage user accounts, roles, and permissions.";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.watchdog',
  'data' => 'a:13:{s:4:"uuid";s:36:"cc010f96-76cd-4da3-8368-9bdb8898ecb6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:5:"dblog";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"j0txIxY4nkJT_dscmXckM-1vanygDkJAeHPawZKfyH0";}s:2:"id";s:8:"watchdog";s:5:"label";s:8:"Watchdog";s:6:"module";s:5:"views";s:11:"description";s:19:"Recent log messages";s:3:"tag";s:0:"";s:10:"base_table";s:8:"watchdog";s:10:"base_field";s:3:"wid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:19:"Recent log messages";s:6:"fields";a:8:{s:7:"nothing";a:22:{s:2:"id";s:7:"nothing";s:5:"table";s:5:"views";s:5:"field";s:7:"nothing";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"Icon";s:9:"plugin_id";s:6:"custom";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:4:"icon";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:0;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:0;}s:3:"wid";a:22:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:3:"WID";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"severity";a:23:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"machine_name";s:5:"label";s:8:"Severity";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"machine_name";b:0;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:4:"Type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:9:"timestamp";a:25:{s:2:"id";s:9:"timestamp";s:5:"table";s:8:"watchdog";s:5:"field";s:9:"timestamp";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"label";s:4:"Date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:7:"message";a:23:{s:2:"id";s:7:"message";s:5:"table";s:8:"watchdog";s:5:"field";s:7:"message";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:13:"dblog_message";s:5:"label";s:7:"Message";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/reports/dblog/event/{{ wid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:13:"{{ message }}";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:56;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:1;s:4:"trim";b:1;s:13:"preserve_tags";s:0:"";s:4:"html";b:1;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"replace_variables";b:1;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"User";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"link";a:22:{s:2:"id";s:4:"link";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"link";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"dblog_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:0;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"access site reports";}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:4:"area";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:26:"No log messages available.";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:26:"No log messages available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:3:"wid";a:10:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"wid";}s:7:"exposed";b:0;}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:4:"type";a:14:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"dblog_types";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"severity";a:14:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"in_operator";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"severity_op";s:5:"label";s:8:"Severity";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"severity_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"severity";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:25:"{{ type }} {{ severity }}";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:7:"nothing";s:7:"nothing";s:3:"wid";s:3:"wid";s:8:"severity";s:8:"severity";s:4:"type";s:4:"type";s:9:"timestamp";s:9:"timestamp";s:7:"message";s:7:"message";s:4:"name";s:4:"name";s:4:"link";s:4:"link";}s:7:"default";s:3:"wid";s:4:"info";a:8:{s:7:"nothing";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:3:"wid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:8:"severity";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:9:"timestamp";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"message";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:4:"link";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:0;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"User";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:11:"admin-dblog";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:4:"page";a:6:{s:2:"id";s:4:"page";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/reports/dblog";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}',
))
->values(array(
  'collection' => '',
  'name' => 'views.view.who_s_new',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"092f1099-0c27-4585-a5be-3bf97a94b942\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zji0_13MyVGK7Bn1lUMDeZyyOIZedWvqpYUeM_SioPI\";}s:2:\"id\";s:9:\"who_s_new\";s:5:\"label\";s:9:\"Who's new\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:53:\"Shows a list of the newest user accounts on the site.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:9:\"Who's new\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:5;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:1:\">\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:10:\"1970-01-01\";s:4:\"type\";s:4:\"date\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:1:\"0\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:1:{s:4:\"type\";s:9:\"html_list\";}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:9:\"Who's new\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:19:\"display_description\";s:19:\"A list of new users\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:9:\"Who's new\";s:14:\"block_category\";s:4:\"User\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}",
))
->values(array(
  'collection' => '',
  'name' => 'views.view.who_s_online',
  'data' => "a:13:{s:4:\"uuid\";s:36:\"2be72e10-be94-4177-8e9f-2682aed6aa39\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"suDsVMgawXoQt4rfmdfpr05EVX3z3KyfDDTYgeSM898\";}s:2:\"id\";s:12:\"who_s_online\";s:5:\"label\";s:18:\"Who's online block\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:93:\"Shows the user names of the most recently active users, and the total number of active users.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:12:\"Who's online\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:20:\"access user profiles\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:35:\"There are currently 0 users online.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:6:\"access\";a:13:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:6:\"access\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:2:\">=\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:11:\"-15 minutes\";s:4:\"type\";s:6:\"offset\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:9:\"access_op\";s:5:\"label\";s:11:\"Last access\";s:11:\"description\";s:77:\"A user is considered online for this long after they have last viewed a page.\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"access_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"access\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:1:{s:6:\"result\";a:9:{s:2:\"id\";s:6:\"result\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:6:\"result\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"result\";s:5:\"empty\";b:0;s:7:\"content\";s:40:\"There are currently @total users online.\";}}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:18:\"who_s_online_block\";a:6:{s:2:\"id\";s:18:\"who_s_online_block\";s:13:\"display_title\";s:12:\"Who's online\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:19:\"display_description\";s:45:\"A list of users that are currently logged in.\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:12:\"Who's online\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}",
))
->execute();
$connection->schema()->createTable('crop', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'uuid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'unique keys' => array(
    'crop_field__uuid__value' => array(
      'uuid',
    ),
    'crop__vid' => array(
      'vid',
    ),
  ),
  'indexes' => array(
    'crop_field__type__target_id' => array(
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('crop_field_data', array(
  'fields' => array(
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '32',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'uri' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'height' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'width' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'x' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'y' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'revision_translation_affected' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'cid',
    'langcode',
  ),
  'indexes' => array(
    'crop__id__default_langcode__langcode' => array(
      'cid',
      'default_langcode',
      'langcode',
    ),
    'crop__vid' => array(
      'vid',
    ),
    'crop_field__type__target_id' => array(
      'type',
    ),
    'crop__uri_type' => array(
      array(
        'uri',
        '191',
      ),
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('crop_field_revision', array(
  'fields' => array(
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'uri' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'height' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'width' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'x' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'y' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'default_langcode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'revision_translation_affected' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'vid',
    'langcode',
  ),
  'indexes' => array(
    'crop__id__default_langcode__langcode' => array(
      'cid',
      'default_langcode',
      'langcode',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('crop_revision', array(
  'fields' => array(
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'revision_timestamp' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'revision_uid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_log' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'revision_default' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'crop__cid' => array(
      'cid',
    ),
    'crop_field__revision_uid__target_id' => array(
      'revision_uid',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->schema()->createTable('date_recur__node__localgov_event_date', array(
  'fields' => array(
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'localgov_event_date_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '20',
    ),
    'localgov_event_date_end_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '20',
    ),
  ),
  'indexes' => array(
    'value' => array(
      'entity_id',
      'localgov_event_date_value',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('date_recur__node__localgov_event_date')
->fields(array(
  'entity_id',
  'revision_id',
  'field_delta',
  'delta',
  'localgov_event_date_value',
  'localgov_event_date_end_value',
))
->values(array(
  'entity_id' => '3',
  'revision_id' => '3',
  'field_delta' => '0',
  'delta' => '0',
  'localgov_event_date_value' => '2023-05-21T14:12:29',
  'localgov_event_date_end_value' => '2023-05-21T14:12:29',
))
->values(array(
  'entity_id' => '4',
  'revision_id' => '4',
  'field_delta' => '0',
  'delta' => '0',
  'localgov_event_date_value' => '2023-05-21T14:14:23',
  'localgov_event_date_end_value' => '2023-05-21T14:14:23',
))
->execute();
$connection->schema()->createTable('file_managed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uuid' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
    ),
    'langcode' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '12',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'uri' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'filemime' => array(
      'type' => 'varchar_ascii',
      'not null' => FALSE,
      'length' => '255',
    ),
    'filesize' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'big',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'unique keys' => array(
    'file_field__uuid__value' => array(
      'uuid',
    ),
  ),
  'indexes' => array(
    'file_field__uid__target_id' => array(
      'uid',
    ),
    'file_field__uri' => array(
      array(
        'uri',
        '191',
      ),
    ),
    'file_field__status' => array(
      'status',
    ),
    'file_field__changed' => array(
      'changed',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('file_managed')
->fields(array(
  'fid',
  'uuid',
  'langcode',
  'uid',
  'filename',
  'uri',
  'filemime',
  'filesize',
  'status',
  'created',
  'changed',
))
->values(array(
  'fid' => '1',
  'uuid' => '7dbb4773-d6c6-4cb4-88bc-e8a10fdf1d07',
  'langcode' => 'en',
  'uid' => '1',
  'filename' => 'W.kml',
  'uri' => 'public://2023-05/W.kml',
  'filemime' => 'application/vnd.google-earth.kml+xml',
  'filesize' => '116880',
  'status' => '1',
  'created' => '1684679325',
  'changed' => '1684679327',
))
->execute();
$connection->schema()->createTable('file_usage', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'id' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '64',
      'default' => '0',
    ),
    'count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
    'type',
    'id',
    'module',
  ),
  'indexes' => array(
    'type_id' => array(
      'type',
      'id',
    ),
    'fid_count' => array(
      'fid',
      'count',
    ),
    'fid_module' => array(
      'fid',
      'module',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('file_usage')
->fields(array(
  'fid',
  'module',
  'type',
  'id',
  'count',
))
->values(array(
  'fid' => '1',
  'module' => 'file',
  'type' => 'localgov_geo',
  'id' => '3',
  'count' => '1',
))
->execute();
$connection->schema()->createTable('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('history')
->fields(array(
  'uid',
  'nid',
  'timestamp',
))
->values(array(
  'uid' => '1',
  'nid' => '1',
  'timestamp' => '1684679056',
))
->values(array(
  'uid' => '1',
  'nid' => '2',
  'timestamp' => '1684678316',
))
->values(array(
  'uid' => '1',
  'nid' => '3',
  'timestamp' => '1684678442',
))
->values(array(
  'uid' => '1',
  'nid' => '4',
  'timestamp' => '1684678478',
))
->values(array(
  'uid' => '1',
  'nid' => '5',
  'timestamp' => '1684678636',
))
->values(array(
  'uid' => '1',
  'nid' => '6',
  'timestamp' => '1684679372',
))
->execute();
$connection->schema()->createTable('key_value', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar_ascii',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8mb4',
));

$connection->insert('key_value')
->fields(array(
  'collection',
  'name',
  'value',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:0e56764a-f7e4-4d32-8f7d-f80c0505163d',
  'value' => 'a:1:{i:0;s:36:"system.action.comment_publish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:2520c504-1f0c-428a-964a-9c901588a579',
  'value' => 'a:1:{i:0;s:30:"system.action.node_save_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:32b04da4-3210-4cee-a1a2-16279d655feb',
  'value' => 'a:1:{i:0;s:34:"system.action.media_publish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:42d1073b-6cb9-45b3-945a-1480a84c8891',
  'value' => 'a:1:{i:0;s:40:"system.action.pathauto_update_alias_user";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:4d690d00-5622-4493-9eb0-de846021bce7',
  'value' => 'a:1:{i:0;s:36:"system.action.media_unpublish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:585e5285-2c32-42ee-8b2b-51af2439a3b4',
  'value' => 'a:1:{i:0;s:38:"system.action.user_unblock_user_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:61e05b30-fd42-415f-a9d8-a12efa4c3c9a',
  'value' => 'a:1:{i:0;s:31:"system.action.media_save_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:644e36f0-4bc5-4e2b-8fdf-ea9a4f42875f',
  'value' => 'a:1:{i:0;s:33:"system.action.node_promote_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:68a3bba3-51e7-4c19-a65c-5aa7e324b939',
  'value' => 'a:1:{i:0;s:35:"system.action.node_unpromote_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:809bb353-1db4-4c26-a137-aac53ad941d8',
  'value' => 'a:1:{i:0;s:37:"system.action.node_make_sticky_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:84345efd-b462-4c44-99e9-6cf02b5721d2',
  'value' => 'a:1:{i:0;s:48:"system.action.user_add_role_action.administrator";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:851d3c53-56f8-4910-8df4-26e83048544a',
  'value' => 'a:1:{i:0;s:35:"system.action.comment_delete_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:9a2d17fb-73f0-459a-9681-55c95f05bd73',
  'value' => 'a:1:{i:0;s:42:"system.action.taxonomy_term_publish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:a67634fb-a980-4d63-b1bf-4bb2515a31ce',
  'value' => 'a:1:{i:0;s:33:"system.action.media_delete_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:ab469203-51e0-4ac8-816d-971eaba82701',
  'value' => 'a:1:{i:0;s:35:"system.action.node_unpublish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:aee53f43-b56e-4844-a9d2-ff58c2cdb357',
  'value' => 'a:1:{i:0;s:38:"system.action.comment_unpublish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:b1141df3-9794-4ae0-95c8-b3e04f509103',
  'value' => 'a:1:{i:0;s:37:"system.action.user_cancel_user_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:b37a161f-c164-42c3-8a0b-9f56ae9b2a49',
  'value' => 'a:1:{i:0;s:51:"system.action.user_remove_role_action.administrator";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:b74172e3-a34f-4b01-a669-5c0406ea7c06',
  'value' => 'a:1:{i:0;s:39:"system.action.node_make_unsticky_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:b9f775ab-a325-4ae7-8769-36a6f3e9e9c3',
  'value' => 'a:1:{i:0;s:33:"system.action.comment_save_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:c12dab88-8b9f-483f-95a2-7d3495fe259b',
  'value' => 'a:1:{i:0;s:33:"system.action.node_publish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:cbe27623-cea4-44a1-bdeb-bcd7af1d1c80',
  'value' => 'a:1:{i:0;s:36:"system.action.user_block_user_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:cdfbd1c0-fb2e-4418-b16e-62d3e912f6f3',
  'value' => 'a:1:{i:0;s:32:"system.action.node_delete_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:d3c3707f-7eee-4683-b865-040336ca62e4',
  'value' => 'a:1:{i:0;s:44:"system.action.taxonomy_term_unpublish_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:d89cd39e-8781-4721-9170-e1207724044f',
  'value' => 'a:1:{i:0;s:49:"system.action.user_add_role_action.content_editor";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:dd4c373a-ead1-4841-8836-66cd31f6e297',
  'value' => 'a:1:{i:0;s:40:"system.action.pathauto_update_alias_node";}',
))
->values(array(
  'collection' => 'config.entity.key_store.action',
  'name' => 'uuid:e9189b77-7168-4791-bfa9-1b5a7c8f563c',
  'value' => 'a:1:{i:0;s:52:"system.action.user_remove_role_action.content_editor";}',
))
->values(array(
  'collection' => 'config.entity.key_store.base_field_override',
  'name' => 'uuid:0bffcd58-9323-4a45-a856-7d8e4824ac00',
  'value' => 'a:1:{i:0;s:42:"core.base_field_override.node.page.promote";}',
))
->values(array(
  'collection' => 'config.entity.key_store.base_field_override',
  'name' => 'uuid:5fb535e3-5fb5-4cc1-9b1e-3f5d00fdc621',
  'value' => 'a:1:{i:0;s:56:"core.base_field_override.node.localgov_directory.promote";}',
))
->values(array(
  'collection' => 'config.entity.key_store.base_field_override',
  'name' => 'uuid:f8e67334-63dc-40ef-836d-00f71088e08b',
  'value' => 'a:1:{i:0;s:64:"core.base_field_override.node.localgov_directories_venue.promote";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'theme:claro',
  'value' => 'a:8:{i:0;s:31:"block.block.claro_local_actions";i:1;s:28:"block.block.claro_page_title";i:2;s:37:"block.block.claro_primary_local_tasks";i:3;s:39:"block.block.claro_secondary_local_tasks";i:4;s:22:"block.block.claro_help";i:5;s:29:"block.block.claro_breadcrumbs";i:6;s:25:"block.block.claro_content";i:7;s:26:"block.block.claro_messages";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'theme:olivero',
  'value' => 'a:15:{i:0;s:24:"block.block.olivero_help";i:1;s:30:"block.block.olivero_page_title";i:2;s:41:"block.block.olivero_primary_admin_actions";i:3;s:39:"block.block.olivero_primary_local_tasks";i:4;s:41:"block.block.olivero_secondary_local_tasks";i:5;s:29:"block.block.olivero_syndicate";i:6;s:38:"block.block.olivero_search_form_narrow";i:7;s:36:"block.block.olivero_search_form_wide";i:8;s:31:"block.block.olivero_breadcrumbs";i:9;s:27:"block.block.olivero_content";i:10;s:28:"block.block.olivero_messages";i:11;s:27:"block.block.olivero_powered";i:12;s:33:"block.block.olivero_site_branding";i:13;s:32:"block.block.olivero_account_menu";i:14;s:29:"block.block.olivero_main_menu";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:12f03826-0e80-45b0-9337-9b76421b34cf',
  'value' => 'a:1:{i:0;s:28:"block.block.claro_page_title";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:189913bb-2384-4d1c-805d-0bf01396b4e5',
  'value' => 'a:1:{i:0;s:36:"block.block.olivero_search_form_wide";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:1c03139c-6229-4034-83b7-d1e95a95e663',
  'value' => 'a:1:{i:0;s:29:"block.block.claro_breadcrumbs";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:1c46e333-ac56-4bbb-893c-ce92948adfee',
  'value' => 'a:1:{i:0;s:38:"block.block.olivero_search_form_narrow";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:1ec2a766-2240-4dce-b3dc-f3f72e806af3',
  'value' => 'a:1:{i:0;s:29:"block.block.olivero_syndicate";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:2393a0dc-db9c-468a-886d-f30405263f23',
  'value' => 'a:1:{i:0;s:31:"block.block.olivero_breadcrumbs";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:28d30d62-961c-44a2-b88e-34d095a61f24',
  'value' => 'a:1:{i:0;s:26:"block.block.claro_messages";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:3b710adb-fb67-4632-bad8-a3f76e974d7b',
  'value' => 'a:1:{i:0;s:27:"block.block.olivero_content";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:3f047fed-971f-449f-87f4-54e73c01ed16',
  'value' => 'a:1:{i:0;s:41:"block.block.olivero_secondary_local_tasks";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:42e06a81-0d11-495a-95b6-347997266bf2',
  'value' => 'a:1:{i:0;s:39:"block.block.claro_secondary_local_tasks";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:4e76b954-5b9e-4a88-9684-44296e54433d',
  'value' => 'a:1:{i:0;s:27:"block.block.olivero_powered";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:4f154a5d-4dcc-4243-a1a2-27ebe782c842',
  'value' => 'a:1:{i:0;s:37:"block.block.claro_primary_local_tasks";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:55e3dd8b-6ca7-49e9-a700-f76c40257fa9',
  'value' => 'a:1:{i:0;s:31:"block.block.claro_local_actions";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:58ae22e1-6c70-42fc-b782-29f31c2d7c20',
  'value' => 'a:1:{i:0;s:33:"block.block.olivero_site_branding";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:6021fad7-bfa0-40ac-950c-bd84d27dde6b',
  'value' => 'a:1:{i:0;s:25:"block.block.claro_content";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:722b6244-0997-4fe0-83d7-377d72ee60d6',
  'value' => 'a:1:{i:0;s:32:"block.block.olivero_account_menu";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:90509a8f-8e7b-4872-bb99-5ead43c8ffa7',
  'value' => 'a:1:{i:0;s:41:"block.block.olivero_primary_admin_actions";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:90f84ff2-9712-47e9-8f27-5a80271a32d8',
  'value' => 'a:1:{i:0;s:24:"block.block.olivero_help";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:acea13cf-490d-4685-af31-38aa431e6346',
  'value' => 'a:1:{i:0;s:39:"block.block.olivero_primary_local_tasks";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:ae89dee0-c571-445f-b1d5-cfd20d283204',
  'value' => 'a:1:{i:0;s:29:"block.block.olivero_main_menu";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:b3e8b0aa-165c-4baf-aed8-e5fcd3f7febd',
  'value' => 'a:1:{i:0;s:22:"block.block.claro_help";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:e2fc9dc6-546a-42c7-8ebb-9bf68deb5081',
  'value' => 'a:1:{i:0;s:30:"block.block.olivero_page_title";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block',
  'name' => 'uuid:eb1b630c-94c5-4956-be90-1d957e20bd71',
  'value' => 'a:1:{i:0;s:28:"block.block.olivero_messages";}',
))
->values(array(
  'collection' => 'config.entity.key_store.block_content_type',
  'name' => 'uuid:85637652-6757-43f8-bd34-10d045ec7bdd',
  'value' => 'a:1:{i:0;s:24:"block_content.type.basic";}',
))
->values(array(
  'collection' => 'config.entity.key_store.comment_type',
  'name' => 'uuid:4ac7d714-924c-4b4d-a144-7ddcdcd633a7',
  'value' => 'a:1:{i:0;s:20:"comment.type.comment";}',
))
->values(array(
  'collection' => 'config.entity.key_store.contact_form',
  'name' => 'uuid:7e8431c4-8dbd-447b-9a05-e6af054be352',
  'value' => 'a:1:{i:0;s:21:"contact.form.feedback";}',
))
->values(array(
  'collection' => 'config.entity.key_store.contact_form',
  'name' => 'uuid:c9f445c2-96ba-4582-a483-4d37f1f04524',
  'value' => 'a:1:{i:0;s:21:"contact.form.personal";}',
))
->values(array(
  'collection' => 'config.entity.key_store.crop_type',
  'name' => 'uuid:5cc9713b-1cac-4af2-b090-86363a2b8597',
  'value' => 'a:1:{i:0;s:13:"crop.type.7_3";}',
))
->values(array(
  'collection' => 'config.entity.key_store.crop_type',
  'name' => 'uuid:71697a3a-bed5-43af-bb90-815c70ccda70',
  'value' => 'a:1:{i:0;s:16:"crop.type.square";}',
))
->values(array(
  'collection' => 'config.entity.key_store.crop_type',
  'name' => 'uuid:90d393e1-d6f0-41de-acf2-9e78e6b3aeec',
  'value' => 'a:1:{i:0;s:13:"crop.type.3_2";}',
))
->values(array(
  'collection' => 'config.entity.key_store.crop_type',
  'name' => 'uuid:98647bd5-7e73-4d09-bec0-08dd00e6b1fc',
  'value' => 'a:1:{i:0;s:14:"crop.type.16_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.crop_type',
  'name' => 'uuid:a755f74f-2a84-4385-923c-3a52bca81482',
  'value' => 'a:1:{i:0;s:28:"crop.type.localgov_news_16_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.crop_type',
  'name' => 'uuid:c2bdc132-f2f1-499f-8dfb-eb2fad997003',
  'value' => 'a:1:{i:0;s:19:"crop.type.freestyle";}',
))
->values(array(
  'collection' => 'config.entity.key_store.crop_type',
  'name' => 'uuid:d0a704f6-fd9c-45a8-8736-31d068cec121',
  'value' => 'a:1:{i:0;s:14:"crop.type.28_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.crop_type',
  'name' => 'uuid:f017b933-32d5-4e2f-8c13-a16a250993b8',
  'value' => 'a:1:{i:0;s:13:"crop.type.8_7";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:3146fdb2-3407-47b7-ac58-bca884c14d94',
  'value' => 'a:1:{i:0;s:30:"core.date_format.html_datetime";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:58c1dbb5-8940-4636-8673-0dfeb310dab7',
  'value' => 'a:1:{i:0;s:41:"core.date_format.localgov_event_date_full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:59a4b606-c534-495c-bd4d-ae9d60b0682e',
  'value' => 'a:1:{i:0;s:31:"core.date_format.olivero_medium";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:7488e7c0-6021-4f44-b268-c34c192944f9',
  'value' => 'a:1:{i:0;s:26:"core.date_format.html_year";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:84d6a496-9546-40ef-97f9-9b4e677c0b2f',
  'value' => 'a:1:{i:0;s:25:"core.date_format.fallback";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:a93528e3-70f3-41d6-9b46-f18ddcac5cd7',
  'value' => 'a:1:{i:0;s:21:"core.date_format.long";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:abb878f6-87d4-4738-be8c-ee1d5e6c1f46',
  'value' => 'a:1:{i:0;s:26:"core.date_format.html_week";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:bc81f2a7-63e1-464c-9430-9fe0ed334542',
  'value' => 'a:1:{i:0;s:41:"core.date_format.localgov_event_date_hour";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:be433a4f-f1e2-461d-9ac9-532f97bd14c9',
  'value' => 'a:1:{i:0;s:27:"core.date_format.html_month";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:cb06b328-81c4-4e1a-9c02-3f32fe0685f6',
  'value' => 'a:1:{i:0;s:26:"core.date_format.html_time";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:d27e1929-fa0d-4c61-8ce8-d0bd11320e87',
  'value' => 'a:1:{i:0;s:35:"core.date_format.html_yearless_date";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:e33f1d3c-99a7-4e1d-a3f8-4d21696a1131',
  'value' => 'a:1:{i:0;s:23:"core.date_format.medium";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:e75cc929-4d8d-4168-9d54-f4d4c4556b36',
  'value' => 'a:1:{i:0;s:22:"core.date_format.short";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_format',
  'name' => 'uuid:f8c82e3f-eca4-48ea-89e8-98273a47fa1f',
  'value' => 'a:1:{i:0;s:26:"core.date_format.html_date";}',
))
->values(array(
  'collection' => 'config.entity.key_store.date_recur_interpreter',
  'name' => 'uuid:8b532bec-68ac-4d37-92fc-d64e1819e169',
  'value' => 'a:1:{i:0;s:42:"date_recur.interpreter.default_interpreter";}',
))
->values(array(
  'collection' => 'config.entity.key_store.editor',
  'name' => 'uuid:66677893-d268-4464-b033-ccdbf2bbe54b',
  'value' => 'a:1:{i:0;s:23:"editor.editor.full_html";}',
))
->values(array(
  'collection' => 'config.entity.key_store.editor',
  'name' => 'uuid:ebd50ec2-05ac-45d8-9bb6-626137d93f90',
  'value' => 'a:1:{i:0;s:24:"editor.editor.basic_html";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_browser',
  'name' => 'uuid:fb73a4b4-0903-4115-a2c0-6d5b71a1a4f3',
  'value' => 'a:1:{i:0;s:43:"entity_browser.browser.localgov_geo_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:06b5ccc5-c737-47e5-bbb4-0b6efe82447a',
  'value' => 'a:1:{i:0;s:44:"core.entity_form_display.media.image.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:0ab0c2be-4cf5-4173-9fff-98d3939d14f8',
  'value' => 'a:1:{i:0;s:42:"core.entity_form_display.user.user.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:0ba94dc5-26a4-4baf-a59a-0661f59ab37f',
  'value' => 'a:1:{i:0;s:44:"core.entity_form_display.media.audio.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:108c95d9-cd6c-44eb-a348-e43823e456ee',
  'value' => 'a:1:{i:0;s:51:"core.entity_form_display.media.remote_video.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:16ee1cfc-6b8e-44c8-8c33-33f49457058a',
  'value' => 'a:1:{i:0;s:44:"core.entity_form_display.media.video.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:33447aa4-8599-433c-9a13-64ba425c633e',
  'value' => 'a:1:{i:0;s:42:"core.entity_form_display.node.test.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:48f319a4-f5ac-4af3-b6a6-caaff2af93ce',
  'value' => 'a:1:{i:0;s:48:"core.entity_form_display.comment.comment.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:49d467cc-2674-4bf0-b2b9-5291b86b6dc7',
  'value' => 'a:1:{i:0;s:47:"core.entity_form_display.media.document.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:4cff9bcc-4e8d-4c6c-a4ec-ef1b7a701687',
  'value' => 'a:1:{i:0;s:50:"core.entity_form_display.localgov_geo.area.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:5deaf829-1b55-42c1-b10a-2128533aee7c',
  'value' => 'a:1:{i:0;s:52:"core.entity_form_display.node.localgov_event.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:6001f079-1e25-4214-8bf6-22810147fb79',
  'value' => 'a:1:{i:0;s:50:"core.entity_form_display.media.audio.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:709f13fc-0515-40fe-bff2-4c2dc494d2ad',
  'value' => 'a:1:{i:0;s:49:"core.entity_form_display.localgov_geo.area.inline";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:7641d751-09b1-426e-acb0-3835c461b061',
  'value' => 'a:1:{i:0;s:50:"core.entity_form_display.media.video.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:8421e03d-c8ef-4f5c-8be9-84910c536c98',
  'value' => 'a:1:{i:0;s:42:"core.entity_form_display.node.page.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:907d63f7-2602-455f-8766-eb1134628092',
  'value' => 'a:1:{i:0;s:50:"core.entity_form_display.media.image.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:992375f1-ead0-435d-a9ff-8d9ccda64976',
  'value' => 'a:1:{i:0;s:56:"core.entity_form_display.node.localgov_directory.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:9d1e6bd4-1acd-4b1e-8596-61b36c5e5d2a',
  'value' => 'a:1:{i:0;s:52:"core.entity_form_display.block_content.basic.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:a1b3514e-914b-430b-a007-770cd998cc20',
  'value' => 'a:1:{i:0;s:53:"core.entity_form_display.localgov_geo.address.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:aec829be-0208-4912-b4cc-2b541cc726de',
  'value' => 'a:1:{i:0;s:52:"core.entity_form_display.localgov_geo.address.inline";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:be366e88-86ba-4af0-bfc7-a606e720fc54',
  'value' => 'a:1:{i:0;s:45:"core.entity_form_display.node.article.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:edbc164c-0ea2-4886-8e92-751179345179',
  'value' => 'a:1:{i:0;s:64:"core.entity_form_display.node.localgov_directories_venue.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:f123b768-eb97-45c8-9abd-d4f15658e881',
  'value' => 'a:1:{i:0;s:53:"core.entity_form_display.media.document.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_display',
  'name' => 'uuid:f324e077-2212-4be8-bf47-f76367cf6969',
  'value' => 'a:1:{i:0;s:57:"core.entity_form_display.media.remote_video.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_mode',
  'name' => 'uuid:1a04479f-c6d6-4589-9c6b-539f6724ad8b',
  'value' => 'a:1:{i:0;s:41:"core.entity_form_mode.localgov_geo.inline";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_mode',
  'name' => 'uuid:2c809aac-a415-4ec8-818f-238d48b41cf0',
  'value' => 'a:1:{i:0;s:35:"core.entity_form_mode.user.register";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_form_mode',
  'name' => 'uuid:831a82e4-fb15-47a6-bc61-61e8c7357965',
  'value' => 'a:1:{i:0;s:41:"core.entity_form_mode.media.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:0b36f6e6-0f35-46e0-9824-f4e91a4eac12',
  'value' => 'a:1:{i:0;s:62:"core.entity_view_display.node.localgov_directory.search_result";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:0f7d39c2-3127-4b16-8133-f0fb48bbbd5e',
  'value' => 'a:1:{i:0;s:57:"core.entity_view_display.media.remote_video.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:122a008b-9078-4052-a7a3-f96c8be4b802',
  'value' => 'a:1:{i:0;s:48:"core.entity_view_display.comment.comment.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:143f8460-5057-46b2-bb87-541dd79572b0',
  'value' => 'a:1:{i:0;s:61:"core.entity_view_display.node.localgov_directory.search_index";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:19c51549-8adb-49a4-a1e9-68dc9221f2ee',
  'value' => 'a:1:{i:0;s:63:"core.entity_view_display.node.localgov_directories_venue.teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:1bf00f70-9b70-498b-b3cc-455027fb55f7',
  'value' => 'a:1:{i:0;s:57:"core.entity_view_display.node.localgov_event.search_index";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:212d73c9-e1ab-466e-9e1f-02995bca7ea1',
  'value' => 'a:1:{i:0;s:70:"core.entity_view_display.node.localgov_directories_venue.search_result";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:214dbd66-776e-4de0-8f91-0e1fb7a3b1f3',
  'value' => 'a:1:{i:0;s:52:"core.entity_view_display.block_content.basic.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:230f1803-f6a4-4e48-82b0-714c48de33c9',
  'value' => 'a:1:{i:0;s:50:"core.entity_view_display.media.audio.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:2fa07fac-c04f-4c0f-a9fe-8b0acc05e667',
  'value' => 'a:1:{i:0;s:48:"core.entity_view_display.media.remote_video.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:300c9c4d-388b-481a-b8a7-bb5012ccac64',
  'value' => 'a:1:{i:0;s:54:"core.entity_view_display.media.image.localgov_featured";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:3942cbc0-8682-4547-a54a-2eda48a1d4da',
  'value' => 'a:1:{i:0;s:45:"core.entity_view_display.node.article.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:39a25664-52e3-4672-93f3-f68c84690219',
  'value' => 'a:1:{i:0;s:42:"core.entity_view_display.user.user.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:3fd6e567-57ed-4f44-a452-b3c4e822f79e',
  'value' => 'a:1:{i:0;s:61:"core.entity_view_display.media.image.localgov_event_thumbnail";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:4c081225-aff6-4890-89af-08607af491fb',
  'value' => 'a:1:{i:0;s:44:"core.entity_view_display.media.image.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:4d5d3dbd-95a5-4d66-ba00-f5762fc6a092',
  'value' => 'a:1:{i:0;s:56:"core.entity_view_display.node.localgov_directory.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:4ec43995-b02f-48c3-8bd3-814cd7015b98',
  'value' => 'a:1:{i:0;s:61:"core.entity_view_display.media.image.localgov_newsroom_teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:507d2ccb-bd15-4d28-9d6a-2d8950273fa0',
  'value' => 'a:1:{i:0;s:50:"core.entity_view_display.localgov_geo.area.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:54860996-affc-4d12-9e07-a59e9dfbb81c',
  'value' => 'a:1:{i:0;s:48:"core.entity_view_display.localgov_geo.area.embed";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:58016a87-1ea0-4d0f-92fe-3cea28400891',
  'value' => 'a:1:{i:0;s:41:"core.entity_view_display.node.page.teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:5c48b8d3-fa4c-4dc6-ab26-7f6b164c985e',
  'value' => 'a:1:{i:0;s:51:"core.entity_view_display.localgov_geo.address.embed";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:60e0240f-84ff-4594-bb97-63a93872034c',
  'value' => 'a:1:{i:0;s:69:"core.entity_view_display.node.localgov_directories_venue.search_index";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:735c4dad-6cf0-4d80-bf6c-e66bbeb9c188',
  'value' => 'a:1:{i:0;s:50:"core.entity_view_display.media.image.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:766dfbfc-4725-4a01-9a4e-6bb1d9c332cd',
  'value' => 'a:1:{i:0;s:43:"core.entity_view_display.media.image.square";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:8145750d-5523-4500-8544-90b1c31e7069',
  'value' => 'a:1:{i:0;s:51:"core.entity_view_display.node.localgov_event.teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:835bdfd7-f54b-468a-849b-f38443dfdb3c',
  'value' => 'a:1:{i:0;s:44:"core.entity_view_display.media.audio.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:8e72275c-a754-4e90-a539-1f8d9bb505ab',
  'value' => 'a:1:{i:0;s:42:"core.entity_view_display.node.page.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:96cec1dd-62c3-483d-bf19-2ae624214458',
  'value' => 'a:1:{i:0;s:53:"core.entity_view_display.media.document.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:980ea716-e43e-41ad-b20f-5b6594457779',
  'value' => 'a:1:{i:0;s:51:"core.entity_view_display.media.image.responsive_3x2";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:9bf93f92-f0f2-4ead-9977-a01d5f6972ea',
  'value' => 'a:1:{i:0;s:42:"core.entity_view_display.user.user.compact";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:a5ac11ca-e7c0-4903-99d7-d07b3cb96980',
  'value' => 'a:1:{i:0;s:44:"core.entity_view_display.media.video.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:a7cb987f-9f6a-4ca4-a5ea-aeb875e14405',
  'value' => 'a:1:{i:0;s:64:"core.entity_view_display.node.localgov_directories_venue.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:aceff9dc-91d9-4b37-9e4f-105a0e0ad0e5',
  'value' => 'a:1:{i:0;s:54:"core.entity_view_display.media.image.responsive_banner";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:aeb1a23f-02c2-4a4e-8aea-0bd1bc5f702a',
  'value' => 'a:1:{i:0;s:50:"core.entity_view_display.media.video.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:b01b7baf-b14d-4054-b598-66dd5cd10dea',
  'value' => 'a:1:{i:0;s:72:"core.entity_view_display.node.localgov_directories_venue.directory_index";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:b97e597d-0dc2-4dfb-b344-135a47e00fd8',
  'value' => 'a:1:{i:0;s:47:"core.entity_view_display.media.image.medium_8_7";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:ce766910-a9ad-476f-a248-363d8a3f217b',
  'value' => 'a:1:{i:0;s:42:"core.entity_view_display.node.test.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:d016774f-1935-4015-9359-5bdec1fda36a',
  'value' => 'a:1:{i:0;s:53:"core.entity_view_display.localgov_geo.address.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:d05abbcd-56b5-4953-8ff5-ccf4e737c25a',
  'value' => 'a:1:{i:0;s:44:"core.entity_view_display.node.article.teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:d1ec116e-ed6d-4450-8d61-716e22c50fd5',
  'value' => 'a:1:{i:0;s:41:"core.entity_view_display.node.test.teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:d355da0c-dfbb-494f-b507-ef08e9d2f3ce',
  'value' => 'a:1:{i:0;s:58:"core.entity_view_display.node.localgov_event.search_result";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:d517e4f2-9e29-471a-af6e-26fca360ce3d',
  'value' => 'a:1:{i:0;s:41:"core.entity_view_display.node.article.rss";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:de4735d2-4139-435f-8033-7bae1f504a88',
  'value' => 'a:1:{i:0;s:57:"core.entity_view_display.media.image.scale_crop_7_3_large";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:df286224-1f4c-4503-a139-174bfe1207cd',
  'value' => 'a:1:{i:0;s:51:"core.entity_view_display.media.remote_video.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:e141f688-936f-412f-ac89-eb5d42ddcc1d',
  'value' => 'a:1:{i:0;s:50:"core.entity_view_display.localgov_geo.address.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:e2bad0fb-ab83-4f9b-a42a-37301b6d4ffe',
  'value' => 'a:1:{i:0;s:47:"core.entity_view_display.media.document.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:f2b8a677-631f-46ec-a002-c366ffa74415',
  'value' => 'a:1:{i:0;s:55:"core.entity_view_display.node.localgov_directory.teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:f3995438-f9da-42af-b7c2-2fa3fa7b464c',
  'value' => 'a:1:{i:0;s:60:"core.entity_view_display.media.image.localgov_featured_large";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:f587afbe-70d6-426b-a310-c217e36d62b6',
  'value' => 'a:1:{i:0;s:52:"core.entity_view_display.node.localgov_event.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_display',
  'name' => 'uuid:f73eefce-2e56-4320-82ea-ab4bb787c890',
  'value' => 'a:1:{i:0;s:47:"core.entity_view_display.localgov_geo.area.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:03d3391e-366b-4806-97ba-fe5759940a99',
  'value' => 'a:1:{i:0;s:31:"core.entity_view_mode.user.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:0554f75f-67c5-4910-9dba-32c36b68efb8',
  'value' => 'a:1:{i:0;s:38:"core.entity_view_mode.path_alias.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:0c6f1344-3c61-48cf-bdd5-4e469765898e',
  'value' => 'a:1:{i:0;s:42:"core.entity_view_mode.node.directory_index";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:0e9dbacd-b875-4de4-8da1-fdffa40104ad',
  'value' => 'a:1:{i:0;s:35:"core.entity_view_mode.comment.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:15df2a0e-d8cf-45c7-92c9-aba60279e15d',
  'value' => 'a:1:{i:0;s:32:"core.entity_view_mode.media.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:25f07832-775b-400b-a3f4-10e56cd01377',
  'value' => 'a:1:{i:0;s:40:"core.entity_view_mode.block_content.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:31b91e6d-e874-4daf-91ab-0f1ee33b95ab',
  'value' => 'a:1:{i:0;s:38:"core.entity_view_mode.media.medium_8_7";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:408b0800-a4df-4343-812d-33ba58b99036',
  'value' => 'a:1:{i:0;s:32:"core.entity_view_mode.tour.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:42557e06-0e4a-44c5-bfd0-3245f1aa48ba',
  'value' => 'a:1:{i:0;s:40:"core.entity_view_mode.localgov_geo.embed";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:4539280d-eb03-43da-8feb-88d5d162c9ce',
  'value' => 'a:1:{i:0;s:41:"core.entity_view_mode.block_content.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:46209c3e-4ac8-4a9c-8985-9616944d9649',
  'value' => 'a:1:{i:0;s:37:"core.entity_view_mode.media.freestyle";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:4a0a527e-7579-4f20-afb8-9504df1e5319',
  'value' => 'a:1:{i:0;s:45:"core.entity_view_mode.media.responsive_banner";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:4ad5286b-642d-48b3-932a-ed76af3794a0',
  'value' => 'a:1:{i:0;s:32:"core.entity_view_mode.file.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:53bb41ee-e41a-4e87-9fc1-66442bbf6de7',
  'value' => 'a:1:{i:0;s:45:"core.entity_view_mode.media.localgov_featured";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:5e875912-c97b-4ca7-b231-7735853291c0',
  'value' => 'a:1:{i:0;s:45:"core.entity_view_mode.menu_link_content.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:6a896ac3-751d-4381-be7b-86d731a9a314',
  'value' => 'a:1:{i:0;s:39:"core.entity_view_mode.localgov_geo.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:70b5b570-4191-4e5b-86dd-8b9863f4b382',
  'value' => 'a:1:{i:0;s:39:"core.entity_view_mode.node.search_index";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:718d0508-1342-44dc-bdc7-52147b2f3e4a',
  'value' => 'a:1:{i:0;s:48:"core.entity_view_mode.media.scale_crop_7_3_large";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:7ad00d09-6476-466a-beea-5da003573d80',
  'value' => 'a:1:{i:0;s:31:"core.entity_view_mode.node.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:7b012c94-45d9-451a-a2ef-fa1d47b15ded',
  'value' => 'a:1:{i:0;s:40:"core.entity_view_mode.taxonomy_term.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:7db23a0b-c1e5-43d5-8cb4-be04b7cf574b',
  'value' => 'a:1:{i:0;s:52:"core.entity_view_mode.media.localgov_newsroom_teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:7f985ae8-c688-4da9-8212-d05a8bc0187b',
  'value' => 'a:1:{i:0;s:41:"core.entity_view_mode.taxonomy_term.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:810db1f4-24a8-477a-aa06-78a61e02e8d3',
  'value' => 'a:1:{i:0;s:33:"core.entity_view_mode.block.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:898a0ae1-7763-4a78-9da6-ce8e74814cbb',
  'value' => 'a:1:{i:0;s:34:"core.entity_view_mode.user.compact";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:8b88057d-798b-4296-8e21-8370fd454dce',
  'value' => 'a:1:{i:0;s:34:"core.entity_view_mode.media.square";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:8e6c4975-6884-4846-8804-1a4fcde8c05b',
  'value' => 'a:1:{i:0;s:32:"core.entity_view_mode.user.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:8e921e97-9708-4292-bbaa-a82b1de0149b',
  'value' => 'a:1:{i:0;s:33:"core.entity_view_mode.media.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:97e911ac-f526-45e8-a0fe-89e6e1bf244c',
  'value' => 'a:1:{i:0;s:30:"core.entity_view_mode.node.rss";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:99be6f26-2b38-45f7-becc-8996e43bcea2',
  'value' => 'a:1:{i:0;s:40:"core.entity_view_mode.node.search_result";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:a11aa545-5afe-4f46-8901-12d746684478',
  'value' => 'a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:b4b12b80-c1a3-496c-97f2-3588fddc8e58',
  'value' => 'a:1:{i:0;s:32:"core.entity_view_mode.crop.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:ba64f911-c8d0-41fe-9fac-bcb21df2a3cf',
  'value' => 'a:1:{i:0;s:34:"core.entity_view_mode.comment.full";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:c45ba79f-7c51-435b-9b58-499bce4d8206',
  'value' => 'a:1:{i:0;s:32:"core.entity_view_mode.node.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:c5d86058-c60c-4b67-8067-69cf4ebb0465',
  'value' => 'a:1:{i:0;s:41:"core.entity_view_mode.media.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:cb943c07-cbb7-43fb-a9b5-0538f114d42a',
  'value' => 'a:1:{i:0;s:43:"core.entity_view_mode.contact_message.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:ce21a3b8-4cd4-4262-88c7-c017dbfa3890',
  'value' => 'a:1:{i:0;s:42:"core.entity_view_mode.media.responsive_3x2";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:ce8ffd8d-1903-473a-b37f-924b9b1bdb38',
  'value' => 'a:1:{i:0;s:51:"core.entity_view_mode.media.localgov_featured_large";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:d3e12972-1cc8-4534-8ebb-43ec4f90cd8e',
  'value' => 'a:1:{i:0;s:52:"core.entity_view_mode.media.localgov_event_thumbnail";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:d6909cb7-ff09-4108-9e95-9cd775650862',
  'value' => 'a:1:{i:0;s:43:"core.entity_view_mode.search_api_task.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.entity_view_mode',
  'name' => 'uuid:e1d7613f-8a5a-4a4b-a969-c6ca7f8bccc1',
  'value' => 'a:1:{i:0;s:36:"core.entity_view_mode.shortcut.token";}',
))
->values(array(
  'collection' => 'config.entity.key_store.facets_facet',
  'name' => 'uuid:2fe2b5f2-bc8e-42b5-afd9-4da6dd541a3f',
  'value' => 'a:1:{i:0;s:34:"facets.facet.localgov_events_price";}',
))
->values(array(
  'collection' => 'config.entity.key_store.facets_facet',
  'name' => 'uuid:96a80c59-43de-4a0e-aad3-1e551dba58e0',
  'value' => 'a:1:{i:0;s:37:"facets.facet.localgov_events_locality";}',
))
->values(array(
  'collection' => 'config.entity.key_store.facets_facet',
  'name' => 'uuid:f5a01929-f11d-40c0-9267-d5f35d969485',
  'value' => 'a:1:{i:0;s:37:"facets.facet.localgov_events_category";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:0474a352-855e-4145-ac90-733d9c955e10',
  'value' => 'a:1:{i:0;s:55:"field.field.node.localgov_event.localgov_event_locality";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:0586931b-da49-40c3-86a1-167ac733f9d4',
  'value' => 'a:1:{i:0;s:70:"field.field.node.localgov_directories_venue.localgov_directory_website";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:062314fc-0763-4dd9-b054-e8bdbadeb51c',
  'value' => 'a:1:{i:0;s:36:"field.field.block_content.basic.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:070a966d-163a-49ac-95f8-5ebc9fe830ef',
  'value' => 'a:1:{i:0;s:32:"field.field.node.article.comment";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:0c3a1921-4571-414b-bb45-b63a8cdbdb1c',
  'value' => 'a:1:{i:0;s:26:"field.field.node.page.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:1ca40fd8-a942-4793-9db7-f990e84c8f98',
  'value' => 'a:1:{i:0;s:68:"field.field.node.localgov_directories_venue.localgov_directory_email";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:272e06b9-b5d2-4b73-93cf-7747c896a0c9',
  'value' => 'a:1:{i:0;s:40:"field.field.node.localgov_directory.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:3200b5a0-e61e-45df-a9cf-afde0fa23a19',
  'value' => 'a:1:{i:0;s:72:"field.field.node.localgov_directories_venue.localgov_directory_job_title";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:4148ddbe-d395-448a-8f6b-a727a3c0bfad',
  'value' => 'a:1:{i:0;s:61:"field.field.node.localgov_directories_venue.localgov_location";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:579474a6-e571-4e06-8baf-a5c504869365',
  'value' => 'a:1:{i:0;s:46:"field.field.localgov_geo.address.accessibility";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:57b89227-41d0-47f5-aa63-61ed87cb682a',
  'value' => 'a:1:{i:0;s:67:"field.field.node.localgov_directories_venue.localgov_directory_name";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:5c36aeb9-9072-43c5-9854-b79bc0a50617',
  'value' => 'a:1:{i:0;s:36:"field.field.node.localgov_event.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:5c41959b-585d-4a21-8765-a02aba6c1068',
  'value' => 'a:1:{i:0;s:36:"field.field.node.article.field_image";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:5d75b905-6ff9-4247-beea-30631f5a056d',
  'value' => 'a:1:{i:0;s:52:"field.field.node.localgov_event.localgov_event_image";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:617487aa-fcf6-4c7c-8f16-3a488cc31aea',
  'value' => 'a:1:{i:0;s:47:"field.field.media.document.field_media_document";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:61d28a56-0e79-4957-8b0c-5e2b005914f4',
  'value' => 'a:1:{i:0;s:73:"field.field.node.localgov_directories_venue.localgov_directory_title_sort";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:65d8a3ef-98bc-411c-bef0-eee66c5883fb',
  'value' => 'a:1:{i:0;s:55:"field.field.node.localgov_event.localgov_event_location";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:6b45f3d1-a5c7-48ef-b569-9959186d508d',
  'value' => 'a:1:{i:0;s:35:"field.field.node.article.field_tags";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:6c7c056f-09fc-4d48-bc05-68ffdf68cdbe',
  'value' => 'a:1:{i:0;s:51:"field.field.node.localgov_event.localgov_event_date";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:6cf24e86-605c-40f5-b704-ea954e937bd5',
  'value' => 'a:1:{i:0;s:61:"field.field.node.localgov_event.localgov_event_call_to_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:6e38544a-19f7-4ccf-9575-92f64dcf1d22',
  'value' => 'a:1:{i:0;s:71:"field.field.node.localgov_directories_venue.localgov_directory_channels";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:74287d46-176e-46a6-9609-70ffaef1e00c',
  'value' => 'a:1:{i:0;s:68:"field.field.node.localgov_directory.localgov_directory_facets_enable";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:7479bc95-37b6-4845-a844-f2f6fc37c2fd',
  'value' => 'a:1:{i:0;s:44:"field.field.localgov_geo.address.external_id";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:7cc774cb-4b79-4491-92bb-5ce3d722a893',
  'value' => 'a:1:{i:0;s:41:"field.field.localgov_geo.area.external_id";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:7d38d638-f3f9-432f-856d-6013afca5a7a',
  'value' => 'a:1:{i:0;s:52:"field.field.node.localgov_event.localgov_event_venue";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:87c36ae2-aa11-4b96-8cce-a372e3e93819',
  'value' => 'a:1:{i:0;s:41:"field.field.localgov_geo.address.location";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:9823c9ec-155e-470c-9146-e3f9f048eef5',
  'value' => 'a:1:{i:0;s:55:"field.field.media.remote_video.field_media_oembed_video";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:9a1ee23a-ec89-4715-b461-771971fa807b',
  'value' => 'a:1:{i:0;s:40:"field.field.comment.comment.comment_body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:9c0dd81b-6e8e-4d4d-9530-062c7a50365d',
  'value' => 'a:1:{i:0;s:76:"field.field.node.localgov_directories_venue.localgov_directory_facets_select";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:9ff38168-afb4-47da-9441-d4b949b46636',
  'value' => 'a:1:{i:0;s:47:"field.field.node.test.field_alternate_reference";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:a12912dc-e8b4-44a5-94cf-8fce926f484f',
  'value' => 'a:1:{i:0;s:68:"field.field.node.localgov_directories_venue.localgov_directory_files";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:a2fb2625-ae07-416b-95a8-b1a3bdaab49a',
  'value' => 'a:1:{i:0;s:68:"field.field.node.localgov_directories_venue.localgov_directory_phone";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:a379217f-fa10-44f7-8595-0cb76c8cf93b',
  'value' => 'a:1:{i:0;s:68:"field.field.node.localgov_directory.localgov_directory_channel_types";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:a382540c-18e3-4307-beb8-c21a22934541',
  'value' => 'a:1:{i:0;s:46:"field.field.media.audio.field_media_audio_file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:a6aae2fd-d322-4050-b9f9-470d556981a6',
  'value' => 'a:1:{i:0;s:38:"field.field.localgov_geo.area.geo_file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:b216b4b4-2fed-49f0-a461-69d0182a4a5f',
  'value' => 'a:1:{i:0;s:57:"field.field.node.localgov_event.localgov_event_categories";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:b3f864da-9233-457b-9abe-10d7f28a1f8c',
  'value' => 'a:1:{i:0;s:68:"field.field.node.localgov_directories_venue.localgov_directory_notes";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:b869c117-0cfd-476e-96b0-11e3d21ffee1',
  'value' => 'a:1:{i:0;s:52:"field.field.node.localgov_event.localgov_event_price";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:b8acc4b1-94ad-47fa-a5f4-2f7c3d74d2bf',
  'value' => 'a:1:{i:0;s:46:"field.field.media.video.field_media_video_file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:bd2e901f-7f0d-46c8-ade0-b825c3742516',
  'value' => 'a:1:{i:0;s:41:"field.field.media.image.field_media_image";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:bfd70ff3-73fd-4634-8d6a-001462b3130d',
  'value' => 'a:1:{i:0;s:76:"field.field.node.localgov_directories_venue.localgov_directory_opening_times";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:c0dcf408-93ac-4ba4-b10c-1e4b1ab11a16',
  'value' => 'a:1:{i:0;s:34:"field.field.user.user.user_picture";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:d2ad1bd6-2eaf-499b-a338-eed68d17317c',
  'value' => 'a:1:{i:0;s:29:"field.field.node.article.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:efc4410c-762e-41fd-a3f1-6c7da10b79ee',
  'value' => 'a:1:{i:0;s:48:"field.field.node.localgov_directories_venue.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:f0f532dd-625f-45c3-9f3e-21091cfc938c',
  'value' => 'a:1:{i:0;s:38:"field.field.localgov_geo.area.location";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_config',
  'name' => 'uuid:f7595e19-73ea-4e8a-a3fc-c0c567c20104',
  'value' => 'a:1:{i:0;s:47:"field.field.localgov_geo.address.postal_address";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:05cea849-c240-4104-9707-0cc9881cedd6',
  'value' => 'a:1:{i:0;s:45:"field.storage.node.localgov_directory_address";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:0d5bee0f-0cf3-4825-a535-b59f9ea48013',
  'value' => 'a:1:{i:0;s:42:"field.storage.media.field_media_audio_file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:117c16b6-4a0f-4339-9e40-7fbf4bc5b453',
  'value' => 'a:1:{i:0;s:39:"field.storage.node.localgov_event_image";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:127b7469-4408-4573-82e5-ceac64309950',
  'value' => 'a:1:{i:0;s:44:"field.storage.media.field_media_oembed_video";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:187f86ab-8c5b-448d-90cd-96cdf8fc3d22',
  'value' => 'a:1:{i:0;s:43:"field.storage.node.localgov_directory_phone";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:27419451-af38-40c0-8212-821d1ffadc91',
  'value' => 'a:1:{i:0;s:37:"field.storage.media.field_media_image";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:2ad54306-14e0-4a93-8fb9-97b5aac2c1bf',
  'value' => 'a:1:{i:0;s:42:"field.storage.node.localgov_event_location";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:2fc286a2-294a-4d63-9fab-83f2499303fd',
  'value' => 'a:1:{i:0;s:47:"field.storage.node.localgov_directory_job_title";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:32e2849f-77cd-4018-8796-37800beb54c0',
  'value' => 'a:1:{i:0;s:41:"field.storage.localgov_geo.postal_address";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:37f4507b-f96f-4c27-90b2-50e90bcf7a4a',
  'value' => 'a:1:{i:0;s:35:"field.storage.localgov_geo.location";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:3da59a11-4ec0-4084-a734-a7e15c074362',
  'value' => 'a:1:{i:0;s:35:"field.storage.localgov_geo.geo_file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:3e825878-5567-4e29-b846-7c624bb2a6f5',
  'value' => 'a:1:{i:0;s:43:"field.storage.node.localgov_directory_files";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:4aad5a9e-3d9f-45d0-96bd-88508a31012b',
  'value' => 'a:1:{i:0;s:40:"field.storage.media.field_media_document";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:4e4b8ec4-4b8a-40e3-a0b7-42ebfbd6f1d9',
  'value' => 'a:1:{i:0;s:42:"field.storage.node.localgov_directory_name";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:5105a991-8638-4e3b-9e82-74c78a22eb26',
  'value' => 'a:1:{i:0;s:51:"field.storage.node.localgov_directory_facets_enable";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:54b5ac09-c800-4aeb-a091-ddd69f57aee3',
  'value' => 'a:1:{i:0;s:34:"field.storage.comment.comment_body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:593846c5-c57b-4caa-84c9-a221d50eb977',
  'value' => 'a:1:{i:0;s:44:"field.storage.node.localgov_event_categories";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:5a782dc2-2cd8-4d69-9b3b-11f49fe89f38',
  'value' => 'a:1:{i:0;s:48:"field.storage.node.localgov_event_call_to_action";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:5b59cd50-9ed2-4467-b78d-6f1da5f458f8',
  'value' => 'a:1:{i:0;s:29:"field.storage.node.field_tags";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:80c84b8b-fadf-4342-814c-b080a21b3914',
  'value' => 'a:1:{i:0;s:35:"field.storage.node.localgov_twitter";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:92c442bb-bc48-4979-8901-512aebb04313',
  'value' => 'a:1:{i:0;s:44:"field.storage.node.field_alternate_reference";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:96d3c6aa-3331-4482-ba05-c95783876bce',
  'value' => 'a:1:{i:0;s:41:"field.storage.node.localgov_email_address";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:987180fb-72f3-4aa4-b470-22e1bb6144d3',
  'value' => 'a:1:{i:0;s:42:"field.storage.node.localgov_event_provider";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:9b3fd605-960b-4c22-adb2-70f1ff163aff',
  'value' => 'a:1:{i:0;s:36:"field.storage.node.localgov_location";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:a29175bb-7e2a-436b-b2fe-0a97451d447e',
  'value' => 'a:1:{i:0;s:30:"field.storage.node.field_image";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:a67dd86a-43a0-4370-b75f-0750d9b0687b',
  'value' => 'a:1:{i:0;s:48:"field.storage.node.localgov_directory_title_sort";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:ad02794b-e0fe-4d0c-ad35-8651430191bd',
  'value' => 'a:1:{i:0;s:33:"field.storage.node.localgov_phone";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:af08b0d1-2212-4837-a72d-5585fcbeffda',
  'value' => 'a:1:{i:0;s:36:"field.storage.node.field_media_image";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:afc11e4a-8005-4386-9cd5-7b8f592928a2',
  'value' => 'a:1:{i:0;s:51:"field.storage.node.localgov_directory_channel_types";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:b3d385e5-642a-40b2-ba44-a9f723c11ea5',
  'value' => 'a:1:{i:0;s:48:"field.storage.node.localgov_proximity_search_cfg";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:bbd44100-8627-434e-8c8b-378781f82766',
  'value' => 'a:1:{i:0;s:32:"field.storage.block_content.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:c0288b99-53f7-4261-8fe4-a014da6aa20d',
  'value' => 'a:1:{i:0;s:23:"field.storage.node.body";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:c55c014e-0daa-47fe-942e-86b015352ff4',
  'value' => 'a:1:{i:0;s:43:"field.storage.node.localgov_directory_notes";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:c671cfd4-5434-41fa-873b-b6752b80ef84',
  'value' => 'a:1:{i:0;s:42:"field.storage.node.localgov_event_locality";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:c6dad20d-ce56-4aa9-b6e3-2ab91605221a',
  'value' => 'a:1:{i:0;s:31:"field.storage.user.user_picture";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:c97267b6-398e-4c7a-bfa0-a8e2406d524a',
  'value' => 'a:1:{i:0;s:39:"field.storage.node.localgov_event_venue";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:cadac30b-5414-4f61-a2fe-9b4334466c49',
  'value' => 'a:1:{i:0;s:38:"field.storage.node.localgov_event_date";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:cf481f7a-5b21-4157-b83f-d73ddef66b84',
  'value' => 'a:1:{i:0;s:51:"field.storage.node.localgov_directory_facets_select";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:d24262ed-00a7-44d8-b124-4ac29af9ac73',
  'value' => 'a:1:{i:0;s:42:"field.storage.media.field_media_video_file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:d485b11b-b280-4216-b87f-19c4cc8cd3af',
  'value' => 'a:1:{i:0;s:45:"field.storage.node.localgov_directory_website";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:d49ea706-d522-4c4c-b934-733e80fc9a1c',
  'value' => 'a:1:{i:0;s:40:"field.storage.localgov_geo.accessibility";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:d74d0c02-adca-4b0a-bd72-a65f30c37bea',
  'value' => 'a:1:{i:0;s:36:"field.storage.node.localgov_facebook";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:e15f7237-4663-41fc-ae91-7d590f170fdb',
  'value' => 'a:1:{i:0;s:46:"field.storage.node.localgov_directory_channels";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:eba86cf4-f724-4209-b6cf-3b70e020b661',
  'value' => 'a:1:{i:0;s:38:"field.storage.localgov_geo.external_id";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:eddc630f-9f88-4e23-960a-2b339ba6b6e4',
  'value' => 'a:1:{i:0;s:39:"field.storage.node.localgov_event_price";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:ede08cae-6b92-442d-a31f-d65a569e7027',
  'value' => 'a:1:{i:0;s:26:"field.storage.node.comment";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:f85f7a02-d138-46bd-9968-adfcb6141dd1',
  'value' => 'a:1:{i:0;s:43:"field.storage.node.localgov_directory_email";}',
))
->values(array(
  'collection' => 'config.entity.key_store.field_storage_config',
  'name' => 'uuid:fbfcfcb7-b6b9-44b9-a764-fce7334da1b9',
  'value' => 'a:1:{i:0;s:51:"field.storage.node.localgov_directory_opening_times";}',
))
->values(array(
  'collection' => 'config.entity.key_store.filter_format',
  'name' => 'uuid:1b61b49d-5b53-415f-8603-056b7e600a76',
  'value' => 'a:1:{i:0;s:24:"filter.format.plain_text";}',
))
->values(array(
  'collection' => 'config.entity.key_store.filter_format',
  'name' => 'uuid:700ad702-3ba2-45e7-9e9d-65a699c29f42',
  'value' => 'a:1:{i:0;s:24:"filter.format.basic_html";}',
))
->values(array(
  'collection' => 'config.entity.key_store.filter_format',
  'name' => 'uuid:75944881-838c-4bb1-a08f-042c43d9b2c3',
  'value' => 'a:1:{i:0;s:23:"filter.format.full_html";}',
))
->values(array(
  'collection' => 'config.entity.key_store.filter_format',
  'name' => 'uuid:7f188e06-a587-4b21-9177-5f16d1235231',
  'value' => 'a:1:{i:0;s:29:"filter.format.restricted_html";}',
))
->values(array(
  'collection' => 'config.entity.key_store.filter_format',
  'name' => 'uuid:ed1bc783-934e-4fea-b392-77e854411e6b',
  'value' => 'a:1:{i:0;s:21:"filter.format.wysiwyg";}',
))
->values(array(
  'collection' => 'config.entity.key_store.geocoder_provider',
  'name' => 'uuid:41045779-17a7-485f-84e3-3a6b85b97aca',
  'value' => 'a:1:{i:0;s:47:"geocoder.geocoder_provider.localgov_default_osm";}',
))
->values(array(
  'collection' => 'config.entity.key_store.geocoder_provider',
  'name' => 'uuid:92e501c2-f16b-4fc0-965b-c40d605bab3d',
  'value' => 'a:1:{i:0;s:31:"geocoder.geocoder_provider.file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.geocoder_provider',
  'name' => 'uuid:ba0c599a-de06-4083-a215-5b8f4401e1a7',
  'value' => 'a:1:{i:0;s:35:"geocoder.geocoder_provider.gpx_file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.geocoder_provider',
  'name' => 'uuid:bdf25e2e-d96b-4857-8489-a697d01a38d6',
  'value' => 'a:1:{i:0;s:35:"geocoder.geocoder_provider.kml_file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.geocoder_provider',
  'name' => 'uuid:f7ab62af-8edf-4a5d-8f46-40579d7b42e3',
  'value' => 'a:1:{i:0;s:39:"geocoder.geocoder_provider.geojson_file";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:018637c5-9598-4cc4-ad5f-ad381ed7fcf2',
  'value' => 'a:1:{i:0;s:25:"image.style.large_21_9_2x";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:07729bc9-fa16-4f53-aebe-33360619314c',
  'value' => 'a:1:{i:0;s:22:"image.style.medium_8_7";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:1017be4a-671b-439c-bb3d-dd54143bf44b',
  'value' => 'a:1:{i:0;s:43:"image.style.geofield_map_default_icon_style";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:14eb5a07-37ed-41d9-b5c6-3fff0e79bed1',
  'value' => 'a:1:{i:0;s:27:"image.style.manual_8_7_crop";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:1f923e63-8064-444f-927d-cdcc00124f51',
  'value' => 'a:1:{i:0;s:27:"image.style.manual_7_3_crop";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:22d9b30a-def3-442a-9dfd-e641be3a287c',
  'value' => 'a:1:{i:0;s:28:"image.style.localgov_248x181";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:23ffcbdf-79ee-4a02-a5a0-2878667ea43f',
  'value' => 'a:1:{i:0;s:25:"image.style.large_28_9_2x";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:284ced4e-4f66-4799-8eda-cac5df1a0207',
  'value' => 'a:1:{i:0;s:22:"image.style.small_21_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:29811fc5-36f8-46b3-9efb-999bd49659e6',
  'value' => 'a:1:{i:0;s:29:"image.style.large_3_2_768x512";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:40a06198-9193-415d-bc1c-15d993f39c1c',
  'value' => 'a:1:{i:0;s:17:"image.style.large";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:46a62189-bec6-4d40-8a10-5876cd23a9d8',
  'value' => 'a:1:{i:0;s:30:"image.style.medium_3_2_600x400";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:479df4e0-e074-4c29-aca9-36fafffae5b1',
  'value' => 'a:1:{i:0;s:24:"image.style.freestyle_sm";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:4c0cc9c6-63b7-4b10-9d31-cbf94b0d3b21',
  'value' => 'a:1:{i:0;s:25:"image.style.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:5aa88c0d-177d-4df0-99e2-59c4e1a830bc',
  'value' => 'a:1:{i:0;s:24:"image.style.square_small";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:5e9486c9-47ff-4f71-9d3b-64774fefdacb',
  'value' => 'a:1:{i:0;s:24:"image.style.freestyle_xl";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:67ba1f34-a7a5-4155-bdbe-f03f708a01ba',
  'value' => 'a:1:{i:0;s:23:"image.style.medium_21_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:6b4d0fc0-0f5c-4736-8b7e-72252ba193ab',
  'value' => 'a:1:{i:0;s:36:"image.style.localgov_newsroom_teaser";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:77c55319-1c7b-446b-bfca-4db6212566ff',
  'value' => 'a:1:{i:0;s:22:"image.style.large_28_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:79a85c7d-05b9-42c9-8b5a-ce011f6b7487',
  'value' => 'a:1:{i:0;s:23:"image.style.medium_28_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:7f2e971b-f334-4949-986a-e3682570a773',
  'value' => 'a:1:{i:0;s:25:"image.style.medium_3_2_2x";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:8b06b347-be6f-4ae2-8dfa-8008b364757e',
  'value' => 'a:1:{i:0;s:28:"image.style.manual_16_9_crop";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:8b97f509-60d4-4b56-b8b0-0368afc2623f',
  'value' => 'a:1:{i:0;s:25:"image.style.square_medium";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:91a785d9-fe0d-4905-a30e-80c7451f7965',
  'value' => 'a:1:{i:0;s:25:"image.style.small_28_9_2x";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:9579c939-68ec-4ea2-b558-464d945fa07d',
  'value' => 'a:1:{i:0;s:23:"image.style.max_650x650";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:9c2c87ce-f946-437f-bd7d-301703ad9bea',
  'value' => 'a:1:{i:0;s:26:"image.style.medium_28_9_2x";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:aa9e7e30-9ea5-44fd-83eb-be50f8f530a9',
  'value' => 'a:1:{i:0;s:24:"image.style.large_3_2_2x";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:ad02a17c-d9eb-4c38-82bc-7dd47c4366e3',
  'value' => 'a:1:{i:0;s:22:"image.style.large_21_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:b48f3593-e82b-4685-8945-26dcb98032ba',
  'value' => 'a:1:{i:0;s:18:"image.style.medium";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:b64747a6-fd87-4569-b16a-b4c7d171e954',
  'value' => 'a:1:{i:0;s:21:"image.style.thumbnail";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:b6a19927-ee68-48ea-b282-ff82361471e5',
  'value' => 'a:1:{i:0;s:16:"image.style.wide";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:bddcd8a8-c973-433d-92b4-a9ac23318d95',
  'value' => 'a:1:{i:0;s:28:"image.style.localgov_535x302";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:c2369ab0-2cb5-4e1b-bb47-bbaf16df1e5c',
  'value' => 'a:1:{i:0;s:25:"image.style.max_1300x1300";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:c38010b5-d3f1-472f-97bc-72e756da0c04',
  'value' => 'a:1:{i:0;s:23:"image.style.max_325x325";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:c4de7465-c204-420d-8d83-998382183c79',
  'value' => 'a:1:{i:0;s:24:"image.style.freestyle_md";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:c685c61d-1a83-4eb4-9b1f-c12f5aea9d89',
  'value' => 'a:1:{i:0;s:26:"image.style.crop_thumbnail";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:cef80839-43a1-4d99-82c7-1a45a8b51ec4',
  'value' => 'a:1:{i:0;s:27:"image.style.manual_3_2_crop";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:d173a1ef-f12b-44ce-8fce-410b42532528',
  'value' => 'a:1:{i:0;s:25:"image.style.max_2600x2600";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:d98ba2f6-107d-49e3-a917-dc1262bc47d3',
  'value' => 'a:1:{i:0;s:30:"image.style.manual_square_crop";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:e1367425-8c53-4fb7-a2ee-2736d7cee53d',
  'value' => 'a:1:{i:0;s:24:"image.style.freestyle_lg";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:e2adf312-d9da-4a19-af2c-c64b296fbd69',
  'value' => 'a:1:{i:0;s:22:"image.style.small_28_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:e82dd00a-a48a-4ce1-becc-382ad55a9be9',
  'value' => 'a:1:{i:0;s:32:"image.style.scale_crop_7_3_large";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:f35aa517-f15e-4107-8a73-368a3f02100c',
  'value' => 'a:1:{i:0;s:24:"image.style.freestyle_xs";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:f8d6516f-dd42-4c8f-b9ef-e20e98f6ee34',
  'value' => 'a:1:{i:0;s:35:"image.style.linkit_result_thumbnail";}',
))
->values(array(
  'collection' => 'config.entity.key_store.image_style',
  'name' => 'uuid:fc1cd225-7474-43a9-9d8a-4b6b65a21108',
  'value' => 'a:1:{i:0;s:24:"image.style.square_large";}',
))
->values(array(
  'collection' => 'config.entity.key_store.linkit_profile',
  'name' => 'uuid:462b8139-b04e-453f-94c2-5170f33f8d73',
  'value' => 'a:1:{i:0;s:29:"linkit.linkit_profile.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.localgov_geo_type',
  'name' => 'uuid:e5765239-48fc-45ee-b1de-aa4a8baf1009',
  'value' => 'a:1:{i:0;s:38:"localgov_geo.localgov_geo_type.address";}',
))
->values(array(
  'collection' => 'config.entity.key_store.localgov_geo_type',
  'name' => 'uuid:f6ae3d2f-15d7-4b4c-a61e-c55efd6ce4d1',
  'value' => 'a:1:{i:0;s:35:"localgov_geo.localgov_geo_type.area";}',
))
->values(array(
  'collection' => 'config.entity.key_store.media_type',
  'name' => 'uuid:1cf02f1d-6be6-42a6-9c25-68f84cea7fd9',
  'value' => 'a:1:{i:0;s:19:"media.type.document";}',
))
->values(array(
  'collection' => 'config.entity.key_store.media_type',
  'name' => 'uuid:7f4efaed-b451-4804-be83-259d59913457',
  'value' => 'a:1:{i:0;s:16:"media.type.video";}',
))
->values(array(
  'collection' => 'config.entity.key_store.media_type',
  'name' => 'uuid:a78a1346-b5d3-41ae-8b9a-c68c449770e1',
  'value' => 'a:1:{i:0;s:16:"media.type.audio";}',
))
->values(array(
  'collection' => 'config.entity.key_store.media_type',
  'name' => 'uuid:d86547c2-91ba-435b-b927-7b7b40aea91e',
  'value' => 'a:1:{i:0;s:23:"media.type.remote_video";}',
))
->values(array(
  'collection' => 'config.entity.key_store.media_type',
  'name' => 'uuid:fa1b66d3-e584-4e86-b77f-35ecb4c83bcf',
  'value' => 'a:1:{i:0;s:16:"media.type.image";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:1e81ee85-417f-420a-86f8-129d45432ef0',
  'value' => 'a:1:{i:0;s:19:"system.menu.account";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:41f8df0f-60b1-4aa6-9efc-679e4ce18813',
  'value' => 'a:1:{i:0;s:18:"system.menu.footer";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:7fb6b202-5930-44ac-8a2c-28ebfc32d179',
  'value' => 'a:1:{i:0;s:16:"system.menu.main";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:ac1c182e-2e0e-4e9a-b36a-ea22d7a0f3d9',
  'value' => 'a:1:{i:0;s:17:"system.menu.admin";}',
))
->values(array(
  'collection' => 'config.entity.key_store.menu',
  'name' => 'uuid:dfaabd23-d856-4497-96c0-ba9a753daa3e',
  'value' => 'a:1:{i:0;s:17:"system.menu.tools";}',
))
->values(array(
  'collection' => 'config.entity.key_store.node_type',
  'name' => 'uuid:47a440b0-99e5-4772-95ce-b587349ab9c7',
  'value' => 'a:1:{i:0;s:17:"node.type.article";}',
))
->values(array(
  'collection' => 'config.entity.key_store.node_type',
  'name' => 'uuid:c5c7e553-ad74-489c-a2d1-72e3a495554d',
  'value' => 'a:1:{i:0;s:28:"node.type.localgov_directory";}',
))
->values(array(
  'collection' => 'config.entity.key_store.node_type',
  'name' => 'uuid:ccb62b0c-20b0-4f42-9db0-4866cba4a57a',
  'value' => 'a:1:{i:0;s:14:"node.type.test";}',
))
->values(array(
  'collection' => 'config.entity.key_store.node_type',
  'name' => 'uuid:d7a8ce14-d123-4d29-8cb2-e6f33518d3f7',
  'value' => 'a:1:{i:0;s:36:"node.type.localgov_directories_venue";}',
))
->values(array(
  'collection' => 'config.entity.key_store.node_type',
  'name' => 'uuid:db00203f-6aef-49c7-ac28-3b3d77c77927',
  'value' => 'a:1:{i:0;s:24:"node.type.localgov_event";}',
))
->values(array(
  'collection' => 'config.entity.key_store.node_type',
  'name' => 'uuid:fe2dfe69-088d-4d1d-a41b-dc637d6dc1da',
  'value' => 'a:1:{i:0;s:14:"node.type.page";}',
))
->values(array(
  'collection' => 'config.entity.key_store.pathauto_pattern',
  'name' => 'status:1',
  'value' => 'a:3:{i:0;s:43:"pathauto.pattern.localgov_directory_channel";i:1;s:43:"pathauto.pattern.localgov_directories_venue";i:2;s:31:"pathauto.pattern.localgov_event";}',
))
->values(array(
  'collection' => 'config.entity.key_store.pathauto_pattern',
  'name' => 'type:canonical_entities:node',
  'value' => 'a:3:{i:0;s:43:"pathauto.pattern.localgov_directory_channel";i:1;s:43:"pathauto.pattern.localgov_directories_venue";i:2;s:31:"pathauto.pattern.localgov_event";}',
))
->values(array(
  'collection' => 'config.entity.key_store.pathauto_pattern',
  'name' => 'uuid:6f07a8d4-1d2a-4ade-9085-eca0582694b9',
  'value' => 'a:1:{i:0;s:43:"pathauto.pattern.localgov_directories_venue";}',
))
->values(array(
  'collection' => 'config.entity.key_store.pathauto_pattern',
  'name' => 'uuid:74933d70-d6f9-455e-bbe3-0784cd145556',
  'value' => 'a:1:{i:0;s:43:"pathauto.pattern.localgov_directory_channel";}',
))
->values(array(
  'collection' => 'config.entity.key_store.pathauto_pattern',
  'name' => 'uuid:aa2043f2-fd6e-4037-9a71-1238de062ddd',
  'value' => 'a:1:{i:0;s:31:"pathauto.pattern.localgov_event";}',
))
->values(array(
  'collection' => 'config.entity.key_store.responsive_image_style',
  'name' => 'uuid:2a2ed215-3279-4885-bcf0-9a45cd565d2b',
  'value' => 'a:1:{i:0;s:44:"responsive_image.styles.freestyle_responsive";}',
))
->values(array(
  'collection' => 'config.entity.key_store.responsive_image_style',
  'name' => 'uuid:4cccaa37-8f07-41a7-876e-83a5ca44381a',
  'value' => 'a:1:{i:0;s:33:"responsive_image.styles.3_2_image";}',
))
->values(array(
  'collection' => 'config.entity.key_store.responsive_image_style',
  'name' => 'uuid:5cffd3ef-5656-4446-b200-b771d8076568',
  'value' => 'a:1:{i:0;s:28:"responsive_image.styles.wide";}',
))
->values(array(
  'collection' => 'config.entity.key_store.responsive_image_style',
  'name' => 'uuid:66cd315d-ee5c-4417-b2b6-ec05c51854a5',
  'value' => 'a:1:{i:0;s:30:"responsive_image.styles.square";}',
))
->values(array(
  'collection' => 'config.entity.key_store.responsive_image_style',
  'name' => 'uuid:80462712-3cdf-4ee2-a43f-16de607cc33a',
  'value' => 'a:1:{i:0;s:35:"responsive_image.styles.banner_28_9";}',
))
->values(array(
  'collection' => 'config.entity.key_store.responsive_image_style',
  'name' => 'uuid:8eb79e19-da57-4bd3-8304-4e0b5a147276',
  'value' => 'a:1:{i:0;s:30:"responsive_image.styles.narrow";}',
))
->values(array(
  'collection' => 'config.entity.key_store.responsive_image_style',
  'name' => 'uuid:a7bd6267-08de-408c-bd69-bbb936c16fa2',
  'value' => 'a:1:{i:0;s:38:"responsive_image.styles.hero_or_banner";}',
))
->values(array(
  'collection' => 'config.entity.key_store.responsive_image_style',
  'name' => 'uuid:c22a954d-f1a8-4fbd-b463-771de9110d2b',
  'value' => 'a:1:{i:0;s:50:"responsive_image.styles.localgov_newsroom_featured";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:269374ca-fb01-435b-97ae-ff89fabbfa53',
  'value' => 'a:1:{i:0;s:51:"search_api.index.localgov_directories_index_default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_index',
  'name' => 'uuid:f2269b5f-fc09-461c-be8d-9611b23ad504',
  'value' => 'a:1:{i:0;s:32:"search_api.index.localgov_events";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_api_server',
  'name' => 'uuid:036fd6e8-63e0-4728-aa2d-249b2c76d243',
  'value' => 'a:1:{i:0;s:33:"search_api.server.localgov_events";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_page',
  'name' => 'uuid:c19e49ac-940f-48bd-83bd-d72b0cd74838',
  'value' => 'a:1:{i:0;s:23:"search.page.node_search";}',
))
->values(array(
  'collection' => 'config.entity.key_store.search_page',
  'name' => 'uuid:eda7f3cc-2e16-4ca0-b929-e57bbd0359d8',
  'value' => 'a:1:{i:0;s:23:"search.page.user_search";}',
))
->values(array(
  'collection' => 'config.entity.key_store.shortcut_set',
  'name' => 'uuid:1a128911-517c-42ed-988e-af88e4375598',
  'value' => 'a:1:{i:0;s:20:"shortcut.set.default";}',
))
->values(array(
  'collection' => 'config.entity.key_store.taxonomy_vocabulary',
  'name' => 'uuid:0b0c8600-8503-4953-975e-1e6109e41ad3',
  'value' => 'a:1:{i:0;s:43:"taxonomy.vocabulary.localgov_event_category";}',
))
->values(array(
  'collection' => 'config.entity.key_store.taxonomy_vocabulary',
  'name' => 'uuid:6df0fac2-a521-4f73-911a-4fd66295ad61',
  'value' => 'a:1:{i:0;s:43:"taxonomy.vocabulary.localgov_event_locality";}',
))
->values(array(
  'collection' => 'config.entity.key_store.taxonomy_vocabulary',
  'name' => 'uuid:84b9fdcc-13b7-4215-a8df-2da8728bdcfd',
  'value' => 'a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}',
))
->values(array(
  'collection' => 'config.entity.key_store.taxonomy_vocabulary',
  'name' => 'uuid:ef2a62db-af26-43f3-819e-096245dfaa93',
  'value' => 'a:1:{i:0;s:40:"taxonomy.vocabulary.localgov_event_price";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:block.admin_display',
  'value' => 'a:1:{i:0;s:22:"tour.tour.block-layout";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.search_api_index.add_form',
  'value' => 'a:1:{i:0;s:31:"tour.tour.search-api-index-form";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.search_api_index.canonical',
  'value' => 'a:1:{i:0;s:26:"tour.tour.search-api-index";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.search_api_index.edit_form',
  'value' => 'a:1:{i:0;s:31:"tour.tour.search-api-index-form";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.search_api_index.fields',
  'value' => 'a:1:{i:0;s:33:"tour.tour.search-api-index-fields";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.search_api_index.processors',
  'value' => 'a:1:{i:0;s:37:"tour.tour.search-api-index-processors";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.search_api_server.add_form',
  'value' => 'a:1:{i:0;s:32:"tour.tour.search-api-server-form";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.search_api_server.canonical',
  'value' => 'a:1:{i:0;s:27:"tour.tour.search-api-server";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.search_api_server.edit_form',
  'value' => 'a:1:{i:0;s:32:"tour.tour.search-api-server-form";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.view.edit_display_form',
  'value' => 'a:1:{i:0;s:18:"tour.tour.views-ui";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'routes.*.route_name:entity.view.edit_form',
  'value' => 'a:1:{i:0;s:18:"tour.tour.views-ui";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'uuid:5ff90830-b991-42b7-93d1-bf6f37888330',
  'value' => 'a:1:{i:0;s:27:"tour.tour.search-api-server";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'uuid:68fde9cc-8d90-4e6e-88a1-19869007593e',
  'value' => 'a:1:{i:0;s:31:"tour.tour.search-api-index-form";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'uuid:9ab83573-c98e-4df6-a562-30ef8bb16e17',
  'value' => 'a:1:{i:0;s:22:"tour.tour.block-layout";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'uuid:a1aa38cc-d015-4128-a180-882326419ca8',
  'value' => 'a:1:{i:0;s:37:"tour.tour.search-api-index-processors";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'uuid:acf9bbcf-fc66-448d-b20c-027cb841f99a',
  'value' => 'a:1:{i:0;s:26:"tour.tour.search-api-index";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'uuid:bf4fc1d1-41ac-49b2-8d22-e34f3a6bf5d9',
  'value' => 'a:1:{i:0;s:18:"tour.tour.views-ui";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'uuid:d4964658-6d4b-4ed0-a887-1177fa51c1cf',
  'value' => 'a:1:{i:0;s:33:"tour.tour.search-api-index-fields";}',
))
->values(array(
  'collection' => 'config.entity.key_store.tour',
  'name' => 'uuid:e387a1e1-6f9a-4e9c-8e14-80fc11f0e0e8',
  'value' => 'a:1:{i:0;s:32:"tour.tour.search-api-server-form";}',
))
->values(array(
  'collection' => 'config.entity.key_store.user_role',
  'name' => 'uuid:1e21d688-0ce4-4383-ac54-cf36cc6094f0',
  'value' => 'a:1:{i:0;s:24:"user.role.content_editor";}',
))
->values(array(
  'collection' => 'config.entity.key_store.user_role',
  'name' => 'uuid:8afec650-295d-4112-a86f-03b2aca774c1',
  'value' => 'a:1:{i:0;s:19:"user.role.anonymous";}',
))
->values(array(
  'collection' => 'config.entity.key_store.user_role',
  'name' => 'uuid:92046314-fe87-42fc-87b9-468b9dc61b59',
  'value' => 'a:1:{i:0;s:23:"user.role.authenticated";}',
))
->values(array(
  'collection' => 'config.entity.key_store.user_role',
  'name' => 'uuid:fcb87241-6a39-4701-80ce-e2dad89a74a2',
  'value' => 'a:1:{i:0;s:23:"user.role.administrator";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:092f1099-0c27-4585-a5be-3bf97a94b942',
  'value' => 'a:1:{i:0;s:20:"views.view.who_s_new";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:0cfeb7bc-f30c-4eae-aeda-5b3089dd2e0d',
  'value' => 'a:1:{i:0;s:18:"views.view.content";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:24572f97-9302-4c32-b828-b7c80a871bda',
  'value' => 'a:1:{i:0;s:33:"views.view.localgov_events_search";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:26bdcc8e-091f-472b-9ccb-06c6d73c5c6e',
  'value' => 'a:1:{i:0;s:37:"views.view.localgov_directory_channel";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:2be72e10-be94-4177-8e9f-2682aed6aa39',
  'value' => 'a:1:{i:0;s:23:"views.view.who_s_online";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:3bf1a4e0-618d-4f52-a1ee-67aef466ea00',
  'value' => 'a:1:{i:0;s:18:"views.view.comment";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:47633682-00ab-4dae-a4c9-117c5b3db267',
  'value' => 'a:1:{i:0;s:19:"views.view.glossary";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:495a5ebb-b92c-4b41-b6a5-d9ad6e2abba1',
  'value' => 'a:1:{i:0;s:16:"views.view.files";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:496bd9df-282a-4c32-8c55-3492e02198ba',
  'value' => 'a:1:{i:0;s:25:"views.view.content_recent";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:677471ae-5812-4ef5-89b4-24c4566e9453',
  'value' => 'a:1:{i:0;s:34:"views.view.localgov_events_listing";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:8c6d48fa-5ef0-4ee5-925f-c29f96e63fd9',
  'value' => 'a:1:{i:0;s:18:"views.view.archive";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:930ce418-8e21-4fc0-af93-4e5c717dbf36',
  'value' => 'a:1:{i:0;s:26:"views.view.comments_recent";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:accd6b89-7cad-47bf-b77f-d79916509e7a',
  'value' => 'a:1:{i:0;s:20:"views.view.frontpage";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:b0524b7d-6c03-421d-ba50-517e9d4bce91',
  'value' => 'a:1:{i:0;s:28:"views.view.user_admin_people";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:ba7c1c4f-713f-40fd-a09b-6fb6c7df04f1',
  'value' => 'a:1:{i:0;s:24:"views.view.block_content";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:beac4130-2946-4f71-bd4e-7b8d8ec567a3',
  'value' => 'a:1:{i:0;s:24:"views.view.media_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:c4289462-149b-49c8-8003-9d7700c1c79a',
  'value' => 'a:1:{i:0;s:16:"views.view.media";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:cc010f96-76cd-4da3-8368-9bdb8898ecb6',
  'value' => 'a:1:{i:0;s:19:"views.view.watchdog";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:ed0a59e9-963a-4852-ab1e-7632a3008d45',
  'value' => 'a:1:{i:0;s:31:"views.view.localgov_geo_library";}',
))
->values(array(
  'collection' => 'config.entity.key_store.view',
  'name' => 'uuid:ffe53f4a-2b4a-4231-8beb-10c449d11617',
  'value' => 'a:1:{i:0;s:24:"views.view.taxonomy_term";}',
))
->values(array(
  'collection' => 'entity.definitions.bundle_field_map',
  'name' => 'block_content',
  'value' => 'a:1:{s:4:"body";a:2:{s:4:"type";s:17:"text_with_summary";s:7:"bundles";a:1:{s:5:"basic";s:5:"basic";}}}',
))
->values(array(
  'collection' => 'entity.definitions.bundle_field_map',
  'name' => 'comment',
  'value' => 'a:1:{s:12:"comment_body";a:2:{s:4:"type";s:9:"text_long";s:7:"bundles";a:1:{s:7:"comment";s:7:"comment";}}}',
))
->values(array(
  'collection' => 'entity.definitions.bundle_field_map',
  'name' => 'localgov_geo',
  'value' => 'a:5:{s:14:"postal_address";a:2:{s:4:"type";s:7:"address";s:7:"bundles";a:1:{s:7:"address";s:7:"address";}}s:8:"location";a:2:{s:4:"type";s:8:"geofield";s:7:"bundles";a:2:{s:7:"address";s:7:"address";s:4:"area";s:4:"area";}}s:11:"external_id";a:2:{s:4:"type";s:6:"string";s:7:"bundles";a:2:{s:7:"address";s:7:"address";s:4:"area";s:4:"area";}}s:13:"accessibility";a:2:{s:4:"type";s:9:"text_long";s:7:"bundles";a:1:{s:7:"address";s:7:"address";}}s:8:"geo_file";a:2:{s:4:"type";s:4:"file";s:7:"bundles";a:1:{s:4:"area";s:4:"area";}}}',
))
->values(array(
  'collection' => 'entity.definitions.bundle_field_map',
  'name' => 'media',
  'value' => 'a:5:{s:22:"field_media_audio_file";a:2:{s:4:"type";s:4:"file";s:7:"bundles";a:1:{s:5:"audio";s:5:"audio";}}s:20:"field_media_document";a:2:{s:4:"type";s:4:"file";s:7:"bundles";a:1:{s:8:"document";s:8:"document";}}s:17:"field_media_image";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:5:"image";s:5:"image";}}s:24:"field_media_oembed_video";a:2:{s:4:"type";s:6:"string";s:7:"bundles";a:1:{s:12:"remote_video";s:12:"remote_video";}}s:22:"field_media_video_file";a:2:{s:4:"type";s:4:"file";s:7:"bundles";a:1:{s:5:"video";s:5:"video";}}}',
))
->values(array(
  'collection' => 'entity.definitions.bundle_field_map',
  'name' => 'node',
  'value' => 'a:27:{s:11:"field_image";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:7:"comment";a:2:{s:4:"type";s:7:"comment";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:10:"field_tags";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:4:"body";a:2:{s:4:"type";s:17:"text_with_summary";s:7:"bundles";a:5:{s:4:"page";s:4:"page";s:7:"article";s:7:"article";s:18:"localgov_directory";s:18:"localgov_directory";s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";s:14:"localgov_event";s:14:"localgov_event";}}s:32:"localgov_directory_facets_enable";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:18:"localgov_directory";s:18:"localgov_directory";}}s:32:"localgov_directory_channel_types";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:18:"localgov_directory";s:18:"localgov_directory";}}s:17:"localgov_location";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:26:"localgov_directory_website";a:2:{s:4:"type";s:4:"link";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:29:"localgov_directory_title_sort";a:2:{s:4:"type";s:6:"string";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:23:"localgov_directory_name";a:2:{s:4:"type";s:6:"string";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:28:"localgov_directory_job_title";a:2:{s:4:"type";s:6:"string";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:24:"localgov_directory_files";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:32:"localgov_directory_facets_select";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:24:"localgov_directory_email";a:2:{s:4:"type";s:5:"email";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:27:"localgov_directory_channels";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:24:"localgov_directory_phone";a:2:{s:4:"type";s:9:"telephone";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:32:"localgov_directory_opening_times";a:2:{s:4:"type";s:9:"text_long";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:24:"localgov_directory_notes";a:2:{s:4:"type";s:9:"text_long";s:7:"bundles";a:1:{s:26:"localgov_directories_venue";s:26:"localgov_directories_venue";}}s:23:"localgov_event_location";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:14:"localgov_event";s:14:"localgov_event";}}s:20:"localgov_event_image";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:14:"localgov_event";s:14:"localgov_event";}}s:19:"localgov_event_date";a:2:{s:4:"type";s:10:"date_recur";s:7:"bundles";a:1:{s:14:"localgov_event";s:14:"localgov_event";}}s:29:"localgov_event_call_to_action";a:2:{s:4:"type";s:4:"link";s:7:"bundles";a:1:{s:14:"localgov_event";s:14:"localgov_event";}}s:25:"localgov_event_categories";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:14:"localgov_event";s:14:"localgov_event";}}s:23:"localgov_event_locality";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:14:"localgov_event";s:14:"localgov_event";}}s:20:"localgov_event_price";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:14:"localgov_event";s:14:"localgov_event";}}s:20:"localgov_event_venue";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:14:"localgov_event";s:14:"localgov_event";}}s:25:"field_alternate_reference";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:4:"test";s:4:"test";}}}',
))
->values(array(
  'collection' => 'entity.definitions.bundle_field_map',
  'name' => 'user',
  'value' => 'a:1:{s:12:"user_picture";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:4:"user";s:4:"user";}}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'action.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":43:{s:5:" * id";s:6:"action";s:8:" * class";s:27:"Drupal\system\Entity\Action";s:11:" * provider";s:6:"system";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:27:"Drupal\system\Entity\Action";s:11:" * handlers";a:2:{s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:18:"administer actions";s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"Action";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Actions";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"action";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"actions";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:13:"@count action";s:6:"plural";s:14:"@count actions";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:18:"config:action_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"type";i:3;s:6:"plugin";i:4;s:13:"configuration";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'base_field_override.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":43:{s:5:" * id";s:19:"base_field_override";s:8:" * class";s:42:"Drupal\Core\Field\Entity\BaseFieldOverride";s:11:" * provider";s:4:"core";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:42:"Drupal\Core\Field\Entity\BaseFieldOverride";s:11:" * handlers";a:2:{s:7:"storage";s:42:"Drupal\Core\Field\BaseFieldOverrideStorage";s:6:"access";s:55:"Drupal\Core\Field\BaseFieldOverrideAccessControlHandler";}s:19:" * admin_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Base field override";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:31:"config:base_field_override_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:19:"base_field_override";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'block.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":43:{s:5:" * id";s:5:"block";s:8:" * class";s:25:"Drupal\block\Entity\Block";s:11:" * provider";s:5:"block";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:25:"Drupal\block\Entity\Block";s:11:" * handlers";a:5:{s:6:"access";s:38:"Drupal\block\BlockAccessControlHandler";s:12:"view_builder";s:29:"Drupal\block\BlockViewBuilder";s:12:"list_builder";s:29:"Drupal\block\BlockListBuilder";s:4:"form";a:2:{s:7:"default";s:22:"Drupal\block\BlockForm";s:6:"delete";s:33:"Drupal\block\Form\BlockDeleteForm";}s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:17:"administer blocks";s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:4:{s:11:"delete-form";s:44:"/admin/structure/block/manage/{block}/delete";s:9:"edit-form";s:37:"/admin/structure/block/manage/{block}";s:6:"enable";s:44:"/admin/structure/block/manage/{block}/enable";s:7:"disable";s:45:"/admin/structure/block/manage/{block}/disable";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"Block";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"Blocks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:5:"block";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:6:"blocks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:12:"@count block";s:6:"plural";s:13:"@count blocks";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:17:"config:block_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";N;s:14:" * lookup_keys";a:2:{i:0;s:5:"theme";i:1;s:4:"uuid";}s:16:" * config_export";a:8:{i:0;s:2:"id";i:1;s:5:"theme";i:2;s:6:"region";i:3;s:6:"weight";i:4;s:8:"provider";i:5;s:6:"plugin";i:6;s:8:"settings";i:7;s:10:"visibility";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'block_content.entity_type',
  'value' => 'O:36:"Drupal\Core\Entity\ContentEntityType":40:{s:5:" * id";s:13:"block_content";s:8:" * class";s:40:"Drupal\block_content\Entity\BlockContent";s:11:" * provider";s:13:"block_content";s:15:" * static_cache";b:1;s:15:" * render_cache";b:0;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:6:"bundle";s:4:"type";s:5:"label";s:4:"info";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:40:"Drupal\block_content\Entity\BlockContent";s:11:" * handlers";a:7:{s:7:"storage";s:46:"Drupal\Core\Entity\Sql\SqlContentEntityStorage";s:6:"access";s:53:"Drupal\block_content\BlockContentAccessControlHandler";s:12:"list_builder";s:44:"Drupal\block_content\BlockContentListBuilder";s:12:"view_builder";s:44:"Drupal\block_content\BlockContentViewBuilder";s:10:"views_data";s:42:"Drupal\block_content\BlockContentViewsData";s:4:"form";a:4:{s:3:"add";s:37:"Drupal\block_content\BlockContentForm";s:4:"edit";s:37:"Drupal\block_content\BlockContentForm";s:6:"delete";s:48:"Drupal\block_content\Form\BlockContentDeleteForm";s:7:"default";s:37:"Drupal\block_content\BlockContentForm";}s:11:"translation";s:51:"Drupal\block_content\BlockContentTranslationHandler";}s:19:" * admin_permission";s:17:"administer blocks";s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:5:{s:9:"canonical";s:22:"/block/{block_content}";s:11:"delete-form";s:29:"/block/{block_content}/delete";s:9:"edit-form";s:22:"/block/{block_content}";s:10:"collection";s:36:"/admin/structure/block/block-content";s:6:"create";s:6:"/block";}s:21:" * bundle_entity_type";s:18:"block_content_type";s:12:" * bundle_of";N;s:15:" * bundle_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:17:"Custom block type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:13:" * base_table";s:13:"block_content";s:22:" * revision_data_table";s:28:"block_content_field_revision";s:17:" * revision_table";s:22:"block_content_revision";s:13:" * data_table";s:24:"block_content_field_data";s:11:" * internal";b:0;s:15:" * translatable";b:1;s:19:" * show_revision_ui";b:1;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Custom block";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Custom blocks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"custom block";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"custom blocks";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:19:"@count custom block";s:6:"plural";s:20:"@count custom blocks";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:7:"content";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";s:35:"entity.block_content_type.edit_form";s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:18:"block_content_list";}s:14:" * constraints";a:2:{s:26:"EntityUntranslatableFields";N;s:25:"BlockContentEntityChanged";N;}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:25:" * revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:12:"revision_log";s:16:"revision_default";s:16:"revision_default";}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'block_content.field_storage_definitions',
  'value' => 'a:16:{s:2:"id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:15:"Custom block ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:20:"The custom block ID.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:2:"id";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:" * fieldDefinition";r:2;}s:7:" * type";s:7:"integer";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:4:"UUID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:22:"The custom block UUID.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:40;}s:7:" * type";s:4:"uuid";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:11:"Revision ID";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"The revision ID.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:" * fieldDefinition";r:77;}s:7:" * type";s:7:"integer";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:8:"Language";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:31:"The custom block language code.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:" * fieldDefinition";r:115;}s:7:" * type";s:8:"language";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"type";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:9:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:10:"Block type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:15:"The block type.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"type";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:18:"block_content_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:" * fieldDefinition";r:155;}s:7:" * type";s:16:"entity_reference";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:16:"revision_created";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:20:"Revision create time";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:47:"The time that the current revision was created.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:" * fieldDefinition";r:193;}s:7:" * type";s:7:"created";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:13:"revision_user";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:8:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Revision user";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:50:"The user ID of the author of the current revision.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:" * fieldDefinition";r:223;}s:7:" * type";s:16:"entity_reference";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:12:"revision_log";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:20:"Revision log message";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:54:"The log entry explaining the changes in this revision.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:12:"revision_log";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:260;}s:7:" * type";s:11:"string_long";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:6:"status";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:9:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:9:"Published";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:6:"status";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:302;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"info";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:12:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:17:"Block description";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:34:"A brief description of your block.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:11:"constraints";a:1:{s:11:"UniqueField";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"info";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:" * fieldDefinition";r:341;}s:7:" * type";s:6:"string";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:7:"changed";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:9:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Changed";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:47:"The time that the custom block was last edited.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:" * fieldDefinition";r:386;}s:7:" * type";s:7:"changed";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:8:"reusable";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:8:"Reusable";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:52:"A boolean indicating whether this block is reusable.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"translatable";b:0;s:12:"revisionable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:8:"reusable";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:417;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:19:"Default translation";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:58:"A flag indicating whether this is the default translation.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:460;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:11:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"Default revision";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:503;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\Core\Field\BaseFieldDefinition":5:{s:13:" * definition";a:10:{s:5:"label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:29:"Revision translation affected";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:11:"description";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:" * itemDefinition";O:51:"Drupal\Core\Field\TypedData\FieldItemDataDefinition":2:{s:13:" * definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:2:"On";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:9:"off_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Off";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}}}s:18:" * fieldDefinition";r:545;}s:7:" * type";s:7:"boolean";s:9:" * schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:" * indexes";a:0:{}}s:4:"body";O:38:"Drupal\field\Entity\FieldStorageConfig":30:{s:15:" * entityTypeId";s:20:"field_storage_config";s:15:" * enforceIsNew";b:1;s:12:" * typedData";N;s:16:" * cacheContexts";a:0:{}s:12:" * cacheTags";a:0:{}s:14:" * cacheMaxAge";i:-1;s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:13:" * originalId";s:18:"block_content.body";s:9:" * status";b:1;s:7:" * uuid";s:36:"bbd44100-8627-434e-8c8b-378781f82766";s:11:" * langcode";s:2:"en";s:23:" * third_party_settings";a:0:{}s:8:" * _core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:14:" * trustedData";b:1;s:15:" * dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:12:" * isSyncing";b:0;s:5:" * id";s:18:"block_content.body";s:13:" * field_name";s:4:"body";s:14:" * entity_type";s:13:"block_content";s:7:" * type";s:17:"text_with_summary";s:9:" * module";s:4:"text";s:11:" * settings";a:0:{}s:14:" * cardinality";i:1;s:15:" * translatable";b:1;s:9:" * locked";b:0;s:25:" * persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:" * indexes";a:0:{}s:10:" * deleted";b:0;}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'block_content_type.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":43:{s:5:" * id";s:18:"block_content_type";s:8:" * class";s:44:"Drupal\block_content\Entity\BlockContentType";s:11:" * provider";s:13:"block_content";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:44:"Drupal\block_content\Entity\BlockContentType";s:11:" * handlers";a:5:{s:4:"form";a:4:{s:7:"default";s:41:"Drupal\block_content\BlockContentTypeForm";s:3:"add";s:41:"Drupal\block_content\BlockContentTypeForm";s:4:"edit";s:41:"Drupal\block_content\BlockContentTypeForm";s:6:"delete";s:52:"Drupal\block_content\Form\BlockContentTypeDeleteForm";}s:14:"route_provider";a:2:{s:4:"html";s:49:"Drupal\Core\Entity\Routing\AdminHtmlRouteProvider";s:11:"permissions";s:58:"Drupal\user\Entity\EntityPermissionsRouteProviderWithCheck";}s:12:"list_builder";s:48:"Drupal\block_content\BlockContentTypeListBuilder";s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:17:"administer blocks";s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:4:{s:11:"delete-form";s:71:"/admin/structure/block/block-content/manage/{block_content_type}/delete";s:9:"edit-form";s:64:"/admin/structure/block/block-content/manage/{block_content_type}";s:23:"entity-permissions-form";s:76:"/admin/structure/block/block-content/manage/{block_content_type}/permissions";s:10:"collection";s:42:"/admin/structure/block/block-content/types";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";s:13:"block_content";s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:17:"Custom block type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:20:"Custom block library";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:17:"custom block type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:18:"custom block types";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:24:"@count custom block type";s:6:"plural";s:25:"@count custom block types";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:30:"config:block_content_type_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:4:"type";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:8:"revision";i:3;s:11:"description";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'comment.entity_type',
  'value' => 'O:36:"Drupal\Core\Entity\ContentEntityType":40:{s:5:" * id";s:7:"comment";s:8:" * class";s:29:"Drupal\comment\Entity\Comment";s:11:" * provider";s:7:"comment";s:15:" * static_cache";b:1;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:10:{s:2:"id";s:3:"cid";s:6:"bundle";s:12:"comment_type";s:5:"label";s:7:"subject";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:5:"owner";s:3:"uid";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:29:"Drupal\comment\Entity\Comment";s:11:" * handlers";a:8:{s:7:"storage";s:29:"Drupal\comment\CommentStorage";s:14:"storage_schema";s:35:"Drupal\comment\CommentStorageSchema";s:6:"access";s:42:"Drupal\comment\CommentAccessControlHandler";s:12:"list_builder";s:36:"Drupal\Core\Entity\EntityListBuilder";s:12:"view_builder";s:33:"Drupal\comment\CommentViewBuilder";s:10:"views_data";s:31:"Drupal\comment\CommentViewsData";s:4:"form";a:2:{s:7:"default";s:26:"Drupal\comment\CommentForm";s:6:"delete";s:30:"Drupal\comment\Form\DeleteForm";}s:11:"translation";s:40:"Drupal\comment\CommentTranslationHandler";}s:19:" * admin_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:5:{s:9:"canonical";s:18:"/comment/{comment}";s:11:"delete-form";s:25:"/comment/{comment}/delete";s:20:"delete-multiple-form";s:29:"/admin/content/comment/delete";s:9:"edit-form";s:23:"/comment/{comment}/edit";s:6:"create";s:8:"/comment";}s:21:" * bundle_entity_type";s:12:"comment_type";s:12:" * bundle_of";N;s:15:" * bundle_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Comment type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:13:" * base_table";s:7:"comment";s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";s:18:"comment_field_data";s:11:" * internal";b:0;s:15:" * translatable";b:1;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Comment";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"comment";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:8:"comments";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:14:"@count comment";s:6:"plural";s:15:"@count comments";s:7:"context";N;}s:15:" * uri_callback";s:11:"comment_uri";s:8:" * group";s:7:"content";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";s:29:"entity.comment_type.edit_form";s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:12:"comment_list";}s:14:" * constraints";a:3:{s:11:"CommentName";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:25:" * revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'comment.field_storage_definitions',
  'value' => "a:20:{s:3:\"cid\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:10:\"Comment ID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"read-only\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:15:\"The comment ID.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:3:\"cid\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:integer\";s:8:\"settings\";a:6:{s:8:\"unsigned\";b:1;s:4:\"size\";s:6:\"normal\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";}}s:18:\" * fieldDefinition\";r:2;}s:7:\" * type\";s:7:\"integer\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:4:\"size\";s:6:\"normal\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:4:\"uuid\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"UUID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"read-only\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:17:\"The comment UUID.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:4:\"uuid\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:15:\"field_item:uuid\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:128;s:8:\"is_ascii\";b:1;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:40;}s:7:\" * type\";s:4:\"uuid\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:128;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:1:{s:5:\"value\";a:1:{i:0;s:5:\"value\";}}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:8:\"langcode\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:9:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Language\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:7:\"display\";a:2:{s:4:\"view\";a:1:{s:7:\"options\";a:1:{s:6:\"region\";s:6:\"hidden\";}}s:4:\"form\";a:1:{s:7:\"options\";a:2:{s:4:\"type\";s:15:\"language_select\";s:6:\"weight\";i:2;}}}s:12:\"translatable\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:26:\"The comment language code.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:8:\"langcode\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:19:\"field_item:language\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:77;}s:7:\" * type\";s:8:\"language\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:12;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:12:\"comment_type\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:9:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"Comment Type\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"required\";b:1;s:9:\"read-only\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:17:\"The comment type.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:12:\"comment_type\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:27:\"field_item:entity_reference\";s:8:\"settings\";a:3:{s:11:\"target_type\";s:12:\"comment_type\";s:7:\"handler\";s:7:\"default\";s:16:\"handler_settings\";a:0:{}}}s:18:\" * fieldDefinition\";r:116;}s:7:\" * type\";s:16:\"entity_reference\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:9:\"target_id\";a:3:{s:11:\"description\";s:28:\"The ID of the target entity.\";s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:32;}}s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:11:\"unique keys\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:6:\"status\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:10:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:9:\"Published\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"revisionable\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";b:1;}}s:22:\"default_value_callback\";s:47:\"Drupal\\comment\\Entity\\Comment::getDefaultStatus\";s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:6:\"status\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:boolean\";s:8:\"settings\";a:2:{s:8:\"on_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:2:\"On\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"off_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:3:\"Off\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}}s:18:\" * fieldDefinition\";r:154;}s:7:\" * type\";s:7:\"boolean\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:3:\"uid\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:9:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"User ID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:22:\"default_value_callback\";s:52:\"Drupal\\comment\\Entity\\Comment::getDefaultEntityOwner\";s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:34:\"The user ID of the comment author.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:3:\"uid\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:27:\"field_item:entity_reference\";s:8:\"settings\";a:3:{s:11:\"target_type\";s:4:\"user\";s:7:\"handler\";s:7:\"default\";s:16:\"handler_settings\";a:0:{}}}s:18:\" * fieldDefinition\";r:194;}s:7:\" * type\";s:16:\"entity_reference\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:9:\"target_id\";a:3:{s:11:\"description\";s:28:\"The ID of the target entity.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}}s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:11:\"unique keys\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:3:\"pid\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:9:\"Parent ID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:54:\"The parent comment ID if this is a reply to a comment.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:3:\"pid\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:27:\"field_item:entity_reference\";s:8:\"settings\";a:3:{s:11:\"target_type\";s:7:\"comment\";s:7:\"handler\";s:7:\"default\";s:16:\"handler_settings\";a:0:{}}}s:18:\" * fieldDefinition\";r:232;}s:7:\" * type\";s:16:\"entity_reference\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:9:\"target_id\";a:3:{s:11:\"description\";s:28:\"The ID of the target entity.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}}s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:11:\"unique keys\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:9:\"entity_id\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:9:\"Entity ID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:54:\"The ID of the entity of which this comment is a reply.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"required\";b:1;s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:9:\"entity_id\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:27:\"field_item:entity_reference\";s:8:\"settings\";a:3:{s:11:\"target_type\";s:4:\"node\";s:7:\"handler\";s:7:\"default\";s:16:\"handler_settings\";a:0:{}}}s:18:\" * fieldDefinition\";r:268;}s:7:\" * type\";s:16:\"entity_reference\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:9:\"target_id\";a:3:{s:11:\"description\";s:28:\"The ID of the target entity.\";s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}}s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:11:\"unique keys\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:7:\"subject\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Subject\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:7:\"display\";a:1:{s:4:\"form\";a:2:{s:7:\"options\";a:2:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:10;}s:12:\"configurable\";b:1;}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:7:\"subject\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:64;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:305;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:4:\"name\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:9:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"Name\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:26:\"The comment author's name.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";s:0:\"\";}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:4:\"name\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:60;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:342;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:60;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:4:\"mail\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:5:\"Email\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:35:\"The comment author's email address.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:4:\"mail\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:16:\"field_item:email\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:380;}s:7:\" * type\";s:5:\"email\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:254;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:8:\"homepage\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Homepage\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:39:\"The comment author's home page address.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:8:\"homepage\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:14:\"field_item:uri\";s:8:\"settings\";a:2:{s:10:\"max_length\";i:255;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:411;}s:7:\" * type\";s:3:\"uri\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:8:\"hostname\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:9:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Hostname\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:30:\"The comment author's hostname.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:22:\"default_value_callback\";s:49:\"Drupal\\comment\\Entity\\Comment::getDefaultHostname\";s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:8:\"hostname\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:128;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:445;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:7:\"created\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Created\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:38:\"The time that the comment was created.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:7:\"created\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:created\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:481;}s:7:\" * type\";s:7:\"created\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:1:{s:4:\"type\";s:3:\"int\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:7:\"changed\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Changed\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:42:\"The time that the comment was last edited.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:7:\"changed\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:changed\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:511;}s:7:\" * type\";s:7:\"changed\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:1:{s:4:\"type\";s:3:\"int\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:6:\"thread\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"Thread place\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:144:\"The alphadecimal representation of the comment's place in a thread, consisting of a base 36 string prefixed by an integer indicating its length.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:6:\"thread\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:541;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:11:\"entity_type\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:11:\"Entity type\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"required\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:50:\"The entity type to which this comment is attached.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:11:\"entity_type\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:32;s:8:\"is_ascii\";b:1;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:575;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:32;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:10:\"field_name\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:18:\"Comment field name\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"required\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:52:\"The field name through which this comment was added.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:10:\"field_name\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:32;s:8:\"is_ascii\";b:1;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:610;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:13:\"varchar_ascii\";s:6:\"length\";i:32;s:6:\"binary\";b:0;}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:16:\"default_langcode\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:10:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:19:\"Default translation\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:58:\"A flag indicating whether this is the default translation.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:12:\"translatable\";b:1;s:12:\"revisionable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";b:1;}}s:8:\"provider\";s:7:\"comment\";s:10:\"field_name\";s:16:\"default_langcode\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";N;s:13:\"initial_value\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:boolean\";s:8:\"settings\";a:2:{s:8:\"on_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:2:\"On\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"off_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:3:\"Off\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}}s:18:\" * fieldDefinition\";r:645;}s:7:\" * type\";s:7:\"boolean\";s:9:\" * schema\";a:4:{s:7:\"columns\";a:1:{s:5:\"value\";a:2:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";}}s:11:\"unique keys\";a:0:{}s:7:\"indexes\";a:0:{}s:12:\"foreign keys\";a:0:{}}s:10:\" * indexes\";a:0:{}}s:12:\"comment_body\";O:38:\"Drupal\\field\\Entity\\FieldStorageConfig\":30:{s:15:\" * entityTypeId\";s:20:\"field_storage_config\";s:15:\" * enforceIsNew\";b:1;s:12:\" * typedData\";N;s:16:\" * cacheContexts\";a:0:{}s:12:\" * cacheTags\";a:0:{}s:14:\" * cacheMaxAge\";i:-1;s:14:\" * _serviceIds\";a:0:{}s:18:\" * _entityStorages\";a:0:{}s:13:\" * originalId\";s:20:\"comment.comment_body\";s:9:\" * status\";b:1;s:7:\" * uuid\";s:36:\"54b5ac09-c800-4aeb-a091-ddd69f57aee3\";s:11:\" * langcode\";s:2:\"en\";s:23:\" * third_party_settings\";a:0:{}s:8:\" * _core\";a:1:{s:19:\"default_config_hash\";s:43:\"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw\";}s:14:\" * trustedData\";b:1;s:15:\" * dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"comment\";i:1;s:4:\"text\";}}s:12:\" * isSyncing\";b:0;s:5:\" * id\";s:20:\"comment.comment_body\";s:13:\" * field_name\";s:12:\"comment_body\";s:14:\" * entity_type\";s:7:\"comment\";s:7:\" * type\";s:9:\"text_long\";s:9:\" * module\";s:4:\"text\";s:11:\" * settings\";a:0:{}s:14:\" * cardinality\";i:1;s:15:\" * translatable\";b:1;s:9:\" * locked\";b:0;s:25:\" * persist_with_no_fields\";b:1;s:14:\"custom_storage\";b:0;s:10:\" * indexes\";a:0:{}s:10:\" * deleted\";b:0;}}",
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'comment_type.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":43:{s:5:" * id";s:12:"comment_type";s:8:" * class";s:33:"Drupal\comment\Entity\CommentType";s:11:" * provider";s:7:"comment";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:33:"Drupal\comment\Entity\CommentType";s:11:" * handlers";a:5:{s:4:"form";a:4:{s:7:"default";s:30:"Drupal\comment\CommentTypeForm";s:3:"add";s:30:"Drupal\comment\CommentTypeForm";s:4:"edit";s:30:"Drupal\comment\CommentTypeForm";s:6:"delete";s:41:"Drupal\comment\Form\CommentTypeDeleteForm";}s:14:"route_provider";a:1:{s:11:"permissions";s:58:"Drupal\user\Entity\EntityPermissionsRouteProviderWithCheck";}s:12:"list_builder";s:37:"Drupal\comment\CommentTypeListBuilder";s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:24:"administer comment types";s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:5:{s:11:"delete-form";s:53:"/admin/structure/comment/manage/{comment_type}/delete";s:9:"edit-form";s:46:"/admin/structure/comment/manage/{comment_type}";s:8:"add-form";s:34:"/admin/structure/comment/types/add";s:23:"entity-permissions-form";s:58:"/admin/structure/comment/manage/{comment_type}/permissions";s:10:"collection";s:24:"/admin/structure/comment";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";s:7:"comment";s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Comment type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"comment type";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"comment types";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:19:"@count comment type";s:6:"plural";s:20:"@count comment types";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:24:"config:comment_type_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:4:"type";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:21:"target_entity_type_id";i:3;s:11:"description";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'contact_form.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":43:{s:5:" * id";s:12:"contact_form";s:8:" * class";s:33:"Drupal\contact\Entity\ContactForm";s:11:" * provider";s:7:"contact";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:33:"Drupal\contact\Entity\ContactForm";s:11:" * handlers";a:5:{s:6:"access";s:46:"Drupal\contact\ContactFormAccessControlHandler";s:12:"list_builder";s:37:"Drupal\contact\ContactFormListBuilder";s:4:"form";a:3:{s:3:"add";s:34:"Drupal\contact\ContactFormEditForm";s:4:"edit";s:34:"Drupal\contact\ContactFormEditForm";s:6:"delete";s:35:"Drupal\Core\Entity\EntityDeleteForm";}s:14:"route_provider";a:1:{s:11:"permissions";s:58:"Drupal\user\Entity\EntityPermissionsRouteProviderWithCheck";}s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:24:"administer contact forms";s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:5:{s:11:"delete-form";s:53:"/admin/structure/contact/manage/{contact_form}/delete";s:9:"edit-form";s:46:"/admin/structure/contact/manage/{contact_form}";s:23:"entity-permissions-form";s:58:"/admin/structure/contact/manage/{contact_form}/permissions";s:10:"collection";s:24:"/admin/structure/contact";s:9:"canonical";s:23:"/contact/{contact_form}";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";s:15:"contact_message";s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Contact form";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Contact forms";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"contact form";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"contact forms";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:19:"@count contact form";s:6:"plural";s:20:"@count contact forms";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:24:"config:contact_form_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:4:"form";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:7:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:10:"recipients";i:3;s:5:"reply";i:4;s:6:"weight";i:5;s:7:"message";i:6;s:8:"redirect";}s:21:" * mergedConfigExport";a:0:{}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'contact_message.entity_type',
  'value' => 'O:36:"Drupal\Core\Entity\ContentEntityType":40:{s:5:" * id";s:15:"contact_message";s:8:" * class";s:29:"Drupal\contact\Entity\Message";s:11:" * provider";s:7:"contact";s:15:" * static_cache";b:1;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:6:{s:6:"bundle";s:12:"contact_form";s:4:"uuid";s:4:"uuid";s:8:"langcode";s:8:"langcode";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:29:"Drupal\contact\Entity\Message";s:11:" * handlers";a:4:{s:6:"access";s:49:"Drupal\contact\ContactMessageAccessControlHandler";s:7:"storage";s:43:"Drupal\Core\Entity\ContentEntityNullStorage";s:12:"view_builder";s:33:"Drupal\contact\MessageViewBuilder";s:4:"form";a:1:{s:7:"default";s:26:"Drupal\contact\MessageForm";}}s:19:" * admin_permission";s:24:"administer contact forms";s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:0:{}s:21:" * bundle_entity_type";s:12:"contact_form";s:12:" * bundle_of";N;s:15:" * bundle_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:12:"Contact form";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:15:"Contact message";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"Contact messages";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:17:" * label_singular";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:15:"contact message";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:15:" * label_plural";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:16:"contact messages";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:14:" * label_count";a:3:{s:8:"singular";s:22:"@count contact message";s:6:"plural";s:23:"@count contact messages";s:7:"context";N;}s:15:" * uri_callback";N;s:8:" * group";s:7:"content";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:7:"Content";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";s:29:"entity.contact_form.edit_form";s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:20:"contact_message_list";}s:14:" * constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:25:" * revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}',
))
->values(array(
  'collection' => 'entity.definitions.installed',
  'name' => 'contact_message.field_storage_definitions',
  'value' => "a:9:{s:4:\"uuid\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"UUID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"read-only\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:17:\"The message UUID.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"contact\";s:10:\"field_name\";s:4:\"uuid\";s:11:\"entity_type\";s:15:\"contact_message\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:15:\"field_item:uuid\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:128;s:8:\"is_ascii\";b:1;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:2;}s:7:\" * type\";s:4:\"uuid\";s:9:\" * schema\";N;s:10:\" * indexes\";a:0:{}}s:8:\"langcode\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:8:\"Language\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:7:\"display\";a:2:{s:4:\"view\";a:1:{s:7:\"options\";a:1:{s:6:\"region\";s:6:\"hidden\";}}s:4:\"form\";a:1:{s:7:\"options\";a:2:{s:4:\"type\";s:15:\"language_select\";s:6:\"weight\";i:2;}}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:26:\"The message language code.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"contact\";s:10:\"field_name\";s:8:\"langcode\";s:11:\"entity_type\";s:15:\"contact_message\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:19:\"field_item:language\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:28;}s:7:\" * type\";s:8:\"language\";s:9:\" * schema\";N;s:10:\" * indexes\";a:0:{}}s:12:\"contact_form\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:8:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Form ID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"required\";b:1;s:9:\"read-only\";b:1;s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:30:\"The ID of the associated form.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"contact\";s:10:\"field_name\";s:12:\"contact_form\";s:11:\"entity_type\";s:15:\"contact_message\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:27:\"field_item:entity_reference\";s:8:\"settings\";a:3:{s:11:\"target_type\";s:12:\"contact_form\";s:7:\"handler\";s:7:\"default\";s:16:\"handler_settings\";a:0:{}}}s:18:\" * fieldDefinition\";r:58;}s:7:\" * type\";s:16:\"entity_reference\";s:9:\" * schema\";N;s:10:\" * indexes\";a:0:{}}s:4:\"name\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:6:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:17:\"The sender's name\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:59:\"The name of the person that is sending the contact message.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"contact\";s:10:\"field_name\";s:4:\"name\";s:11:\"entity_type\";s:15:\"contact_message\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:85;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";N;s:10:\" * indexes\";a:0:{}}s:4:\"mail\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:6:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:18:\"The sender's email\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:60:\"The email of the person that is sending the contact message.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"contact\";s:10:\"field_name\";s:4:\"mail\";s:11:\"entity_type\";s:15:\"contact_message\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:16:\"field_item:email\";s:8:\"settings\";a:0:{}}s:18:\" * fieldDefinition\";r:110;}s:7:\" * type\";s:5:\"email\";s:9:\" * schema\";N;s:10:\" * indexes\";a:0:{}}s:7:\"subject\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Subject\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:4:\"form\";a:2:{s:7:\"options\";a:2:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:-10;}s:12:\"configurable\";b:1;}}s:8:\"provider\";s:7:\"contact\";s:10:\"field_name\";s:7:\"subject\";s:11:\"entity_type\";s:15:\"contact_message\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:17:\"field_item:string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:100;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:132;}s:7:\" * type\";s:6:\"string\";s:9:\" * schema\";N;s:10:\" * indexes\";a:0:{}}s:7:\"message\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:7:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:7:\"Message\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"required\";b:1;s:7:\"display\";a:2:{s:4:\"form\";a:2:{s:7:\"options\";a:3:{s:4:\"type\";s:15:\"string_textarea\";s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:4:\"rows\";i:12;}}s:12:\"configurable\";b:1;}s:4:\"view\";a:2:{s:7:\"options\";a:3:{s:4:\"type\";s:6:\"string\";s:6:\"weight\";i:0;s:5:\"label\";s:5:\"above\";}s:12:\"configurable\";b:1;}}s:8:\"provider\";s:7:\"contact\";s:10:\"field_name\";s:7:\"message\";s:11:\"entity_type\";s:15:\"contact_message\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:22:\"field_item:string_long\";s:8:\"settings\";a:1:{s:14:\"case_sensitive\";b:0;}}s:18:\" * fieldDefinition\";r:160;}s:7:\" * type\";s:11:\"string_long\";s:9:\" * schema\";N;s:10:\" * indexes\";a:0:{}}s:4:\"copy\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:6:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:4:\"Copy\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:52:\"Whether to send a copy of the message to the sender.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"contact\";s:10:\"field_name\";s:4:\"copy\";s:11:\"entity_type\";s:15:\"contact_message\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition\":2:{s:13:\" * definition\";a:2:{s:4:\"type\";s:18:\"field_item:boolean\";s:8:\"settings\";a:2:{s:8:\"on_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:2:\"On\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:9:\"off_label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:3:\"Off\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}}}s:18:\" * fieldDefinition\";r:194;}s:7:\" * type\";s:7:\"boolean\";s:9:\" * schema\";N;s:10:\" * indexes\";a:0:{}}s:9:\"recipient\";O:37:\"Drupal\\Core\\Field\\BaseFieldDefinition\":5:{s:13:\" * definition\";a:6:{s:5:\"label\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:12:\"Recipient ID\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:11:\"description\";O:48:\"Drupal\\Core\\StringTranslation\\TranslatableMarkup\":3:{s:9:\" * string\";s:59:\"The ID of the recipient user for personal contact messages.\";s:12:\" * arguments\";a:0:{}s:10:\" * options\";a:0:{}}s:8:\"provider\";s:7:\"contact\";s:10:\"field_name\";s:9:\"recipient\";s:11:\"entity_type\";s:15:\"contact_message\";s:6:\"bundle\";N;}s:17:\" * itemDefinition\";O:51:\"Drupal\\Core\\Field\\TypedData\\FieldIt