<?php

namespace Drupal\Tests\localgov_microsites_group\Kernel;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Tests\group\Kernel\GroupKernelTestBase;
use Drupal\group\Entity\Group;
use Drupal\localgov_microsites_group\GroupDefaultContent;
use Drupal\node\Entity\Node;
use Drupal\node\Entity\NodeType;

/**
 * @covers \Drupal\localgov_microsites_group\GroupDefaultContent
 *
 * @group localgov_microsites_group
 */
class GroupDefaultContentTest extends GroupKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'domain',
    'domain_path',
    'entity_reference_revisions',
    'field_formatter_class',
    'field_group',
    'file',
    'image',
    'media',
    'media_library',
    'gnode',
    'groupmedia',
    'group_content_menu',
    'group_sites',
    'layout_discovery',
    'layout_paragraphs',
    'layout_paragraphs_permissions',
    'node',
    'override_node_options',
    'paragraphs',
    'path_alias',
    'replicate',
    'toolbar',
    'tour',
    'user',
    'views',
    'localgov_media',
    'localgov_microsites_group',
    'localgov_sa11y',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Set config that group_sites needs to run tests.
    $this->config('group_sites.settings')
      ->set('no_site_access_policy', 'group_sites.no_site_access_policy.do_nothing')
      ->set('site_access_policy', 'group_sites.site_access_policy.single')
      ->save();

    $this->installEntitySchema('group_content_menu');
    $this->installSchema('node', 'node_access');

    // You really don't want to install localgov_page in a Kernel test!
    NodeType::create([
      'type' => 'localgov_page',
      'name' => 'Page',
    ])->save();
    NodeType::create([
      'type' => 'example_page',
      'name' => 'Example',
    ])->save();

    $this->installConfig([
      'gnode',
      'override_node_options',
      'user',
      'localgov_media',
      'localgov_microsites_group',

    ]);
  }

  /**
   * Test generating default content.
   */
  public function testGenerate() {
    $config_factory = $this->container->get('config.factory');
    assert($config_factory instanceof ConfigFactoryInterface);

    $service = new GroupDefaultContent($this->entityTypeManager, $config_factory, $this->container->get('replicate.replicator'));
    $group = Group::create([
      'label' => 'Microsite 1',
      'type' => 'microsite',
    ]);
    $group->save();

    // Default config. Create a new node.
    $result = $service->generate($group);
    $this->assertEquals('Welcome to your new site', $result->label());

    // A existing node.
    $node = Node::create([
      'type' => 'localgov_page',
      'title' => 'Other page',
    ]);
    $node->save();
    $config = $config_factory->getEditable('localgov_microsites_group.settings');
    $config->set('default_group_node', $node->id());
    $config->save();
    $result = $service->generate($group);
    $this->assertEquals('Other page', $result->label());

    // A node in a content type that can't go in the group.
    $node = Node::create([
      'type' => 'example_page',
      'title' => 'Not group content page',
    ]);
    $node->save();
    $config = $config_factory->getEditable('localgov_microsites_group.settings');
    $config->set('default_group_node', $node->id());
    $config->save();
    $result = $service->generate($group);
    $this->assertNull($result);
  }

}
