<?php

namespace Drupal\localgov_publications_importer\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure LocalGov Publications Importer settings.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * Config settings name.
   */
  const CONFIG_NAME = 'localgov_publications_importer.settings';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'localgov_publications_importer_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      self::CONFIG_NAME,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config(self::CONFIG_NAME);

    $form['cron'] = [
      '#type' => 'details',
      '#title' => $this->t('Cron settings'),
      '#open' => TRUE,
    ];

    $form['cron']['cron_processing_mode'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Process imports on cron'),
      '#description' => $this->t('When enabled, a number of pending imports will be processed each time cron is run. When disabled, you must process the queue using the drush command localgov_publications_importer:import (lpii).'),
      '#default_value' => $config->get('cron_processing_mode') ?? FALSE,
    ];

    $form['cron']['cron_items_limit'] = [
      '#type' => 'number',
      '#title' => $this->t('Number of items to process per cron run'),
      '#description' => $this->t('The maximum number of import items to process during each cron run.'),
      '#default_value' => $config->get('cron_items_limit') ?? 1,
      '#min' => 1,
      '#required' => TRUE,
      '#states' => [
        'visible' => [
          ':input[name="cron_processing_mode"]' => ['checked' => TRUE],
        ],
      ],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config(self::CONFIG_NAME)
      ->set('cron_processing_mode', $form_state->getValue('cron_processing_mode'))
      ->set('cron_items_limit', $form_state->getValue('cron_items_limit'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
