<?php

namespace Drupal\localgov_publications_importer;

use Drupal\Core\Cache\Cache;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\localgov_publications_importer\Service\ImportManager;

/**
 * Hooks for this module.
 */
class Hooks {

  /**
   * Constructor.
   */
  public function __construct(
    protected ImportManager $importManager,
    protected ConfigFactoryInterface $configFactory,
  ) {
  }

  /**
   * Implements hook_cron().
   */
  #[Hook('cron')]
  public function cron() {

    $config = $this->configFactory->get('localgov_publications_importer.settings');

    $enabled = $config->get('cron_processing_mode') ?? FALSE;
    if (!$enabled) {
      return;
    }

    // Process a specific number of items.
    $limit = $config->get('cron_items_limit') ?? 1;
    for ($i = 0; $i < $limit; $i++) {
      if (!$this->importManager->importNext()) {
        break;
      }
    }

    // For some reason, saving the imports invalidates the cached view once when
    // an imports start, but not when an import ends. Invalidating this tag for
    // the imports view means that imports ending show up the view. This should
    // be considered a workaround though, as it shouldn't be required.
    Cache::invalidateTags(['config:views.view.imports']);
  }

}
