<?php

namespace Drupal\localgov_publications_importer;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\localgov_publications_importer\Entity\ImportPipeline;

/**
 * Provides a listing of Import Pipeline entities.
 */
class ImportPipelineListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header = [
      'label' => $this->t('Label'),
      'id' => $this->t('Machine name'),
      'extract_plugin' => $this->t('Extract Plugin'),
      'save_plugin' => $this->t('Save Plugin'),
    ];
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    assert($entity instanceof ImportPipeline);
    $row = [
      'label' => $entity->label(),
      'id' => $entity->id(),
      'extract_plugin' => $entity->extract_plugin,
      'save_plugin' => $entity->save_plugin,
    ];
    return $row + parent::buildRow($entity);
  }

  /**
   * Get the title for the list page.
   *
   * @return string
   *   The page title.
   */
  public function getTitle() {
    return 'Import Pipelines';
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();
    $build['intro'] = [
      '#prefix' => '<p>',
      '#markup' => 'Import pipelines are used by the content importer. You can add multiple pipelines to import content in different ways. For example: To different content types, Using different AI prompts, or using your own custom plugins.',
      '#suffix' => '</p>',
      '#weight' => -1,
    ];
    return $build;
  }

}
