<?php

namespace Drupal\localgov_publications_importer;

use Drupal\Core\Entity\Sql\SqlContentEntityStorage;
use Drupal\localgov_publications_importer\Entity\Import;

/**
 * Storage handler for Import entities.
 */
class ImportStorage extends SqlContentEntityStorage {

  /**
   * Gets the next import to process.
   *
   * Loads the oldest import entity with pending status, sets it to processing,
   * and returns it.
   *
   * @return \Drupal\localgov_publications_importer\ImportInterface|null
   *   The next import to process, or NULL if none available.
   */
  public function getNextToImport(): ?ImportInterface {
    $storage = $this->entityTypeManager->getStorage('import');

    $query = $storage->getQuery()
      ->condition('status', Import::STATUS_PENDING)
      ->sort('created', 'ASC')
      ->range(0, 1)
      ->accessCheck(FALSE);

    $ids = $query->execute();

    if ($ids === []) {
      return NULL;
    }

    $import_id = reset($ids);

    /** @var \Drupal\localgov_publications_importer\ImportInterface|null $import */
    $import = $storage->load($import_id);
    return $import;
  }

}
