# LocalGov Replicate

## INTRODUCTION

The LocalGov Replicate module adds the ability to replicate/clone content on your LocalGov Drupal website. This module is specifically designed for and intended to be used with LocalGov Drupal sites.

## REQUIREMENTS

- Replicate
- Replicate UI

## INSTALLATION

### For LocalGov CMS sites
Install as you would normally install a contributed Drupal module:
1. Download the module using Composer:
   ```
   composer require drupal/localgov_replicate
   ```
2. Enable the module via Drush:
   ```
   drush en localgov_replicate
   ```
   or through the Drupal admin interface at `/admin/modules`

### For LocalGov Microsites
Install as above, but also install the 'LocalGov Replicate Microsites' module, which sets the permissions for microsites roles.

See: https://www.drupal.org/node/895232 for further information on module installation.

## CONFIGURATION
- By default this will set all content types to be replicatable.
- It also sets a permission so that only users with the 'LocalGov Editor' role can use the replicate feature. You can visit the permissions page to allow other roles to use this functionality.


## ROLES AND PERMISSIONS

The module establishes the following permission structure:

- **LocalGov Editor**: By default, users with this role can replicate content.
- **LocalGov Admin**: Has full permissions to replicate content and configure which content types can be replicated.
- If you install the microsites submodule, it will allow 'Microsites Controller' and 'Microsites Editor' roles to use the functionality for microsites content.
- **Other roles**: By default, other roles do not have permission to replicate content. You can modify this at `/admin/people/permissions` under the "Replicate" section.

To adjust which roles can use the replicate functionality, visit the permissions page at `/admin/people/permissions`.

## MAINTAINERS

Current maintainers for Drupal 10:

- Mark Conroy (markconroy) - https://www.drupal.org/u/markconroy
