<?php

namespace Drupal\Tests\localgov_waste_collection\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test postcode form.
 *
 * @group localgov_waste_collection
 */
class PostcodeFormTest extends BrowserTestBase {

  /**
   * Use LocalGov base theme.
   *
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'localgov_waste_collection',
    'localgov_waste_collection_example_provider',
  ];

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();
    $config = $this->config('localgov_waste_collection.settings');
    $config->set('active_data_provider', 'example_data_provider');
    $config->save();
  }

  /**
   * Test postcode search works.
   */
  public function testPostcodeForm(): void {

    $user = $this->drupalCreateUser([
      'access content',
    ]);
    $this->drupalLogin($user);

    // Check postcode search form.
    $validPostcode = 'SF1 1AA';
    $invalidPostcode = 'XX1 1XX';
    $url = $this->container->get('url_generator')->generateFromRoute('localgov_waste_collection.form');
    $this->drupalGet($url);
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->elementExists('css', '#edit-postcode');
    $this->assertSession()->pageTextContains('SF1 1AA');

    // Check searches.
    $this->submitForm(['postcode' => $invalidPostcode], 'Find');
    $this->assertSession()->pageTextContains($invalidPostcode);
    $this->assertSession()->pageTextContains('No properties found');
    $this->submitForm(['postcode' => $validPostcode], 'Find');
    $this->assertSession()->pageTextContains($validPostcode);
    $this->assertSession()->pageTextContains('Select an address');
    $this->submitForm(['uprn' => '12345674'], 'View collection days');
    $this->assertSession()->pageTextContains('Tuesday 1 October');
  }

}
